// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode.AccessLocation;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Clazz;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.SpecialStruct;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.VTable;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM.ForeignToLLVMType;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMInteropReadNode#doClazzCached}
 *     Activation probability: 0.32000
 *     With/without class size: 11/8 bytes
 *   Specialization {@link LLVMInteropReadNode#doClazz}
 *     Activation probability: 0.26000
 *     With/without class size: 10/8 bytes
 *   Specialization {@link LLVMInteropReadNode#doSpecialType}
 *     Activation probability: 0.20000
 *     With/without class size: 8/4 bytes
 *   Specialization {@link LLVMInteropReadNode#doKnownType}
 *     Activation probability: 0.14000
 *     With/without class size: 7/8 bytes
 *   Specialization {@link LLVMInteropReadNode#doUnknownType}
 *     Activation probability: 0.08000
 *     With/without class size: 5/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMInteropReadNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMInteropReadNodeGen extends LLVMInteropReadNode implements GenerateAOT.Provider {

    static final ReferenceField<ClazzCachedData> CLAZZ_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "clazzCached_cache", ClazzCachedData.class);
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMInteropReadNode#doClazzCached}
     *   2: SpecializationActive {@link LLVMInteropReadNode#doClazz}
     *   3: SpecializationActive {@link LLVMInteropReadNode#doSpecialType}
     *   4: SpecializationActive {@link LLVMInteropReadNode#doKnownType}
     *   5: SpecializationActive {@link LLVMInteropReadNode#doUnknownType}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @CompilationFinal private ClazzCachedData clazzCached_cache;
    @Child private ClazzData clazz_cache;
    @Child private SpecialTypeData specialType_cache;
    @Child private KnownTypeData knownType_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMInteropReadNode#doUnknownType}
     *   Parameter: {@link ReadLocationNode} read</pre>
     */
    @Child private ReadLocationNode unknownType_read_;

    private LLVMInteropReadNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object execute(Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVMType arg3Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }
        if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMInteropReadNode.doClazzCached(Clazz, Object, long, ForeignToLLVMType, Clazz, VTable)] || SpecializationActive[LLVMInteropReadNode.doClazz(Clazz, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] || SpecializationActive[LLVMInteropReadNode.doSpecialType(SpecialStruct, Object, long, ForeignToLLVMType, LLVMInteropSpecialAccessNode)] || SpecializationActive[LLVMInteropReadNode.doKnownType(Structured, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] || SpecializationActive[LLVMInteropReadNode.doUnknownType(Structured, Object, long, ForeignToLLVMType, ReadLocationNode)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMInteropReadNode.doClazzCached(Clazz, Object, long, ForeignToLLVMType, Clazz, VTable)] || SpecializationActive[LLVMInteropReadNode.doClazz(Clazz, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] */ && arg0Value instanceof Clazz) {
                Clazz arg0Value_ = (Clazz) arg0Value;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropReadNode.doClazzCached(Clazz, Object, long, ForeignToLLVMType, Clazz, VTable)] */) {
                    ClazzCachedData s0_ = this.clazzCached_cache;
                    while (s0_ != null) {
                        if ((arg0Value_ == s0_.cachedType_) && (arg2Value == 0)) {
                            assert DSLSupport.assertIdempotence((s0_.cachedType_ != null));
                            assert DSLSupport.assertIdempotence((s0_.cachedType_.hasVirtualMethods()));
                            return doClazzCached(arg0Value_, arg1Value, arg2Value, arg3Value, s0_.cachedType_, s0_.vTable_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropReadNode.doClazz(Clazz, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] */) {
                    ClazzData s1_ = this.clazz_cache;
                    if (s1_ != null) {
                        if ((arg0Value_ != null) && (LLVMInteropReadNode.hasVirtualMethods(arg0Value_)) && (arg2Value == 0)) {
                            return doClazz(arg0Value_, arg1Value, arg2Value, arg3Value, s1_.access_, s1_.read_);
                        }
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropReadNode.doSpecialType(SpecialStruct, Object, long, ForeignToLLVMType, LLVMInteropSpecialAccessNode)] */ && arg0Value instanceof SpecialStruct) {
                SpecialStruct arg0Value_ = (SpecialStruct) arg0Value;
                SpecialTypeData s2_ = this.specialType_cache;
                if (s2_ != null) {
                    if ((arg0Value_ != null)) {
                        return doSpecialType(arg0Value_, arg1Value, arg2Value, arg3Value, s2_.access_);
                    }
                }
            }
            if ((state_0 & 0b110000) != 0 /* is SpecializationActive[LLVMInteropReadNode.doKnownType(Structured, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] || SpecializationActive[LLVMInteropReadNode.doUnknownType(Structured, Object, long, ForeignToLLVMType, ReadLocationNode)] */) {
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropReadNode.doKnownType(Structured, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] */) {
                    KnownTypeData s3_ = this.knownType_cache;
                    if (s3_ != null) {
                        if ((arg0Value != null) && (arg2Value != 0 || !(LLVMInteropReadNode.hasVirtualMethods(arg0Value)))) {
                            return doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, s3_.access_, s3_.read_);
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMInteropReadNode.doUnknownType(Structured, Object, long, ForeignToLLVMType, ReadLocationNode)] */) {
                    {
                        ReadLocationNode read__ = this.unknownType_read_;
                        if (read__ != null) {
                            if ((arg0Value == null)) {
                                return doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, read__);
                            }
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    private Object executeAndSpecialize(Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVMType arg3Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Clazz) {
            Clazz arg0Value_ = (Clazz) arg0Value;
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMInteropReadNode.doClazz(Clazz, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] */) {
                while (true) {
                    int count0_ = 0;
                    ClazzCachedData s0_ = CLAZZ_CACHED_CACHE_UPDATER.getVolatile(this);
                    ClazzCachedData s0_original = s0_;
                    while (s0_ != null) {
                        if ((arg0Value_ == s0_.cachedType_) && (arg2Value == 0)) {
                            assert DSLSupport.assertIdempotence((s0_.cachedType_ != null));
                            assert DSLSupport.assertIdempotence((s0_.cachedType_.hasVirtualMethods()));
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        if ((arg2Value == 0)) {
                            // assert (arg0Value_ == s0_.cachedType_);
                            Clazz cachedType__ = (arg0Value_);
                            if ((cachedType__ != null) && (cachedType__.hasVirtualMethods()) && count0_ < (3)) {
                                s0_ = new ClazzCachedData(s0_original);
                                s0_.cachedType_ = cachedType__;
                                s0_.vTable_ = (cachedType__.getVTable());
                                if (!CLAZZ_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropReadNode.doClazzCached(Clazz, Object, long, ForeignToLLVMType, Clazz, VTable)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s0_ != null) {
                        return doClazzCached(arg0Value_, arg1Value, arg2Value, arg3Value, s0_.cachedType_, s0_.vTable_);
                    }
                    break;
                }
            }
            if ((arg0Value_ != null) && (LLVMInteropReadNode.hasVirtualMethods(arg0Value_)) && (arg2Value == 0)) {
                ClazzData s1_ = this.insert(new ClazzData());
                s1_.access_ = s1_.insert((LLVMInteropAccessNode.create()));
                ReadLocationNode read__1 = s1_.insert((ReadLocationNodeGen.create()));
                Objects.requireNonNull(read__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.read_ = read__1;
                VarHandle.storeStoreFence();
                this.clazz_cache = s1_;
                this.clazzCached_cache = null;
                state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMInteropReadNode.doClazzCached(Clazz, Object, long, ForeignToLLVMType, Clazz, VTable)] */;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropReadNode.doClazz(Clazz, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] */;
                this.state_0_ = state_0;
                return doClazz(arg0Value_, arg1Value, arg2Value, arg3Value, s1_.access_, read__1);
            }
        }
        if (arg0Value instanceof SpecialStruct) {
            SpecialStruct arg0Value_ = (SpecialStruct) arg0Value;
            if ((arg0Value_ != null)) {
                SpecialTypeData s2_ = this.insert(new SpecialTypeData());
                s2_.access_ = s2_.insert((LLVMInteropSpecialAccessNode.create()));
                VarHandle.storeStoreFence();
                this.specialType_cache = s2_;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMInteropReadNode.doSpecialType(SpecialStruct, Object, long, ForeignToLLVMType, LLVMInteropSpecialAccessNode)] */;
                this.state_0_ = state_0;
                return doSpecialType(arg0Value_, arg1Value, arg2Value, arg3Value, s2_.access_);
            }
        }
        if ((arg0Value != null) && (arg2Value != 0 || !(LLVMInteropReadNode.hasVirtualMethods(arg0Value)))) {
            KnownTypeData s3_ = this.insert(new KnownTypeData());
            s3_.access_ = s3_.insert((LLVMInteropAccessNode.create()));
            ReadLocationNode read__2 = s3_.insert((ReadLocationNodeGen.create()));
            Objects.requireNonNull(read__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.read_ = read__2;
            VarHandle.storeStoreFence();
            this.knownType_cache = s3_;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMInteropReadNode.doKnownType(Structured, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] */;
            this.state_0_ = state_0;
            return doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, s3_.access_, read__2);
        }
        if ((arg0Value == null)) {
            ReadLocationNode read__ = this.insert((ReadLocationNodeGen.create()));
            Objects.requireNonNull(read__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.unknownType_read_ = read__;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMInteropReadNode.doUnknownType(Structured, Object, long, ForeignToLLVMType, ReadLocationNode)] */;
            this.state_0_ = state_0;
            return doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, read__);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            ClazzData s1_ = this.insert(new ClazzData());
            s1_.access_ = s1_.insert((LLVMInteropAccessNode.create()));
            ReadLocationNode read__1 = s1_.insert((ReadLocationNodeGen.create()));
            Objects.requireNonNull(read__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.read_ = read__1;
            VarHandle.storeStoreFence();
            this.clazz_cache = s1_;
            this.clazzCached_cache = null;
            this.state_0_ = state_0_ & 0xfffffffd /* remove SpecializationActive[LLVMInteropReadNode.doClazzCached(Clazz, Object, long, ForeignToLLVMType, Clazz, VTable)] */;
            assert NodeUtil.assertRecursion(s1_.access_, 1);
            ((GenerateAOT.Provider) s1_.access_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s1_.read_, 1);
            ((GenerateAOT.Provider) s1_.read_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMInteropReadNode.doClazz(Clazz, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] */;
        }
        {
            SpecialTypeData s2_ = this.insert(new SpecialTypeData());
            s2_.access_ = s2_.insert((LLVMInteropSpecialAccessNode.create()));
            VarHandle.storeStoreFence();
            this.specialType_cache = s2_;
            assert NodeUtil.assertRecursion(s2_.access_, 1);
            ((GenerateAOT.Provider) s2_.access_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMInteropReadNode.doSpecialType(SpecialStruct, Object, long, ForeignToLLVMType, LLVMInteropSpecialAccessNode)] */;
        }
        {
            KnownTypeData s3_ = this.insert(new KnownTypeData());
            s3_.access_ = s3_.insert((LLVMInteropAccessNode.create()));
            ReadLocationNode read__2 = s3_.insert((ReadLocationNodeGen.create()));
            Objects.requireNonNull(read__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.read_ = read__2;
            VarHandle.storeStoreFence();
            this.knownType_cache = s3_;
            assert NodeUtil.assertRecursion(s3_.access_, 1);
            ((GenerateAOT.Provider) s3_.access_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s3_.read_, 1);
            ((GenerateAOT.Provider) s3_.read_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMInteropReadNode.doKnownType(Structured, Object, long, ForeignToLLVMType, LLVMInteropAccessNode, ReadLocationNode)] */;
        }
        {
            ReadLocationNode read__ = this.insert((ReadLocationNodeGen.create()));
            Objects.requireNonNull(read__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.unknownType_read_ = read__;
            assert NodeUtil.assertRecursion(this.unknownType_read_, 1);
            ((GenerateAOT.Provider) this.unknownType_read_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMInteropReadNode.doUnknownType(Structured, Object, long, ForeignToLLVMType, ReadLocationNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.clazz_cache = null;
        this.specialType_cache = null;
        this.knownType_cache = null;
        this.unknownType_read_ = null;
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLJL(Node thisNode_, Object arg0Value, Object arg1Value, long arg2Value, Object arg3Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
    }

    @NeverDefault
    public static LLVMInteropReadNode create() {
        return new LLVMInteropReadNodeGen();
    }

    @NeverDefault
    public static LLVMInteropReadNode getUncached() {
        return LLVMInteropReadNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMInteropReadNode.class)
    @DenyReplace
    private static final class ClazzCachedData implements SpecializationDataNode {

        @CompilationFinal final ClazzCachedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropReadNode#doClazzCached}
         *   Parameter: {@link Clazz} cachedType</pre>
         */
        @CompilationFinal Clazz cachedType_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropReadNode#doClazzCached}
         *   Parameter: {@link VTable} vTable</pre>
         */
        @CompilationFinal VTable vTable_;

        ClazzCachedData(ClazzCachedData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMInteropReadNode.class)
    @DenyReplace
    private static final class ClazzData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropReadNode#doClazz}
         *   Parameter: {@link LLVMInteropAccessNode} access</pre>
         */
        @Child LLVMInteropAccessNode access_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropReadNode#doClazz}
         *   Parameter: {@link ReadLocationNode} read</pre>
         */
        @Child ReadLocationNode read_;

        ClazzData() {
        }

    }
    @GeneratedBy(LLVMInteropReadNode.class)
    @DenyReplace
    private static final class SpecialTypeData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropReadNode#doSpecialType}
         *   Parameter: {@link LLVMInteropSpecialAccessNode} access</pre>
         */
        @Child LLVMInteropSpecialAccessNode access_;

        SpecialTypeData() {
        }

    }
    @GeneratedBy(LLVMInteropReadNode.class)
    @DenyReplace
    private static final class KnownTypeData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropReadNode#doKnownType}
         *   Parameter: {@link LLVMInteropAccessNode} access</pre>
         */
        @Child LLVMInteropAccessNode access_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropReadNode#doKnownType}
         *   Parameter: {@link ReadLocationNode} read</pre>
         */
        @Child ReadLocationNode read_;

        KnownTypeData() {
        }

    }
    @GeneratedBy(LLVMInteropReadNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMInteropReadNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object execute(Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVMType arg3Value) {
            if (arg0Value instanceof Clazz) {
                Clazz arg0Value_ = (Clazz) arg0Value;
                if ((arg0Value_ != null) && (LLVMInteropReadNode.hasVirtualMethods(arg0Value_)) && (arg2Value == 0)) {
                    return doClazz(arg0Value_, arg1Value, arg2Value, arg3Value, (LLVMInteropAccessNodeGen.getUncached()), (ReadLocationNodeGen.getUncached()));
                }
            }
            if (arg0Value instanceof SpecialStruct) {
                SpecialStruct arg0Value_ = (SpecialStruct) arg0Value;
                if ((arg0Value_ != null)) {
                    return doSpecialType(arg0Value_, arg1Value, arg2Value, arg3Value, (LLVMInteropSpecialAccessNodeGen.getUncached()));
                }
            }
            if ((arg0Value != null) && (arg2Value != 0 || !(LLVMInteropReadNode.hasVirtualMethods(arg0Value)))) {
                return doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, (LLVMInteropAccessNodeGen.getUncached()), (ReadLocationNodeGen.getUncached()));
            }
            if ((arg0Value == null)) {
                return doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, (ReadLocationNodeGen.getUncached()));
            }
            throw newUnsupportedSpecializationException4LLJL(this, arg0Value, arg1Value, arg2Value, arg3Value);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ReadLocationNode#readMember}
     *     Activation probability: 0.23929
     *     With/without class size: 11/12 bytes
     *   Specialization {@link ReadLocationNode#readMember}
     *     Activation probability: 0.20714
     *     With/without class size: 8/8 bytes
     *   Specialization {@link ReadLocationNode#readArrayElementTypeMatch}
     *     Activation probability: 0.17500
     *     With/without class size: 9/12 bytes
     *   Specialization {@link ReadLocationNode#readArrayElementTypeMatch}
     *     Activation probability: 0.14286
     *     With/without class size: 7/8 bytes
     *   Specialization {@link ReadLocationNode#readArrayElementFromI8}
     *     Activation probability: 0.11071
     *     With/without class size: 8/20 bytes
     *   Specialization {@link ReadLocationNode#readArrayElementFromI8}
     *     Activation probability: 0.07857
     *     With/without class size: 6/16 bytes
     *   Specialization {@link ReadLocationNode#fallback}
     *     Activation probability: 0.04643
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(ReadLocationNode.class)
    @SuppressWarnings("javadoc")
    static final class ReadLocationNodeGen extends ReadLocationNode implements GenerateAOT.Provider {

        static final ReferenceField<ReadMember0Data> READ_MEMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "readMember0_cache", ReadMember0Data.class);
        static final ReferenceField<ReadArrayElementTypeMatch0Data> READ_ARRAY_ELEMENT_TYPE_MATCH0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "readArrayElementTypeMatch0_cache", ReadArrayElementTypeMatch0Data.class);
        static final ReferenceField<ReadArrayElementFromI80Data> READ_ARRAY_ELEMENT_FROM_I80_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "readArrayElementFromI80_cache", ReadArrayElementFromI80Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ReadLocationNode#readMember}
         *   2: SpecializationActive {@link ReadLocationNode#readMember}
         *   3: SpecializationActive {@link ReadLocationNode#readArrayElementTypeMatch}
         *   4: SpecializationActive {@link ReadLocationNode#readArrayElementTypeMatch}
         *   5: SpecializationActive {@link ReadLocationNode#readArrayElementFromI8}
         *   6: SpecializationActive {@link ReadLocationNode#readArrayElementFromI8}
         *   7: SpecializationActive {@link ReadLocationNode#fallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private ReadMember0Data readMember0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ReadLocationNode#readMember}
         *   Parameter: {@link ToLLVM} toLLVM</pre>
         */
        @Child private ToLLVM readMember1_toLLVM_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ReadLocationNode#readMember}
         *   Parameter: {@link BranchProfile} exception</pre>
         */
        @CompilationFinal private BranchProfile readMember1_exception_;
        @UnsafeAccessedField @Child private ReadArrayElementTypeMatch0Data readArrayElementTypeMatch0_cache;
        @Child private ReadArrayElementTypeMatch1Data readArrayElementTypeMatch1_cache;
        @UnsafeAccessedField @Child private ReadArrayElementFromI80Data readArrayElementFromI80_cache;
        @Child private ReadArrayElementFromI81Data readArrayElementFromI81_cache;

        private ReadLocationNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arg0Value, AccessLocation arg1Value, ForeignToLLVMType arg2Value) {
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */) && arg0Value instanceof String) {
                return false;
            }
            if (arg0Value instanceof Long) {
                if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */) && (ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value))) {
                    return false;
                }
                if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] */) && (!(ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value))) && ((arg1Value.type.kind.foreignToLLVMType).isI8()) && ((arg2Value.getSizeInBytes()) > 1)) {
                    return false;
                }
            }
            return true;
        }

        @ExplodeLoop
        @Override
        Object execute(Object arg0Value, AccessLocation arg1Value, ForeignToLLVMType arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.fallback(Object, AccessLocation, ForeignToLLVMType)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */ && arg0Value instanceof String) {
                    String arg0Value_ = (String) arg0Value;
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */) {
                        ReadMember0Data s0_ = this.readMember0_cache;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value.base))) {
                                return readMember(arg0Value_, arg1Value, arg2Value, s0_.interop_, s0_.toLLVM_, s0_.exception_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */) {
                        {
                            ToLLVM toLLVM__ = this.readMember1_toLLVM_;
                            if (toLLVM__ != null) {
                                BranchProfile exception__ = this.readMember1_exception_;
                                if (exception__ != null) {
                                    return this.readMember1Boundary(state_0, arg0Value_, arg1Value, arg2Value, toLLVM__, exception__);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1111000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] || SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] */ && arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */) {
                        ReadArrayElementTypeMatch0Data s2_ = this.readArrayElementTypeMatch0_cache;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value.base)) && (ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value))) {
                                return readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, s2_.interop_, s2_.toLLVM_, s2_.exception_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */) {
                        ReadArrayElementTypeMatch1Data s3_ = this.readArrayElementTypeMatch1_cache;
                        if (s3_ != null) {
                            if ((ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value))) {
                                return this.readArrayElementTypeMatch1Boundary(state_0, s3_, arg0Value_, arg1Value, arg2Value);
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] */) {
                        ReadArrayElementFromI80Data s4_ = this.readArrayElementFromI80_cache;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(arg1Value.base)) && (!(ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)))) {
                                ForeignToLLVMType locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                if ((locationType__.isI8())) {
                                    int accessTypeSizeInBytes__ = (arg2Value.getSizeInBytes());
                                    if ((accessTypeSizeInBytes__ > 1)) {
                                        return readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, s4_.interop_, s4_.toLLVM_, s4_.fromLongToLLVM_, s4_.exception_, s4_.outOfBounds_, locationType__, accessTypeSizeInBytes__);
                                    }
                                }
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] */) {
                        ReadArrayElementFromI81Data s5_ = this.readArrayElementFromI81_cache;
                        if (s5_ != null) {
                            if ((!(ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)))) {
                                ForeignToLLVMType locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                if ((locationType__.isI8())) {
                                    int accessTypeSizeInBytes__ = (arg2Value.getSizeInBytes());
                                    if ((accessTypeSizeInBytes__ > 1)) {
                                        return this.readArrayElementFromI81Boundary(state_0, s5_, arg0Value_, arg1Value, arg2Value);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReadLocationNode.fallback(Object, AccessLocation, ForeignToLLVMType)] */) {
                    if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                        return fallback(arg0Value, arg1Value, arg2Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object readMember1Boundary(int state_0, String arg0Value_, AccessLocation arg1Value, ForeignToLLVMType arg2Value, ToLLVM toLLVM__, BranchProfile exception__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                    return readMember(arg0Value_, arg1Value, arg2Value, interop__, toLLVM__, exception__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object readArrayElementTypeMatch1Boundary(int state_0, ReadArrayElementTypeMatch1Data s3_, long arg0Value_, AccessLocation arg1Value, ForeignToLLVMType arg2Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                    return readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, interop__1, s3_.toLLVM_, s3_.exception_);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object readArrayElementFromI81Boundary(int state_0, ReadArrayElementFromI81Data s5_, long arg0Value_, AccessLocation arg1Value, ForeignToLLVMType arg2Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__2 = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                    ForeignToLLVMType locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                    int accessTypeSizeInBytes__ = (arg2Value.getSizeInBytes());
                    return readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, interop__2, s5_.toLLVM_, s5_.fromLongToLLVM_, s5_.exception_, s5_.outOfBounds_, locationType__, accessTypeSizeInBytes__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(Object arg0Value, AccessLocation arg1Value, ForeignToLLVMType arg2Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */) {
                    while (true) {
                        int count0_ = 0;
                        ReadMember0Data s0_ = READ_MEMBER0_CACHE_UPDATER.getVolatile(this);
                        ReadMember0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value.base))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.interop_.accepts(arg1Value.base));
                            if (count0_ < (3)) {
                                s0_ = this.insert(new ReadMember0Data(s0_original));
                                InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.create(arg1Value.base)));
                                Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.interop_ = interop__;
                                ToLLVM toLLVM__ = s0_.insert((ToLLVMNodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.toLLVM_ = toLLVM__;
                                BranchProfile exception__ = (BranchProfile.create());
                                Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.exception_ = exception__;
                                if (!READ_MEMBER0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return readMember(arg0Value_, arg1Value, arg2Value, s0_.interop_, s0_.toLLVM_, s0_.exception_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                            ToLLVM toLLVM__ = this.insert((ToLLVMNodeGen.create()));
                            Objects.requireNonNull(toLLVM__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.readMember1_toLLVM_ = toLLVM__;
                            BranchProfile exception__ = (BranchProfile.create());
                            Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.readMember1_exception_ = exception__;
                            this.readMember0_cache = null;
                            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */;
                            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readMember(String, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */;
                            this.state_0_ = state_0;
                            return readMember(arg0Value_, arg1Value, arg2Value, interop__, toLLVM__, exception__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */) {
                    while (true) {
                        int count2_ = 0;
                        ReadArrayElementTypeMatch0Data s2_ = READ_ARRAY_ELEMENT_TYPE_MATCH0_CACHE_UPDATER.getVolatile(this);
                        ReadArrayElementTypeMatch0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value.base)) && (ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            if ((ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)) && count2_ < (3)) {
                                // assert (s2_.interop_.accepts(arg1Value.base));
                                s2_ = this.insert(new ReadArrayElementTypeMatch0Data(s2_original));
                                InteropLibrary interop__1 = s2_.insert((INTEROP_LIBRARY_.create(arg1Value.base)));
                                Objects.requireNonNull(interop__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.interop_ = interop__1;
                                ToLLVM toLLVM__1 = s2_.insert((ToLLVMNodeGen.create()));
                                Objects.requireNonNull(toLLVM__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.toLLVM_ = toLLVM__1;
                                BranchProfile exception__1 = (BranchProfile.create());
                                Objects.requireNonNull(exception__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.exception_ = exception__1;
                                if (!READ_ARRAY_ELEMENT_TYPE_MATCH0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, s2_.interop_, s2_.toLLVM_, s2_.exception_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value))) {
                                ReadArrayElementTypeMatch1Data s3_ = this.insert(new ReadArrayElementTypeMatch1Data());
                                interop__1 = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                                ToLLVM toLLVM__1 = s3_.insert((ToLLVMNodeGen.create()));
                                Objects.requireNonNull(toLLVM__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s3_.toLLVM_ = toLLVM__1;
                                BranchProfile exception__1 = (BranchProfile.create());
                                Objects.requireNonNull(exception__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s3_.exception_ = exception__1;
                                VarHandle.storeStoreFence();
                                this.readArrayElementTypeMatch1_cache = s3_;
                                this.readArrayElementTypeMatch0_cache = null;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementTypeMatch(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, interop__1, toLLVM__1, exception__1);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                {
                    int accessTypeSizeInBytes__ = 0;
                    ForeignToLLVMType locationType__ = null;
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] */) {
                        while (true) {
                            int count4_ = 0;
                            ReadArrayElementFromI80Data s4_ = READ_ARRAY_ELEMENT_FROM_I80_CACHE_UPDATER.getVolatile(this);
                            ReadArrayElementFromI80Data s4_original = s4_;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(arg1Value.base)) && (!(ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)))) {
                                    locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                    if ((locationType__.isI8())) {
                                        accessTypeSizeInBytes__ = (arg2Value.getSizeInBytes());
                                        if ((accessTypeSizeInBytes__ > 1)) {
                                            break;
                                        }
                                    }
                                }
                                count4_++;
                                s4_ = s4_.next_;
                            }
                            if (s4_ == null) {
                                if ((!(ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)))) {
                                    // assert (s4_.interop_.accepts(arg1Value.base));
                                    locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                    if ((locationType__.isI8())) {
                                        accessTypeSizeInBytes__ = (arg2Value.getSizeInBytes());
                                        if ((accessTypeSizeInBytes__ > 1) && count4_ < (3)) {
                                            s4_ = this.insert(new ReadArrayElementFromI80Data(s4_original));
                                            InteropLibrary interop__2 = s4_.insert((INTEROP_LIBRARY_.create(arg1Value.base)));
                                            Objects.requireNonNull(interop__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s4_.interop_ = interop__2;
                                            ToLLVM toLLVM__2 = s4_.insert((ToLLVMNodeGen.create()));
                                            Objects.requireNonNull(toLLVM__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s4_.toLLVM_ = toLLVM__2;
                                            ReinterpretLongAsLLVM fromLongToLLVM__ = s4_.insert((ReinterpretLongAsLLVMNodeGen.create()));
                                            Objects.requireNonNull(fromLongToLLVM__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s4_.fromLongToLLVM_ = fromLongToLLVM__;
                                            BranchProfile exception__2 = (BranchProfile.create());
                                            Objects.requireNonNull(exception__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s4_.exception_ = exception__2;
                                            BranchProfile outOfBounds__ = (BranchProfile.create());
                                            Objects.requireNonNull(outOfBounds__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s4_.outOfBounds_ = outOfBounds__;
                                            if (!READ_ARRAY_ELEMENT_FROM_I80_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                            if (s4_ != null) {
                                return readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, s4_.interop_, s4_.toLLVM_, s4_.fromLongToLLVM_, s4_.exception_, s4_.outOfBounds_, locationType__, accessTypeSizeInBytes__);
                            }
                            break;
                        }
                    }
                }
                {
                    int accessTypeSizeInBytes__ = 0;
                    ForeignToLLVMType locationType__ = null;
                    InteropLibrary interop__2 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((!(ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)))) {
                                locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                if ((locationType__.isI8())) {
                                    accessTypeSizeInBytes__ = (arg2Value.getSizeInBytes());
                                    if ((accessTypeSizeInBytes__ > 1)) {
                                        ReadArrayElementFromI81Data s5_ = this.insert(new ReadArrayElementFromI81Data());
                                        interop__2 = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                                        ToLLVM toLLVM__2 = s5_.insert((ToLLVMNodeGen.create()));
                                        Objects.requireNonNull(toLLVM__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s5_.toLLVM_ = toLLVM__2;
                                        ReinterpretLongAsLLVM fromLongToLLVM__ = s5_.insert((ReinterpretLongAsLLVMNodeGen.create()));
                                        Objects.requireNonNull(fromLongToLLVM__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s5_.fromLongToLLVM_ = fromLongToLLVM__;
                                        BranchProfile exception__2 = (BranchProfile.create());
                                        Objects.requireNonNull(exception__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s5_.exception_ = exception__2;
                                        BranchProfile outOfBounds__ = (BranchProfile.create());
                                        Objects.requireNonNull(outOfBounds__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s5_.outOfBounds_ = outOfBounds__;
                                        VarHandle.storeStoreFence();
                                        this.readArrayElementFromI81_cache = s5_;
                                        this.readArrayElementFromI80_cache = null;
                                        state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] */;
                                        state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMInteropReadNode.ReadLocationNode.readArrayElementFromI8(long, AccessLocation, ForeignToLLVMType, InteropLibrary, ToLLVM, ReinterpretLongAsLLVM, BranchProfile, BranchProfile, ForeignToLLVMType, int)] */;
                                        this.state_0_ = state_0;
                                        return readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, interop__2, toLLVM__2, fromLongToLLVM__, exception__2, outOfBounds__, locationType__, accessTypeSizeInBytes__);
                                    }
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMInteropReadNode.ReadLocationNode.fallback(Object, AccessLocation, ForeignToLLVMType)] */;
            this.state_0_ = state_0;
            return fallback(arg0Value, arg1Value, arg2Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMInteropReadNode.ReadLocationNode.fallback(Object, AccessLocation, ForeignToLLVMType)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ReadLocationNode create() {
            return new ReadLocationNodeGen();
        }

        @NeverDefault
        public static ReadLocationNode getUncached() {
            return ReadLocationNodeGen.UNCACHED;
        }

        @GeneratedBy(ReadLocationNode.class)
        @DenyReplace
        private static final class ReadMember0Data extends Node implements SpecializationDataNode {

            @Child ReadMember0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readMember}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readMember}
             *   Parameter: {@link ToLLVM} toLLVM</pre>
             */
            @Child ToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readMember}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;

            ReadMember0Data(ReadMember0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadLocationNode.class)
        @DenyReplace
        private static final class ReadArrayElementTypeMatch0Data extends Node implements SpecializationDataNode {

            @Child ReadArrayElementTypeMatch0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementTypeMatch}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementTypeMatch}
             *   Parameter: {@link ToLLVM} toLLVM</pre>
             */
            @Child ToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementTypeMatch}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;

            ReadArrayElementTypeMatch0Data(ReadArrayElementTypeMatch0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadLocationNode.class)
        @DenyReplace
        private static final class ReadArrayElementTypeMatch1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementTypeMatch}
             *   Parameter: {@link ToLLVM} toLLVM</pre>
             */
            @Child ToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementTypeMatch}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;

            ReadArrayElementTypeMatch1Data() {
            }

        }
        @GeneratedBy(ReadLocationNode.class)
        @DenyReplace
        private static final class ReadArrayElementFromI80Data extends Node implements SpecializationDataNode {

            @Child ReadArrayElementFromI80Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementFromI8}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementFromI8}
             *   Parameter: {@link ToLLVM} toLLVM</pre>
             */
            @Child ToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementFromI8}
             *   Parameter: {@link ReinterpretLongAsLLVM} fromLongToLLVM</pre>
             */
            @Child ReinterpretLongAsLLVM fromLongToLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementFromI8}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementFromI8}
             *   Parameter: {@link BranchProfile} outOfBounds</pre>
             */
            @CompilationFinal BranchProfile outOfBounds_;

            ReadArrayElementFromI80Data(ReadArrayElementFromI80Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadLocationNode.class)
        @DenyReplace
        private static final class ReadArrayElementFromI81Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementFromI8}
             *   Parameter: {@link ToLLVM} toLLVM</pre>
             */
            @Child ToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementFromI8}
             *   Parameter: {@link ReinterpretLongAsLLVM} fromLongToLLVM</pre>
             */
            @Child ReinterpretLongAsLLVM fromLongToLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementFromI8}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadLocationNode#readArrayElementFromI8}
             *   Parameter: {@link BranchProfile} outOfBounds</pre>
             */
            @CompilationFinal BranchProfile outOfBounds_;

            ReadArrayElementFromI81Data() {
            }

        }
        @GeneratedBy(ReadLocationNode.class)
        @DenyReplace
        private static final class Uncached extends ReadLocationNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            Object execute(Object arg0Value, AccessLocation arg1Value, ForeignToLLVMType arg2Value) {
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String) arg0Value;
                    return readMember(arg0Value_, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value.base)), (ToLLVMNodeGen.getUncached()), (BranchProfile.getUncached()));
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value))) {
                        return readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value.base)), (ToLLVMNodeGen.getUncached()), (BranchProfile.getUncached()));
                    }
                    if ((!(ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value))) && ((arg1Value.type.kind.foreignToLLVMType).isI8()) && ((arg2Value.getSizeInBytes()) > 1)) {
                        return readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value.base)), (ToLLVMNodeGen.getUncached()), (ReinterpretLongAsLLVMNodeGen.getUncached()), (BranchProfile.getUncached()), (BranchProfile.getUncached()), (arg1Value.type.kind.foreignToLLVMType), (arg2Value.getSizeInBytes()));
                    }
                }
                return fallback(arg0Value, arg1Value, arg2Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ReinterpretLongAsLLVM#toI16}
     *     Activation probability: 0.23929
     *     With/without class size: 6/0 bytes
     *   Specialization {@link ReinterpretLongAsLLVM#toI32}
     *     Activation probability: 0.20714
     *     With/without class size: 6/0 bytes
     *   Specialization {@link ReinterpretLongAsLLVM#toI64}
     *     Activation probability: 0.17500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link ReinterpretLongAsLLVM#toFloat}
     *     Activation probability: 0.14286
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ReinterpretLongAsLLVM#toDouble}
     *     Activation probability: 0.11071
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ReinterpretLongAsLLVM#toPointer}
     *     Activation probability: 0.07857
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ReinterpretLongAsLLVM#fallback}
     *     Activation probability: 0.04643
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(ReinterpretLongAsLLVM.class)
    @SuppressWarnings("javadoc")
    static final class ReinterpretLongAsLLVMNodeGen extends ReinterpretLongAsLLVM implements GenerateAOT.Provider {

        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ReinterpretLongAsLLVM#toI16}
         *   2: SpecializationActive {@link ReinterpretLongAsLLVM#toI32}
         *   3: SpecializationActive {@link ReinterpretLongAsLLVM#toI64}
         *   4: SpecializationActive {@link ReinterpretLongAsLLVM#toFloat}
         *   5: SpecializationActive {@link ReinterpretLongAsLLVM#toDouble}
         *   6: SpecializationActive {@link ReinterpretLongAsLLVM#toPointer}
         *   7: SpecializationActive {@link ReinterpretLongAsLLVM#fallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private ReinterpretLongAsLLVMNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, long arg0Value, ForeignToLLVMType arg1Value) {
            if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI16(long, ForeignToLLVMType)] */) && (arg1Value.isI16())) {
                return false;
            }
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI32(long, ForeignToLLVMType)] */) && (arg1Value.isI32())) {
                return false;
            }
            if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI64(long, ForeignToLLVMType)] */) && (arg1Value.isI64())) {
                return false;
            }
            if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toFloat(long, ForeignToLLVMType)] */) && (arg1Value.isFloat())) {
                return false;
            }
            if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toDouble(long, ForeignToLLVMType)] */) && (arg1Value.isDouble())) {
                return false;
            }
            if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toPointer(long, ForeignToLLVMType)] */) && (arg1Value.isPointer())) {
                return false;
            }
            return true;
        }

        @Override
        Object executeWithAccessType(long arg0Value, ForeignToLLVMType arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI16(long, ForeignToLLVMType)] || SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI32(long, ForeignToLLVMType)] || SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI64(long, ForeignToLLVMType)] || SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toFloat(long, ForeignToLLVMType)] || SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toDouble(long, ForeignToLLVMType)] || SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toPointer(long, ForeignToLLVMType)] || SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.fallback(long, ForeignToLLVMType)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI16(long, ForeignToLLVMType)] */) {
                    if ((arg1Value.isI16())) {
                        return toI16(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI32(long, ForeignToLLVMType)] */) {
                    if ((arg1Value.isI32())) {
                        return toI32(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI64(long, ForeignToLLVMType)] */) {
                    if ((arg1Value.isI64())) {
                        return toI64(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toFloat(long, ForeignToLLVMType)] */) {
                    if ((arg1Value.isFloat())) {
                        return toFloat(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toDouble(long, ForeignToLLVMType)] */) {
                    if ((arg1Value.isDouble())) {
                        return toDouble(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toPointer(long, ForeignToLLVMType)] */) {
                    if ((arg1Value.isPointer())) {
                        return toPointer(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.fallback(long, ForeignToLLVMType)] */) {
                    if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return fallback(arg0Value, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(long arg0Value, ForeignToLLVMType arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((arg1Value.isI16())) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI16(long, ForeignToLLVMType)] */;
                this.state_0_ = state_0;
                return toI16(arg0Value, arg1Value);
            }
            if ((arg1Value.isI32())) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI32(long, ForeignToLLVMType)] */;
                this.state_0_ = state_0;
                return toI32(arg0Value, arg1Value);
            }
            if ((arg1Value.isI64())) {
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI64(long, ForeignToLLVMType)] */;
                this.state_0_ = state_0;
                return toI64(arg0Value, arg1Value);
            }
            if ((arg1Value.isFloat())) {
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toFloat(long, ForeignToLLVMType)] */;
                this.state_0_ = state_0;
                return toFloat(arg0Value, arg1Value);
            }
            if ((arg1Value.isDouble())) {
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toDouble(long, ForeignToLLVMType)] */;
                this.state_0_ = state_0;
                return toDouble(arg0Value, arg1Value);
            }
            if ((arg1Value.isPointer())) {
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toPointer(long, ForeignToLLVMType)] */;
                this.state_0_ = state_0;
                return toPointer(arg0Value, arg1Value);
            }
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.fallback(long, ForeignToLLVMType)] */;
            this.state_0_ = state_0;
            return fallback(arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI16(long, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI32(long, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toI64(long, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toFloat(long, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toDouble(long, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.toPointer(long, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMInteropReadNode.ReinterpretLongAsLLVM.fallback(long, ForeignToLLVMType)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ReinterpretLongAsLLVM create() {
            return new ReinterpretLongAsLLVMNodeGen();
        }

        @NeverDefault
        public static ReinterpretLongAsLLVM getUncached() {
            return ReinterpretLongAsLLVMNodeGen.UNCACHED;
        }

        @GeneratedBy(ReinterpretLongAsLLVM.class)
        @DenyReplace
        private static final class Uncached extends ReinterpretLongAsLLVM implements UnadoptableNode {

            @TruffleBoundary
            @Override
            Object executeWithAccessType(long arg0Value, ForeignToLLVMType arg1Value) {
                if ((arg1Value.isI16())) {
                    return toI16(arg0Value, arg1Value);
                }
                if ((arg1Value.isI32())) {
                    return toI32(arg0Value, arg1Value);
                }
                if ((arg1Value.isI64())) {
                    return toI64(arg0Value, arg1Value);
                }
                if ((arg1Value.isFloat())) {
                    return toFloat(arg0Value, arg1Value);
                }
                if ((arg1Value.isDouble())) {
                    return toDouble(arg0Value, arg1Value);
                }
                if ((arg1Value.isPointer())) {
                    return toPointer(arg0Value, arg1Value);
                }
                return fallback(arg0Value, arg1Value);
            }

        }
    }
}
