// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.SpecialStruct;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.SpecialStructAccessor;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM.ForeignToLLVMType;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMInteropSpecialAccessNode#doSpecialized}
 *     Activation probability: 0.65000
 *     With/without class size: 40/36 bytes
 *   Specialization {@link LLVMInteropSpecialAccessNode#doUnspecialized}
 *     Activation probability: 0.35000
 *     With/without class size: 16/20 bytes
 * </pre>
 */
@GeneratedBy(LLVMInteropSpecialAccessNode.class)
@SuppressWarnings("javadoc")
public final class LLVMInteropSpecialAccessNodeGen extends LLVMInteropSpecialAccessNode implements GenerateAOT.Provider {

    static final ReferenceField<SpecializedData> SPECIALIZED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "specialized_cache", SpecializedData.class);
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMInteropSpecialAccessNode#doSpecialized}
     *   2: SpecializationActive {@link LLVMInteropSpecialAccessNode#doUnspecialized}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private SpecializedData specialized_cache;
    @Child private UnspecializedData unspecialized_cache;

    private LLVMInteropSpecialAccessNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object execute(Object arg0Value, ForeignToLLVMType arg1Value, Structured arg2Value, long arg3Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMInteropSpecialAccessNode.doSpecialized(Object, ForeignToLLVMType, SpecialStruct, long, SpecialStruct, long, SpecialStructAccessor, ToLLVM, BranchProfile, BranchProfile, BranchProfile, InteropLibrary)] || SpecializationActive[LLVMInteropSpecialAccessNode.doUnspecialized(Object, ForeignToLLVMType, SpecialStruct, long, ToLLVM, BranchProfile, BranchProfile, BranchProfile, InteropLibrary)] */ && arg2Value instanceof SpecialStruct) {
            SpecialStruct arg2Value_ = (SpecialStruct) arg2Value;
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropSpecialAccessNode.doSpecialized(Object, ForeignToLLVMType, SpecialStruct, long, SpecialStruct, long, SpecialStructAccessor, ToLLVM, BranchProfile, BranchProfile, BranchProfile, InteropLibrary)] */) {
                SpecializedData s0_ = this.specialized_cache;
                while (s0_ != null) {
                    if ((arg2Value_ == s0_.cachedType_) && (arg3Value == s0_.cachedOffset_)) {
                        return doSpecialized(arg0Value, arg1Value, arg2Value_, arg3Value, s0_.cachedType_, s0_.cachedOffset_, s0_.accessor_, s0_.toLLVM_, s0_.exception1_, s0_.exception2_, s0_.exception3_, s0_.interop_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropSpecialAccessNode.doUnspecialized(Object, ForeignToLLVMType, SpecialStruct, long, ToLLVM, BranchProfile, BranchProfile, BranchProfile, InteropLibrary)] */) {
                UnspecializedData s1_ = this.unspecialized_cache;
                if (s1_ != null) {
                    return doUnspecialized(arg0Value, arg1Value, arg2Value_, arg3Value, s1_.toLLVM_, s1_.exception1_, s1_.exception2_, s1_.exception3_, s1_.interop_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    private Object executeAndSpecialize(Object arg0Value, ForeignToLLVMType arg1Value, Structured arg2Value, long arg3Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg2Value instanceof SpecialStruct) {
            SpecialStruct arg2Value_ = (SpecialStruct) arg2Value;
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMInteropSpecialAccessNode.doUnspecialized(Object, ForeignToLLVMType, SpecialStruct, long, ToLLVM, BranchProfile, BranchProfile, BranchProfile, InteropLibrary)] */) {
                while (true) {
                    int count0_ = 0;
                    SpecializedData s0_ = SPECIALIZED_CACHE_UPDATER.getVolatile(this);
                    SpecializedData s0_original = s0_;
                    while (s0_ != null) {
                        if ((arg2Value_ == s0_.cachedType_) && (arg3Value == s0_.cachedOffset_)) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        // assert (arg2Value_ == s0_.cachedType_);
                        // assert (arg3Value == s0_.cachedOffset_);
                        if (count0_ < (3)) {
                            s0_ = this.insert(new SpecializedData(s0_original));
                            s0_.cachedType_ = (arg2Value_);
                            s0_.cachedOffset_ = (arg3Value);
                            s0_.accessor_ = (findAccessor(s0_.cachedType_, s0_.cachedOffset_));
                            ToLLVM toLLVM__ = s0_.insert((ToLLVMNodeGen.create()));
                            Objects.requireNonNull(toLLVM__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.toLLVM_ = toLLVM__;
                            BranchProfile exception1__ = (BranchProfile.create());
                            Objects.requireNonNull(exception1__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.exception1_ = exception1__;
                            BranchProfile exception2__ = (BranchProfile.create());
                            Objects.requireNonNull(exception2__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.exception2_ = exception2__;
                            BranchProfile exception3__ = (BranchProfile.create());
                            Objects.requireNonNull(exception3__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.exception3_ = exception3__;
                            InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.interop_ = interop__;
                            if (!SPECIALIZED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropSpecialAccessNode.doSpecialized(Object, ForeignToLLVMType, SpecialStruct, long, SpecialStruct, long, SpecialStructAccessor, ToLLVM, BranchProfile, BranchProfile, BranchProfile, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s0_ != null) {
                        return doSpecialized(arg0Value, arg1Value, arg2Value_, arg3Value, s0_.cachedType_, s0_.cachedOffset_, s0_.accessor_, s0_.toLLVM_, s0_.exception1_, s0_.exception2_, s0_.exception3_, s0_.interop_);
                    }
                    break;
                }
            }
            UnspecializedData s1_ = this.insert(new UnspecializedData());
            ToLLVM toLLVM__1 = s1_.insert((ToLLVMNodeGen.create()));
            Objects.requireNonNull(toLLVM__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.toLLVM_ = toLLVM__1;
            BranchProfile exception1__1 = (BranchProfile.create());
            Objects.requireNonNull(exception1__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.exception1_ = exception1__1;
            BranchProfile exception2__1 = (BranchProfile.create());
            Objects.requireNonNull(exception2__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.exception2_ = exception2__1;
            BranchProfile exception3__1 = (BranchProfile.create());
            Objects.requireNonNull(exception3__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.exception3_ = exception3__1;
            InteropLibrary interop__1 = s1_.insert((INTEROP_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(interop__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.interop_ = interop__1;
            VarHandle.storeStoreFence();
            this.unspecialized_cache = s1_;
            this.specialized_cache = null;
            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMInteropSpecialAccessNode.doSpecialized(Object, ForeignToLLVMType, SpecialStruct, long, SpecialStruct, long, SpecialStructAccessor, ToLLVM, BranchProfile, BranchProfile, BranchProfile, InteropLibrary)] */;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropSpecialAccessNode.doUnspecialized(Object, ForeignToLLVMType, SpecialStruct, long, ToLLVM, BranchProfile, BranchProfile, BranchProfile, InteropLibrary)] */;
            this.state_0_ = state_0;
            return doUnspecialized(arg0Value, arg1Value, arg2Value_, arg3Value, toLLVM__1, exception1__1, exception2__1, exception3__1, interop__1);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLLJ(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
    }

    @NeverDefault
    public static LLVMInteropSpecialAccessNode create() {
        return new LLVMInteropSpecialAccessNodeGen();
    }

    @NeverDefault
    public static LLVMInteropSpecialAccessNode getUncached() {
        return LLVMInteropSpecialAccessNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMInteropSpecialAccessNode.class)
    @DenyReplace
    private static final class SpecializedData extends Node implements SpecializationDataNode {

        @Child SpecializedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doSpecialized}
         *   Parameter: {@link SpecialStruct} cachedType</pre>
         */
        @CompilationFinal SpecialStruct cachedType_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doSpecialized}
         *   Parameter: long cachedOffset</pre>
         */
        @CompilationFinal long cachedOffset_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doSpecialized}
         *   Parameter: {@link SpecialStructAccessor} accessor</pre>
         */
        @CompilationFinal SpecialStructAccessor accessor_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doSpecialized}
         *   Parameter: {@link ToLLVM} toLLVM</pre>
         */
        @Child ToLLVM toLLVM_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doSpecialized}
         *   Parameter: {@link BranchProfile} exception1</pre>
         */
        @CompilationFinal BranchProfile exception1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doSpecialized}
         *   Parameter: {@link BranchProfile} exception2</pre>
         */
        @CompilationFinal BranchProfile exception2_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doSpecialized}
         *   Parameter: {@link BranchProfile} exception3</pre>
         */
        @CompilationFinal BranchProfile exception3_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doSpecialized}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;

        SpecializedData(SpecializedData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMInteropSpecialAccessNode.class)
    @DenyReplace
    private static final class UnspecializedData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doUnspecialized}
         *   Parameter: {@link ToLLVM} toLLVM</pre>
         */
        @Child ToLLVM toLLVM_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doUnspecialized}
         *   Parameter: {@link BranchProfile} exception1</pre>
         */
        @CompilationFinal BranchProfile exception1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doUnspecialized}
         *   Parameter: {@link BranchProfile} exception2</pre>
         */
        @CompilationFinal BranchProfile exception2_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doUnspecialized}
         *   Parameter: {@link BranchProfile} exception3</pre>
         */
        @CompilationFinal BranchProfile exception3_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropSpecialAccessNode#doUnspecialized}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;

        UnspecializedData() {
        }

    }
    @GeneratedBy(LLVMInteropSpecialAccessNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMInteropSpecialAccessNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object execute(Object arg0Value, ForeignToLLVMType arg1Value, Structured arg2Value, long arg3Value) {
            if (arg2Value instanceof SpecialStruct) {
                SpecialStruct arg2Value_ = (SpecialStruct) arg2Value;
                return doUnspecialized(arg0Value, arg1Value, arg2Value_, arg3Value, (ToLLVMNodeGen.getUncached()), (BranchProfile.getUncached()), (BranchProfile.getUncached()), (BranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }
            throw newUnsupportedSpecializationException4LLLJ(this, arg0Value, arg1Value, arg2Value, arg3Value);
        }

    }
}
