// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToI64#fromInt}
 *     Activation probability: 0.12714
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI64#fromChar}
 *     Activation probability: 0.11857
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI64#fromShort}
 *     Activation probability: 0.11000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI64#fromLong}
 *     Activation probability: 0.10143
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI64#fromByte}
 *     Activation probability: 0.09286
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI64#fromFloat}
 *     Activation probability: 0.08429
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI64#fromDouble}
 *     Activation probability: 0.07571
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToI64#fromBoolean}
 *     Activation probability: 0.06714
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToI64#fromString}
 *     Activation probability: 0.05857
 *     With/without class size: 4/4 bytes
 *   Specialization {@link ToI64#fromPointer}
 *     Activation probability: 0.05000
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToI64#fromForeign}
 *     Activation probability: 0.04143
 *     With/without class size: 5/12 bytes
 *   Specialization {@link ToI64#fromForeign}
 *     Activation probability: 0.03286
 *     With/without class size: 4/8 bytes
 *   Specialization {@link ToI64#fromForeignPointer}
 *     Activation probability: 0.02429
 *     With/without class size: 4/12 bytes
 *   Specialization {@link ToI64#fromForeignPointer}
 *     Activation probability: 0.01571
 *     With/without class size: 4/8 bytes
 * </pre>
 */
@GeneratedBy(ToI64.class)
@SuppressWarnings({"javadoc", "unused"})
public final class ToI64NodeGen extends ToI64 implements GenerateAOT.Provider {

    static final ReferenceField<FromForeign0Data> FROM_FOREIGN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fromForeign0_cache", FromForeign0Data.class);
    static final ReferenceField<FromForeignPointer0Data> FROM_FOREIGN_POINTER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fromForeignPointer0_cache", FromForeignPointer0Data.class);
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link ToI64#fromInt}
     *   2: SpecializationActive {@link ToI64#fromChar}
     *   3: SpecializationActive {@link ToI64#fromShort}
     *   4: SpecializationActive {@link ToI64#fromLong}
     *   5: SpecializationActive {@link ToI64#fromByte}
     *   6: SpecializationActive {@link ToI64#fromFloat}
     *   7: SpecializationActive {@link ToI64#fromDouble}
     *   8: SpecializationActive {@link ToI64#fromBoolean}
     *   9: SpecializationActive {@link ToI64#fromString}
     *   10: SpecializationActive {@link ToI64#fromPointer}
     *   11: SpecializationActive {@link ToI64#fromForeign}
     *   12: SpecializationActive {@link ToI64#fromForeign}
     *   13: SpecializationActive {@link ToI64#fromForeignPointer}
     *   14: SpecializationActive {@link ToI64#fromForeignPointer}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToI64#fromString}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile fromString_exception_;
    @UnsafeAccessedField @Child private FromForeign0Data fromForeign0_cache;
    @Child private FromForeign1Data fromForeign1_cache;
    @UnsafeAccessedField @Child private FromForeignPointer0Data fromForeignPointer0_cache;
    @Child private FromForeignPointer1Data fromForeignPointer1_cache;

    private ToI64NodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object executeWithForeignToLLVMType(Object arg0Value, Structured type, ForeignToLLVMType ftlType) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b111111111111110) != 0 /* is SpecializationActive[ToI64.fromInt(int)] || SpecializationActive[ToI64.fromChar(char)] || SpecializationActive[ToI64.fromShort(short)] || SpecializationActive[ToI64.fromLong(long)] || SpecializationActive[ToI64.fromByte(byte)] || SpecializationActive[ToI64.fromFloat(float)] || SpecializationActive[ToI64.fromDouble(double)] || SpecializationActive[ToI64.fromBoolean(boolean)] || SpecializationActive[ToI64.fromString(String, BranchProfile)] || SpecializationActive[ToI64.fromPointer(LLVMPointer)] || SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToI64.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToI64.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToI64.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToI64.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToI64.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToI64.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToI64.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToI64.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToI64.fromString(String, BranchProfile)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                {
                    BranchProfile exception__ = this.fromString_exception_;
                    if (exception__ != null) {
                        return fromString(arg0Value_, exception__);
                    }
                }
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToI64.fromPointer(LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return fromPointer(arg0Value_);
            }
            if ((state_0 & 0b111100000000000) != 0 /* is SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign0Data s10_ = this.fromForeign0_cache;
                    while (s10_ != null) {
                        if ((s10_.foreigns_.accepts(arg0Value)) && (s10_.foreigns_.isForeign(arg0Value)) && (s10_.interop_.isNumber(s10_.foreigns_.asForeign(arg0Value)))) {
                            return fromForeign(arg0Value, s10_.foreigns_, s10_.interop_, s10_.exception_);
                        }
                        s10_ = s10_.next_;
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign1Data s11_ = this.fromForeign1_cache;
                    if (s11_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
                                if ((foreigns__.isForeign(arg0Value)) && (s11_.interop_.isNumber(foreigns__.asForeign(arg0Value)))) {
                                    return this.fromForeign1Boundary(state_0, s11_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
                    FromForeignPointer0Data s12_ = this.fromForeignPointer0_cache;
                    while (s12_ != null) {
                        if ((s12_.interop_.accepts(arg0Value)) && (s12_.foreigns_.isForeign(arg0Value)) && (!(s12_.interop_.isNumber(arg0Value)))) {
                            return fromForeignPointer(arg0Value, s12_.interop_, s12_.toPointer_, s12_.foreigns_);
                        }
                        s12_ = s12_.next_;
                    }
                }
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
                    FromForeignPointer1Data s13_ = this.fromForeignPointer1_cache;
                    if (s13_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((s13_.foreigns_.isForeign(arg0Value))) {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((!(interop__.isNumber(arg0Value)))) {
                                    return this.fromForeignPointer1Boundary(state_0, s13_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object fromForeign1Boundary(int state_0, FromForeign1Data s11_, Object arg0Value) {
        {
            LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
            return fromForeign(arg0Value, foreigns__, s11_.interop_, s11_.exception_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object fromForeignPointer1Boundary(int state_0, FromForeignPointer1Data s13_, Object arg0Value) {
        {
            InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
            return fromForeignPointer(arg0Value, interop__, s13_.toPointer_, s13_.foreigns_);
        }
    }

    @ExplodeLoop
    @Override
    public Object executeWithType(Object arg0Value, Structured type) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b111111111111110) != 0 /* is SpecializationActive[ToI64.fromInt(int)] || SpecializationActive[ToI64.fromChar(char)] || SpecializationActive[ToI64.fromShort(short)] || SpecializationActive[ToI64.fromLong(long)] || SpecializationActive[ToI64.fromByte(byte)] || SpecializationActive[ToI64.fromFloat(float)] || SpecializationActive[ToI64.fromDouble(double)] || SpecializationActive[ToI64.fromBoolean(boolean)] || SpecializationActive[ToI64.fromString(String, BranchProfile)] || SpecializationActive[ToI64.fromPointer(LLVMPointer)] || SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToI64.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToI64.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToI64.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToI64.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToI64.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToI64.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToI64.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToI64.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToI64.fromString(String, BranchProfile)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                {
                    BranchProfile exception__ = this.fromString_exception_;
                    if (exception__ != null) {
                        return fromString(arg0Value_, exception__);
                    }
                }
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToI64.fromPointer(LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return fromPointer(arg0Value_);
            }
            if ((state_0 & 0b111100000000000) != 0 /* is SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign0Data s10_ = this.fromForeign0_cache;
                    while (s10_ != null) {
                        if ((s10_.foreigns_.accepts(arg0Value)) && (s10_.foreigns_.isForeign(arg0Value)) && (s10_.interop_.isNumber(s10_.foreigns_.asForeign(arg0Value)))) {
                            return fromForeign(arg0Value, s10_.foreigns_, s10_.interop_, s10_.exception_);
                        }
                        s10_ = s10_.next_;
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign1Data s11_ = this.fromForeign1_cache;
                    if (s11_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
                                if ((foreigns__.isForeign(arg0Value)) && (s11_.interop_.isNumber(foreigns__.asForeign(arg0Value)))) {
                                    return this.fromForeign1Boundary0(state_0, s11_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
                    FromForeignPointer0Data s12_ = this.fromForeignPointer0_cache;
                    while (s12_ != null) {
                        if ((s12_.interop_.accepts(arg0Value)) && (s12_.foreigns_.isForeign(arg0Value)) && (!(s12_.interop_.isNumber(arg0Value)))) {
                            return fromForeignPointer(arg0Value, s12_.interop_, s12_.toPointer_, s12_.foreigns_);
                        }
                        s12_ = s12_.next_;
                    }
                }
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
                    FromForeignPointer1Data s13_ = this.fromForeignPointer1_cache;
                    if (s13_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((s13_.foreigns_.isForeign(arg0Value))) {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((!(interop__.isNumber(arg0Value)))) {
                                    return this.fromForeignPointer1Boundary1(state_0, s13_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object fromForeign1Boundary0(int state_0, FromForeign1Data s11_, Object arg0Value) {
        {
            LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
            return fromForeign(arg0Value, foreigns__, s11_.interop_, s11_.exception_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object fromForeignPointer1Boundary1(int state_0, FromForeignPointer1Data s13_, Object arg0Value) {
        {
            InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
            return fromForeignPointer(arg0Value, interop__, s13_.toPointer_, s13_.foreigns_);
        }
    }

    @ExplodeLoop
    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b111111111111110) != 0 /* is SpecializationActive[ToI64.fromInt(int)] || SpecializationActive[ToI64.fromChar(char)] || SpecializationActive[ToI64.fromShort(short)] || SpecializationActive[ToI64.fromLong(long)] || SpecializationActive[ToI64.fromByte(byte)] || SpecializationActive[ToI64.fromFloat(float)] || SpecializationActive[ToI64.fromDouble(double)] || SpecializationActive[ToI64.fromBoolean(boolean)] || SpecializationActive[ToI64.fromString(String, BranchProfile)] || SpecializationActive[ToI64.fromPointer(LLVMPointer)] || SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToI64.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToI64.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToI64.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToI64.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToI64.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToI64.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToI64.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToI64.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToI64.fromString(String, BranchProfile)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                {
                    BranchProfile exception__ = this.fromString_exception_;
                    if (exception__ != null) {
                        return fromString(arg0Value_, exception__);
                    }
                }
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToI64.fromPointer(LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return fromPointer(arg0Value_);
            }
            if ((state_0 & 0b111100000000000) != 0 /* is SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] || SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign0Data s10_ = this.fromForeign0_cache;
                    while (s10_ != null) {
                        if ((s10_.foreigns_.accepts(arg0Value)) && (s10_.foreigns_.isForeign(arg0Value)) && (s10_.interop_.isNumber(s10_.foreigns_.asForeign(arg0Value)))) {
                            return fromForeign(arg0Value, s10_.foreigns_, s10_.interop_, s10_.exception_);
                        }
                        s10_ = s10_.next_;
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign1Data s11_ = this.fromForeign1_cache;
                    if (s11_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
                                if ((foreigns__.isForeign(arg0Value)) && (s11_.interop_.isNumber(foreigns__.asForeign(arg0Value)))) {
                                    return this.fromForeign1Boundary2(state_0, s11_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
                    FromForeignPointer0Data s12_ = this.fromForeignPointer0_cache;
                    while (s12_ != null) {
                        if ((s12_.interop_.accepts(arg0Value)) && (s12_.foreigns_.isForeign(arg0Value)) && (!(s12_.interop_.isNumber(arg0Value)))) {
                            return fromForeignPointer(arg0Value, s12_.interop_, s12_.toPointer_, s12_.foreigns_);
                        }
                        s12_ = s12_.next_;
                    }
                }
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
                    FromForeignPointer1Data s13_ = this.fromForeignPointer1_cache;
                    if (s13_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((s13_.foreigns_.isForeign(arg0Value))) {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((!(interop__.isNumber(arg0Value)))) {
                                    return this.fromForeignPointer1Boundary3(state_0, s13_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object fromForeign1Boundary2(int state_0, FromForeign1Data s11_, Object arg0Value) {
        {
            LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
            return fromForeign(arg0Value, foreigns__, s11_.interop_, s11_.exception_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object fromForeignPointer1Boundary3(int state_0, FromForeignPointer1Data s13_, Object arg0Value) {
        {
            InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
            return fromForeignPointer(arg0Value, interop__, s13_.toPointer_, s13_.foreigns_);
        }
    }

    @SuppressWarnings("unused")
    private Object executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[ToI64.fromInt(int)] */;
            this.state_0_ = state_0;
            return fromInt(arg0Value_);
        }
        if (arg0Value instanceof Character) {
            char arg0Value_ = (char) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[ToI64.fromChar(char)] */;
            this.state_0_ = state_0;
            return fromChar(arg0Value_);
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (short) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[ToI64.fromShort(short)] */;
            this.state_0_ = state_0;
            return fromShort(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[ToI64.fromLong(long)] */;
            this.state_0_ = state_0;
            return fromLong(arg0Value_);
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (byte) arg0Value;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[ToI64.fromByte(byte)] */;
            this.state_0_ = state_0;
            return fromByte(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = (float) arg0Value;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToI64.fromFloat(float)] */;
            this.state_0_ = state_0;
            return fromFloat(arg0Value_);
        }
        if (arg0Value instanceof Double) {
            double arg0Value_ = (double) arg0Value;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToI64.fromDouble(double)] */;
            this.state_0_ = state_0;
            return fromDouble(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToI64.fromBoolean(boolean)] */;
            this.state_0_ = state_0;
            return fromBoolean(arg0Value_);
        }
        if (arg0Value instanceof String) {
            String arg0Value_ = (String) arg0Value;
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.fromString_exception_ = exception__;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ToI64.fromString(String, BranchProfile)] */;
            this.state_0_ = state_0;
            return fromString(arg0Value_, exception__);
        }
        if (LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[ToI64.fromPointer(LLVMPointer)] */;
            this.state_0_ = state_0;
            return fromPointer(arg0Value_);
        }
        if (((state_0 & 0b1000000000000)) == 0 /* is-not SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
            while (true) {
                int count10_ = 0;
                FromForeign0Data s10_ = FROM_FOREIGN0_CACHE_UPDATER.getVolatile(this);
                FromForeign0Data s10_original = s10_;
                while (s10_ != null) {
                    if ((s10_.foreigns_.accepts(arg0Value)) && (s10_.foreigns_.isForeign(arg0Value)) && (s10_.interop_.isNumber(s10_.foreigns_.asForeign(arg0Value)))) {
                        break;
                    }
                    count10_++;
                    s10_ = s10_.next_;
                }
                if (s10_ == null) {
                    {
                        LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.create(arg0Value)));
                        // assert (s10_.foreigns_.accepts(arg0Value));
                        if ((foreigns__.isForeign(arg0Value))) {
                            InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            if ((interop__1.isNumber(foreigns__.asForeign(arg0Value))) && count10_ < (5)) {
                                s10_ = this.insert(new FromForeign0Data(s10_original));
                                Objects.requireNonNull(s10_.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s10_.foreigns_ = foreigns__;
                                Objects.requireNonNull(s10_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s10_.interop_ = interop__1;
                                BranchProfile exception__1 = (BranchProfile.create());
                                Objects.requireNonNull(exception__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s10_.exception_ = exception__1;
                                if (!FROM_FOREIGN0_CACHE_UPDATER.compareAndSet(this, s10_original, s10_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                }
                if (s10_ != null) {
                    return fromForeign(arg0Value, s10_.foreigns_, s10_.interop_, s10_.exception_);
                }
                break;
            }
        }
        {
            LLVMAsForeignLibrary foreigns__ = null;
            {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
                        if ((foreigns__.isForeign(arg0Value))) {
                            InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            if ((interop__1.isNumber(foreigns__.asForeign(arg0Value)))) {
                                FromForeign1Data s11_ = this.insert(new FromForeign1Data());
                                Objects.requireNonNull(s11_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s11_.interop_ = interop__1;
                                BranchProfile exception__1 = (BranchProfile.create());
                                Objects.requireNonNull(exception__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s11_.exception_ = exception__1;
                                VarHandle.storeStoreFence();
                                this.fromForeign1_cache = s11_;
                                this.fromForeign0_cache = null;
                                state_0 = state_0 & 0xfffff7ff /* remove SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */;
                                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[ToI64.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return fromForeign(arg0Value, foreigns__, interop__1, exception__1);
                            }
                        }
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        if (((state_0 & 0b100000000000000)) == 0 /* is-not SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */) {
            while (true) {
                int count12_ = 0;
                FromForeignPointer0Data s12_ = FROM_FOREIGN_POINTER0_CACHE_UPDATER.getVolatile(this);
                FromForeignPointer0Data s12_original = s12_;
                while (s12_ != null) {
                    if ((s12_.interop_.accepts(arg0Value)) && (s12_.foreigns_.isForeign(arg0Value)) && (!(s12_.interop_.isNumber(arg0Value)))) {
                        break;
                    }
                    count12_++;
                    s12_ = s12_.next_;
                }
                if (s12_ == null) {
                    {
                        LLVMAsForeignLibrary foreigns__1 = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                        // assert (s12_.interop_.accepts(arg0Value));
                        if ((foreigns__1.isForeign(arg0Value))) {
                            InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            if ((!(interop__.isNumber(arg0Value))) && count12_ < (5)) {
                                s12_ = this.insert(new FromForeignPointer0Data(s12_original));
                                Objects.requireNonNull(s12_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s12_.interop_ = interop__;
                                s12_.toPointer_ = s12_.insert((ToPointer.create()));
                                Objects.requireNonNull(s12_.insert(foreigns__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s12_.foreigns_ = foreigns__1;
                                if (!FROM_FOREIGN_POINTER0_CACHE_UPDATER.compareAndSet(this, s12_original, s12_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                }
                if (s12_ != null) {
                    return fromForeignPointer(arg0Value, s12_.interop_, s12_.toPointer_, s12_.foreigns_);
                }
                break;
            }
        }
        {
            InteropLibrary interop__ = null;
            {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        LLVMAsForeignLibrary foreigns__1 = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                        if ((foreigns__1.isForeign(arg0Value))) {
                            interop__ = (INTEROP_LIBRARY_.getUncached());
                            if ((!(interop__.isNumber(arg0Value)))) {
                                FromForeignPointer1Data s13_ = this.insert(new FromForeignPointer1Data());
                                s13_.toPointer_ = s13_.insert((ToPointer.create()));
                                Objects.requireNonNull(s13_.insert(foreigns__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s13_.foreigns_ = foreigns__1;
                                VarHandle.storeStoreFence();
                                this.fromForeignPointer1_cache = s13_;
                                this.fromForeignPointer0_cache = null;
                                state_0 = state_0 & 0xffffdfff /* remove SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */;
                                state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[ToI64.fromForeignPointer(Object, InteropLibrary, ToPointer, LLVMAsForeignLibrary)] */;
                                this.state_0_ = state_0;
                                return fromForeignPointer(arg0Value, interop__, s13_.toPointer_, foreigns__1);
                            }
                        }
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToI64.fromInt(int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[ToI64.fromChar(char)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToI64.fromShort(short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[ToI64.fromLong(long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[ToI64.fromByte(byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[ToI64.fromFloat(float)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[ToI64.fromDouble(double)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[ToI64.fromBoolean(boolean)] */;
        }
        {
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.fromString_exception_ = exception__;
            this.fromString_exception_.disable();
            this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[ToI64.fromString(String, BranchProfile)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[ToI64.fromPointer(LLVMPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.fromString_exception_.reset();
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value);
    }

    @NeverDefault
    public static ToI64 create() {
        return new ToI64NodeGen();
    }

    @NeverDefault
    public static ToI64 getUncached() {
        return ToI64NodeGen.UNCACHED;
    }

    @GeneratedBy(ToI64.class)
    @DenyReplace
    private static final class FromForeign0Data extends Node implements SpecializationDataNode {

        @Child FromForeign0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeign}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeign}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeign}
         *   Parameter: {@link BranchProfile} exception</pre>
         */
        @CompilationFinal BranchProfile exception_;

        FromForeign0Data(FromForeign0Data next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(ToI64.class)
    @DenyReplace
    private static final class FromForeign1Data extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeign}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeign}
         *   Parameter: {@link BranchProfile} exception</pre>
         */
        @CompilationFinal BranchProfile exception_;

        FromForeign1Data() {
        }

    }
    @GeneratedBy(ToI64.class)
    @DenyReplace
    private static final class FromForeignPointer0Data extends Node implements SpecializationDataNode {

        @Child FromForeignPointer0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeignPointer}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeignPointer}
         *   Parameter: {@link ToPointer} toPointer</pre>
         */
        @Child ToPointer toPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeignPointer}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;

        FromForeignPointer0Data(FromForeignPointer0Data next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(ToI64.class)
    @DenyReplace
    private static final class FromForeignPointer1Data extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeignPointer}
         *   Parameter: {@link ToPointer} toPointer</pre>
         */
        @Child ToPointer toPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI64#fromForeignPointer}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;

        FromForeignPointer1Data() {
        }

    }
    @GeneratedBy(ToI64.class)
    @DenyReplace
    private static final class Uncached extends ToI64 implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object executeWithForeignToLLVMType(Object arg0Value, Structured type, ForeignToLLVMType ftlType) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return fromString(arg0Value_, (BranchProfile.getUncached()));
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return fromPointer(arg0Value_);
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).isForeign(arg0Value)) && ((INTEROP_LIBRARY_.getUncached()).isNumber((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).asForeign(arg0Value)))) {
                return fromForeign(arg0Value, (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()).isForeign(arg0Value)) && (!((INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)))) {
                return fromForeignPointer(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)), (ToPointerNodeGen.getUncached()), (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()));
            }
            throw newUnsupportedSpecializationException1(this, arg0Value);
        }

        @TruffleBoundary
        @Override
        public Object executeWithType(Object arg0Value, Structured type) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return fromString(arg0Value_, (BranchProfile.getUncached()));
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return fromPointer(arg0Value_);
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).isForeign(arg0Value)) && ((INTEROP_LIBRARY_.getUncached()).isNumber((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).asForeign(arg0Value)))) {
                return fromForeign(arg0Value, (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()).isForeign(arg0Value)) && (!((INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)))) {
                return fromForeignPointer(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)), (ToPointerNodeGen.getUncached()), (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()));
            }
            throw newUnsupportedSpecializationException1(this, arg0Value);
        }

        @TruffleBoundary
        @Override
        public Object executeWithTarget(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return fromString(arg0Value_, (BranchProfile.getUncached()));
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return fromPointer(arg0Value_);
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).isForeign(arg0Value)) && ((INTEROP_LIBRARY_.getUncached()).isNumber((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).asForeign(arg0Value)))) {
                return fromForeign(arg0Value, (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()).isForeign(arg0Value)) && (!((INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)))) {
                return fromForeignPointer(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)), (ToPointerNodeGen.getUncached()), (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()));
            }
            throw newUnsupportedSpecializationException1(this, arg0Value);
        }

    }
}
