// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Value;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.ValueKind;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM.ForeignToLLVMType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToLLVM#doConvert}
 *     Activation probability: 0.48333
 *     With/without class size: 15/8 bytes
 *   Specialization {@link ToLLVM#doConvertTypeMismatch}
 *     Activation probability: 0.33333
 *     With/without class size: 13/12 bytes
 *   Specialization {@link ToLLVM#doUnknownType}
 *     Activation probability: 0.18333
 *     With/without class size: 7/4 bytes
 * </pre>
 */
@GeneratedBy(ToLLVM.class)
@SuppressWarnings({"javadoc", "unused"})
public final class ToLLVMNodeGen extends ToLLVM implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link ToLLVM#doConvert}
     *   2: SpecializationExcluded {@link ToLLVM#doConvert}
     *   3: SpecializationActive {@link ToLLVM#doConvertTypeMismatch}
     *   4: SpecializationActive {@link ToLLVM#doUnknownType}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToLLVM#doConvert}
     *   Parameter: {@link ReadValue} read</pre>
     */
    @Child private ReadValue convert_read_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToLLVM#doConvert}
     *   Parameter: {@link ConvertValue} convert</pre>
     */
    @Child private ConvertValue convert_convert_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToLLVM#doConvertTypeMismatch}
     *   Parameter: {@link ReadValue} read</pre>
     */
    @Child private ReadValue convertTypeMismatch_read_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToLLVM#doConvertTypeMismatch}
     *   Parameter: {@link ConvertValue} convert</pre>
     */
    @Child private ConvertValue convertTypeMismatch_convert_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToLLVM#doConvertTypeMismatch}
     *   Parameter: {@link ReadUnknown} readUnknown</pre>
     */
    @Child private ReadUnknown convertTypeMismatch_readUnknown_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToLLVM#doUnknownType}
     *   Parameter: {@link ReadUnknown} read</pre>
     */
    @Child private ReadUnknown unknownType_read_;

    private ToLLVMNodeGen() {
    }

    @Override
    public Object executeWithType(Object arg0Value, Value arg1Value, ForeignToLLVMType arg2Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }
        if ((state_0 & 0b11010) != 0 /* is SpecializationActive[ToLLVM.doConvert(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue)] || SpecializationActive[ToLLVM.doConvertTypeMismatch(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue, ReadUnknown)] || SpecializationActive[ToLLVM.doUnknownType(Object, Value, ForeignToLLVMType, ReadUnknown)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToLLVM.doConvert(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue)] */) {
                {
                    ReadValue read__ = this.convert_read_;
                    if (read__ != null) {
                        ConvertValue convert__ = this.convert_convert_;
                        if (convert__ != null) {
                            if ((arg1Value != null) && (arg1Value.getSize() == arg2Value.getSizeInBytes())) {
                                try {
                                    return doConvert(arg0Value, arg1Value, arg2Value, read__, convert__);
                                } catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[ToLLVM.doConvert(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToLLVM.doConvertTypeMismatch(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue, ReadUnknown)] */) {
                {
                    ReadValue read__1 = this.convertTypeMismatch_read_;
                    if (read__1 != null) {
                        ConvertValue convert__1 = this.convertTypeMismatch_convert_;
                        if (convert__1 != null) {
                            ReadUnknown readUnknown__ = this.convertTypeMismatch_readUnknown_;
                            if (readUnknown__ != null) {
                                if ((arg1Value != null)) {
                                    return doConvertTypeMismatch(arg0Value, arg1Value, arg2Value, read__1, convert__1, readUnknown__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToLLVM.doUnknownType(Object, Value, ForeignToLLVMType, ReadUnknown)] */) {
                {
                    ReadUnknown read__2 = this.unknownType_read_;
                    if (read__2 != null) {
                        if ((arg1Value == null)) {
                            return ToLLVM.doUnknownType(arg0Value, arg1Value, arg2Value, read__2);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(Object arg0Value, Value arg1Value, ForeignToLLVMType arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[ToLLVM.doConvertTypeMismatch(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue, ReadUnknown)] */ && ((state_0 & 0b100)) == 0 /* is-not SpecializationExcluded  */) {
            if ((arg1Value != null) && (arg1Value.getSize() == arg2Value.getSizeInBytes())) {
                ReadValue read__ = this.insert((ReadValueNodeGen.create()));
                Objects.requireNonNull(read__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.convert_read_ = read__;
                ConvertValue convert__ = this.insert((ConvertValueNodeGen.create()));
                Objects.requireNonNull(convert__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.convert_convert_ = convert__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[ToLLVM.doConvert(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue)] */;
                this.state_0_ = state_0;
                try {
                    return doConvert(arg0Value, arg1Value, arg2Value, read__, convert__);
                } catch (UnsupportedMessageException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[ToLLVM.doConvert(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue)] */;
                    state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                }
            }
        }
        if ((arg1Value != null)) {
            ReadValue read__1 = this.insert((ReadValueNodeGen.create()));
            Objects.requireNonNull(read__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.convertTypeMismatch_read_ = read__1;
            ConvertValue convert__1 = this.insert((ConvertValueNodeGen.create()));
            Objects.requireNonNull(convert__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.convertTypeMismatch_convert_ = convert__1;
            ReadUnknown readUnknown__ = this.insert((ReadUnknownNodeGen.create()));
            Objects.requireNonNull(readUnknown__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.convertTypeMismatch_readUnknown_ = readUnknown__;
            this.convert_read_ = null;
            this.convert_convert_ = null;
            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[ToLLVM.doConvert(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue)] */;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[ToLLVM.doConvertTypeMismatch(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue, ReadUnknown)] */;
            this.state_0_ = state_0;
            return doConvertTypeMismatch(arg0Value, arg1Value, arg2Value, read__1, convert__1, readUnknown__);
        }
        if ((arg1Value == null)) {
            ReadUnknown read__2 = this.insert((ReadUnknownNodeGen.create()));
            Objects.requireNonNull(read__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.unknownType_read_ = read__2;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[ToLLVM.doUnknownType(Object, Value, ForeignToLLVMType, ReadUnknown)] */;
            this.state_0_ = state_0;
            return ToLLVM.doUnknownType(arg0Value, arg1Value, arg2Value, read__2);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            ReadValue read__1 = this.insert((ReadValueNodeGen.create()));
            Objects.requireNonNull(read__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.convertTypeMismatch_read_ = read__1;
            ConvertValue convert__1 = this.insert((ConvertValueNodeGen.create()));
            Objects.requireNonNull(convert__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.convertTypeMismatch_convert_ = convert__1;
            ReadUnknown readUnknown__ = this.insert((ReadUnknownNodeGen.create()));
            Objects.requireNonNull(readUnknown__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.convertTypeMismatch_readUnknown_ = readUnknown__;
            this.convert_read_ = null;
            this.convert_convert_ = null;
            this.state_0_ = state_0_ & 0xfffffffd /* remove SpecializationActive[ToLLVM.doConvert(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue)] */;
            assert NodeUtil.assertRecursion(this.convertTypeMismatch_read_, 1);
            ((GenerateAOT.Provider) this.convertTypeMismatch_read_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(this.convertTypeMismatch_convert_, 1);
            ((GenerateAOT.Provider) this.convertTypeMismatch_convert_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(this.convertTypeMismatch_readUnknown_, 1);
            ((GenerateAOT.Provider) this.convertTypeMismatch_readUnknown_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToLLVM.doConvertTypeMismatch(Object, Value, ForeignToLLVMType, ReadValue, ConvertValue, ReadUnknown)] */;
        }
        {
            ReadUnknown read__2 = this.insert((ReadUnknownNodeGen.create()));
            Objects.requireNonNull(read__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.unknownType_read_ = read__2;
            assert NodeUtil.assertRecursion(this.unknownType_read_, 1);
            ((GenerateAOT.Provider) this.unknownType_read_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[ToLLVM.doUnknownType(Object, Value, ForeignToLLVMType, ReadUnknown)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.convertTypeMismatch_read_ = null;
        this.convertTypeMismatch_convert_ = null;
        this.convertTypeMismatch_readUnknown_ = null;
        this.unknownType_read_ = null;
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException3(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
    }

    @NeverDefault
    public static ToLLVM create() {
        return new ToLLVMNodeGen();
    }

    @NeverDefault
    public static ToLLVM getUncached() {
        return ToLLVMNodeGen.UNCACHED;
    }

    @GeneratedBy(ToLLVM.class)
    @DenyReplace
    private static final class Uncached extends ToLLVM implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object executeWithType(Object arg0Value, Value arg1Value, ForeignToLLVMType arg2Value) {
            if ((arg1Value != null)) {
                return doConvertTypeMismatch(arg0Value, arg1Value, arg2Value, (ReadValueNodeGen.getUncached()), (ConvertValueNodeGen.getUncached()), (ReadUnknownNodeGen.getUncached()));
            }
            if ((arg1Value == null)) {
                return ToLLVM.doUnknownType(arg0Value, arg1Value, arg2Value, (ReadUnknownNodeGen.getUncached()));
            }
            throw newUnsupportedSpecializationException3(this, arg0Value, arg1Value, arg2Value);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link WrapPointer#doPointer}
     *     Activation probability: 0.32000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link WrapPointer#doTyped}
     *     Activation probability: 0.26000
     *     With/without class size: 10/4 bytes
     *   Specialization {@link WrapPointer#doTyped}
     *     Activation probability: 0.20000
     *     With/without class size: 6/0 bytes
     *   Specialization {@link WrapPointer#doUntyped}
     *     Activation probability: 0.14000
     *     With/without class size: 7/4 bytes
     *   Specialization {@link WrapPointer#doUntyped}
     *     Activation probability: 0.08000
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(WrapPointer.class)
    @SuppressWarnings("javadoc")
    static final class WrapPointerNodeGen extends WrapPointer implements GenerateAOT.Provider {

        static final ReferenceField<Typed0Data> TYPED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "typed0_cache", Typed0Data.class);
        static final ReferenceField<Untyped0Data> UNTYPED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "untyped0_cache", Untyped0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link WrapPointer#doPointer}
         *   2: SpecializationActive {@link WrapPointer#doTyped}
         *   3: SpecializationActive {@link WrapPointer#doTyped}
         *   4: SpecializationActive {@link WrapPointer#doUntyped}
         *   5: SpecializationActive {@link WrapPointer#doUntyped}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Typed0Data typed0_cache;
        @UnsafeAccessedField @Child private Untyped0Data untyped0_cache;

        private WrapPointerNodeGen() {
        }

        @ExplodeLoop
        @Override
        protected LLVMPointer execute(Object arg0Value, Structured arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[ToLLVM.WrapPointer.doPointer(LLVMPointer, Structured)] || SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] || SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] || SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] || SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToLLVM.WrapPointer.doPointer(LLVMPointer, Structured)] */ && LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    return doPointer(arg0Value_, arg1Value);
                }
                if ((state_0 & 0b111100) != 0 /* is SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] || SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] || SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] || SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] */) {
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] */) {
                        Typed0Data s1_ = this.typed0_cache;
                        while (s1_ != null) {
                            if ((s1_.nativeTypes_.accepts(arg0Value)) && (!(WrapPointer.isPointer(arg0Value))) && (arg1Value != null) && (!(s1_.nativeTypes_.hasNativeType(arg0Value)))) {
                                return doTyped(arg0Value, arg1Value, s1_.nativeTypes_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((!(WrapPointer.isPointer(arg0Value))) && (arg1Value != null)) {
                                NativeTypeLibrary nativeTypes__ = (NATIVE_TYPE_LIBRARY_.getUncached());
                                if ((!(nativeTypes__.hasNativeType(arg0Value)))) {
                                    return this.typed1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] */) {
                        Untyped0Data s3_ = this.untyped0_cache;
                        while (s3_ != null) {
                            if ((s3_.nativeTypes_.accepts(arg0Value)) && (!(WrapPointer.isPointer(arg0Value))) && (arg1Value == null || s3_.nativeTypes_.hasNativeType(arg0Value))) {
                                return doUntyped(arg0Value, arg1Value, s3_.nativeTypes_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((!(WrapPointer.isPointer(arg0Value)))) {
                                NativeTypeLibrary nativeTypes__1 = (NATIVE_TYPE_LIBRARY_.getUncached());
                                if ((arg1Value == null || nativeTypes__1.hasNativeType(arg0Value))) {
                                    return this.untyped1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMPointer typed1Boundary(int state_0, Object arg0Value, Structured arg1Value) {
            {
                NativeTypeLibrary nativeTypes__ = (NATIVE_TYPE_LIBRARY_.getUncached());
                return doTyped(arg0Value, arg1Value, nativeTypes__);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMPointer untyped1Boundary(int state_0, Object arg0Value, Structured arg1Value) {
            {
                NativeTypeLibrary nativeTypes__1 = (NATIVE_TYPE_LIBRARY_.getUncached());
                return doUntyped(arg0Value, arg1Value, nativeTypes__1);
            }
        }

        @SuppressWarnings("unused")
        private LLVMPointer executeAndSpecialize(Object arg0Value, Structured arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                state_0 = state_0 | 0b10 /* add SpecializationActive[ToLLVM.WrapPointer.doPointer(LLVMPointer, Structured)] */;
                this.state_0_ = state_0;
                return doPointer(arg0Value_, arg1Value);
            }
            if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] */) {
                while (true) {
                    int count1_ = 0;
                    Typed0Data s1_ = TYPED0_CACHE_UPDATER.getVolatile(this);
                    Typed0Data s1_original = s1_;
                    while (s1_ != null) {
                        if ((s1_.nativeTypes_.accepts(arg0Value)) && (!(WrapPointer.isPointer(arg0Value))) && (arg1Value != null) && (!(s1_.nativeTypes_.hasNativeType(arg0Value)))) {
                            break;
                        }
                        count1_++;
                        s1_ = s1_.next_;
                    }
                    if (s1_ == null) {
                        if ((!(WrapPointer.isPointer(arg0Value))) && (arg1Value != null)) {
                            // assert (s1_.nativeTypes_.accepts(arg0Value));
                            NativeTypeLibrary nativeTypes__ = this.insert((NATIVE_TYPE_LIBRARY_.create(arg0Value)));
                            if ((!(nativeTypes__.hasNativeType(arg0Value))) && count1_ < (3)) {
                                s1_ = this.insert(new Typed0Data(s1_original));
                                Objects.requireNonNull(s1_.insert(nativeTypes__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s1_.nativeTypes_ = nativeTypes__;
                                if (!TYPED0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100 /* add SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s1_ != null) {
                        return doTyped(arg0Value, arg1Value, s1_.nativeTypes_);
                    }
                    break;
                }
            }
            {
                NativeTypeLibrary nativeTypes__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((!(WrapPointer.isPointer(arg0Value))) && (arg1Value != null)) {
                            nativeTypes__ = (NATIVE_TYPE_LIBRARY_.getUncached());
                            if ((!(nativeTypes__.hasNativeType(arg0Value)))) {
                                this.typed0_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[ToLLVM.WrapPointer.doTyped(Object, Structured, NativeTypeLibrary)] */;
                                this.state_0_ = state_0;
                                return doTyped(arg0Value, arg1Value, nativeTypes__);
                            }
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] */) {
                while (true) {
                    int count3_ = 0;
                    Untyped0Data s3_ = UNTYPED0_CACHE_UPDATER.getVolatile(this);
                    Untyped0Data s3_original = s3_;
                    while (s3_ != null) {
                        if ((s3_.nativeTypes_.accepts(arg0Value)) && (!(WrapPointer.isPointer(arg0Value))) && (arg1Value == null || s3_.nativeTypes_.hasNativeType(arg0Value))) {
                            break;
                        }
                        count3_++;
                        s3_ = s3_.next_;
                    }
                    if (s3_ == null) {
                        if ((!(WrapPointer.isPointer(arg0Value)))) {
                            // assert (s3_.nativeTypes_.accepts(arg0Value));
                            NativeTypeLibrary nativeTypes__1 = this.insert((NATIVE_TYPE_LIBRARY_.create(arg0Value)));
                            if ((arg1Value == null || nativeTypes__1.hasNativeType(arg0Value)) && count3_ < (3)) {
                                s3_ = this.insert(new Untyped0Data(s3_original));
                                Objects.requireNonNull(s3_.insert(nativeTypes__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s3_.nativeTypes_ = nativeTypes__1;
                                if (!UNTYPED0_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s3_ != null) {
                        return doUntyped(arg0Value, arg1Value, s3_.nativeTypes_);
                    }
                    break;
                }
            }
            {
                NativeTypeLibrary nativeTypes__1 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((!(WrapPointer.isPointer(arg0Value)))) {
                            nativeTypes__1 = (NATIVE_TYPE_LIBRARY_.getUncached());
                            if ((arg1Value == null || nativeTypes__1.hasNativeType(arg0Value))) {
                                this.untyped0_cache = null;
                                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] */;
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[ToLLVM.WrapPointer.doUntyped(Object, Structured, NativeTypeLibrary)] */;
                                this.state_0_ = state_0;
                                return doUntyped(arg0Value, arg1Value, nativeTypes__1);
                            }
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToLLVM.WrapPointer.doPointer(LLVMPointer, Structured)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
        }

        @NeverDefault
        public static WrapPointer create() {
            return new WrapPointerNodeGen();
        }

        @NeverDefault
        public static WrapPointer getUncached() {
            return WrapPointerNodeGen.UNCACHED;
        }

        @GeneratedBy(WrapPointer.class)
        @DenyReplace
        private static final class Typed0Data extends Node implements SpecializationDataNode {

            @Child Typed0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WrapPointer#doTyped}
             *   Parameter: {@link NativeTypeLibrary} nativeTypes</pre>
             */
            @Child NativeTypeLibrary nativeTypes_;

            Typed0Data(Typed0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(WrapPointer.class)
        @DenyReplace
        private static final class Untyped0Data extends Node implements SpecializationDataNode {

            @Child Untyped0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WrapPointer#doUntyped}
             *   Parameter: {@link NativeTypeLibrary} nativeTypes</pre>
             */
            @Child NativeTypeLibrary nativeTypes_;

            Untyped0Data(Untyped0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(WrapPointer.class)
        @DenyReplace
        private static final class Uncached extends WrapPointer implements UnadoptableNode {

            @TruffleBoundary
            @Override
            protected LLVMPointer execute(Object arg0Value, Structured arg1Value) {
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    return doPointer(arg0Value_, arg1Value);
                }
                if ((!(WrapPointer.isPointer(arg0Value))) && (arg1Value != null) && (!((NATIVE_TYPE_LIBRARY_.getUncached(arg0Value)).hasNativeType(arg0Value)))) {
                    return doTyped(arg0Value, arg1Value, (NATIVE_TYPE_LIBRARY_.getUncached(arg0Value)));
                }
                if ((!(WrapPointer.isPointer(arg0Value))) && (arg1Value == null || (NATIVE_TYPE_LIBRARY_.getUncached(arg0Value)).hasNativeType(arg0Value))) {
                    return doUntyped(arg0Value, arg1Value, (NATIVE_TYPE_LIBRARY_.getUncached(arg0Value)));
                }
                throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ReadValue#doI1}
     *     Activation probability: 0.11917
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ReadValue#doI1}
     *     Activation probability: 0.11167
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ReadValue#doI8}
     *     Activation probability: 0.10417
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ReadValue#doI8}
     *     Activation probability: 0.09667
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ReadValue#doI16}
     *     Activation probability: 0.08917
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ReadValue#doI16}
     *     Activation probability: 0.08167
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ReadValue#doI32}
     *     Activation probability: 0.07417
     *     With/without class size: 5/4 bytes
     *   Specialization {@link ReadValue#doI32}
     *     Activation probability: 0.06667
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ReadValue#doI64}
     *     Activation probability: 0.05917
     *     With/without class size: 5/4 bytes
     *   Specialization {@link ReadValue#doI64}
     *     Activation probability: 0.05167
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ReadValue#doFloat}
     *     Activation probability: 0.04417
     *     With/without class size: 5/4 bytes
     *   Specialization {@link ReadValue#doFloat}
     *     Activation probability: 0.03667
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ReadValue#doDouble}
     *     Activation probability: 0.02917
     *     With/without class size: 4/4 bytes
     *   Specialization {@link ReadValue#doDouble}
     *     Activation probability: 0.02167
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ReadValue#doPointer}
     *     Activation probability: 0.01417
     *     With/without class size: 4/4 bytes
     * </pre>
     */
    @GeneratedBy(ReadValue.class)
    @SuppressWarnings("javadoc")
    static final class ReadValueNodeGen extends ReadValue implements GenerateAOT.Provider {

        static final ReferenceField<I10Data> I10_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i10_cache", I10Data.class);
        static final ReferenceField<I80Data> I80_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i80_cache", I80Data.class);
        static final ReferenceField<I160Data> I160_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i160_cache", I160Data.class);
        static final ReferenceField<I320Data> I320_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i320_cache", I320Data.class);
        static final ReferenceField<I640Data> I640_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i640_cache", I640Data.class);
        static final ReferenceField<Float0Data> FLOAT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "float0_cache", Float0Data.class);
        static final ReferenceField<Double0Data> DOUBLE0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "double0_cache", Double0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ReadValue#doI1}
         *   2: SpecializationActive {@link ReadValue#doI1}
         *   3: SpecializationActive {@link ReadValue#doI8}
         *   4: SpecializationActive {@link ReadValue#doI8}
         *   5: SpecializationActive {@link ReadValue#doI16}
         *   6: SpecializationActive {@link ReadValue#doI16}
         *   7: SpecializationActive {@link ReadValue#doI32}
         *   8: SpecializationActive {@link ReadValue#doI32}
         *   9: SpecializationActive {@link ReadValue#doI64}
         *   10: SpecializationActive {@link ReadValue#doI64}
         *   11: SpecializationActive {@link ReadValue#doFloat}
         *   12: SpecializationActive {@link ReadValue#doFloat}
         *   13: SpecializationActive {@link ReadValue#doDouble}
         *   14: SpecializationActive {@link ReadValue#doDouble}
         *   15: SpecializationActive {@link ReadValue#doPointer}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private I10Data i10_cache;
        @UnsafeAccessedField @Child private I80Data i80_cache;
        @UnsafeAccessedField @Child private I160Data i160_cache;
        @UnsafeAccessedField @Child private I320Data i320_cache;
        @UnsafeAccessedField @Child private I640Data i640_cache;
        @UnsafeAccessedField @Child private Float0Data float0_cache;
        @UnsafeAccessedField @Child private Double0Data double0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ReadValue#doPointer}
         *   Parameter: {@link WrapPointer} wrap</pre>
         */
        @Child private WrapPointer pointer_wrap_;

        private ReadValueNodeGen() {
        }

        @ExplodeLoop
        @Override
        protected Object execute(Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b1111111111111110) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI1(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doI1(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doI8(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doI8(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doI16(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doI16(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doI32(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doI32(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doI64(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doI64(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doFloat(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doFloat(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doDouble(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doDouble(Object, Value, InteropLibrary)] || SpecializationActive[ToLLVM.ReadValue.doPointer(Object, Value, WrapPointer)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI1(Object, Value, InteropLibrary)] */) {
                    I10Data s0_ = this.i10_cache;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I1)) {
                            return ReadValue.doI1(arg0Value, arg1Value, s0_.interop_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI1(Object, Value, InteropLibrary)] */) {
                    if ((arg1Value.kind == ValueKind.I1)) {
                        return this.i11Boundary(state_0, arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI8(Object, Value, InteropLibrary)] */) {
                    I80Data s2_ = this.i80_cache;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I8)) {
                            return ReadValue.doI8(arg0Value, arg1Value, s2_.interop_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI8(Object, Value, InteropLibrary)] */) {
                    if ((arg1Value.kind == ValueKind.I8)) {
                        return this.i81Boundary(state_0, arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI16(Object, Value, InteropLibrary)] */) {
                    I160Data s4_ = this.i160_cache;
                    while (s4_ != null) {
                        if ((s4_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I16)) {
                            return ReadValue.doI16(arg0Value, arg1Value, s4_.interop_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI16(Object, Value, InteropLibrary)] */) {
                    if ((arg1Value.kind == ValueKind.I16)) {
                        return this.i161Boundary(state_0, arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI32(Object, Value, InteropLibrary)] */) {
                    I320Data s6_ = this.i320_cache;
                    while (s6_ != null) {
                        if ((s6_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I32)) {
                            return ReadValue.doI32(arg0Value, arg1Value, s6_.interop_);
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI32(Object, Value, InteropLibrary)] */) {
                    if ((arg1Value.kind == ValueKind.I32)) {
                        return this.i321Boundary(state_0, arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI64(Object, Value, InteropLibrary)] */) {
                    I640Data s8_ = this.i640_cache;
                    while (s8_ != null) {
                        if ((s8_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I64)) {
                            return ReadValue.doI64(arg0Value, arg1Value, s8_.interop_);
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doI64(Object, Value, InteropLibrary)] */) {
                    if ((arg1Value.kind == ValueKind.I64)) {
                        return this.i641Boundary(state_0, arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doFloat(Object, Value, InteropLibrary)] */) {
                    Float0Data s10_ = this.float0_cache;
                    while (s10_ != null) {
                        if ((s10_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.FLOAT)) {
                            return ReadValue.doFloat(arg0Value, arg1Value, s10_.interop_);
                        }
                        s10_ = s10_.next_;
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doFloat(Object, Value, InteropLibrary)] */) {
                    if ((arg1Value.kind == ValueKind.FLOAT)) {
                        return this.float1Boundary(state_0, arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doDouble(Object, Value, InteropLibrary)] */) {
                    Double0Data s12_ = this.double0_cache;
                    while (s12_ != null) {
                        if ((s12_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.DOUBLE)) {
                            return ReadValue.doDouble(arg0Value, arg1Value, s12_.interop_);
                        }
                        s12_ = s12_.next_;
                    }
                }
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doDouble(Object, Value, InteropLibrary)] */) {
                    if ((arg1Value.kind == ValueKind.DOUBLE)) {
                        return this.double1Boundary(state_0, arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[ToLLVM.ReadValue.doPointer(Object, Value, WrapPointer)] */) {
                    {
                        WrapPointer wrap__ = this.pointer_wrap_;
                        if (wrap__ != null) {
                            if ((arg1Value.kind == ValueKind.POINTER)) {
                                return ReadValue.doPointer(arg0Value, arg1Value, wrap__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object i11Boundary(int state_0, Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return ReadValue.doI1(arg0Value, arg1Value, interop__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object i81Boundary(int state_0, Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return ReadValue.doI8(arg0Value, arg1Value, interop__1);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object i161Boundary(int state_0, Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__2 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return ReadValue.doI16(arg0Value, arg1Value, interop__2);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object i321Boundary(int state_0, Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__3 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return ReadValue.doI32(arg0Value, arg1Value, interop__3);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object i641Boundary(int state_0, Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__4 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return ReadValue.doI64(arg0Value, arg1Value, interop__4);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object float1Boundary(int state_0, Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__5 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return ReadValue.doFloat(arg0Value, arg1Value, interop__5);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object double1Boundary(int state_0, Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__6 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return ReadValue.doDouble(arg0Value, arg1Value, interop__6);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[ToLLVM.ReadValue.doI1(Object, Value, InteropLibrary)] */) {
                while (true) {
                    int count0_ = 0;
                    I10Data s0_ = I10_CACHE_UPDATER.getVolatile(this);
                    I10Data s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I1)) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        if ((arg1Value.kind == ValueKind.I1) && count0_ < (3)) {
                            // assert (s0_.interop_.accepts(arg0Value));
                            s0_ = this.insert(new I10Data(s0_original));
                            InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.interop_ = interop__;
                            if (!I10_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[ToLLVM.ReadValue.doI1(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s0_ != null) {
                        return ReadValue.doI1(arg0Value, arg1Value, s0_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((arg1Value.kind == ValueKind.I1)) {
                            interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                            this.i10_cache = null;
                            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[ToLLVM.ReadValue.doI1(Object, Value, InteropLibrary)] */;
                            state_0 = state_0 | 0b100 /* add SpecializationActive[ToLLVM.ReadValue.doI1(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadValue.doI1(arg0Value, arg1Value, interop__);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[ToLLVM.ReadValue.doI8(Object, Value, InteropLibrary)] */) {
                while (true) {
                    int count2_ = 0;
                    I80Data s2_ = I80_CACHE_UPDATER.getVolatile(this);
                    I80Data s2_original = s2_;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I8)) {
                            break;
                        }
                        count2_++;
                        s2_ = s2_.next_;
                    }
                    if (s2_ == null) {
                        if ((arg1Value.kind == ValueKind.I8) && count2_ < (3)) {
                            // assert (s2_.interop_.accepts(arg0Value));
                            s2_ = this.insert(new I80Data(s2_original));
                            InteropLibrary interop__1 = s2_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.interop_ = interop__1;
                            if (!I80_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[ToLLVM.ReadValue.doI8(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s2_ != null) {
                        return ReadValue.doI8(arg0Value, arg1Value, s2_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__1 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((arg1Value.kind == ValueKind.I8)) {
                            interop__1 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                            this.i80_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[ToLLVM.ReadValue.doI8(Object, Value, InteropLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[ToLLVM.ReadValue.doI8(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadValue.doI8(arg0Value, arg1Value, interop__1);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[ToLLVM.ReadValue.doI16(Object, Value, InteropLibrary)] */) {
                while (true) {
                    int count4_ = 0;
                    I160Data s4_ = I160_CACHE_UPDATER.getVolatile(this);
                    I160Data s4_original = s4_;
                    while (s4_ != null) {
                        if ((s4_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I16)) {
                            break;
                        }
                        count4_++;
                        s4_ = s4_.next_;
                    }
                    if (s4_ == null) {
                        if ((arg1Value.kind == ValueKind.I16) && count4_ < (3)) {
                            // assert (s4_.interop_.accepts(arg0Value));
                            s4_ = this.insert(new I160Data(s4_original));
                            InteropLibrary interop__2 = s4_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s4_.interop_ = interop__2;
                            if (!I160_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[ToLLVM.ReadValue.doI16(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s4_ != null) {
                        return ReadValue.doI16(arg0Value, arg1Value, s4_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__2 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((arg1Value.kind == ValueKind.I16)) {
                            interop__2 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                            this.i160_cache = null;
                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[ToLLVM.ReadValue.doI16(Object, Value, InteropLibrary)] */;
                            state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToLLVM.ReadValue.doI16(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadValue.doI16(arg0Value, arg1Value, interop__2);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[ToLLVM.ReadValue.doI32(Object, Value, InteropLibrary)] */) {
                while (true) {
                    int count6_ = 0;
                    I320Data s6_ = I320_CACHE_UPDATER.getVolatile(this);
                    I320Data s6_original = s6_;
                    while (s6_ != null) {
                        if ((s6_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I32)) {
                            break;
                        }
                        count6_++;
                        s6_ = s6_.next_;
                    }
                    if (s6_ == null) {
                        if ((arg1Value.kind == ValueKind.I32) && count6_ < (3)) {
                            // assert (s6_.interop_.accepts(arg0Value));
                            s6_ = this.insert(new I320Data(s6_original));
                            InteropLibrary interop__3 = s6_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__3, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s6_.interop_ = interop__3;
                            if (!I320_CACHE_UPDATER.compareAndSet(this, s6_original, s6_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToLLVM.ReadValue.doI32(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s6_ != null) {
                        return ReadValue.doI32(arg0Value, arg1Value, s6_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__3 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((arg1Value.kind == ValueKind.I32)) {
                            interop__3 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                            this.i320_cache = null;
                            state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[ToLLVM.ReadValue.doI32(Object, Value, InteropLibrary)] */;
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToLLVM.ReadValue.doI32(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadValue.doI32(arg0Value, arg1Value, interop__3);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            if (((state_0 & 0b10000000000)) == 0 /* is-not SpecializationActive[ToLLVM.ReadValue.doI64(Object, Value, InteropLibrary)] */) {
                while (true) {
                    int count8_ = 0;
                    I640Data s8_ = I640_CACHE_UPDATER.getVolatile(this);
                    I640Data s8_original = s8_;
                    while (s8_ != null) {
                        if ((s8_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.I64)) {
                            break;
                        }
                        count8_++;
                        s8_ = s8_.next_;
                    }
                    if (s8_ == null) {
                        if ((arg1Value.kind == ValueKind.I64) && count8_ < (3)) {
                            // assert (s8_.interop_.accepts(arg0Value));
                            s8_ = this.insert(new I640Data(s8_original));
                            InteropLibrary interop__4 = s8_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__4, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s8_.interop_ = interop__4;
                            if (!I640_CACHE_UPDATER.compareAndSet(this, s8_original, s8_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ToLLVM.ReadValue.doI64(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s8_ != null) {
                        return ReadValue.doI64(arg0Value, arg1Value, s8_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__4 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((arg1Value.kind == ValueKind.I64)) {
                            interop__4 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                            this.i640_cache = null;
                            state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[ToLLVM.ReadValue.doI64(Object, Value, InteropLibrary)] */;
                            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[ToLLVM.ReadValue.doI64(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadValue.doI64(arg0Value, arg1Value, interop__4);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            if (((state_0 & 0b1000000000000)) == 0 /* is-not SpecializationActive[ToLLVM.ReadValue.doFloat(Object, Value, InteropLibrary)] */) {
                while (true) {
                    int count10_ = 0;
                    Float0Data s10_ = FLOAT0_CACHE_UPDATER.getVolatile(this);
                    Float0Data s10_original = s10_;
                    while (s10_ != null) {
                        if ((s10_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.FLOAT)) {
                            break;
                        }
                        count10_++;
                        s10_ = s10_.next_;
                    }
                    if (s10_ == null) {
                        if ((arg1Value.kind == ValueKind.FLOAT) && count10_ < (3)) {
                            // assert (s10_.interop_.accepts(arg0Value));
                            s10_ = this.insert(new Float0Data(s10_original));
                            InteropLibrary interop__5 = s10_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__5, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s10_.interop_ = interop__5;
                            if (!FLOAT0_CACHE_UPDATER.compareAndSet(this, s10_original, s10_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[ToLLVM.ReadValue.doFloat(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s10_ != null) {
                        return ReadValue.doFloat(arg0Value, arg1Value, s10_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__5 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((arg1Value.kind == ValueKind.FLOAT)) {
                            interop__5 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                            this.float0_cache = null;
                            state_0 = state_0 & 0xfffff7ff /* remove SpecializationActive[ToLLVM.ReadValue.doFloat(Object, Value, InteropLibrary)] */;
                            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[ToLLVM.ReadValue.doFloat(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadValue.doFloat(arg0Value, arg1Value, interop__5);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            if (((state_0 & 0b100000000000000)) == 0 /* is-not SpecializationActive[ToLLVM.ReadValue.doDouble(Object, Value, InteropLibrary)] */) {
                while (true) {
                    int count12_ = 0;
                    Double0Data s12_ = DOUBLE0_CACHE_UPDATER.getVolatile(this);
                    Double0Data s12_original = s12_;
                    while (s12_ != null) {
                        if ((s12_.interop_.accepts(arg0Value)) && (arg1Value.kind == ValueKind.DOUBLE)) {
                            break;
                        }
                        count12_++;
                        s12_ = s12_.next_;
                    }
                    if (s12_ == null) {
                        if ((arg1Value.kind == ValueKind.DOUBLE) && count12_ < (3)) {
                            // assert (s12_.interop_.accepts(arg0Value));
                            s12_ = this.insert(new Double0Data(s12_original));
                            InteropLibrary interop__6 = s12_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__6, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s12_.interop_ = interop__6;
                            if (!DOUBLE0_CACHE_UPDATER.compareAndSet(this, s12_original, s12_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[ToLLVM.ReadValue.doDouble(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s12_ != null) {
                        return ReadValue.doDouble(arg0Value, arg1Value, s12_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__6 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((arg1Value.kind == ValueKind.DOUBLE)) {
                            interop__6 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                            this.double0_cache = null;
                            state_0 = state_0 & 0xffffdfff /* remove SpecializationActive[ToLLVM.ReadValue.doDouble(Object, Value, InteropLibrary)] */;
                            state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[ToLLVM.ReadValue.doDouble(Object, Value, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadValue.doDouble(arg0Value, arg1Value, interop__6);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            if ((arg1Value.kind == ValueKind.POINTER)) {
                WrapPointer wrap__ = this.insert((WrapPointerNodeGen.create()));
                Objects.requireNonNull(wrap__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.pointer_wrap_ = wrap__;
                state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[ToLLVM.ReadValue.doPointer(Object, Value, WrapPointer)] */;
                this.state_0_ = state_0;
                return ReadValue.doPointer(arg0Value, arg1Value, wrap__);
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                WrapPointer wrap__ = this.insert((WrapPointerNodeGen.create()));
                Objects.requireNonNull(wrap__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.pointer_wrap_ = wrap__;
                assert NodeUtil.assertRecursion(this.pointer_wrap_, 1);
                ((GenerateAOT.Provider) this.pointer_wrap_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000000000000000 /* add SpecializationActive[ToLLVM.ReadValue.doPointer(Object, Value, WrapPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_wrap_ = null;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
        }

        @NeverDefault
        public static ReadValue create() {
            return new ReadValueNodeGen();
        }

        @NeverDefault
        public static ReadValue getUncached() {
            return ReadValueNodeGen.UNCACHED;
        }

        @GeneratedBy(ReadValue.class)
        @DenyReplace
        private static final class I10Data extends Node implements SpecializationDataNode {

            @Child I10Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadValue#doI1}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            I10Data(I10Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadValue.class)
        @DenyReplace
        private static final class I80Data extends Node implements SpecializationDataNode {

            @Child I80Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadValue#doI8}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            I80Data(I80Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadValue.class)
        @DenyReplace
        private static final class I160Data extends Node implements SpecializationDataNode {

            @Child I160Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadValue#doI16}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            I160Data(I160Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadValue.class)
        @DenyReplace
        private static final class I320Data extends Node implements SpecializationDataNode {

            @Child I320Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadValue#doI32}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            I320Data(I320Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadValue.class)
        @DenyReplace
        private static final class I640Data extends Node implements SpecializationDataNode {

            @Child I640Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadValue#doI64}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            I640Data(I640Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadValue.class)
        @DenyReplace
        private static final class Float0Data extends Node implements SpecializationDataNode {

            @Child Float0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadValue#doFloat}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Float0Data(Float0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadValue.class)
        @DenyReplace
        private static final class Double0Data extends Node implements SpecializationDataNode {

            @Child Double0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadValue#doDouble}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Double0Data(Double0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadValue.class)
        @DenyReplace
        private static final class Uncached extends ReadValue implements UnadoptableNode {

            @TruffleBoundary
            @Override
            protected Object execute(Object arg0Value, Value arg1Value) throws UnsupportedMessageException {
                if ((arg1Value.kind == ValueKind.I1)) {
                    return ReadValue.doI1(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
                }
                if ((arg1Value.kind == ValueKind.I8)) {
                    return ReadValue.doI8(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
                }
                if ((arg1Value.kind == ValueKind.I16)) {
                    return ReadValue.doI16(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
                }
                if ((arg1Value.kind == ValueKind.I32)) {
                    return ReadValue.doI32(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
                }
                if ((arg1Value.kind == ValueKind.I64)) {
                    return ReadValue.doI64(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
                }
                if ((arg1Value.kind == ValueKind.FLOAT)) {
                    return ReadValue.doFloat(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
                }
                if ((arg1Value.kind == ValueKind.DOUBLE)) {
                    return ReadValue.doDouble(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
                }
                if ((arg1Value.kind == ValueKind.POINTER)) {
                    return ReadValue.doPointer(arg0Value, arg1Value, (WrapPointerNodeGen.getUncached()));
                }
                throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ConvertValue#doI1}
     *     Activation probability: 0.11213
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ConvertValue#doI8}
     *     Activation probability: 0.10551
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ConvertValue#doI16}
     *     Activation probability: 0.09890
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ConvertValue#doI32(int, ForeignToLLVMType)}
     *     Activation probability: 0.09228
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ConvertValue#doI32(float, ForeignToLLVMType)}
     *     Activation probability: 0.08566
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ConvertValue#doI64(long, ForeignToLLVMType)}
     *     Activation probability: 0.07904
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doI64(double, ForeignToLLVMType)}
     *     Activation probability: 0.07243
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doI64(LLVMPointer, ForeignToLLVMType)}
     *     Activation probability: 0.06581
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doFloat(float, ForeignToLLVMType)}
     *     Activation probability: 0.05919
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doFloat(int, ForeignToLLVMType)}
     *     Activation probability: 0.05257
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doDouble(double, ForeignToLLVMType)}
     *     Activation probability: 0.04596
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doDouble(long, ForeignToLLVMType)}
     *     Activation probability: 0.03934
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doDouble(LLVMPointer, ForeignToLLVMType)}
     *     Activation probability: 0.03272
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doPointer(LLVMPointer, ForeignToLLVMType)}
     *     Activation probability: 0.02610
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doPointer(long, ForeignToLLVMType)}
     *     Activation probability: 0.01949
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ConvertValue#doPointer(double, ForeignToLLVMType)}
     *     Activation probability: 0.01287
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(ConvertValue.class)
    @SuppressWarnings("javadoc")
    static final class ConvertValueNodeGen extends ConvertValue implements GenerateAOT.Provider {

        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ConvertValue#doI1}
         *   2: SpecializationActive {@link ConvertValue#doI8}
         *   3: SpecializationActive {@link ConvertValue#doI16}
         *   4: SpecializationActive {@link ConvertValue#doI32(int, ForeignToLLVMType)}
         *   5: SpecializationActive {@link ConvertValue#doI32(float, ForeignToLLVMType)}
         *   6: SpecializationActive {@link ConvertValue#doI64(long, ForeignToLLVMType)}
         *   7: SpecializationActive {@link ConvertValue#doI64(double, ForeignToLLVMType)}
         *   8: SpecializationActive {@link ConvertValue#doI64(LLVMPointer, ForeignToLLVMType)}
         *   9: SpecializationActive {@link ConvertValue#doFloat(float, ForeignToLLVMType)}
         *   10: SpecializationActive {@link ConvertValue#doFloat(int, ForeignToLLVMType)}
         *   11: SpecializationActive {@link ConvertValue#doDouble(double, ForeignToLLVMType)}
         *   12: SpecializationActive {@link ConvertValue#doDouble(long, ForeignToLLVMType)}
         *   13: SpecializationActive {@link ConvertValue#doDouble(LLVMPointer, ForeignToLLVMType)}
         *   14: SpecializationActive {@link ConvertValue#doPointer(LLVMPointer, ForeignToLLVMType)}
         *   15: SpecializationActive {@link ConvertValue#doPointer(long, ForeignToLLVMType)}
         *   16: SpecializationActive {@link ConvertValue#doPointer(double, ForeignToLLVMType)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private ConvertValueNodeGen() {
        }

        @Override
        protected Object execute(Object arg0Value, ForeignToLLVMType arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0x1fffe) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doI1(boolean, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doI8(byte, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doI16(short, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doI32(int, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doI32(float, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doI64(long, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doI64(double, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doI64(LLVMPointer, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doFloat(float, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doFloat(int, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doDouble(double, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doDouble(long, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doDouble(LLVMPointer, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doPointer(LLVMPointer, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doPointer(long, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doPointer(double, ForeignToLLVMType)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doI1(boolean, ForeignToLLVMType)] */ && arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I1)) {
                        return ConvertValue.doI1(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doI8(byte, ForeignToLLVMType)] */ && arg0Value instanceof Byte) {
                    byte arg0Value_ = (byte) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I8)) {
                        return ConvertValue.doI8(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doI16(short, ForeignToLLVMType)] */ && arg0Value instanceof Short) {
                    short arg0Value_ = (short) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I16)) {
                        return ConvertValue.doI16(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doI32(int, ForeignToLLVMType)] */ && arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I32)) {
                        return ConvertValue.doI32(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doI32(float, ForeignToLLVMType)] */ && arg0Value instanceof Float) {
                    float arg0Value_ = (float) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I32)) {
                        return ConvertValue.doI32(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doI64(long, ForeignToLLVMType)] */ && arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I64)) {
                        return ConvertValue.doI64(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doI64(double, ForeignToLLVMType)] */ && arg0Value instanceof Double) {
                    double arg0Value_ = (double) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I64)) {
                        return ConvertValue.doI64(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doI64(LLVMPointer, ForeignToLLVMType)] */ && LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if ((arg1Value == ForeignToLLVMType.I64)) {
                        return ConvertValue.doI64(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doFloat(float, ForeignToLLVMType)] */ && arg0Value instanceof Float) {
                    float arg0Value_ = (float) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.FLOAT)) {
                        return ConvertValue.doFloat(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doFloat(int, ForeignToLLVMType)] */ && arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.FLOAT)) {
                        return ConvertValue.doFloat(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doDouble(double, ForeignToLLVMType)] */ && arg0Value instanceof Double) {
                    double arg0Value_ = (double) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.DOUBLE)) {
                        return ConvertValue.doDouble(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doDouble(long, ForeignToLLVMType)] */ && arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.DOUBLE)) {
                        return ConvertValue.doDouble(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b110000000000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doDouble(LLVMPointer, ForeignToLLVMType)] || SpecializationActive[ToLLVM.ConvertValue.doPointer(LLVMPointer, ForeignToLLVMType)] */ && LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doDouble(LLVMPointer, ForeignToLLVMType)] */) {
                        if ((arg1Value == ForeignToLLVMType.DOUBLE)) {
                            return doDouble(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doPointer(LLVMPointer, ForeignToLLVMType)] */) {
                        if ((arg1Value == ForeignToLLVMType.POINTER)) {
                            return ConvertValue.doPointer(arg0Value_, arg1Value);
                        }
                    }
                }
                if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doPointer(long, ForeignToLLVMType)] */ && arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.POINTER)) {
                        return ConvertValue.doPointer(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0x10000) != 0 /* is SpecializationActive[ToLLVM.ConvertValue.doPointer(double, ForeignToLLVMType)] */ && arg0Value instanceof Double) {
                    double arg0Value_ = (double) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.POINTER)) {
                        return doPointer(arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, ForeignToLLVMType arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                if ((arg1Value == ForeignToLLVMType.I1)) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[ToLLVM.ConvertValue.doI1(boolean, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doI1(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                if ((arg1Value == ForeignToLLVMType.I8)) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[ToLLVM.ConvertValue.doI8(byte, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doI8(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                if ((arg1Value == ForeignToLLVMType.I16)) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[ToLLVM.ConvertValue.doI16(short, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doI16(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                if ((arg1Value == ForeignToLLVMType.I32)) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[ToLLVM.ConvertValue.doI32(int, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doI32(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                if ((arg1Value == ForeignToLLVMType.I32)) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[ToLLVM.ConvertValue.doI32(float, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doI32(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if ((arg1Value == ForeignToLLVMType.I64)) {
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToLLVM.ConvertValue.doI64(long, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doI64(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                if ((arg1Value == ForeignToLLVMType.I64)) {
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToLLVM.ConvertValue.doI64(double, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doI64(arg0Value_, arg1Value);
                }
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if ((arg1Value == ForeignToLLVMType.I64)) {
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToLLVM.ConvertValue.doI64(LLVMPointer, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doI64(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                if ((arg1Value == ForeignToLLVMType.FLOAT)) {
                    state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doFloat(float, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doFloat(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                if ((arg1Value == ForeignToLLVMType.FLOAT)) {
                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doFloat(int, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doFloat(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                if ((arg1Value == ForeignToLLVMType.DOUBLE)) {
                    state_0 = state_0 | 0b100000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doDouble(double, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doDouble(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if ((arg1Value == ForeignToLLVMType.DOUBLE)) {
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doDouble(long, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doDouble(arg0Value_, arg1Value);
                }
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if ((arg1Value == ForeignToLLVMType.DOUBLE)) {
                    state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doDouble(LLVMPointer, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return doDouble(arg0Value_, arg1Value);
                }
                if ((arg1Value == ForeignToLLVMType.POINTER)) {
                    state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doPointer(LLVMPointer, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doPointer(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if ((arg1Value == ForeignToLLVMType.POINTER)) {
                    state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doPointer(long, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return ConvertValue.doPointer(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                if ((arg1Value == ForeignToLLVMType.POINTER)) {
                    state_0 = state_0 | 0x10000 /* add SpecializationActive[ToLLVM.ConvertValue.doPointer(double, ForeignToLLVMType)] */;
                    this.state_0_ = state_0;
                    return doPointer(arg0Value_, arg1Value);
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToLLVM.ConvertValue.doI1(boolean, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[ToLLVM.ConvertValue.doI8(byte, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToLLVM.ConvertValue.doI16(short, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[ToLLVM.ConvertValue.doI32(int, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[ToLLVM.ConvertValue.doI32(float, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[ToLLVM.ConvertValue.doI64(long, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[ToLLVM.ConvertValue.doI64(double, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[ToLLVM.ConvertValue.doI64(LLVMPointer, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doFloat(float, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doFloat(int, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doDouble(double, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doDouble(long, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doDouble(LLVMPointer, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doPointer(LLVMPointer, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000000000 /* add SpecializationActive[ToLLVM.ConvertValue.doPointer(long, ForeignToLLVMType)] */;
            }
            {
                this.state_0_ = state_0_ | 0x10000 /* add SpecializationActive[ToLLVM.ConvertValue.doPointer(double, ForeignToLLVMType)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
        }

        @NeverDefault
        public static ConvertValue create() {
            return new ConvertValueNodeGen();
        }

        @NeverDefault
        public static ConvertValue getUncached() {
            return ConvertValueNodeGen.UNCACHED;
        }

        @GeneratedBy(ConvertValue.class)
        @DenyReplace
        private static final class Uncached extends ConvertValue implements UnadoptableNode {

            @TruffleBoundary
            @Override
            protected Object execute(Object arg0Value, ForeignToLLVMType arg1Value) {
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I1)) {
                        return ConvertValue.doI1(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Byte) {
                    byte arg0Value_ = (byte) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I8)) {
                        return ConvertValue.doI8(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Short) {
                    short arg0Value_ = (short) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I16)) {
                        return ConvertValue.doI16(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I32)) {
                        return ConvertValue.doI32(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Float) {
                    float arg0Value_ = (float) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I32)) {
                        return ConvertValue.doI32(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I64)) {
                        return ConvertValue.doI64(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (double) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.I64)) {
                        return ConvertValue.doI64(arg0Value_, arg1Value);
                    }
                }
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if ((arg1Value == ForeignToLLVMType.I64)) {
                        return ConvertValue.doI64(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Float) {
                    float arg0Value_ = (float) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.FLOAT)) {
                        return ConvertValue.doFloat(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.FLOAT)) {
                        return ConvertValue.doFloat(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (double) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.DOUBLE)) {
                        return ConvertValue.doDouble(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.DOUBLE)) {
                        return ConvertValue.doDouble(arg0Value_, arg1Value);
                    }
                }
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if ((arg1Value == ForeignToLLVMType.DOUBLE)) {
                        return doDouble(arg0Value_, arg1Value);
                    }
                    if ((arg1Value == ForeignToLLVMType.POINTER)) {
                        return ConvertValue.doPointer(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.POINTER)) {
                        return ConvertValue.doPointer(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (double) arg0Value;
                    if ((arg1Value == ForeignToLLVMType.POINTER)) {
                        return doPointer(arg0Value_, arg1Value);
                    }
                }
                throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ReadUnknown#toI1}
     *     Activation probability: 0.21250
     *     With/without class size: 8/4 bytes
     *   Specialization {@link ReadUnknown#toI8}
     *     Activation probability: 0.18750
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ReadUnknown#toI16}
     *     Activation probability: 0.16250
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ReadUnknown#toI32}
     *     Activation probability: 0.13750
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ReadUnknown#toI64}
     *     Activation probability: 0.11250
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ReadUnknown#toFloat}
     *     Activation probability: 0.08750
     *     With/without class size: 5/4 bytes
     *   Specialization {@link ReadUnknown#toDouble}
     *     Activation probability: 0.06250
     *     With/without class size: 5/4 bytes
     *   Specialization {@link ReadUnknown#toPointer}
     *     Activation probability: 0.03750
     *     With/without class size: 4/4 bytes
     * </pre>
     */
    @GeneratedBy(ReadUnknown.class)
    @SuppressWarnings("javadoc")
    static final class ReadUnknownNodeGen extends ReadUnknown implements GenerateAOT.Provider {

        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ReadUnknown#toI1}
         *   2: SpecializationActive {@link ReadUnknown#toI8}
         *   3: SpecializationActive {@link ReadUnknown#toI16}
         *   4: SpecializationActive {@link ReadUnknown#toI32}
         *   5: SpecializationActive {@link ReadUnknown#toI64}
         *   6: SpecializationActive {@link ReadUnknown#toFloat}
         *   7: SpecializationActive {@link ReadUnknown#toDouble}
         *   8: SpecializationActive {@link ReadUnknown#toPointer}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ToI1Data toI1_cache;
        @Child private ToI8Data toI8_cache;
        @Child private ToI16Data toI16_cache;
        @Child private ToI32Data toI32_cache;
        @Child private ToI64Data toI64_cache;
        @Child private ToFloatData toFloat_cache;
        @Child private ToDoubleData toDouble_cache;
        @Child private ToPointerData toPointer_cache;

        private ReadUnknownNodeGen() {
        }

        @Override
        protected Object executeWithType(Object arg0Value, ForeignToLLVMType arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[ToLLVM.ReadUnknown.toI1(Object, ForeignToLLVMType, ForeignToLLVM)] || SpecializationActive[ToLLVM.ReadUnknown.toI8(Object, ForeignToLLVMType, ForeignToLLVM)] || SpecializationActive[ToLLVM.ReadUnknown.toI16(Object, ForeignToLLVMType, ForeignToLLVM)] || SpecializationActive[ToLLVM.ReadUnknown.toI32(Object, ForeignToLLVMType, ForeignToLLVM)] || SpecializationActive[ToLLVM.ReadUnknown.toI64(Object, ForeignToLLVMType, ForeignToLLVM)] || SpecializationActive[ToLLVM.ReadUnknown.toFloat(Object, ForeignToLLVMType, ForeignToLLVM)] || SpecializationActive[ToLLVM.ReadUnknown.toDouble(Object, ForeignToLLVMType, ForeignToLLVM)] || SpecializationActive[ToLLVM.ReadUnknown.toPointer(Object, ForeignToLLVMType, ForeignToLLVM)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToLLVM.ReadUnknown.toI1(Object, ForeignToLLVMType, ForeignToLLVM)] */) {
                    ToI1Data s0_ = this.toI1_cache;
                    if (s0_ != null) {
                        if ((ReadUnknown.isI1(arg1Value))) {
                            return ReadUnknown.toI1(arg0Value, arg1Value, s0_.toI1_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToLLVM.ReadUnknown.toI8(Object, ForeignToLLVMType, ForeignToLLVM)] */) {
                    ToI8Data s1_ = this.toI8_cache;
                    if (s1_ != null) {
                        if ((ReadUnknown.isI8(arg1Value))) {
                            return ReadUnknown.toI8(arg0Value, arg1Value, s1_.toI8_);
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToLLVM.ReadUnknown.toI16(Object, ForeignToLLVMType, ForeignToLLVM)] */) {
                    ToI16Data s2_ = this.toI16_cache;
                    if (s2_ != null) {
                        if ((ReadUnknown.isI16(arg1Value))) {
                            return ReadUnknown.toI16(arg0Value, arg1Value, s2_.toI16_);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToLLVM.ReadUnknown.toI32(Object, ForeignToLLVMType, ForeignToLLVM)] */) {
                    ToI32Data s3_ = this.toI32_cache;
                    if (s3_ != null) {
                        if ((ReadUnknown.isI32(arg1Value))) {
                            return ReadUnknown.toI32(arg0Value, arg1Value, s3_.toI32_);
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToLLVM.ReadUnknown.toI64(Object, ForeignToLLVMType, ForeignToLLVM)] */) {
                    ToI64Data s4_ = this.toI64_cache;
                    if (s4_ != null) {
                        if ((ReadUnknown.isI64(arg1Value))) {
                            return ReadUnknown.toI64(arg0Value, arg1Value, s4_.toI64_);
                        }
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToLLVM.ReadUnknown.toFloat(Object, ForeignToLLVMType, ForeignToLLVM)] */) {
                    ToFloatData s5_ = this.toFloat_cache;
                    if (s5_ != null) {
                        if ((ReadUnknown.isFloat(arg1Value))) {
                            return ReadUnknown.toFloat(arg0Value, arg1Value, s5_.toFloat_);
                        }
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToLLVM.ReadUnknown.toDouble(Object, ForeignToLLVMType, ForeignToLLVM)] */) {
                    ToDoubleData s6_ = this.toDouble_cache;
                    if (s6_ != null) {
                        if ((ReadUnknown.isDouble(arg1Value))) {
                            return ReadUnknown.toDouble(arg0Value, arg1Value, s6_.toDouble_);
                        }
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToLLVM.ReadUnknown.toPointer(Object, ForeignToLLVMType, ForeignToLLVM)] */) {
                    ToPointerData s7_ = this.toPointer_cache;
                    if (s7_ != null) {
                        if ((ReadUnknown.isPointer(arg1Value))) {
                            return ReadUnknown.toPointer(arg0Value, arg1Value, s7_.toPointer_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, ForeignToLLVMType arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((ReadUnknown.isI1(arg1Value))) {
                ToI1Data s0_ = this.insert(new ToI1Data());
                s0_.toI1_ = s0_.insert((createToI1()));
                VarHandle.storeStoreFence();
                this.toI1_cache = s0_;
                state_0 = state_0 | 0b10 /* add SpecializationActive[ToLLVM.ReadUnknown.toI1(Object, ForeignToLLVMType, ForeignToLLVM)] */;
                this.state_0_ = state_0;
                return ReadUnknown.toI1(arg0Value, arg1Value, s0_.toI1_);
            }
            if ((ReadUnknown.isI8(arg1Value))) {
                ToI8Data s1_ = this.insert(new ToI8Data());
                s1_.toI8_ = s1_.insert((createToI8()));
                VarHandle.storeStoreFence();
                this.toI8_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[ToLLVM.ReadUnknown.toI8(Object, ForeignToLLVMType, ForeignToLLVM)] */;
                this.state_0_ = state_0;
                return ReadUnknown.toI8(arg0Value, arg1Value, s1_.toI8_);
            }
            if ((ReadUnknown.isI16(arg1Value))) {
                ToI16Data s2_ = this.insert(new ToI16Data());
                s2_.toI16_ = s2_.insert((createToI16()));
                VarHandle.storeStoreFence();
                this.toI16_cache = s2_;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[ToLLVM.ReadUnknown.toI16(Object, ForeignToLLVMType, ForeignToLLVM)] */;
                this.state_0_ = state_0;
                return ReadUnknown.toI16(arg0Value, arg1Value, s2_.toI16_);
            }
            if ((ReadUnknown.isI32(arg1Value))) {
                ToI32Data s3_ = this.insert(new ToI32Data());
                s3_.toI32_ = s3_.insert((createToI32()));
                VarHandle.storeStoreFence();
                this.toI32_cache = s3_;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[ToLLVM.ReadUnknown.toI32(Object, ForeignToLLVMType, ForeignToLLVM)] */;
                this.state_0_ = state_0;
                return ReadUnknown.toI32(arg0Value, arg1Value, s3_.toI32_);
            }
            if ((ReadUnknown.isI64(arg1Value))) {
                ToI64Data s4_ = this.insert(new ToI64Data());
                s4_.toI64_ = s4_.insert((createToI64()));
                VarHandle.storeStoreFence();
                this.toI64_cache = s4_;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[ToLLVM.ReadUnknown.toI64(Object, ForeignToLLVMType, ForeignToLLVM)] */;
                this.state_0_ = state_0;
                return ReadUnknown.toI64(arg0Value, arg1Value, s4_.toI64_);
            }
            if ((ReadUnknown.isFloat(arg1Value))) {
                ToFloatData s5_ = this.insert(new ToFloatData());
                s5_.toFloat_ = s5_.insert((createToFloat()));
                VarHandle.storeStoreFence();
                this.toFloat_cache = s5_;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToLLVM.ReadUnknown.toFloat(Object, ForeignToLLVMType, ForeignToLLVM)] */;
                this.state_0_ = state_0;
                return ReadUnknown.toFloat(arg0Value, arg1Value, s5_.toFloat_);
            }
            if ((ReadUnknown.isDouble(arg1Value))) {
                ToDoubleData s6_ = this.insert(new ToDoubleData());
                s6_.toDouble_ = s6_.insert((createToDouble()));
                VarHandle.storeStoreFence();
                this.toDouble_cache = s6_;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToLLVM.ReadUnknown.toDouble(Object, ForeignToLLVMType, ForeignToLLVM)] */;
                this.state_0_ = state_0;
                return ReadUnknown.toDouble(arg0Value, arg1Value, s6_.toDouble_);
            }
            if ((ReadUnknown.isPointer(arg1Value))) {
                ToPointerData s7_ = this.insert(new ToPointerData());
                s7_.toPointer_ = s7_.insert((createToPointer()));
                VarHandle.storeStoreFence();
                this.toPointer_cache = s7_;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToLLVM.ReadUnknown.toPointer(Object, ForeignToLLVMType, ForeignToLLVM)] */;
                this.state_0_ = state_0;
                return ReadUnknown.toPointer(arg0Value, arg1Value, s7_.toPointer_);
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                ToI1Data s0_ = this.insert(new ToI1Data());
                s0_.toI1_ = s0_.insert((createToI1()));
                VarHandle.storeStoreFence();
                this.toI1_cache = s0_;
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToLLVM.ReadUnknown.toI1(Object, ForeignToLLVMType, ForeignToLLVM)] */;
            }
            {
                ToI8Data s1_ = this.insert(new ToI8Data());
                s1_.toI8_ = s1_.insert((createToI8()));
                VarHandle.storeStoreFence();
                this.toI8_cache = s1_;
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[ToLLVM.ReadUnknown.toI8(Object, ForeignToLLVMType, ForeignToLLVM)] */;
            }
            {
                ToI16Data s2_ = this.insert(new ToI16Data());
                s2_.toI16_ = s2_.insert((createToI16()));
                VarHandle.storeStoreFence();
                this.toI16_cache = s2_;
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToLLVM.ReadUnknown.toI16(Object, ForeignToLLVMType, ForeignToLLVM)] */;
            }
            {
                ToI32Data s3_ = this.insert(new ToI32Data());
                s3_.toI32_ = s3_.insert((createToI32()));
                VarHandle.storeStoreFence();
                this.toI32_cache = s3_;
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[ToLLVM.ReadUnknown.toI32(Object, ForeignToLLVMType, ForeignToLLVM)] */;
            }
            {
                ToI64Data s4_ = this.insert(new ToI64Data());
                s4_.toI64_ = s4_.insert((createToI64()));
                VarHandle.storeStoreFence();
                this.toI64_cache = s4_;
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[ToLLVM.ReadUnknown.toI64(Object, ForeignToLLVMType, ForeignToLLVM)] */;
            }
            {
                ToFloatData s5_ = this.insert(new ToFloatData());
                s5_.toFloat_ = s5_.insert((createToFloat()));
                VarHandle.storeStoreFence();
                this.toFloat_cache = s5_;
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[ToLLVM.ReadUnknown.toFloat(Object, ForeignToLLVMType, ForeignToLLVM)] */;
            }
            {
                ToDoubleData s6_ = this.insert(new ToDoubleData());
                s6_.toDouble_ = s6_.insert((createToDouble()));
                VarHandle.storeStoreFence();
                this.toDouble_cache = s6_;
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[ToLLVM.ReadUnknown.toDouble(Object, ForeignToLLVMType, ForeignToLLVM)] */;
            }
            {
                ToPointerData s7_ = this.insert(new ToPointerData());
                s7_.toPointer_ = s7_.insert((createToPointer()));
                VarHandle.storeStoreFence();
                this.toPointer_cache = s7_;
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[ToLLVM.ReadUnknown.toPointer(Object, ForeignToLLVMType, ForeignToLLVM)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.toI1_cache = null;
            this.toI8_cache = null;
            this.toI16_cache = null;
            this.toI32_cache = null;
            this.toI64_cache = null;
            this.toFloat_cache = null;
            this.toDouble_cache = null;
            this.toPointer_cache = null;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
        }

        @NeverDefault
        public static ReadUnknown create() {
            return new ReadUnknownNodeGen();
        }

        @NeverDefault
        public static ReadUnknown getUncached() {
            return ReadUnknownNodeGen.UNCACHED;
        }

        @GeneratedBy(ReadUnknown.class)
        @DenyReplace
        private static final class ToI1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadUnknown#toI1}
             *   Parameter: {@link ForeignToLLVM} toI1</pre>
             */
            @Child ForeignToLLVM toI1_;

            ToI1Data() {
            }

        }
        @GeneratedBy(ReadUnknown.class)
        @DenyReplace
        private static final class ToI8Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadUnknown#toI8}
             *   Parameter: {@link ForeignToLLVM} toI8</pre>
             */
            @Child ForeignToLLVM toI8_;

            ToI8Data() {
            }

        }
        @GeneratedBy(ReadUnknown.class)
        @DenyReplace
        private static final class ToI16Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadUnknown#toI16}
             *   Parameter: {@link ForeignToLLVM} toI16</pre>
             */
            @Child ForeignToLLVM toI16_;

            ToI16Data() {
            }

        }
        @GeneratedBy(ReadUnknown.class)
        @DenyReplace
        private static final class ToI32Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadUnknown#toI32}
             *   Parameter: {@link ForeignToLLVM} toI32</pre>
             */
            @Child ForeignToLLVM toI32_;

            ToI32Data() {
            }

        }
        @GeneratedBy(ReadUnknown.class)
        @DenyReplace
        private static final class ToI64Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadUnknown#toI64}
             *   Parameter: {@link ForeignToLLVM} toI64</pre>
             */
            @Child ForeignToLLVM toI64_;

            ToI64Data() {
            }

        }
        @GeneratedBy(ReadUnknown.class)
        @DenyReplace
        private static final class ToFloatData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadUnknown#toFloat}
             *   Parameter: {@link ForeignToLLVM} toFloat</pre>
             */
            @Child ForeignToLLVM toFloat_;

            ToFloatData() {
            }

        }
        @GeneratedBy(ReadUnknown.class)
        @DenyReplace
        private static final class ToDoubleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadUnknown#toDouble}
             *   Parameter: {@link ForeignToLLVM} toDouble</pre>
             */
            @Child ForeignToLLVM toDouble_;

            ToDoubleData() {
            }

        }
        @GeneratedBy(ReadUnknown.class)
        @DenyReplace
        private static final class ToPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadUnknown#toPointer}
             *   Parameter: {@link ForeignToLLVM} toPointer</pre>
             */
            @Child ForeignToLLVM toPointer_;

            ToPointerData() {
            }

        }
        @GeneratedBy(ReadUnknown.class)
        @DenyReplace
        private static final class Uncached extends ReadUnknown implements UnadoptableNode {

            @TruffleBoundary
            @Override
            protected Object executeWithType(Object arg0Value, ForeignToLLVMType arg1Value) {
                if ((ReadUnknown.isI1(arg1Value))) {
                    return ReadUnknown.toI1(arg0Value, arg1Value, (ForeignToLLVM.getSlowPath()));
                }
                if ((ReadUnknown.isI8(arg1Value))) {
                    return ReadUnknown.toI8(arg0Value, arg1Value, (ForeignToLLVM.getSlowPath()));
                }
                if ((ReadUnknown.isI16(arg1Value))) {
                    return ReadUnknown.toI16(arg0Value, arg1Value, (ForeignToLLVM.getSlowPath()));
                }
                if ((ReadUnknown.isI32(arg1Value))) {
                    return ReadUnknown.toI32(arg0Value, arg1Value, (ForeignToLLVM.getSlowPath()));
                }
                if ((ReadUnknown.isI64(arg1Value))) {
                    return ReadUnknown.toI64(arg0Value, arg1Value, (ForeignToLLVM.getSlowPath()));
                }
                if ((ReadUnknown.isFloat(arg1Value))) {
                    return ReadUnknown.toFloat(arg0Value, arg1Value, (ForeignToLLVM.getSlowPath()));
                }
                if ((ReadUnknown.isDouble(arg1Value))) {
                    return ReadUnknown.toDouble(arg0Value, arg1Value, (ForeignToLLVM.getSlowPath()));
                }
                if ((ReadUnknown.isPointer(arg1Value))) {
                    return ReadUnknown.toPointer(arg0Value, arg1Value, (ForeignToLLVM.getSlowPath()));
                }
                throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

        }
    }
}
