// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.VirtualAlloc;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.ToNativePointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.ToNativePointerNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(VirtualAlloc.class)
@SuppressWarnings("javadoc")
final class VirtualAllocGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    static  {
        LibraryExport.register(VirtualAlloc.class, new LLVMManagedReadLibraryExports(), new LLVMManagedWriteLibraryExports());
    }

    private VirtualAllocGen() {
    }

    @GeneratedBy(VirtualAlloc.class)
    private static final class LLVMManagedReadLibraryExports extends LibraryExport<LLVMManagedReadLibrary> {

        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, byte[].class, true, false, 0);
        }

        @Override
        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert receiver instanceof byte[];
            LLVMManagedReadLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert receiver instanceof byte[];
            return new Cached(receiver);
        }

        @GeneratedBy(VirtualAlloc.class)
        private static final class Cached extends LLVMManagedReadLibrary {

            @Child private LLVMManagedWriteLibrary receiverLLVMManagedWriteLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link VirtualAlloc#readI8}
             *   1: SpecializationActive {@link VirtualAlloc#readI16}
             *   2: SpecializationActive {@link VirtualAlloc#readI32}
             *   3: SpecializationActive {@link VirtualAlloc#readI64}
             *   4: SpecializationActive {@link VirtualAlloc#readFloat}
             *   5: SpecializationActive {@link VirtualAlloc#readDouble}
             *   6: SpecializationActive {@link VirtualAlloc#readPointer}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link VirtualAlloc#readI8}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal private BranchProfile exception;

            protected Cached(Object receiver) {
                byte[] castReceiver = ((byte[]) receiver) ;
                this.receiverLLVMManagedWriteLibrary_ = L_L_V_M_MANAGED_WRITE_LIBRARY_.create((castReceiver));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof byte[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof byte[])) {
                    return false;
                } else if (!this.receiverLLVMManagedWriteLibrary_.accepts((receiver))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert receiver instanceof byte[] : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return VirtualAlloc.isAccessible((((byte[]) receiver)));
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#readI8}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert arg0Value_ instanceof byte[] : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[VirtualAlloc.readI8(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                            return VirtualAlloc.readI8(arg0Value, arg1Value, self__, exception_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI8Node_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readI8Node_AndSpecialize(byte[] arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = this.receiverLLVMManagedWriteLibrary_;
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b1 /* add SpecializationActive[VirtualAlloc.readI8(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return VirtualAlloc.readI8(arg0Value, arg1Value, self__, exception_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#readI16}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                assert arg0Value_ instanceof byte[] : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[VirtualAlloc.readI16(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                            return VirtualAlloc.readI16(arg0Value, arg1Value, self__, exception_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI16Node_AndSpecialize(arg0Value, arg1Value);
            }

            private short readI16Node_AndSpecialize(byte[] arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = this.receiverLLVMManagedWriteLibrary_;
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b10 /* add SpecializationActive[VirtualAlloc.readI16(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return VirtualAlloc.readI16(arg0Value, arg1Value, self__, exception_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#readI32}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                assert arg0Value_ instanceof byte[] : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[VirtualAlloc.readI32(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                            return VirtualAlloc.readI32(arg0Value, arg1Value, self__, exception_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI32Node_AndSpecialize(arg0Value, arg1Value);
            }

            private int readI32Node_AndSpecialize(byte[] arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = this.receiverLLVMManagedWriteLibrary_;
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b100 /* add SpecializationActive[VirtualAlloc.readI32(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return VirtualAlloc.readI32(arg0Value, arg1Value, self__, exception_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#readI64}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert arg0Value_ instanceof byte[] : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[VirtualAlloc.readI64(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                            return VirtualAlloc.readI64(arg0Value, arg1Value, self__, exception_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            private long readI64Node_AndSpecialize(byte[] arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = this.receiverLLVMManagedWriteLibrary_;
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[VirtualAlloc.readI64(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return VirtualAlloc.readI64(arg0Value, arg1Value, self__, exception_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#readFloat}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert arg0Value_ instanceof byte[] : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[VirtualAlloc.readFloat(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                            return VirtualAlloc.readFloat(arg0Value, arg1Value, self__, exception_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatNode_AndSpecialize(byte[] arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = this.receiverLLVMManagedWriteLibrary_;
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[VirtualAlloc.readFloat(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return VirtualAlloc.readFloat(arg0Value, arg1Value, self__, exception_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#readDouble}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert arg0Value_ instanceof byte[] : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[VirtualAlloc.readDouble(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                            return VirtualAlloc.readDouble(arg0Value, arg1Value, self__, exception_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleNode_AndSpecialize(byte[] arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = this.receiverLLVMManagedWriteLibrary_;
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[VirtualAlloc.readDouble(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return VirtualAlloc.readDouble(arg0Value, arg1Value, self__, exception_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#readPointer}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert arg0Value_ instanceof byte[] : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[VirtualAlloc.readPointer(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                            return VirtualAlloc.readPointer(arg0Value, arg1Value, self__, exception_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readPointerNode_AndSpecialize(arg0Value, arg1Value);
            }

            private LLVMPointer readPointerNode_AndSpecialize(byte[] arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = this.receiverLLVMManagedWriteLibrary_;
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[VirtualAlloc.readPointer(byte[], long, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return VirtualAlloc.readPointer(arg0Value, arg1Value, self__, exception_);
                }
            }

        }
        @GeneratedBy(VirtualAlloc.class)
        @DenyReplace
        private static final class Uncached extends LLVMManagedReadLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof byte[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            @TruffleBoundary
            @Override
            public boolean isReadable(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return VirtualAlloc.isAccessible(((byte[]) receiver) );
            }

            @TruffleBoundary
            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                return VirtualAlloc.readI8(arg0Value, arg1Value, L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                return VirtualAlloc.readI16(arg0Value, arg1Value, L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                return VirtualAlloc.readI32(arg0Value, arg1Value, L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                return VirtualAlloc.readI64(arg0Value, arg1Value, L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                return VirtualAlloc.readFloat(arg0Value, arg1Value, L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                return VirtualAlloc.readDouble(arg0Value, arg1Value, L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                return VirtualAlloc.readPointer(arg0Value, arg1Value, L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
            }

        }
    }
    @GeneratedBy(VirtualAlloc.class)
    private static final class LLVMManagedWriteLibraryExports extends LibraryExport<LLVMManagedWriteLibrary> {

        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, byte[].class, true, false, 0);
        }

        @Override
        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert receiver instanceof byte[];
            LLVMManagedWriteLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert receiver instanceof byte[];
            return new Cached();
        }

        @GeneratedBy(VirtualAlloc.class)
        private static final class Cached extends LLVMManagedWriteLibrary {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link WriteGenericI64#writeI64}
             *   1: SpecializationActive {@link WriteGenericI64#writePointer}
             *   2: SpecializationActive {@link VirtualAlloc#writeI8}
             *   3: SpecializationActive {@link VirtualAlloc#writeI16}
             *   4: SpecializationActive {@link VirtualAlloc#writeI32}
             *   5: SpecializationActive {@link VirtualAlloc#writeI64}
             *   6: SpecializationActive {@link VirtualAlloc#writeFloat}
             *   7: SpecializationActive {@link VirtualAlloc#writeDouble}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteGenericI64#writeI64}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal private BranchProfile exception;
            @Child private WriteGenericI64WritePointerData writeGenericI64_writePointer_cache;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof byte[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteGenericI64#writeI64}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link WriteGenericI64#writePointer}
             *     Activation probability: 0.05000
             *     With/without class size: 5/8 bytes
             * </pre>
             */
            @Override
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[VirtualAlloc.WriteGenericI64.writeI64(byte[], long, long, LLVMManagedWriteLibrary, BranchProfile)] || SpecializationActive[VirtualAlloc.WriteGenericI64.writePointer(byte[], long, LLVMPointer, ToNativePointerNode, BranchProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[VirtualAlloc.WriteGenericI64.writeI64(byte[], long, long, LLVMManagedWriteLibrary, BranchProfile)] */ && arg2Value instanceof Long) {
                        long arg2Value_ = (long) arg2Value;
                        {
                            BranchProfile exception_ = this.exception;
                            if (exception_ != null) {
                                LLVMManagedWriteLibrary self__ = (this);
                                WriteGenericI64.writeI64(arg0Value, arg1Value, arg2Value_, self__, exception_);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[VirtualAlloc.WriteGenericI64.writePointer(byte[], long, LLVMPointer, ToNativePointerNode, BranchProfile)] */ && arg2Value instanceof LLVMPointer) {
                        LLVMPointer arg2Value_ = (LLVMPointer) arg2Value;
                        WriteGenericI64WritePointerData s1_ = this.writeGenericI64_writePointer_cache;
                        if (s1_ != null) {
                            WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, s1_.toNativePointer_, s1_.exception_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeGenericI64AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeGenericI64AndSpecialize(byte[] arg0Value, long arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (long) arg2Value;
                        self__ = (this);
                        BranchProfile exception_;
                        BranchProfile exception__shared = this.exception;
                        if (exception__shared != null) {
                            exception_ = exception__shared;
                        } else {
                            exception_ = (BranchProfile.create());
                            if (exception_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.exception == null) {
                            VarHandle.storeStoreFence();
                            this.exception = exception_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[VirtualAlloc.WriteGenericI64.writeI64(byte[], long, long, LLVMManagedWriteLibrary, BranchProfile)] */;
                        this.state_0_ = state_0;
                        WriteGenericI64.writeI64(arg0Value, arg1Value, arg2Value_, self__, exception_);
                        return;
                    }
                }
                if (arg2Value instanceof LLVMPointer) {
                    LLVMPointer arg2Value_ = (LLVMPointer) arg2Value;
                    WriteGenericI64WritePointerData s1_ = this.insert(new WriteGenericI64WritePointerData());
                    ToNativePointerNode toNativePointer__ = s1_.insert((ToNativePointerNodeGen.create()));
                    Objects.requireNonNull(toNativePointer__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s1_.toNativePointer_ = toNativePointer__;
                    BranchProfile exception__ = (BranchProfile.create());
                    Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s1_.exception_ = exception__;
                    VarHandle.storeStoreFence();
                    this.writeGenericI64_writePointer_cache = s1_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[VirtualAlloc.WriteGenericI64.writePointer(byte[], long, LLVMPointer, ToNativePointerNode, BranchProfile)] */;
                    this.state_0_ = state_0;
                    WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, toNativePointer__, exception__);
                    return;
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return VirtualAlloc.isAccessible((((byte[]) receiver)));
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#writeI8}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[VirtualAlloc.writeI8(byte[], long, byte, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = (this);
                            VirtualAlloc.writeI8(arg0Value, arg1Value, arg2Value, self__, exception_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeI8Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeI8Node_AndSpecialize(byte[] arg0Value, long arg1Value, byte arg2Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = (this);
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b100 /* add SpecializationActive[VirtualAlloc.writeI8(byte[], long, byte, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    VirtualAlloc.writeI8(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#writeI16}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[VirtualAlloc.writeI16(byte[], long, short, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = (this);
                            VirtualAlloc.writeI16(arg0Value, arg1Value, arg2Value, self__, exception_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeI16Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeI16Node_AndSpecialize(byte[] arg0Value, long arg1Value, short arg2Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = (this);
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[VirtualAlloc.writeI16(byte[], long, short, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    VirtualAlloc.writeI16(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#writeI32}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[VirtualAlloc.writeI32(byte[], long, int, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = (this);
                            VirtualAlloc.writeI32(arg0Value, arg1Value, arg2Value, self__, exception_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeI32Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeI32Node_AndSpecialize(byte[] arg0Value, long arg1Value, int arg2Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = (this);
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[VirtualAlloc.writeI32(byte[], long, int, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    VirtualAlloc.writeI32(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#writeI64}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[VirtualAlloc.writeI64(byte[], long, long, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = (this);
                            VirtualAlloc.writeI64(arg0Value, arg1Value, arg2Value, self__, exception_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeI64Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeI64Node_AndSpecialize(byte[] arg0Value, long arg1Value, long arg2Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = (this);
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[VirtualAlloc.writeI64(byte[], long, long, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    VirtualAlloc.writeI64(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#writeFloat}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[VirtualAlloc.writeFloat(byte[], long, float, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = (this);
                            VirtualAlloc.writeFloat(arg0Value, arg1Value, arg2Value, self__, exception_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeFloatNode_AndSpecialize(byte[] arg0Value, long arg1Value, float arg2Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = (this);
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[VirtualAlloc.writeFloat(byte[], long, float, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    VirtualAlloc.writeFloat(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link VirtualAlloc#writeDouble}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                byte[] arg0Value = ((byte[]) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[VirtualAlloc.writeDouble(byte[], long, double, LLVMManagedWriteLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            LLVMManagedWriteLibrary self__ = (this);
                            VirtualAlloc.writeDouble(arg0Value, arg1Value, arg2Value, self__, exception_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeDoubleNode_AndSpecialize(byte[] arg0Value, long arg1Value, double arg2Value) {
                int state_0 = this.state_0_;
                {
                    LLVMManagedWriteLibrary self__ = null;
                    self__ = (this);
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = (BranchProfile.create());
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[VirtualAlloc.writeDouble(byte[], long, double, LLVMManagedWriteLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    VirtualAlloc.writeDouble(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
            }

            @GeneratedBy(VirtualAlloc.class)
            @DenyReplace
            private static final class WriteGenericI64WritePointerData extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link WriteGenericI64#writePointer}
                 *   Parameter: {@link ToNativePointerNode} toNativePointer</pre>
                 */
                @Child ToNativePointerNode toNativePointer_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link WriteGenericI64#writePointer}
                 *   Parameter: {@link BranchProfile} exception</pre>
                 */
                @CompilationFinal BranchProfile exception_;

                WriteGenericI64WritePointerData() {
                }

            }
        }
        @GeneratedBy(VirtualAlloc.class)
        @DenyReplace
        private static final class Uncached extends LLVMManagedWriteLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof byte[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            @TruffleBoundary
            @Override
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                if (arg2Value instanceof Long) {
                    long arg2Value_ = (long) arg2Value;
                    WriteGenericI64.writeI64(arg0Value, arg1Value, arg2Value_, (this), (BranchProfile.getUncached()));
                    return;
                }
                if (arg2Value instanceof LLVMPointer) {
                    LLVMPointer arg2Value_ = (LLVMPointer) arg2Value;
                    WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, (ToNativePointerNodeGen.getUncached()), (BranchProfile.getUncached()));
                    return;
                }
                throw newUnsupportedSpecializationException3LJL(this, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public boolean isWritable(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return VirtualAlloc.isAccessible(((byte[]) receiver) );
            }

            @TruffleBoundary
            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                VirtualAlloc.writeI8(arg0Value, arg1Value, arg2Value, (this), (BranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                VirtualAlloc.writeI16(arg0Value, arg1Value, arg2Value, (this), (BranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                VirtualAlloc.writeI32(arg0Value, arg1Value, arg2Value, (this), (BranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                VirtualAlloc.writeI64(arg0Value, arg1Value, arg2Value, (this), (BranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                VirtualAlloc.writeFloat(arg0Value, arg1Value, arg2Value, (this), (BranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                VirtualAlloc.writeDouble(arg0Value, arg1Value, arg2Value, (this), (BranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException3LJL(Node thisNode_, Object arg0Value, long arg1Value, Object arg2Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
            }

        }
    }
}
