// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMAMD64CpuidNode#doOp}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMAMD64CpuidNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64CpuidNodeGen extends LLVMAMD64CpuidNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode level_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMAMD64CpuidNode#doOp}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMAMD64CpuidNodeGen(LLVMAMD64WriteValueNode eax, LLVMAMD64WriteValueNode ebx, LLVMAMD64WriteValueNode ecx, LLVMAMD64WriteValueNode edx, LLVMExpressionNode level) {
        super(eax, ebx, ecx, edx);
        this.level_ = level;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        int levelValue_;
        try {
            levelValue_ = this.level_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, levelValue_);
            return;
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64CpuidNode.doOp(VirtualFrame, int)] */) {
            doOp(frameValue, levelValue_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(frameValue, levelValue_);
        return;
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object levelValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (levelValue instanceof Integer) {
            int levelValue_ = (int) levelValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64CpuidNode.doOp(VirtualFrame, int)] */;
            this.state_0_ = state_0;
            doOp(frameValue, levelValue_);
            return;
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.level_}, levelValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64CpuidNode.doOp(VirtualFrame, int)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64CpuidNode create(LLVMAMD64WriteValueNode eax, LLVMAMD64WriteValueNode ebx, LLVMAMD64WriteValueNode ecx, LLVMAMD64WriteValueNode edx, LLVMExpressionNode level) {
        return new LLVMAMD64CpuidNodeGen(eax, ebx, ecx, edx, level);
    }

}
