// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XaddNode.LLVMAMD64XaddbNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XaddNode.LLVMAMD64XaddlNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XaddNode.LLVMAMD64XaddqNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XaddNode.LLVMAMD64XaddwNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMAMD64XaddNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64XaddNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64XaddbNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64XaddbNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64XaddbNodeGen extends LLVMAMD64XaddbNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64XaddbNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64XaddbNodeGen(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags, out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddbNode.doOp(VirtualFrame, byte, byte)] */) {
                doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, leftValue_, rightValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Byte) {
                byte leftValue_ = (byte) leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (byte) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddbNode.doOp(VirtualFrame, byte, byte)] */;
                    this.state_0_ = state_0;
                    doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddbNode.doOp(VirtualFrame, byte, byte)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64XaddbNode create(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XaddbNodeGen(flags, out, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64XaddwNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64XaddwNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64XaddwNodeGen extends LLVMAMD64XaddwNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64XaddwNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64XaddwNodeGen(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags, out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddwNode.doOp(VirtualFrame, short, short)] */) {
                doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, leftValue_, rightValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Short) {
                short leftValue_ = (short) leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (short) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddwNode.doOp(VirtualFrame, short, short)] */;
                    this.state_0_ = state_0;
                    doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddwNode.doOp(VirtualFrame, short, short)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64XaddwNode create(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XaddwNodeGen(flags, out, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64XaddlNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64XaddlNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64XaddlNodeGen extends LLVMAMD64XaddlNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64XaddlNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64XaddlNodeGen(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags, out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddlNode.doOp(VirtualFrame, int, int)] */) {
                doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, leftValue_, rightValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Integer) {
                int leftValue_ = (int) leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (int) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddlNode.doOp(VirtualFrame, int, int)] */;
                    this.state_0_ = state_0;
                    doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddlNode.doOp(VirtualFrame, int, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64XaddlNode create(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XaddlNodeGen(flags, out, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64XaddqNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64XaddqNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64XaddqNodeGen extends LLVMAMD64XaddqNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64XaddqNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64XaddqNodeGen(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags, out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddqNode.doOp(VirtualFrame, long, long)] */) {
                doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, leftValue_, rightValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Long) {
                long leftValue_ = (long) leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (long) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddqNode.doOp(VirtualFrame, long, long)] */;
                    this.state_0_ = state_0;
                    doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64XaddNode.LLVMAMD64XaddqNode.doOp(VirtualFrame, long, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64XaddqNode create(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XaddqNodeGen(flags, out, left, right);
        }

    }
}
