// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMAMD64RegisterToLongNode#readLong}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMAMD64RegisterToLongNode#readAddress}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMAMD64RegisterToLongNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64RegisterToLongNodeGen extends LLVMAMD64RegisterToLongNode implements GenerateAOT.Provider {

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMAMD64RegisterToLongNode#readLong}
     *   2: SpecializationActive {@link LLVMAMD64RegisterToLongNode#readAddress}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMAMD64RegisterToLongNodeGen() {
    }

    @Override
    public long execute(VirtualFrame frameValue, int arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, arg0Value);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAMD64RegisterToLongNode.readLong(VirtualFrame, int)] || SpecializationActive[LLVMAMD64RegisterToLongNode.readAddress(VirtualFrame, int)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64RegisterToLongNode.readLong(VirtualFrame, int)] */) {
                if ((isLong(frameValue, arg0Value))) {
                    return readLong(frameValue, arg0Value);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64RegisterToLongNode.readAddress(VirtualFrame, int)] */) {
                if ((isAddress(frameValue, arg0Value))) {
                    return readAddress(frameValue, arg0Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, arg0Value);
    }

    private long executeAndSpecialize(VirtualFrame frameValue, int arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((isLong(frameValue, arg0Value))) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64RegisterToLongNode.readLong(VirtualFrame, int)] */;
            this.state_0_ = state_0;
            return readLong(frameValue, arg0Value);
        }
        if ((isAddress(frameValue, arg0Value))) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64RegisterToLongNode.readAddress(VirtualFrame, int)] */;
            this.state_0_ = state_0;
            return readAddress(frameValue, arg0Value);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64RegisterToLongNode.readLong(VirtualFrame, int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64RegisterToLongNode.readAddress(VirtualFrame, int)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64RegisterToLongNode create() {
        return new LLVMAMD64RegisterToLongNodeGen();
    }

}
