// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMAMD64WriteAddressRegisterNode#doI8}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMAMD64WriteAddressRegisterNode#doI16}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMAMD64WriteAddressRegisterNode#doI32}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMAMD64WriteAddressRegisterNode#doI64}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMAMD64WriteAddressRegisterNode#doAddress}
 *     Activation probability: 0.08000
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMAMD64WriteAddressRegisterNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64WriteAddressRegisterNodeGen extends LLVMAMD64WriteAddressRegisterNode implements GenerateAOT.Provider {

    private final int slot;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMAMD64WriteAddressRegisterNode#doI8}
     *   2: SpecializationActive {@link LLVMAMD64WriteAddressRegisterNode#doI16}
     *   3: SpecializationActive {@link LLVMAMD64WriteAddressRegisterNode#doI32}
     *   4: SpecializationActive {@link LLVMAMD64WriteAddressRegisterNode#doI64}
     *   5: SpecializationActive {@link LLVMAMD64WriteAddressRegisterNode#doAddress}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMAMD64WriteAddressRegisterNodeGen(LLVMExpressionNode value, int slot) {
        this.slot = slot;
        this.value_ = value;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111100) == 0 /* only-active SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doAddress(VirtualFrame, LLVMPointer)] */)) {
            execute_byte0(state_0, frameValue);
            return;
        } else if ((state_0 & 0b111010) == 0 /* only-active SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doAddress(VirtualFrame, LLVMPointer)] */)) {
            execute_short1(state_0, frameValue);
            return;
        } else if ((state_0 & 0b110110) == 0 /* only-active SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doAddress(VirtualFrame, LLVMPointer)] */)) {
            execute_int2(state_0, frameValue);
            return;
        } else if ((state_0 & 0b101110) == 0 /* only-active SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] && SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doAddress(VirtualFrame, LLVMPointer)] */)) {
            execute_long3(state_0, frameValue);
            return;
        } else {
            execute_generic4(state_0, frameValue);
            return;
        }
    }

    private void execute_byte0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        byte valueValue_;
        try {
            valueValue_ = this.value_.executeI8(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] */;
        doI8(frameValue, valueValue_);
        return;
    }

    private void execute_short1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        short valueValue_;
        try {
            valueValue_ = this.value_.executeI16(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] */;
        doI16(frameValue, valueValue_);
        return;
    }

    private void execute_int2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int valueValue_;
        try {
            valueValue_ = this.value_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] */;
        doI32(frameValue, valueValue_);
        return;
    }

    private void execute_long3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long valueValue_;
        try {
            valueValue_ = this.value_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] */;
        doI64(frameValue, valueValue_);
        return;
    }

    private void execute_generic4(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] || SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] || SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] || SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] || SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doAddress(VirtualFrame, LLVMPointer)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] */ && valueValue_ instanceof Byte) {
                byte valueValue__ = (byte) valueValue_;
                doI8(frameValue, valueValue__);
                return;
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] */ && valueValue_ instanceof Short) {
                short valueValue__ = (short) valueValue_;
                doI16(frameValue, valueValue__);
                return;
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] */ && valueValue_ instanceof Integer) {
                int valueValue__ = (int) valueValue_;
                doI32(frameValue, valueValue__);
                return;
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] */ && valueValue_ instanceof Long) {
                long valueValue__ = (long) valueValue_;
                doI64(frameValue, valueValue__);
                return;
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doAddress(VirtualFrame, LLVMPointer)] */ && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                doAddress(frameValue, valueValue__);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(frameValue, valueValue_);
        return;
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (valueValue instanceof Byte) {
            byte valueValue_ = (byte) valueValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] */;
            this.state_0_ = state_0;
            doI8(frameValue, valueValue_);
            return;
        }
        if (valueValue instanceof Short) {
            short valueValue_ = (short) valueValue;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] */;
            this.state_0_ = state_0;
            doI16(frameValue, valueValue_);
            return;
        }
        if (valueValue instanceof Integer) {
            int valueValue_ = (int) valueValue;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] */;
            this.state_0_ = state_0;
            doI32(frameValue, valueValue_);
            return;
        }
        if (valueValue instanceof Long) {
            long valueValue_ = (long) valueValue;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] */;
            this.state_0_ = state_0;
            doI64(frameValue, valueValue_);
            return;
        }
        if (LLVMTypes.isPointer(valueValue)) {
            LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doAddress(VirtualFrame, LLVMPointer)] */;
            this.state_0_ = state_0;
            doAddress(frameValue, valueValue_);
            return;
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.value_}, valueValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI8(VirtualFrame, byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI16(VirtualFrame, short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI32(VirtualFrame, int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doI64(VirtualFrame, long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMAMD64WriteAddressRegisterNode.doAddress(VirtualFrame, LLVMPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64WriteAddressRegisterNode create(LLVMExpressionNode value, int slot) {
        return new LLVMAMD64WriteAddressRegisterNodeGen(value, slot);
    }

}
