// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMAMD64WriteValueNode#doI8}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMAMD64WriteValueNode#doI16}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMAMD64WriteValueNode#doI32}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMAMD64WriteValueNode#doI64}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMAMD64WriteValueNode#doAddress}
 *     Activation probability: 0.08000
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMAMD64WriteValueNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64WriteValueNodeGen extends LLVMAMD64WriteValueNode implements GenerateAOT.Provider {

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMAMD64WriteValueNode#doI8}
     *   2: SpecializationActive {@link LLVMAMD64WriteValueNode#doI16}
     *   3: SpecializationActive {@link LLVMAMD64WriteValueNode#doI32}
     *   4: SpecializationActive {@link LLVMAMD64WriteValueNode#doI64}
     *   5: SpecializationActive {@link LLVMAMD64WriteValueNode#doAddress}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMAMD64WriteValueNodeGen(LLVMAMD64Target dst) {
        super(dst);
    }

    @Override
    public void execute(VirtualFrame frameValue, Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, arg0Value);
            return;
        }
        if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMAMD64WriteValueNode.doI8(VirtualFrame, byte)] || SpecializationActive[LLVMAMD64WriteValueNode.doI16(VirtualFrame, short)] || SpecializationActive[LLVMAMD64WriteValueNode.doI32(VirtualFrame, int)] || SpecializationActive[LLVMAMD64WriteValueNode.doI64(VirtualFrame, long)] || SpecializationActive[LLVMAMD64WriteValueNode.doAddress(VirtualFrame, LLVMPointer)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64WriteValueNode.doI8(VirtualFrame, byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                doI8(frameValue, arg0Value_);
                return;
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64WriteValueNode.doI16(VirtualFrame, short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                doI16(frameValue, arg0Value_);
                return;
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64WriteValueNode.doI32(VirtualFrame, int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                doI32(frameValue, arg0Value_);
                return;
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64WriteValueNode.doI64(VirtualFrame, long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                doI64(frameValue, arg0Value_);
                return;
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMAMD64WriteValueNode.doAddress(VirtualFrame, LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                doAddress(frameValue, arg0Value_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(frameValue, arg0Value);
        return;
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (byte) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64WriteValueNode.doI8(VirtualFrame, byte)] */;
            this.state_0_ = state_0;
            doI8(frameValue, arg0Value_);
            return;
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (short) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64WriteValueNode.doI16(VirtualFrame, short)] */;
            this.state_0_ = state_0;
            doI16(frameValue, arg0Value_);
            return;
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64WriteValueNode.doI32(VirtualFrame, int)] */;
            this.state_0_ = state_0;
            doI32(frameValue, arg0Value_);
            return;
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMAMD64WriteValueNode.doI64(VirtualFrame, long)] */;
            this.state_0_ = state_0;
            doI64(frameValue, arg0Value_);
            return;
        }
        if (LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMAMD64WriteValueNode.doAddress(VirtualFrame, LLVMPointer)] */;
            this.state_0_ = state_0;
            doAddress(frameValue, arg0Value_);
            return;
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64WriteValueNode.doI8(VirtualFrame, byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64WriteValueNode.doI16(VirtualFrame, short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64WriteValueNode.doI32(VirtualFrame, int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMAMD64WriteValueNode.doI64(VirtualFrame, long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMAMD64WriteValueNode.doAddress(VirtualFrame, LLVMPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64WriteValueNode create(LLVMAMD64Target dst) {
        return new LLVMAMD64WriteValueNodeGen(dst);
    }

}
