// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMTo80BitFloatingNode#doPointer}
 *     Activation probability: 1.00000
 *     With/without class size: 28/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMTo80BitFloatingNode.class)
@SuppressWarnings("javadoc")
public final class LLVMTo80BitFloatingNodeGen extends LLVMTo80BitFloatingNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode fromNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMTo80BitFloatingNode#doPointer}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private PointerData pointer_cache;

    private LLVMTo80BitFloatingNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    private LLVMTo80BitFloatingNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
        super(isRecursive);
        this.fromNode_ = fromNode;
    }

    @Override
    protected LLVM80BitFloat executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere("Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
            LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            PointerData s0_ = this.pointer_cache;
            if (s0_ != null) {
                assert DSLSupport.assertIdempotence((!(isRecursive)));
                return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    private LLVM80BitFloat executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            if ((!(isRecursive))) {
                PointerData s0_ = this.insert(new PointerData());
                s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s0_.recursive_ = s0_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */;
                this.state_0_ = state_0;
                return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            if ((!(isRecursive))) {
                PointerData s0_ = this.insert(new PointerData());
                s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s0_.recursive_ = s0_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
    }

    @NeverDefault
    public static LLVMTo80BitFloatingNode create(LLVMExpressionNode fromNode) {
        return new LLVMTo80BitFloatingNodeGen(fromNode);
    }

    @NeverDefault
    public static LLVMTo80BitFloatingNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
        return new LLVMTo80BitFloatingNodeGen(isRecursive, fromNode);
    }

    @GeneratedBy(LLVMTo80BitFloatingNode.class)
    @DenyReplace
    private static final class PointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMTo80BitFloatingNode#doPointer}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMTo80BitFloatingNode#doPointer}
         *   Parameter: {@link LLVMTo80BitFloatingNode} recursive</pre>
         */
        @Child LLVMTo80BitFloatingNode recursive_;

        PointerData() {
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMTo80BitFloatingNode#doPointer}
     *     Activation probability: 0.17364
     *     With/without class size: 8/8 bytes
     *   Specialization {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(boolean)}
     *     Activation probability: 0.15727
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM80BitFloatNode#do80BitFloat}
     *     Activation probability: 0.14091
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(short)}
     *     Activation probability: 0.12455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(int)}
     *     Activation probability: 0.10818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(long)}
     *     Activation probability: 0.09182
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(float)}
     *     Activation probability: 0.07545
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(double)}
     *     Activation probability: 0.05909
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(LLVM80BitFloat)}
     *     Activation probability: 0.04273
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(LLVMIVarBitLarge)}
     *     Activation probability: 0.02636
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMSignedCastToLLVM80BitFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMSignedCastToLLVM80BitFloatNodeGen extends LLVMSignedCastToLLVM80BitFloatNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMTo80BitFloatingNode#doPointer}
         *   2: SpecializationActive {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(boolean)}
         *   3: SpecializationActive {@link LLVMSignedCastToLLVM80BitFloatNode#do80BitFloat}
         *   4: SpecializationActive {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(short)}
         *   5: SpecializationActive {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(int)}
         *   6: SpecializationActive {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(long)}
         *   7: SpecializationActive {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(float)}
         *   8: SpecializationActive {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(double)}
         *   9: SpecializationActive {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(LLVM80BitFloat)}
         *   10: SpecializationActive {@link LLVMSignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(LLVMIVarBitLarge)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private PointerData pointer_cache;

        private LLVMSignedCastToLLVM80BitFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMSignedCastToLLVM80BitFloatNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected LLVM80BitFloat executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */) {
                return doLLVM80BitFloatNode(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111111010) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b11111110110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b11111101110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b11111011110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b11110111110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b11101111110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else if ((state_0 & 0b11011111110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_double6(state_0, frameValue);
            } else {
                return executeGeneric_generic7(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */;
            return do80BitFloat(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111111110) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return do80BitFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */ && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                    LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private LLVM80BitFloat executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */;
                this.state_0_ = state_0;
                return do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                    ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                    ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMSignedCastToLLVM80BitFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToLLVM80BitFloatNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMSignedCastToLLVM80BitFloatNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToLLVM80BitFloatNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMSignedCastToLLVM80BitFloatNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo80BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo80BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMTo80BitFloatingNode} recursive</pre>
             */
            @Child LLVMTo80BitFloatingNode recursive_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMTo80BitFloatingNode#doPointer}
     *     Activation probability: 0.17364
     *     With/without class size: 8/8 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(boolean)}
     *     Activation probability: 0.15727
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM80BitFloatNode#do80BitFloat(byte)}
     *     Activation probability: 0.14091
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM80BitFloatNode#do80BitFloat(short)}
     *     Activation probability: 0.12455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(int)}
     *     Activation probability: 0.10818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(long)}
     *     Activation probability: 0.09182
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(float)}
     *     Activation probability: 0.07545
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(double)}
     *     Activation probability: 0.05909
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(LLVM80BitFloat)}
     *     Activation probability: 0.04273
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(LLVMIVarBitLarge)}
     *     Activation probability: 0.02636
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMUnsignedCastToLLVM80BitFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMUnsignedCastToLLVM80BitFloatNodeGen extends LLVMUnsignedCastToLLVM80BitFloatNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMTo80BitFloatingNode#doPointer}
         *   2: SpecializationActive {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(boolean)}
         *   3: SpecializationActive {@link LLVMUnsignedCastToLLVM80BitFloatNode#do80BitFloat(byte)}
         *   4: SpecializationActive {@link LLVMUnsignedCastToLLVM80BitFloatNode#do80BitFloat(short)}
         *   5: SpecializationActive {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(int)}
         *   6: SpecializationActive {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(long)}
         *   7: SpecializationActive {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(float)}
         *   8: SpecializationActive {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(double)}
         *   9: SpecializationActive {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(LLVM80BitFloat)}
         *   10: SpecializationActive {@link LLVMUnsignedCastToLLVM80BitFloatNode#doLLVM80BitFloatNode(LLVMIVarBitLarge)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private PointerData pointer_cache;

        private LLVMUnsignedCastToLLVM80BitFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMUnsignedCastToLLVM80BitFloatNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected LLVM80BitFloat executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */) {
                return doLLVM80BitFloatNode(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111111010) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b11111110110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b11111101110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b11111011110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b11110111110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b11101111110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else if ((state_0 & 0b11011111110) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_double6(state_0, frameValue);
            } else {
                return executeGeneric_generic7(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */;
            return do80BitFloat(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] */;
            return do80BitFloat(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */;
            return doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111111110) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return do80BitFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return do80BitFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */ && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                    LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private LLVM80BitFloat executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */;
                this.state_0_ = state_0;
                return do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] */;
                this.state_0_ = state_0;
                return do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                    ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                    ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.do80BitFloat(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVMIVarBitLarge)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMUnsignedCastToLLVM80BitFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToLLVM80BitFloatNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMUnsignedCastToLLVM80BitFloatNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToLLVM80BitFloatNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMUnsignedCastToLLVM80BitFloatNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo80BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo80BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMTo80BitFloatingNode} recursive</pre>
             */
            @Child LLVMTo80BitFloatingNode recursive_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMTo80BitFloatingNode#doPointer}
     *     Activation probability: 0.23929
     *     With/without class size: 9/8 bytes
     *   Specialization {@link LLVMBitcastToLLVM80BitFloatNode#doDouble}
     *     Activation probability: 0.20714
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMBitcastToLLVM80BitFloatNode#doLLVM80BitFloatNode}
     *     Activation probability: 0.17500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMBitcastToLLVM80BitFloatNode#doIVarBit}
     *     Activation probability: 0.14286
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToLLVM80BitFloatNode#doI1Vector}
     *     Activation probability: 0.11071
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToLLVM80BitFloatNode#doI8Vector}
     *     Activation probability: 0.07857
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToLLVM80BitFloatNode#doI16Vector}
     *     Activation probability: 0.04643
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMBitcastToLLVM80BitFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMBitcastToLLVM80BitFloatNodeGen extends LLVMBitcastToLLVM80BitFloatNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMTo80BitFloatingNode#doPointer}
         *   2: SpecializationActive {@link LLVMBitcastToLLVM80BitFloatNode#doDouble}
         *   3: SpecializationActive {@link LLVMBitcastToLLVM80BitFloatNode#doLLVM80BitFloatNode}
         *   4: SpecializationActive {@link LLVMBitcastToLLVM80BitFloatNode#doIVarBit}
         *   5: SpecializationActive {@link LLVMBitcastToLLVM80BitFloatNode#doI1Vector}
         *   6: SpecializationActive {@link LLVMBitcastToLLVM80BitFloatNode#doI8Vector}
         *   7: SpecializationActive {@link LLVMBitcastToLLVM80BitFloatNode#doI16Vector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private PointerData pointer_cache;

        private LLVMBitcastToLLVM80BitFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMBitcastToLLVM80BitFloatNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected LLVM80BitFloat executeWith(long fromNodeValue) {
            throw CompilerDirectives.shouldNotReachHere("Delegation failed.");
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111010) == 0 /* only-active SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doDouble(double)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doDouble(double)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI16Vector(LLVMI16Vector)] */)) {
                return executeGeneric_double0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_double0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doDouble(double)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doIVarBit(LLVMIVarBitLarge)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI8Vector(LLVMI8Vector)] || SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI16Vector(LLVMI16Vector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doLLVM80BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doIVarBit(LLVMIVarBitLarge)] */ && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                    LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI8Vector(LLVMI8Vector)] */ && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector) fromNodeValue_;
                    return doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI16Vector(LLVMI16Vector)] */ && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector) fromNodeValue_;
                    return doI16Vector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private LLVM80BitFloat executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloatNode(fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doIVarBit(LLVMIVarBitLarge)] */;
                this.state_0_ = state_0;
                return doIVarBit(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI1Vector(LLVMI1Vector)] */;
                this.state_0_ = state_0;
                return doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI8Vector(LLVMI8Vector)] */;
                this.state_0_ = state_0;
                return doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI16Vector(LLVMI16Vector)] */;
                this.state_0_ = state_0;
                return doI16Vector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                    ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                    ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTo80BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo80BitFloatingNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doDouble(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doLLVM80BitFloatNode(LLVM80BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doIVarBit(LLVMIVarBitLarge)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI1Vector(LLVMI1Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI8Vector(LLVMI8Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.doI16Vector(LLVMI16Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMBitcastToLLVM80BitFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToLLVM80BitFloatNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMBitcastToLLVM80BitFloatNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMBitcastToLLVM80BitFloatNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMBitcastToLLVM80BitFloatNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo80BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo80BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMTo80BitFloatingNode} recursive</pre>
             */
            @Child LLVMTo80BitFloatingNode recursive_;

            PointerData() {
            }

        }
    }
}
