// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.except.LLVMException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValueNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToI8Node#doManagedPointer}
 *     Activation probability: 0.48333
 *     With/without class size: 17/12 bytes
 *   Specialization {@link LLVMToI8Node#doPointer}
 *     Activation probability: 0.33333
 *     With/without class size: 10/4 bytes
 *   Specialization {@link LLVMToI8Node#doFallbackPointerAsComparable}
 *     Activation probability: 0.18333
 *     With/without class size: 7/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMToI8Node.class)
@SuppressWarnings("javadoc")
public final class LLVMToI8NodeGen extends LLVMToI8Node implements GenerateAOT.Provider {

    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @Child private LLVMExpressionNode fromNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToI8Node#doManagedPointer}
     *   2: SpecializationActive {@link LLVMToI8Node#doPointer}
     *   3: SpecializationExcluded {@link LLVMToI8Node#doPointer}
     *   4: SpecializationActive {@link LLVMToI8Node#doFallbackPointerAsComparable}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private ManagedPointerData managedPointer_cache;
    @Child private PointerData pointer_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMToI8Node#doFallbackPointerAsComparable}
     *   Parameter: {@link ToComparableValue} toComparableValue</pre>
     */
    @Child private ToComparableValue fallbackPointerAsComparable_toComparableValue_;

    private LLVMToI8NodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b10110) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null) {
                    if ((LLVMToI8Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                        return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                    }
                }
            }
            if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */) {
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        try {
                            return doPointer(fromNodeValue__, s1_.toNative_);
                        } catch (LLVMException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.pointer_cache = null;
                            return executeAndSpecialize(fromNodeValue__);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
                    {
                        ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                        if (toComparableValue__ != null) {
                            return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    @Override
    public byte executeI8(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b10110) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null) {
                    if ((LLVMToI8Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                        return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                    }
                }
            }
            if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */) {
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        try {
                            return doPointer(fromNodeValue__, s1_.toNative_);
                        } catch (LLVMException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.pointer_cache = null;
                            return executeAndSpecialize(fromNodeValue__);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
                    {
                        ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                        if (toComparableValue__ != null) {
                            return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    @SuppressWarnings("unused")
    private byte executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(fromNodeValue)) {
            LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
            {
                LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                if ((LLVMToI8Node.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                    ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                    s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                    Objects.requireNonNull(s0_.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.foreigns_ = foreigns__;
                    Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.interop_ = interop__;
                    VarHandle.storeStoreFence();
                    this.managedPointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return doManagedPointer(fromNodeValue_, s0_.toLLVM_, foreigns__, interop__);
                }
            }
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            if (((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                this.state_0_ = state_0;
                try {
                    return doPointer(fromNodeValue_, s1_.toNative_);
                } catch (LLVMException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                    state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    this.pointer_cache = null;
                    return executeAndSpecialize(fromNodeValue_);
                }
            }
            ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
            Objects.requireNonNull(toComparableValue__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
            this.state_0_ = state_0;
            return doFallbackPointerAsComparable(fromNodeValue_, toComparableValue__);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            PointerData s1_ = this.insert(new PointerData());
            s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            VarHandle.storeStoreFence();
            this.pointer_cache = s1_;
            assert NodeUtil.assertRecursion(s1_.toNative_, 1);
            ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
        }
        {
            ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
            Objects.requireNonNull(toComparableValue__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
            assert NodeUtil.assertRecursion(this.fallbackPointerAsComparable_toComparableValue_, 1);
            ((GenerateAOT.Provider) this.fallbackPointerAsComparable_toComparableValue_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
        this.fallbackPointerAsComparable_toComparableValue_ = null;
    }

    @NeverDefault
    public static LLVMToI8Node create(LLVMExpressionNode fromNode) {
        return new LLVMToI8NodeGen(fromNode);
    }

    @GeneratedBy(LLVMToI8Node.class)
    @DenyReplace
    private static final class ManagedPointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI8Node#doManagedPointer}
         *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
         */
        @Child ForeignToLLVM toLLVM_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI8Node#doManagedPointer}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI8Node#doManagedPointer}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;

        ManagedPointerData() {
        }

    }
    @GeneratedBy(LLVMToI8Node.class)
    @DenyReplace
    private static final class PointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI8Node#doPointer}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;

        PointerData() {
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToI8Node#doManagedPointer}
     *     Activation probability: 0.14679
     *     With/without class size: 8/12 bytes
     *   Specialization {@link LLVMToI8Node#doPointer}
     *     Activation probability: 0.13526
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMToI8Node#doFallbackPointerAsComparable}
     *     Activation probability: 0.12372
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMSignedCastToI8Node#doI8(boolean)}
     *     Activation probability: 0.11218
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI8Node#doI8(byte)}
     *     Activation probability: 0.10064
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI8Node#doI8(short)}
     *     Activation probability: 0.08910
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI8Node#doI8(int)}
     *     Activation probability: 0.07756
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI8Node#doI8(long)}
     *     Activation probability: 0.06603
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI8Node#doI8(LLVMIVarBit)}
     *     Activation probability: 0.05449
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI8Node#doI8(float)}
     *     Activation probability: 0.04295
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI8Node#doI8(double)}
     *     Activation probability: 0.03141
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI8Node#doI8(LLVM80BitFloat)}
     *     Activation probability: 0.01987
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMSignedCastToI8Node.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMSignedCastToI8NodeGen extends LLVMSignedCastToI8Node implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToI8Node#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToI8Node#doPointer}
         *   3: SpecializationExcluded {@link LLVMToI8Node#doPointer}
         *   4: SpecializationActive {@link LLVMToI8Node#doFallbackPointerAsComparable}
         *   5: SpecializationActive {@link LLVMSignedCastToI8Node#doI8(boolean)}
         *   6: SpecializationActive {@link LLVMSignedCastToI8Node#doI8(byte)}
         *   7: SpecializationActive {@link LLVMSignedCastToI8Node#doI8(short)}
         *   8: SpecializationActive {@link LLVMSignedCastToI8Node#doI8(int)}
         *   9: SpecializationActive {@link LLVMSignedCastToI8Node#doI8(long)}
         *   10: SpecializationActive {@link LLVMSignedCastToI8Node#doI8(LLVMIVarBit)}
         *   11: SpecializationActive {@link LLVMSignedCastToI8Node#doI8(float)}
         *   12: SpecializationActive {@link LLVMSignedCastToI8Node#doI8(double)}
         *   13: SpecializationActive {@link LLVMSignedCastToI8Node#doI8(LLVM80BitFloat)}
         *   14-16: ImplicitCast[type=LLVMIVarBit, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI8Node#doFallbackPointerAsComparable}
         *   Parameter: {@link ToComparableValue} toComparableValue</pre>
         */
        @Child private ToComparableValue fallbackPointerAsComparable_toComparableValue_;

        private LLVMSignedCastToI8NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111111010110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b11111110110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b11111101110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b11111011110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b11110111110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b11011111110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else if ((state_0 & 0b10111111110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeGeneric_double6(state_0, frameValue);
            } else {
                return executeGeneric_generic7(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111111110110) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI8Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */) {
                        PointerData s1_ = this.pointer_cache;
                        if (s1_ != null) {
                            try {
                                return doPointer(fromNodeValue__, s1_.toNative_);
                            } catch (LLVMException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointer_cache = null;
                                return executeAndSpecialize(fromNodeValue__);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
                        {
                            ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                            if (toComparableValue__ != null) {
                                return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111111010110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeI8_boolean8(state_0, frameValue);
            } else if ((state_0 & 0b11111110110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeI8_byte9(state_0, frameValue);
            } else if ((state_0 & 0b11111101110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeI8_short10(state_0, frameValue);
            } else if ((state_0 & 0b11111011110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeI8_int11(state_0, frameValue);
            } else if ((state_0 & 0b11110111110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeI8_long12(state_0, frameValue);
            } else if ((state_0 & 0b11011111110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeI8_float13(state_0, frameValue);
            } else if ((state_0 & 0b10111111110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] && SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */)) {
                return executeI8_double14(state_0, frameValue);
            } else {
                return executeI8_generic15(state_0, frameValue);
            }
        }

        private byte executeI8_boolean8(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] */;
            return doI8(fromNodeValue_);
        }

        private byte executeI8_byte9(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private byte executeI8_short10(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] */;
            return doI8(fromNodeValue_);
        }

        private byte executeI8_int11(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] */;
            return doI8(fromNodeValue_);
        }

        private byte executeI8_long12(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] */;
            return doI8(fromNodeValue_);
        }

        private byte executeI8_float13(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] */;
            return doI8(fromNodeValue_);
        }

        private byte executeI8_double14(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] */;
            return doI8(fromNodeValue_);
        }

        private byte executeI8_generic15(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111111110110) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] || SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI8Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */) {
                        PointerData s1_ = this.pointer_cache;
                        if (s1_ != null) {
                            try {
                                return doPointer(fromNodeValue__, s1_.toNative_);
                            } catch (LLVMException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointer_cache = null;
                                return executeAndSpecialize(fromNodeValue__);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
                        {
                            ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                            if (toComparableValue__ != null) {
                                return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private byte executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToI8Node.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, foreigns__, interop__);
                    }
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                    this.state_0_ = state_0;
                    try {
                        return doPointer(fromNodeValue_, s1_.toNative_);
                    } catch (LLVMException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.pointer_cache = null;
                        return executeAndSpecialize(fromNodeValue_);
                    }
                }
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
                this.state_0_ = state_0;
                return doFallbackPointerAsComparable(fromNodeValue_, toComparableValue__);
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            {
                int lLVMIVarBitCast0;
                if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue)) != 0) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state_0 = (state_0 | (lLVMIVarBitCast0 << 14) /* set-int ImplicitCast[type=LLVMIVarBit, index=0] */);
                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] */;
                    this.state_0_ = state_0;
                    return doI8(fromNodeValue_);
                }
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
            }
            {
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                assert NodeUtil.assertRecursion(this.fallbackPointerAsComparable_toComparableValue_, 1);
                ((GenerateAOT.Provider) this.fallbackPointerAsComparable_toComparableValue_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVMIVarBit)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000000 /* add SpecializationActive[LLVMToI8Node.LLVMSignedCastToI8Node.doI8(LLVM80BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            state_0 = state_0 | 0x1c000 /* add ImplicitCast[type=LLVMIVarBit, index=0] */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
            this.fallbackPointerAsComparable_toComparableValue_ = null;
        }

        @NeverDefault
        public static LLVMSignedCastToI8Node create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToI8NodeGen(fromNode);
        }

        @GeneratedBy(LLVMSignedCastToI8Node.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

        }
        @GeneratedBy(LLVMSignedCastToI8Node.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToI8Node#doManagedPointer}
     *     Activation probability: 0.19111
     *     With/without class size: 9/12 bytes
     *   Specialization {@link LLVMToI8Node#doPointer}
     *     Activation probability: 0.17111
     *     With/without class size: 7/4 bytes
     *   Specialization {@link LLVMToI8Node#doFallbackPointerAsComparable}
     *     Activation probability: 0.15111
     *     With/without class size: 7/4 bytes
     *   Specialization {@link LLVMUnsignedCastToI8Node#doI1}
     *     Activation probability: 0.13111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI8Node#doI8}
     *     Activation probability: 0.11111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI8Node#doIVarBit}
     *     Activation probability: 0.09111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI8Node#doFloat(float)}
     *     Activation probability: 0.07111
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI8Node#doFloat(double)}
     *     Activation probability: 0.05111
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI8Node#doLLVM80BitFloat}
     *     Activation probability: 0.03111
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMUnsignedCastToI8Node.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMUnsignedCastToI8NodeGen extends LLVMUnsignedCastToI8Node implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToI8Node#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToI8Node#doPointer}
         *   3: SpecializationExcluded {@link LLVMToI8Node#doPointer}
         *   4: SpecializationActive {@link LLVMToI8Node#doFallbackPointerAsComparable}
         *   5: SpecializationActive {@link LLVMUnsignedCastToI8Node#doI1}
         *   6: SpecializationActive {@link LLVMUnsignedCastToI8Node#doI8}
         *   7: SpecializationActive {@link LLVMUnsignedCastToI8Node#doIVarBit}
         *   8: SpecializationActive {@link LLVMUnsignedCastToI8Node#doFloat(float)}
         *   9: SpecializationActive {@link LLVMUnsignedCastToI8Node#doFloat(double)}
         *   10: SpecializationActive {@link LLVMUnsignedCastToI8Node#doLLVM80BitFloat}
         *   11-13: ImplicitCast[type=LLVMIVarBit, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI8Node#doFallbackPointerAsComparable}
         *   Parameter: {@link ToComparableValue} toComparableValue</pre>
         */
        @Child private ToComparableValue fallbackPointerAsComparable_toComparableValue_;

        private LLVMUnsignedCastToI8NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111010110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] */ && ((state_0 & 0b11111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b11110110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] */ && ((state_0 & 0b11111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b11011110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] */ && ((state_0 & 0b11111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_float2(state_0, frameValue);
            } else if ((state_0 & 0b10111110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] */ && ((state_0 & 0b11111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_double3(state_0, frameValue);
            } else {
                return executeGeneric_generic4(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] */;
            return doI1(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_float2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111110110) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI8Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */) {
                        PointerData s1_ = this.pointer_cache;
                        if (s1_ != null) {
                            try {
                                return doPointer(fromNodeValue__, s1_.toNative_);
                            } catch (LLVMException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointer_cache = null;
                                return executeAndSpecialize(fromNodeValue__);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
                        {
                            ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                            if (toComparableValue__ != null) {
                                return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI1(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doLLVM80BitFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111010110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] */ && ((state_0 & 0b11111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI8_boolean5(state_0, frameValue);
            } else if ((state_0 & 0b11110110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] */ && ((state_0 & 0b11111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI8_byte6(state_0, frameValue);
            } else if ((state_0 & 0b11011110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] */ && ((state_0 & 0b11111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI8_float7(state_0, frameValue);
            } else if ((state_0 & 0b10111110110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] */ && ((state_0 & 0b11111110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] && SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI8_double8(state_0, frameValue);
            } else {
                return executeI8_generic9(state_0, frameValue);
            }
        }

        private byte executeI8_boolean5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] */;
            return doI1(fromNodeValue_);
        }

        private byte executeI8_byte6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private byte executeI8_float7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private byte executeI8_double8(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] */;
            return doFloat(fromNodeValue_);
        }

        private byte executeI8_generic9(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111110110) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] || SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI8Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */) {
                        PointerData s1_ = this.pointer_cache;
                        if (s1_ != null) {
                            try {
                                return doPointer(fromNodeValue__, s1_.toNative_);
                            } catch (LLVMException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointer_cache = null;
                                return executeAndSpecialize(fromNodeValue__);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
                        {
                            ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                            if (toComparableValue__ != null) {
                                return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI1(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doLLVM80BitFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private byte executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToI8Node.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, foreigns__, interop__);
                    }
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                    this.state_0_ = state_0;
                    try {
                        return doPointer(fromNodeValue_, s1_.toNative_);
                    } catch (LLVMException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.pointer_cache = null;
                        return executeAndSpecialize(fromNodeValue_);
                    }
                }
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
                this.state_0_ = state_0;
                return doFallbackPointerAsComparable(fromNodeValue_, toComparableValue__);
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] */;
                this.state_0_ = state_0;
                return doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            {
                int lLVMIVarBitCast0;
                if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue)) != 0) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state_0 = (state_0 | (lLVMIVarBitCast0 << 11) /* set-int ImplicitCast[type=LLVMIVarBit, index=0] */);
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] */;
                    this.state_0_ = state_0;
                    return doIVarBit(fromNodeValue_);
                }
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloat(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
            }
            {
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                assert NodeUtil.assertRecursion(this.fallbackPointerAsComparable_toComparableValue_, 1);
                ((GenerateAOT.Provider) this.fallbackPointerAsComparable_toComparableValue_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI1(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doI8(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doIVarBit(LLVMIVarBit)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doFloat(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToI8Node.LLVMUnsignedCastToI8Node.doLLVM80BitFloat(LLVM80BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            state_0 = state_0 | 0b11100000000000 /* add ImplicitCast[type=LLVMIVarBit, index=0] */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
            this.fallbackPointerAsComparable_toComparableValue_ = null;
        }

        @NeverDefault
        public static LLVMUnsignedCastToI8Node create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToI8NodeGen(fromNode);
        }

        @GeneratedBy(LLVMUnsignedCastToI8Node.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

        }
        @GeneratedBy(LLVMUnsignedCastToI8Node.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToI8Node#doManagedPointer}
     *     Activation probability: 0.27381
     *     With/without class size: 11/12 bytes
     *   Specialization {@link LLVMToI8Node#doPointer}
     *     Activation probability: 0.23095
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMToI8Node#doFallbackPointerAsComparable}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link LLVMBitcastToI8Node#doI8}
     *     Activation probability: 0.14524
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToI8Node#doI1Vector}
     *     Activation probability: 0.10238
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToI8Node#doI8Vector}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMBitcastToI8Node.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMBitcastToI8NodeGen extends LLVMBitcastToI8Node implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToI8Node#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToI8Node#doPointer}
         *   3: SpecializationExcluded {@link LLVMToI8Node#doPointer}
         *   4: SpecializationActive {@link LLVMToI8Node#doFallbackPointerAsComparable}
         *   5: SpecializationActive {@link LLVMBitcastToI8Node#doI8}
         *   6: SpecializationActive {@link LLVMBitcastToI8Node#doI1Vector}
         *   7: SpecializationActive {@link LLVMBitcastToI8Node#doI8Vector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI8Node#doFallbackPointerAsComparable}
         *   Parameter: {@link ToComparableValue} toComparableValue</pre>
         */
        @Child private ToComparableValue fallbackPointerAsComparable_toComparableValue_;

        private LLVMBitcastToI8NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11010110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] */ && ((state_0 & 0b11110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8Vector(LLVMI8Vector)] */)) {
                return executeGeneric_byte0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_byte0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11110110) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] || SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8Vector(LLVMI8Vector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI8Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */) {
                        PointerData s1_ = this.pointer_cache;
                        if (s1_ != null) {
                            try {
                                return doPointer(fromNodeValue__, s1_.toNative_);
                            } catch (LLVMException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointer_cache = null;
                                return executeAndSpecialize(fromNodeValue__);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
                        {
                            ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                            if (toComparableValue__ != null) {
                                return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8Vector(LLVMI8Vector)] */ && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector) fromNodeValue_;
                    return doI8Vector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11010110) == 0 /* only-active SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] */ && ((state_0 & 0b11110110) != 0  /* is-not SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] && SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8Vector(LLVMI8Vector)] */)) {
                return executeI8_byte2(state_0, frameValue);
            } else {
                return executeI8_generic3(state_0, frameValue);
            }
        }

        private byte executeI8_byte2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private byte executeI8_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11110110) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] || SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8Vector(LLVMI8Vector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI8Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */) {
                        PointerData s1_ = this.pointer_cache;
                        if (s1_ != null) {
                            try {
                                return doPointer(fromNodeValue__, s1_.toNative_);
                            } catch (LLVMException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointer_cache = null;
                                return executeAndSpecialize(fromNodeValue__);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
                        {
                            ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                            if (toComparableValue__ != null) {
                                return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8Vector(LLVMI8Vector)] */ && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector) fromNodeValue_;
                    return doI8Vector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private byte executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToI8Node.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI8Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, foreigns__, interop__);
                    }
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                    this.state_0_ = state_0;
                    try {
                        return doPointer(fromNodeValue_, s1_.toNative_);
                    } catch (LLVMException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.pointer_cache = null;
                        return executeAndSpecialize(fromNodeValue_);
                    }
                }
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
                this.state_0_ = state_0;
                return doFallbackPointerAsComparable(fromNodeValue_, toComparableValue__);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI1Vector(LLVMI1Vector)] */;
                this.state_0_ = state_0;
                return doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8Vector(LLVMI8Vector)] */;
                this.state_0_ = state_0;
                return doI8Vector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI8Node.doPointer(LLVMPointer, LLVMToNativeNode)] */;
            }
            {
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                assert NodeUtil.assertRecursion(this.fallbackPointerAsComparable_toComparableValue_, 1);
                ((GenerateAOT.Provider) this.fallbackPointerAsComparable_toComparableValue_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI8Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI1Vector(LLVMI1Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToI8Node.LLVMBitcastToI8Node.doI8Vector(LLVMI8Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
            this.fallbackPointerAsComparable_toComparableValue_ = null;
        }

        @NeverDefault
        public static LLVMBitcastToI8Node create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToI8NodeGen(fromNode);
        }

        @GeneratedBy(LLVMBitcastToI8Node.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

        }
        @GeneratedBy(LLVMBitcastToI8Node.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI8Node#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;

            PointerData() {
            }

        }
    }
}
