// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchSwitchNode.CatchPadEntryNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(CatchPadEntryNode.class)
final class CatchPadEntryNodeWrapper extends CatchPadEntryNode implements WrapperNode {

    @Child private CatchPadEntryNode delegateNode;
    @Child private ProbeNode probeNode;

    CatchPadEntryNodeWrapper(CatchPadEntryNode node, CatchPadEntryNode delegateNode, ProbeNode probeNode) {
        super(node);
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public CatchPadEntryNode getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    boolean execute(VirtualFrame frame, LLVMStack stack, LLVMPointer thrownObject, LLVMPointer throwInfo, LLVMPointer imageBase, long stackPointer) {
        boolean returnValue;
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                returnValue = delegateNode.execute(frame, stack, thrownObject, throwInfo, imageBase, stackPointer);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, returnValue);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    returnValue = (boolean) result;
                    break;
                }
                throw t;
            }
        }
        return returnValue;
    }

}
