// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMCallNode#doCall}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMCallNode#doTailCall}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMCallNode.class)
@SuppressWarnings("javadoc")
public final class LLVMCallNodeGen extends LLVMCallNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode dispatchTarget_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMCallNode#doCall}
     *   2: SpecializationActive {@link LLVMCallNode#doTailCall}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMCallNodeGen(FunctionType functionType, LLVMExpressionNode[] argumentNodes, boolean isSourceCall, boolean mustTail, LLVMFunction llvmFunction, LLVMExpressionNode dispatchTarget) {
        super(functionType, argumentNodes, isSourceCall, mustTail, llvmFunction);
        this.dispatchTarget_ = dispatchTarget;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object dispatchTargetValue_ = this.dispatchTarget_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, dispatchTargetValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMCallNode.doCall(VirtualFrame, Object)] || SpecializationActive[LLVMCallNode.doTailCall(VirtualFrame, Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMCallNode.doCall(VirtualFrame, Object)] */) {
                assert DSLSupport.assertIdempotence((!(mustTail)));
                return doCall(frameValue, dispatchTargetValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMCallNode.doTailCall(VirtualFrame, Object)] */) {
                assert DSLSupport.assertIdempotence((mustTail));
                return doTailCall(frameValue, dispatchTargetValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, dispatchTargetValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object dispatchTargetValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((!(mustTail))) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMCallNode.doCall(VirtualFrame, Object)] */;
            this.state_0_ = state_0;
            return doCall(frameValue, dispatchTargetValue);
        }
        if ((mustTail)) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMCallNode.doTailCall(VirtualFrame, Object)] */;
            this.state_0_ = state_0;
            return doTailCall(frameValue, dispatchTargetValue);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.dispatchTarget_}, dispatchTargetValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            if ((!(mustTail))) {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMCallNode.doCall(VirtualFrame, Object)] */;
            }
        }
        {
            if ((mustTail)) {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMCallNode.doTailCall(VirtualFrame, Object)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMCallNode create(FunctionType functionType, LLVMExpressionNode[] argumentNodes, boolean isSourceCall, boolean mustTail, LLVMFunction llvmFunction, LLVMExpressionNode dispatchTarget) {
        return new LLVMCallNodeGen(functionType, argumentNodes, isSourceCall, mustTail, llvmFunction, dispatchTarget);
    }

}
