// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMRaiseExceptionNode#doRaise}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMRaiseExceptionNode.class)
@SuppressWarnings("javadoc")
public final class LLVMRaiseExceptionNodeGen extends LLVMRaiseExceptionNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode unwindHeader_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMRaiseExceptionNode#doRaise}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMRaiseExceptionNodeGen(LLVMExpressionNode unwindHeader) {
        this.unwindHeader_ = unwindHeader;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object unwindHeaderValue_ = this.unwindHeader_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(unwindHeaderValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRaiseExceptionNode.doRaise(LLVMPointer)] */ && LLVMTypes.isPointer(unwindHeaderValue_)) {
            LLVMPointer unwindHeaderValue__ = LLVMTypes.asPointer(unwindHeaderValue_);
            return doRaise(unwindHeaderValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(unwindHeaderValue_);
    }

    private Object executeAndSpecialize(Object unwindHeaderValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(unwindHeaderValue)) {
            LLVMPointer unwindHeaderValue_ = LLVMTypes.asPointer(unwindHeaderValue);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRaiseExceptionNode.doRaise(LLVMPointer)] */;
            this.state_0_ = state_0;
            return doRaise(unwindHeaderValue_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.unwindHeader_}, unwindHeaderValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRaiseExceptionNode.doRaise(LLVMPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMRaiseExceptionNode create(LLVMExpressionNode unwindHeader) {
        return new LLVMRaiseExceptionNodeGen(unwindHeader);
    }

}
