// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMWindowsInitThreadIntrinsics.InitThreadLock;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMWindowsInitThreadIntrinsics.InitThreadNotify;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMWindowsInitThreadIntrinsics.InitThreadUnlock;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMWindowsInitThreadIntrinsics.InitThreadWait;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMWindowsInitThreadIntrinsics.class)
@SuppressWarnings("javadoc")
public final class LLVMWindowsInitThreadIntrinsicsFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link InitThreadLock#doLock}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(InitThreadLock.class)
    @SuppressWarnings("javadoc")
    public static final class InitThreadLockNodeGen extends InitThreadLock implements GenerateAOT.Provider {

        private InitThreadLockNodeGen() {
        }

        @Override
        Object execute() {
            return doLock();
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return doLock();
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static InitThreadLock create() {
            return new InitThreadLockNodeGen();
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link InitThreadUnlock#doUnlock}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(InitThreadUnlock.class)
    @SuppressWarnings("javadoc")
    public static final class InitThreadUnlockNodeGen extends InitThreadUnlock implements GenerateAOT.Provider {

        private InitThreadUnlockNodeGen() {
        }

        @Override
        Object execute() {
            return doUnlock();
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return doUnlock();
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static InitThreadUnlock create() {
            return new InitThreadUnlockNodeGen();
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link InitThreadWait#doWait}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(InitThreadWait.class)
    @SuppressWarnings("javadoc")
    public static final class InitThreadWaitNodeGen extends InitThreadWait implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode timeout_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link InitThreadWait#doWait}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private InitThreadWaitNodeGen(LLVMExpressionNode timeout) {
            this.timeout_ = timeout;
        }

        @Override
        Object execute(int timeoutValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(timeoutValue);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMWindowsInitThreadIntrinsics.InitThreadWait.doWait(int)] */) {
                return doWait(timeoutValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(timeoutValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int timeoutValue_;
            try {
                timeoutValue_ = this.timeout_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(timeoutValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMWindowsInitThreadIntrinsics.InitThreadWait.doWait(int)] */) {
                return doWait(timeoutValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(timeoutValue_);
        }

        private Object executeAndSpecialize(Object timeoutValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (timeoutValue instanceof Integer) {
                int timeoutValue_ = (int) timeoutValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMWindowsInitThreadIntrinsics.InitThreadWait.doWait(int)] */;
                this.state_0_ = state_0;
                return doWait(timeoutValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.timeout_}, timeoutValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMWindowsInitThreadIntrinsics.InitThreadWait.doWait(int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static InitThreadWait create(LLVMExpressionNode timeout) {
            return new InitThreadWaitNodeGen(timeout);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link InitThreadNotify#doWait}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(InitThreadNotify.class)
    @SuppressWarnings("javadoc")
    public static final class InitThreadNotifyNodeGen extends InitThreadNotify implements GenerateAOT.Provider {

        private InitThreadNotifyNodeGen() {
        }

        @Override
        Object execute() {
            return doWait();
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return doWait();
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static InitThreadNotify create() {
            return new InitThreadNotifyNodeGen();
        }

    }
}
