// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMDLOpen#doOp}
 *     Activation probability: 1.00000
 *     With/without class size: 24/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMDLOpen.class)
@SuppressWarnings("javadoc")
public final class LLVMDLOpenNodeGen extends LLVMDLOpen implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    @Child private LLVMExpressionNode child1_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMDLOpen#doOp}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMDLOpen#doOp}
     *   Parameter: {@link LLVMReadStringNode} readStr</pre>
     */
    @Child private LLVMReadStringNode readStr_;

    private LLVMDLOpenNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        int child1Value_;
        try {
            child1Value_ = this.child1_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(child0Value_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_, child1Value_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMDLOpen.doOp(Object, int, LLVMReadStringNode)] */) {
            {
                LLVMReadStringNode readStr__ = this.readStr_;
                if (readStr__ != null) {
                    return doOp(child0Value_, child1Value_, readStr__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_, child1Value_);
    }

    private Object executeAndSpecialize(Object child0Value, Object child1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (child1Value instanceof Integer) {
            int child1Value_ = (int) child1Value;
            LLVMReadStringNode readStr__ = this.insert((LLVMReadStringNodeGen.create()));
            Objects.requireNonNull(readStr__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.readStr_ = readStr__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMDLOpen.doOp(Object, int, LLVMReadStringNode)] */;
            this.state_0_ = state_0;
            return doOp(child0Value, child1Value_, readStr__);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_, this.child1_}, child0Value, child1Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            LLVMReadStringNode readStr__ = this.insert((LLVMReadStringNodeGen.create()));
            Objects.requireNonNull(readStr__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.readStr_ = readStr__;
            assert NodeUtil.assertRecursion(this.readStr_, 1);
            ((GenerateAOT.Provider) this.readStr_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMDLOpen.doOp(Object, int, LLVMReadStringNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.readStr_ = null;
    }

    @NeverDefault
    public static LLVMDLOpen create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
        return new LLVMDLOpenNodeGen(child0, child1);
    }

}
