// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link GraalVMCreateHandle#doZero}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link GraalVMCreateHandle#doNonZero}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link GraalVMCreateHandle#doError}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(GraalVMCreateHandle.class)
@SuppressWarnings("javadoc")
public final class GraalVMCreateHandleNodeGen extends GraalVMCreateHandle implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link GraalVMCreateHandle#doZero}
     *   2: SpecializationActive {@link GraalVMCreateHandle#doNonZero}
     *   3: SpecializationActive {@link GraalVMCreateHandle#doError}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private GraalVMCreateHandleNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[GraalVMCreateHandle.doZero(LLVMManagedPointer)] || SpecializationActive[GraalVMCreateHandle.doNonZero(LLVMManagedPointer)] || SpecializationActive[GraalVMCreateHandle.doError(LLVMNativePointer)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[GraalVMCreateHandle.doZero(LLVMManagedPointer)] || SpecializationActive[GraalVMCreateHandle.doNonZero(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(child0Value_)) {
                LLVMManagedPointer child0Value__ = LLVMTypes.asManagedPointer(child0Value_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[GraalVMCreateHandle.doZero(LLVMManagedPointer)] */) {
                    if ((child0Value__.getOffset() == 0)) {
                        return doZero(child0Value__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[GraalVMCreateHandle.doNonZero(LLVMManagedPointer)] */) {
                    if ((child0Value__.getOffset() != 0)) {
                        return doNonZero(child0Value__);
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[GraalVMCreateHandle.doError(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                return doError(child0Value__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    private LLVMNativePointer executeAndSpecialize(Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(child0Value)) {
            LLVMManagedPointer child0Value_ = LLVMTypes.asManagedPointer(child0Value);
            if ((child0Value_.getOffset() == 0)) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[GraalVMCreateHandle.doZero(LLVMManagedPointer)] */;
                this.state_0_ = state_0;
                return doZero(child0Value_);
            }
            if ((child0Value_.getOffset() != 0)) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[GraalVMCreateHandle.doNonZero(LLVMManagedPointer)] */;
                this.state_0_ = state_0;
                return doNonZero(child0Value_);
            }
        }
        if (LLVMTypes.isNativePointer(child0Value)) {
            LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
            state_0 = state_0 | 0b1000 /* add SpecializationActive[GraalVMCreateHandle.doError(LLVMNativePointer)] */;
            this.state_0_ = state_0;
            return doError(child0Value_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_}, child0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[GraalVMCreateHandle.doZero(LLVMManagedPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[GraalVMCreateHandle.doNonZero(LLVMManagedPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[GraalVMCreateHandle.doError(LLVMNativePointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static GraalVMCreateHandle create(LLVMExpressionNode child0) {
        return new GraalVMCreateHandleNodeGen(child0);
    }

}
