// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPolyglotBoxedPredicate#matchNonForeignManaged}
 *     Activation probability: 0.32000
 *     With/without class size: 11/8 bytes
 *   Specialization {@link LLVMPolyglotBoxedPredicate#matchForeignManaged}
 *     Activation probability: 0.26000
 *     With/without class size: 10/8 bytes
 *   Specialization {@link LLVMPolyglotBoxedPredicate#matchNative}
 *     Activation probability: 0.20000
 *     With/without class size: 8/4 bytes
 *   Specialization {@link LLVMPolyglotBoxedPredicate#matchString}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMPolyglotBoxedPredicate#fallback}
 *     Activation probability: 0.08000
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMPolyglotBoxedPredicate.class)
@SuppressWarnings("javadoc")
public final class LLVMPolyglotBoxedPredicateNodeGen extends LLVMPolyglotBoxedPredicate implements GenerateAOT.Provider {

    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @Child private LLVMExpressionNode object_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPolyglotBoxedPredicate#matchNonForeignManaged}
     *   2: GuardActive[guardIndex=0] {@link LLVMPolyglotBoxedPredicate#matchNonForeignManaged}
     *   3: SpecializationActive {@link LLVMPolyglotBoxedPredicate#matchForeignManaged}
     *   4: GuardActive[guardIndex=0] {@link LLVMPolyglotBoxedPredicate#matchForeignManaged}
     *   5: SpecializationActive {@link LLVMPolyglotBoxedPredicate#matchNative}
     *   6: SpecializationActive {@link LLVMPolyglotBoxedPredicate#matchString}
     *   7: SpecializationActive {@link LLVMPolyglotBoxedPredicate#fallback}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPolyglotBoxedPredicate#matchNonForeignManaged}
     *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
     */
    @Child private LLVMAsForeignLibrary matchNonForeignManaged_foreigns_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPolyglotBoxedPredicate#matchNonForeignManaged}
     *   Parameter: {@link InteropLibrary} interop</pre>
     */
    @Child private InteropLibrary matchNonForeignManaged_interop_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPolyglotBoxedPredicate#matchForeignManaged}
     *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
     */
    @Child private LLVMAsForeignLibrary matchForeignManaged_foreigns_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPolyglotBoxedPredicate#matchForeignManaged}
     *   Parameter: {@link InteropLibrary} interop</pre>
     */
    @Child private InteropLibrary matchForeignManaged_interop_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPolyglotBoxedPredicate#matchNative}
     *   Parameter: {@link InteropLibrary} interop</pre>
     */
    @Child private InteropLibrary matchNative_interop_;

    private LLVMPolyglotBoxedPredicateNodeGen(Predicate predicate, LLVMExpressionNode object) {
        super(predicate);
        this.object_ = object;
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object objectValue) {
        if (LLVMTypes.isManagedPointer(objectValue)) {
            {
                LLVMManagedPointer objectValue_ = LLVMTypes.asManagedPointer(objectValue);
                LLVMAsForeignLibrary foreigns__ = this.matchNonForeignManaged_foreigns_;
                if ((((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary), guardIndex=0] */ || foreigns__ == null || (!(foreigns__.isForeign(objectValue_))))) {
                    return false;
                }
            }
            {
                LLVMManagedPointer objectValue_ = LLVMTypes.asManagedPointer(objectValue);
                LLVMAsForeignLibrary foreigns__1 = this.matchForeignManaged_foreigns_;
                if ((((state_0 & 0b10000)) == 0 /* is-not GuardActive[specialization=LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary), guardIndex=0] */ || foreigns__1 == null || (foreigns__1.isForeign(objectValue_)))) {
                    return false;
                }
            }
        }
        if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchNative(LLVMNativePointer, InteropLibrary)] */) && LLVMTypes.isNativePointer(objectValue)) {
            return false;
        }
        if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchString(String)] */) && objectValue instanceof String) {
            return false;
        }
        return true;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object objectValue_ = this.object_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(objectValue_);
        }
        if ((state_0 & 0b11101010) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMPolyglotBoxedPredicate.matchNative(LLVMNativePointer, InteropLibrary)] || SpecializationActive[LLVMPolyglotBoxedPredicate.matchString(String)] || SpecializationActive[LLVMPolyglotBoxedPredicate.fallback(Object)] */) {
            if ((state_0 & 0b1010) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(objectValue_)) {
                LLVMManagedPointer objectValue__ = LLVMTypes.asManagedPointer(objectValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] */) {
                    {
                        LLVMAsForeignLibrary foreigns__ = this.matchNonForeignManaged_foreigns_;
                        if (foreigns__ != null) {
                            InteropLibrary interop__ = this.matchNonForeignManaged_interop_;
                            if (interop__ != null) {
                                if ((!(foreigns__.isForeign(objectValue__)))) {
                                    return matchNonForeignManaged(objectValue__, foreigns__, interop__);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] */) {
                    {
                        LLVMAsForeignLibrary foreigns__1 = this.matchForeignManaged_foreigns_;
                        if (foreigns__1 != null) {
                            InteropLibrary interop__1 = this.matchForeignManaged_interop_;
                            if (interop__1 != null) {
                                if ((foreigns__1.isForeign(objectValue__))) {
                                    return matchForeignManaged(objectValue__, foreigns__1, interop__1);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchNative(LLVMNativePointer, InteropLibrary)] */ && LLVMTypes.isNativePointer(objectValue_)) {
                LLVMNativePointer objectValue__ = LLVMTypes.asNativePointer(objectValue_);
                {
                    InteropLibrary interop__2 = this.matchNative_interop_;
                    if (interop__2 != null) {
                        return matchNative(objectValue__, interop__2);
                    }
                }
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchString(String)] */ && objectValue_ instanceof String) {
                String objectValue__ = (String) objectValue_;
                return matchString(objectValue__);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.fallback(Object)] */) {
                if (fallbackGuard_(state_0, objectValue_)) {
                    return fallback(objectValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(objectValue_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object objectValue_ = this.object_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(objectValue_);
        }
        if ((state_0 & 0b11101010) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMPolyglotBoxedPredicate.matchNative(LLVMNativePointer, InteropLibrary)] || SpecializationActive[LLVMPolyglotBoxedPredicate.matchString(String)] || SpecializationActive[LLVMPolyglotBoxedPredicate.fallback(Object)] */) {
            if ((state_0 & 0b1010) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(objectValue_)) {
                LLVMManagedPointer objectValue__ = LLVMTypes.asManagedPointer(objectValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] */) {
                    {
                        LLVMAsForeignLibrary foreigns__ = this.matchNonForeignManaged_foreigns_;
                        if (foreigns__ != null) {
                            InteropLibrary interop__ = this.matchNonForeignManaged_interop_;
                            if (interop__ != null) {
                                if ((!(foreigns__.isForeign(objectValue__)))) {
                                    return matchNonForeignManaged(objectValue__, foreigns__, interop__);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] */) {
                    {
                        LLVMAsForeignLibrary foreigns__1 = this.matchForeignManaged_foreigns_;
                        if (foreigns__1 != null) {
                            InteropLibrary interop__1 = this.matchForeignManaged_interop_;
                            if (interop__1 != null) {
                                if ((foreigns__1.isForeign(objectValue__))) {
                                    return matchForeignManaged(objectValue__, foreigns__1, interop__1);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchNative(LLVMNativePointer, InteropLibrary)] */ && LLVMTypes.isNativePointer(objectValue_)) {
                LLVMNativePointer objectValue__ = LLVMTypes.asNativePointer(objectValue_);
                {
                    InteropLibrary interop__2 = this.matchNative_interop_;
                    if (interop__2 != null) {
                        return matchNative(objectValue__, interop__2);
                    }
                }
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.matchString(String)] */ && objectValue_ instanceof String) {
                String objectValue__ = (String) objectValue_;
                return matchString(objectValue__);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMPolyglotBoxedPredicate.fallback(Object)] */) {
                if (fallbackGuard_(state_0, objectValue_)) {
                    return fallback(objectValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(objectValue_);
    }

    @SuppressWarnings("unused")
    private boolean executeAndSpecialize(Object objectValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(objectValue)) {
            LLVMManagedPointer objectValue_ = LLVMTypes.asManagedPointer(objectValue);
            {
                LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                if (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary), guardIndex=0] */) {
                    Objects.requireNonNull(this.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.matchNonForeignManaged_foreigns_ = foreigns__;
                    state_0 = state_0 | 0b100 /* add GuardActive[specialization=LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary), guardIndex=0] */;
                }
                if ((!(foreigns__.isForeign(objectValue_)))) {
                    Objects.requireNonNull(this.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.matchNonForeignManaged_foreigns_ = foreigns__;
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.matchNonForeignManaged_interop_ = interop__;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPolyglotBoxedPredicate.matchNonForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return matchNonForeignManaged(objectValue_, foreigns__, interop__);
                }
            }
            {
                LLVMAsForeignLibrary foreigns__1 = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                if (((state_0 & 0b10000)) == 0 /* is-not GuardActive[specialization=LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary), guardIndex=0] */) {
                    Objects.requireNonNull(this.insert(foreigns__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.matchForeignManaged_foreigns_ = foreigns__1;
                    state_0 = state_0 | 0b10000 /* add GuardActive[specialization=LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary), guardIndex=0] */;
                }
                if ((foreigns__1.isForeign(objectValue_))) {
                    Objects.requireNonNull(this.insert(foreigns__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.matchForeignManaged_foreigns_ = foreigns__1;
                    InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(interop__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.matchForeignManaged_interop_ = interop__1;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMPolyglotBoxedPredicate.matchForeignManaged(LLVMManagedPointer, LLVMAsForeignLibrary, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return matchForeignManaged(objectValue_, foreigns__1, interop__1);
                }
            }
        }
        if (LLVMTypes.isNativePointer(objectValue)) {
            LLVMNativePointer objectValue_ = LLVMTypes.asNativePointer(objectValue);
            InteropLibrary interop__2 = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(interop__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.matchNative_interop_ = interop__2;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMPolyglotBoxedPredicate.matchNative(LLVMNativePointer, InteropLibrary)] */;
            this.state_0_ = state_0;
            return matchNative(objectValue_, interop__2);
        }
        if (objectValue instanceof String) {
            String objectValue_ = (String) objectValue;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMPolyglotBoxedPredicate.matchString(String)] */;
            this.state_0_ = state_0;
            return matchString(objectValue_);
        }
        state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMPolyglotBoxedPredicate.fallback(Object)] */;
        this.state_0_ = state_0;
        return fallback(objectValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMPolyglotBoxedPredicate.matchString(String)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMPolyglotBoxedPredicate.fallback(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPolyglotBoxedPredicate create(Predicate predicate, LLVMExpressionNode object) {
        return new LLVMPolyglotBoxedPredicateNodeGen(predicate, object);
    }

}
