// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.values.LLVMInstantValue;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPolyglotInstantFromTimeNode#doLong}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMPolyglotInstantFromTimeNode.class)
@SuppressWarnings("javadoc")
public final class LLVMPolyglotInstantFromTimeNodeGen extends LLVMPolyglotInstantFromTimeNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPolyglotInstantFromTimeNode#doLong}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMPolyglotInstantFromTimeNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotInstantFromTimeNode.doLong(long)] */) {
            return doLong(child0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    @Override
    public LLVMInstantValue execute(VirtualFrame frameValue) {
        return (LLVMInstantValue) executeGeneric(frameValue);
    }

    private Object executeAndSpecialize(Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (child0Value instanceof Long) {
            long child0Value_ = (long) child0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPolyglotInstantFromTimeNode.doLong(long)] */;
            this.state_0_ = state_0;
            return doLong(child0Value_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_}, child0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPolyglotInstantFromTimeNode.doLong(long)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPolyglotInstantFromTimeNode create(LLVMExpressionNode child0) {
        return new LLVMPolyglotInstantFromTimeNodeGen(child0);
    }

}
