// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMInvariantEnd#doI1}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMInvariantEnd.class)
@SuppressWarnings("javadoc")
public final class LLVMInvariantEndNodeGen extends LLVMInvariantEnd implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode size_;
    @Child private LLVMExpressionNode expected_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMInvariantEnd#doI1}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMInvariantEndNodeGen(LLVMExpressionNode size, LLVMExpressionNode expected) {
        this.size_ = size;
        this.expected_ = expected;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        long sizeValue_;
        try {
            sizeValue_ = this.size_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object expectedValue = this.expected_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), expectedValue);
        }
        Object expectedValue_ = this.expected_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(sizeValue_, expectedValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInvariantEnd.doI1(long, Object)] */) {
            return doI1(sizeValue_, expectedValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(sizeValue_, expectedValue_);
    }

    private Object executeAndSpecialize(Object sizeValue, Object expectedValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (sizeValue instanceof Long) {
            long sizeValue_ = (long) sizeValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInvariantEnd.doI1(long, Object)] */;
            this.state_0_ = state_0;
            return doI1(sizeValue_, expectedValue);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.size_, this.expected_}, sizeValue, expectedValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMInvariantEnd.doI1(long, Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMInvariantEnd create(LLVMExpressionNode size, LLVMExpressionNode expected) {
        return new LLVMInvariantEndNodeGen(size, expected);
    }

}
