// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMStackRestore#doVoid}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMStackRestore.class)
@SuppressWarnings("javadoc")
public final class LLVMStackRestoreNodeGen extends LLVMStackRestore implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMStackRestore#doVoid}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMStackRestoreNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, child0Value_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStackRestore.doVoid(VirtualFrame, LLVMPointer)] */ && LLVMTypes.isPointer(child0Value_)) {
            LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
            return doVoid(frameValue, child0Value__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, child0Value_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(child0Value)) {
            LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMStackRestore.doVoid(VirtualFrame, LLVMPointer)] */;
            this.state_0_ = state_0;
            return doVoid(frameValue, child0Value_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_}, child0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMStackRestore.doVoid(VirtualFrame, LLVMPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMStackRestore create(LLVMExpressionNode child0) {
        return new LLVMStackRestoreNodeGen(child0);
    }

}
