// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsics.LLVMThreadCreate;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsics.LLVMThreadExit;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsics.LLVMThreadGetName;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsics.LLVMThreadJoin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsics.LLVMThreadSelf;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsics.LLVMThreadSetName;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsics.LLVMThreadSleep;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsics.LLVMThreadYield;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMThreadIntrinsics.class)
@SuppressWarnings("javadoc")
public final class LLVMThreadIntrinsicsFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadCreate#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 24/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadCreate.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadCreateNodeGen extends LLVMThreadCreate implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode thread_;
        @Child private LLVMExpressionNode startRoutine_;
        @Child private LLVMExpressionNode arg_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMThreadCreate#doIntrinsic}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private IntrinsicData intrinsic_cache;

        private LLVMThreadCreateNodeGen(LLVMExpressionNode thread, LLVMExpressionNode startRoutine, LLVMExpressionNode arg) {
            this.thread_ = thread;
            this.startRoutine_ = startRoutine;
            this.arg_ = arg;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object threadValue_ = this.thread_.executeGeneric(frameValue);
            Object startRoutineValue_ = this.startRoutine_.executeGeneric(frameValue);
            Object argValue_ = this.arg_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadIntrinsics.LLVMThreadCreate.doIntrinsic(LLVMPointer, LLVMPointer, LLVMPointer, LLVMI64StoreNode)] */ && LLVMTypes.isPointer(threadValue_)) {
                LLVMPointer threadValue__ = LLVMTypes.asPointer(threadValue_);
                if (LLVMTypes.isPointer(startRoutineValue_)) {
                    LLVMPointer startRoutineValue__ = LLVMTypes.asPointer(startRoutineValue_);
                    if (LLVMTypes.isPointer(argValue_)) {
                        LLVMPointer argValue__ = LLVMTypes.asPointer(argValue_);
                        IntrinsicData s0_ = this.intrinsic_cache;
                        if (s0_ != null) {
                            return doIntrinsic(threadValue__, startRoutineValue__, argValue__, s0_.store_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object threadValue_ = this.thread_.executeGeneric(frameValue);
            Object startRoutineValue_ = this.startRoutine_.executeGeneric(frameValue);
            Object argValue_ = this.arg_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadIntrinsics.LLVMThreadCreate.doIntrinsic(LLVMPointer, LLVMPointer, LLVMPointer, LLVMI64StoreNode)] */ && LLVMTypes.isPointer(threadValue_)) {
                LLVMPointer threadValue__ = LLVMTypes.asPointer(threadValue_);
                if (LLVMTypes.isPointer(startRoutineValue_)) {
                    LLVMPointer startRoutineValue__ = LLVMTypes.asPointer(startRoutineValue_);
                    if (LLVMTypes.isPointer(argValue_)) {
                        LLVMPointer argValue__ = LLVMTypes.asPointer(argValue_);
                        IntrinsicData s0_ = this.intrinsic_cache;
                        if (s0_ != null) {
                            return doIntrinsic(threadValue__, startRoutineValue__, argValue__, s0_.store_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
        }

        private int executeAndSpecialize(Object threadValue, Object startRoutineValue, Object argValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(threadValue)) {
                LLVMPointer threadValue_ = LLVMTypes.asPointer(threadValue);
                if (LLVMTypes.isPointer(startRoutineValue)) {
                    LLVMPointer startRoutineValue_ = LLVMTypes.asPointer(startRoutineValue);
                    if (LLVMTypes.isPointer(argValue)) {
                        LLVMPointer argValue_ = LLVMTypes.asPointer(argValue);
                        IntrinsicData s0_ = this.insert(new IntrinsicData());
                        s0_.store_ = s0_.insert((LLVMI64StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.intrinsic_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadCreate.doIntrinsic(LLVMPointer, LLVMPointer, LLVMPointer, LLVMI64StoreNode)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(threadValue_, startRoutineValue_, argValue_, s0_.store_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.thread_, this.startRoutine_, this.arg_}, threadValue, startRoutineValue, argValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                IntrinsicData s0_ = this.insert(new IntrinsicData());
                s0_.store_ = s0_.insert((LLVMI64StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.store_, 1);
                ((GenerateAOT.Provider) s0_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadCreate.doIntrinsic(LLVMPointer, LLVMPointer, LLVMPointer, LLVMI64StoreNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.intrinsic_cache = null;
        }

        @NeverDefault
        public static LLVMThreadCreate create(LLVMExpressionNode thread, LLVMExpressionNode startRoutine, LLVMExpressionNode arg) {
            return new LLVMThreadCreateNodeGen(thread, startRoutine, arg);
        }

        @GeneratedBy(LLVMThreadCreate.class)
        @DenyReplace
        private static final class IntrinsicData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMThreadCreate#doIntrinsic}
             *   Parameter: {@link LLVMI64StoreNode} store</pre>
             */
            @Child LLVMI64StoreNode store_;

            IntrinsicData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadExit#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadExit.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadExitNodeGen extends LLVMThreadExit implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retval_;

        private LLVMThreadExitNodeGen(LLVMExpressionNode retval) {
            this.retval_ = retval;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            Object retvalValue_ = this.retval_.executeGeneric(frameValue);
            return doIntrinsic(retvalValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            Object retvalValue_ = this.retval_.executeGeneric(frameValue);
            return doIntrinsic(retvalValue_);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static LLVMThreadExit create(LLVMExpressionNode retval) {
            return new LLVMThreadExitNodeGen(retval);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadYield#doYield}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadYield.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadYieldNodeGen extends LLVMThreadYield implements GenerateAOT.Provider {

        private LLVMThreadYieldNodeGen() {
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return doYield();
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static LLVMThreadYield create() {
            return new LLVMThreadYieldNodeGen();
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadSleep#doSleep}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadSleep.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadSleepNodeGen extends LLVMThreadSleep implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode millis_;
        @Child private LLVMExpressionNode nanos_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMThreadSleep#doSleep}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMThreadSleepNodeGen(LLVMExpressionNode millis, LLVMExpressionNode nanos) {
            this.millis_ = millis;
            this.nanos_ = nanos;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long millisValue_;
            try {
                millisValue_ = this.millis_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object nanosValue = this.nanos_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), nanosValue);
            }
            int nanosValue_;
            try {
                nanosValue_ = this.nanos_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(millisValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(millisValue_, nanosValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadIntrinsics.LLVMThreadSleep.doSleep(long, int)] */) {
                return doSleep(millisValue_, nanosValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(millisValue_, nanosValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long millisValue_;
            try {
                millisValue_ = this.millis_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object nanosValue = this.nanos_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), nanosValue);
            }
            int nanosValue_;
            try {
                nanosValue_ = this.nanos_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(millisValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(millisValue_, nanosValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadIntrinsics.LLVMThreadSleep.doSleep(long, int)] */) {
                return doSleep(millisValue_, nanosValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(millisValue_, nanosValue_);
        }

        private int executeAndSpecialize(Object millisValue, Object nanosValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (millisValue instanceof Long) {
                long millisValue_ = (long) millisValue;
                if (nanosValue instanceof Integer) {
                    int nanosValue_ = (int) nanosValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadSleep.doSleep(long, int)] */;
                    this.state_0_ = state_0;
                    return doSleep(millisValue_, nanosValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.millis_, this.nanos_}, millisValue, nanosValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadSleep.doSleep(long, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadSleep create(LLVMExpressionNode millis, LLVMExpressionNode nanos) {
            return new LLVMThreadSleepNodeGen(millis, nanos);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadJoin#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadJoin.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadJoinNodeGen extends LLVMThreadJoin implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode threadId_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMThreadJoin#doIntrinsic}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMThreadJoinNodeGen(LLVMExpressionNode threadId) {
            this.threadId_ = threadId;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long threadIdValue_;
            try {
                threadIdValue_ = this.threadId_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(threadIdValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadIntrinsics.LLVMThreadJoin.doIntrinsic(long)] */) {
                return doIntrinsic(threadIdValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(threadIdValue_);
        }

        private Object executeAndSpecialize(Object threadIdValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (threadIdValue instanceof Long) {
                long threadIdValue_ = (long) threadIdValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadJoin.doIntrinsic(long)] */;
                this.state_0_ = state_0;
                return doIntrinsic(threadIdValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.threadId_}, threadIdValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadJoin.doIntrinsic(long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadJoin create(LLVMExpressionNode threadId) {
            return new LLVMThreadJoinNodeGen(threadId);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadSelf#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadSelf.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadSelfNodeGen extends LLVMThreadSelf implements GenerateAOT.Provider {

        private LLVMThreadSelfNodeGen() {
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return doIntrinsic();
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            return doIntrinsic();
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static LLVMThreadSelf create() {
            return new LLVMThreadSelfNodeGen();
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadSetName#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 24/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadSetName.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadSetNameNodeGen extends LLVMThreadSetName implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode id_;
        @Child private LLVMExpressionNode namePointer_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMThreadSetName#doIntrinsic}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMThreadSetName#doIntrinsic}
         *   Parameter: {@link LLVMReadStringNode} readString</pre>
         */
        @Child private LLVMReadStringNode readString_;

        private LLVMThreadSetNameNodeGen(LLVMExpressionNode id, LLVMExpressionNode namePointer) {
            this.id_ = id;
            this.namePointer_ = namePointer;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long idValue_;
            try {
                idValue_ = this.id_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object namePointerValue = this.namePointer_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), namePointerValue);
            }
            Object namePointerValue_ = this.namePointer_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(idValue_, namePointerValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadIntrinsics.LLVMThreadSetName.doIntrinsic(long, LLVMPointer, LLVMReadStringNode)] */ && LLVMTypes.isPointer(namePointerValue_)) {
                LLVMPointer namePointerValue__ = LLVMTypes.asPointer(namePointerValue_);
                {
                    LLVMReadStringNode readString__ = this.readString_;
                    if (readString__ != null) {
                        return doIntrinsic(idValue_, namePointerValue__, readString__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(idValue_, namePointerValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long idValue_;
            try {
                idValue_ = this.id_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object namePointerValue = this.namePointer_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), namePointerValue);
            }
            Object namePointerValue_ = this.namePointer_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(idValue_, namePointerValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadIntrinsics.LLVMThreadSetName.doIntrinsic(long, LLVMPointer, LLVMReadStringNode)] */ && LLVMTypes.isPointer(namePointerValue_)) {
                LLVMPointer namePointerValue__ = LLVMTypes.asPointer(namePointerValue_);
                {
                    LLVMReadStringNode readString__ = this.readString_;
                    if (readString__ != null) {
                        return doIntrinsic(idValue_, namePointerValue__, readString__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(idValue_, namePointerValue_);
        }

        private int executeAndSpecialize(Object idValue, Object namePointerValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (idValue instanceof Long) {
                long idValue_ = (long) idValue;
                if (LLVMTypes.isPointer(namePointerValue)) {
                    LLVMPointer namePointerValue_ = LLVMTypes.asPointer(namePointerValue);
                    LLVMReadStringNode readString__ = this.insert((LLVMReadStringNodeGen.create()));
                    Objects.requireNonNull(readString__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.readString_ = readString__;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadSetName.doIntrinsic(long, LLVMPointer, LLVMReadStringNode)] */;
                    this.state_0_ = state_0;
                    return doIntrinsic(idValue_, namePointerValue_, readString__);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.id_, this.namePointer_}, idValue, namePointerValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                LLVMReadStringNode readString__ = this.insert((LLVMReadStringNodeGen.create()));
                Objects.requireNonNull(readString__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.readString_ = readString__;
                assert NodeUtil.assertRecursion(this.readString_, 1);
                ((GenerateAOT.Provider) this.readString_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadSetName.doIntrinsic(long, LLVMPointer, LLVMReadStringNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.readString_ = null;
        }

        @NeverDefault
        public static LLVMThreadSetName create(LLVMExpressionNode id, LLVMExpressionNode namePointer) {
            return new LLVMThreadSetNameNodeGen(id, namePointer);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadGetName#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadGetName.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadGetNameNodeGen extends LLVMThreadGetName implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode threadID_;
        @Child private LLVMExpressionNode buffer_;
        @Child private LLVMExpressionNode targetLen_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMThreadGetName#doIntrinsic}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMThreadGetNameNodeGen(LLVMExpressionNode threadID, LLVMExpressionNode buffer, LLVMExpressionNode targetLen) {
            this.threadID_ = threadID;
            this.buffer_ = buffer;
            this.targetLen_ = targetLen;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long threadIDValue_;
            try {
                threadIDValue_ = this.threadID_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object bufferValue = this.buffer_.executeGeneric(frameValue);
                Object targetLenValue = this.targetLen_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), bufferValue, targetLenValue);
            }
            Object bufferValue_ = this.buffer_.executeGeneric(frameValue);
            long targetLenValue_;
            try {
                targetLenValue_ = this.targetLen_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(threadIDValue_, bufferValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(threadIDValue_, bufferValue_, targetLenValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadIntrinsics.LLVMThreadGetName.doIntrinsic(long, LLVMPointer, long)] */ && LLVMTypes.isPointer(bufferValue_)) {
                LLVMPointer bufferValue__ = LLVMTypes.asPointer(bufferValue_);
                return doIntrinsic(threadIDValue_, bufferValue__, targetLenValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(threadIDValue_, bufferValue_, targetLenValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long threadIDValue_;
            try {
                threadIDValue_ = this.threadID_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object bufferValue = this.buffer_.executeGeneric(frameValue);
                Object targetLenValue = this.targetLen_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), bufferValue, targetLenValue);
            }
            Object bufferValue_ = this.buffer_.executeGeneric(frameValue);
            long targetLenValue_;
            try {
                targetLenValue_ = this.targetLen_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(threadIDValue_, bufferValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(threadIDValue_, bufferValue_, targetLenValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadIntrinsics.LLVMThreadGetName.doIntrinsic(long, LLVMPointer, long)] */ && LLVMTypes.isPointer(bufferValue_)) {
                LLVMPointer bufferValue__ = LLVMTypes.asPointer(bufferValue_);
                return doIntrinsic(threadIDValue_, bufferValue__, targetLenValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(threadIDValue_, bufferValue_, targetLenValue_);
        }

        private int executeAndSpecialize(Object threadIDValue, Object bufferValue, Object targetLenValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (threadIDValue instanceof Long) {
                long threadIDValue_ = (long) threadIDValue;
                if (LLVMTypes.isPointer(bufferValue)) {
                    LLVMPointer bufferValue_ = LLVMTypes.asPointer(bufferValue);
                    if (targetLenValue instanceof Long) {
                        long targetLenValue_ = (long) targetLenValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadGetName.doIntrinsic(long, LLVMPointer, long)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(threadIDValue_, bufferValue_, targetLenValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.threadID_, this.buffer_, this.targetLen_}, threadIDValue, bufferValue, targetLenValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMThreadIntrinsics.LLVMThreadGetName.doIntrinsic(long, LLVMPointer, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadGetName create(LLVMExpressionNode threadID, LLVMExpressionNode buffer, LLVMExpressionNode targetLen) {
            return new LLVMThreadGetNameNodeGen(threadID, buffer, targetLen);
        }

    }
}
