// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode.LLVMI16OffsetStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode.LLVMI32OffsetStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode.LLVMI64OffsetStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode.LLVMI8OffsetStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode.LLVMPointerOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMCompareExchangeNode#doOp}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMCompareExchangeNode.class)
@SuppressWarnings("javadoc")
public final class LLVMCompareExchangeNodeGen extends LLVMCompareExchangeNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode comparisonValue_;
    @Child private LLVMExpressionNode newValue_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMCompareExchangeNode#doOp}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMCompareExchangeNodeGen(LLVMExpressionNode resultAllocation, long secondValueOffset, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) {
        super(resultAllocation, secondValueOffset);
        this.address_ = address;
        this.comparisonValue_ = comparisonValue;
        this.newValue_ = newValue;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object comparisonValueValue_ = this.comparisonValue_.executeGeneric(frameValue);
        Object newValueValue_ = this.newValue_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, addressValue_, comparisonValueValue_, newValueValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.doOp(VirtualFrame, LLVMPointer, Object, Object)] */ && LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return doOp(frameValue, addressValue__, comparisonValueValue_, newValueValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, addressValue_, comparisonValueValue_, newValueValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object addressValue, Object comparisonValueValue, Object newValueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMCompareExchangeNode.doOp(VirtualFrame, LLVMPointer, Object, Object)] */;
            this.state_0_ = state_0;
            return doOp(frameValue, addressValue_, comparisonValueValue, newValueValue);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.comparisonValue_, this.newValue_}, addressValue, comparisonValueValue, newValueValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMCompareExchangeNode.doOp(VirtualFrame, LLVMPointer, Object, Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMCompareExchangeNode create(LLVMExpressionNode resultAllocation, long secondValueOffset, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) {
        return new LLVMCompareExchangeNodeGen(resultAllocation, secondValueOffset, address, comparisonValue, newValue);
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link AllocResultNode#doByte}
     *     Activation probability: 0.32000
     *     With/without class size: 10/4 bytes
     *   Specialization {@link AllocResultNode#doShort}
     *     Activation probability: 0.26000
     *     With/without class size: 9/4 bytes
     *   Specialization {@link AllocResultNode#doInt}
     *     Activation probability: 0.20000
     *     With/without class size: 8/4 bytes
     *   Specialization {@link AllocResultNode#doLong}
     *     Activation probability: 0.14000
     *     With/without class size: 6/4 bytes
     *   Specialization {@link AllocResultNode#doPointer}
     *     Activation probability: 0.08000
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(AllocResultNode.class)
    @SuppressWarnings("javadoc")
    static final class AllocResultNodeGen extends AllocResultNode implements GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link AllocResultNode#doByte}
         *   2: SpecializationExcluded {@link AllocResultNode#doByte}
         *   3: SpecializationActive {@link AllocResultNode#doShort}
         *   4: SpecializationExcluded {@link AllocResultNode#doShort}
         *   5: SpecializationActive {@link AllocResultNode#doInt}
         *   6: SpecializationExcluded {@link AllocResultNode#doInt}
         *   7: SpecializationActive {@link AllocResultNode#doLong}
         *   8: SpecializationExcluded {@link AllocResultNode#doLong}
         *   9: SpecializationActive {@link AllocResultNode#doPointer}
         *   10: SpecializationExcluded {@link AllocResultNode#doPointer}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ByteData byte_cache;
        @Child private ShortData short_cache;
        @Child private IntData int_cache;
        @Child private LongData long_cache;
        @Child private PointerData pointer_cache;

        private AllocResultNodeGen(long secondValueOffset, LLVMExpressionNode resultAllocation) {
            super(secondValueOffset, resultAllocation);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, Object arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 0b1010101010) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doByte(VirtualFrame, byte, boolean, LLVMI8OffsetStoreNode)] || SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doShort(VirtualFrame, short, boolean, LLVMI16OffsetStoreNode)] || SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doInt(VirtualFrame, int, boolean, LLVMI32OffsetStoreNode)] || SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doLong(VirtualFrame, long, boolean, LLVMI64OffsetStoreNode)] || SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doPointer(VirtualFrame, LLVMPointer, boolean, LLVMPointerOffsetStoreNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doByte(VirtualFrame, byte, boolean, LLVMI8OffsetStoreNode)] */ && arg0Value instanceof Byte) {
                    byte arg0Value_ = (byte) arg0Value;
                    ByteData s0_ = this.byte_cache;
                    if (s0_ != null) {
                        try {
                            return doByte(frameValue, arg0Value_, arg1Value, s0_.valueStore_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doByte(VirtualFrame, byte, boolean, LLVMI8OffsetStoreNode)] */;
                            state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.byte_cache = null;
                            return ex.getResult();
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doShort(VirtualFrame, short, boolean, LLVMI16OffsetStoreNode)] */ && arg0Value instanceof Short) {
                    short arg0Value_ = (short) arg0Value;
                    ShortData s1_ = this.short_cache;
                    if (s1_ != null) {
                        try {
                            return doShort(frameValue, arg0Value_, arg1Value, s1_.valueStore_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doShort(VirtualFrame, short, boolean, LLVMI16OffsetStoreNode)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.short_cache = null;
                            return ex.getResult();
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doInt(VirtualFrame, int, boolean, LLVMI32OffsetStoreNode)] */ && arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    IntData s2_ = this.int_cache;
                    if (s2_ != null) {
                        try {
                            return doInt(frameValue, arg0Value_, arg1Value, s2_.valueStore_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doInt(VirtualFrame, int, boolean, LLVMI32OffsetStoreNode)] */;
                            state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.int_cache = null;
                            return ex.getResult();
                        }
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doLong(VirtualFrame, long, boolean, LLVMI64OffsetStoreNode)] */ && arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    LongData s3_ = this.long_cache;
                    if (s3_ != null) {
                        try {
                            return doLong(frameValue, arg0Value_, arg1Value, s3_.valueStore_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doLong(VirtualFrame, long, boolean, LLVMI64OffsetStoreNode)] */;
                            state_0 = state_0 | 0b100000000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.long_cache = null;
                            return ex.getResult();
                        }
                    }
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doPointer(VirtualFrame, LLVMPointer, boolean, LLVMPointerOffsetStoreNode)] */ && LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    PointerData s4_ = this.pointer_cache;
                    if (s4_ != null) {
                        try {
                            return doPointer(frameValue, arg0Value_, arg1Value, s4_.valueStore_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doPointer(VirtualFrame, LLVMPointer, boolean, LLVMPointerOffsetStoreNode)] */;
                            state_0 = state_0 | 0b10000000000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.pointer_cache = null;
                            return ex.getResult();
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, byte arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doByte(VirtualFrame, byte, boolean, LLVMI8OffsetStoreNode)] */) {
                ByteData s0_ = this.byte_cache;
                if (s0_ != null) {
                    try {
                        return doByte(frameValue, arg0Value, arg1Value, s0_.valueStore_);
                    } catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doByte(VirtualFrame, byte, boolean, LLVMI8OffsetStoreNode)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.byte_cache = null;
                        return ex.getResult();
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, int arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doInt(VirtualFrame, int, boolean, LLVMI32OffsetStoreNode)] */) {
                IntData s2_ = this.int_cache;
                if (s2_ != null) {
                    try {
                        return doInt(frameValue, arg0Value, arg1Value, s2_.valueStore_);
                    } catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doInt(VirtualFrame, int, boolean, LLVMI32OffsetStoreNode)] */;
                        state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.int_cache = null;
                        return ex.getResult();
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, long arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doLong(VirtualFrame, long, boolean, LLVMI64OffsetStoreNode)] */) {
                LongData s3_ = this.long_cache;
                if (s3_ != null) {
                    try {
                        return doLong(frameValue, arg0Value, arg1Value, s3_.valueStore_);
                    } catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doLong(VirtualFrame, long, boolean, LLVMI64OffsetStoreNode)] */;
                        state_0 = state_0 | 0b100000000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.long_cache = null;
                        return ex.getResult();
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, short arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doShort(VirtualFrame, short, boolean, LLVMI16OffsetStoreNode)] */) {
                ShortData s1_ = this.short_cache;
                if (s1_ != null) {
                    try {
                        return doShort(frameValue, arg0Value, arg1Value, s1_.valueStore_);
                    } catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doShort(VirtualFrame, short, boolean, LLVMI16OffsetStoreNode)] */;
                        state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.short_cache = null;
                        return ex.getResult();
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationExcluded  */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                ByteData s0_ = this.insert(new ByteData());
                s0_.valueStore_ = s0_.insert((LLVMI8OffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.byte_cache = s0_;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doByte(VirtualFrame, byte, boolean, LLVMI8OffsetStoreNode)] */;
                this.state_0_ = state_0;
                try {
                    return doByte(frameValue, arg0Value_, arg1Value, s0_.valueStore_);
                } catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doByte(VirtualFrame, byte, boolean, LLVMI8OffsetStoreNode)] */;
                    state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    this.byte_cache = null;
                    return ex.getResult();
                }
            }
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                ShortData s1_ = this.insert(new ShortData());
                s1_.valueStore_ = s1_.insert((LLVMI16OffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.short_cache = s1_;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doShort(VirtualFrame, short, boolean, LLVMI16OffsetStoreNode)] */;
                this.state_0_ = state_0;
                try {
                    return doShort(frameValue, arg0Value_, arg1Value, s1_.valueStore_);
                } catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doShort(VirtualFrame, short, boolean, LLVMI16OffsetStoreNode)] */;
                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    this.short_cache = null;
                    return ex.getResult();
                }
            }
            if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationExcluded  */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                IntData s2_ = this.insert(new IntData());
                s2_.valueStore_ = s2_.insert((LLVMI32OffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.int_cache = s2_;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doInt(VirtualFrame, int, boolean, LLVMI32OffsetStoreNode)] */;
                this.state_0_ = state_0;
                try {
                    return doInt(frameValue, arg0Value_, arg1Value, s2_.valueStore_);
                } catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doInt(VirtualFrame, int, boolean, LLVMI32OffsetStoreNode)] */;
                    state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    this.int_cache = null;
                    return ex.getResult();
                }
            }
            if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationExcluded  */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                LongData s3_ = this.insert(new LongData());
                s3_.valueStore_ = s3_.insert((LLVMI64OffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.long_cache = s3_;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doLong(VirtualFrame, long, boolean, LLVMI64OffsetStoreNode)] */;
                this.state_0_ = state_0;
                try {
                    return doLong(frameValue, arg0Value_, arg1Value, s3_.valueStore_);
                } catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doLong(VirtualFrame, long, boolean, LLVMI64OffsetStoreNode)] */;
                    state_0 = state_0 | 0b100000000 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    this.long_cache = null;
                    return ex.getResult();
                }
            }
            if (((state_0 & 0b10000000000)) == 0 /* is-not SpecializationExcluded  */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                PointerData s4_ = this.insert(new PointerData());
                s4_.valueStore_ = s4_.insert((LLVMPointerOffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s4_;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doPointer(VirtualFrame, LLVMPointer, boolean, LLVMPointerOffsetStoreNode)] */;
                this.state_0_ = state_0;
                try {
                    return doPointer(frameValue, arg0Value_, arg1Value, s4_.valueStore_);
                } catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doPointer(VirtualFrame, LLVMPointer, boolean, LLVMPointerOffsetStoreNode)] */;
                    state_0 = state_0 | 0b10000000000 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    this.pointer_cache = null;
                    return ex.getResult();
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                ByteData s0_ = this.insert(new ByteData());
                s0_.valueStore_ = s0_.insert((LLVMI8OffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.byte_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.valueStore_, 1);
                ((GenerateAOT.Provider) s0_.valueStore_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doByte(VirtualFrame, byte, boolean, LLVMI8OffsetStoreNode)] */;
            }
            {
                ShortData s1_ = this.insert(new ShortData());
                s1_.valueStore_ = s1_.insert((LLVMI16OffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.short_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.valueStore_, 1);
                ((GenerateAOT.Provider) s1_.valueStore_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doShort(VirtualFrame, short, boolean, LLVMI16OffsetStoreNode)] */;
            }
            {
                IntData s2_ = this.insert(new IntData());
                s2_.valueStore_ = s2_.insert((LLVMI32OffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.int_cache = s2_;
                assert NodeUtil.assertRecursion(s2_.valueStore_, 1);
                ((GenerateAOT.Provider) s2_.valueStore_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doInt(VirtualFrame, int, boolean, LLVMI32OffsetStoreNode)] */;
            }
            {
                LongData s3_ = this.insert(new LongData());
                s3_.valueStore_ = s3_.insert((LLVMI64OffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.long_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.valueStore_, 1);
                ((GenerateAOT.Provider) s3_.valueStore_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doLong(VirtualFrame, long, boolean, LLVMI64OffsetStoreNode)] */;
            }
            {
                PointerData s4_ = this.insert(new PointerData());
                s4_.valueStore_ = s4_.insert((LLVMPointerOffsetStoreNode.create()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s4_;
                assert NodeUtil.assertRecursion(s4_.valueStore_, 1);
                ((GenerateAOT.Provider) s4_.valueStore_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMCompareExchangeNode.AllocResultNode.doPointer(VirtualFrame, LLVMPointer, boolean, LLVMPointerOffsetStoreNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.byte_cache = null;
            this.short_cache = null;
            this.int_cache = null;
            this.long_cache = null;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static AllocResultNode create(long secondValueOffset, LLVMExpressionNode resultAllocation) {
            return new AllocResultNodeGen(secondValueOffset, resultAllocation);
        }

        @GeneratedBy(AllocResultNode.class)
        @DenyReplace
        private static final class ByteData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link AllocResultNode#doByte}
             *   Parameter: {@link LLVMI8OffsetStoreNode} valueStore</pre>
             */
            @Child LLVMI8OffsetStoreNode valueStore_;

            ByteData() {
            }

        }
        @GeneratedBy(AllocResultNode.class)
        @DenyReplace
        private static final class ShortData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link AllocResultNode#doShort}
             *   Parameter: {@link LLVMI16OffsetStoreNode} valueStore</pre>
             */
            @Child LLVMI16OffsetStoreNode valueStore_;

            ShortData() {
            }

        }
        @GeneratedBy(AllocResultNode.class)
        @DenyReplace
        private static final class IntData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link AllocResultNode#doInt}
             *   Parameter: {@link LLVMI32OffsetStoreNode} valueStore</pre>
             */
            @Child LLVMI32OffsetStoreNode valueStore_;

            IntData() {
            }

        }
        @GeneratedBy(AllocResultNode.class)
        @DenyReplace
        private static final class LongData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link AllocResultNode#doLong}
             *   Parameter: {@link LLVMI64OffsetStoreNode} valueStore</pre>
             */
            @Child LLVMI64OffsetStoreNode valueStore_;

            LongData() {
            }

        }
        @GeneratedBy(AllocResultNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link AllocResultNode#doPointer}
             *   Parameter: {@link LLVMPointerOffsetStoreNode} valueStore</pre>
             */
            @Child LLVMPointerOffsetStoreNode valueStore_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, byte, byte)}
     *     Activation probability: 0.15909
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, short, short)}
     *     Activation probability: 0.14545
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, int, int)}
     *     Activation probability: 0.13182
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, long, long)}
     *     Activation probability: 0.11818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMNativePointer)}
     *     Activation probability: 0.10455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, byte, byte, LLVMI8LoadNode, LLVMI8StoreNode)}
     *     Activation probability: 0.09091
     *     With/without class size: 6/8 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, short, short, LLVMI16LoadNode, LLVMI16StoreNode)}
     *     Activation probability: 0.07727
     *     With/without class size: 5/8 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, int, int, LLVMI32LoadNode, LLVMI32StoreNode)}
     *     Activation probability: 0.06364
     *     With/without class size: 5/8 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doLong}
     *     Activation probability: 0.05000
     *     With/without class size: 5/8 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doLongGeneric}
     *     Activation probability: 0.03636
     *     With/without class size: 5/12 bytes
     *   Specialization {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)}
     *     Activation probability: 0.02273
     *     With/without class size: 4/12 bytes
     * </pre>
     */
    @GeneratedBy(LLVMCMPXCHInternalNode.class)
    @SuppressWarnings("javadoc")
    static final class LLVMCMPXCHInternalNodeGen extends LLVMCMPXCHInternalNode implements GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, byte, byte)}
         *   2: SpecializationActive {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, short, short)}
         *   3: SpecializationActive {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, int, int)}
         *   4: SpecializationActive {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, long, long)}
         *   5: SpecializationActive {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMNativePointer)}
         *   6: SpecializationActive {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, byte, byte, LLVMI8LoadNode, LLVMI8StoreNode)}
         *   7: SpecializationActive {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, short, short, LLVMI16LoadNode, LLVMI16StoreNode)}
         *   8: SpecializationActive {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, int, int, LLVMI32LoadNode, LLVMI32StoreNode)}
         *   9: SpecializationActive {@link LLVMCMPXCHInternalNode#doLong}
         *   10: SpecializationExcluded {@link LLVMCMPXCHInternalNode#doLong}
         *   11: SpecializationActive {@link LLVMCMPXCHInternalNode#doLongGeneric}
         *   12: SpecializationActive {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private Op5Data op5_cache;
        @Child private Op6Data op6_cache;
        @Child private Op7Data op7_cache;
        @Child private LongData long_cache;
        @Child private LongGenericData longGeneric_cache;
        @Child private Op8Data op8_cache;

        private LLVMCMPXCHInternalNodeGen(AllocResultNode allocResult) {
            super(allocResult);
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 0b1101111111110) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, byte, byte)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, short, short)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, int, int)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, long, long)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, byte, byte, LLVMI8LoadNode, LLVMI8StoreNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, short, short, LLVMI16LoadNode, LLVMI16StoreNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, int, int, LLVMI32LoadNode, LLVMI32StoreNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLong(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLongGeneric(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode, LLVMAddressEqualsNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)] */) {
                if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, byte, byte)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, short, short)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, int, int)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, long, long)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, byte, byte)] */ && arg1Value instanceof Byte) {
                        byte arg1Value_ = (byte) arg1Value;
                        if (arg2Value instanceof Byte) {
                            byte arg2Value_ = (byte) arg2Value;
                            return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, short, short)] */ && arg1Value instanceof Short) {
                        short arg1Value_ = (short) arg1Value;
                        if (arg2Value instanceof Short) {
                            short arg2Value_ = (short) arg2Value;
                            return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, int, int)] */ && arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        if (arg2Value instanceof Integer) {
                            int arg2Value_ = (int) arg2Value;
                            return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, long, long)] */ && arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        if (arg2Value instanceof Long) {
                            long arg2Value_ = (long) arg2Value;
                            return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(arg1Value)) {
                        LLVMNativePointer arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                        if (LLVMTypes.isNativePointer(arg2Value)) {
                            LLVMNativePointer arg2Value_ = LLVMTypes.asNativePointer(arg2Value);
                            return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                        }
                    }
                }
                if ((state_0 & 0b1101111000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, byte, byte, LLVMI8LoadNode, LLVMI8StoreNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, short, short, LLVMI16LoadNode, LLVMI16StoreNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, int, int, LLVMI32LoadNode, LLVMI32StoreNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLong(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLongGeneric(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode, LLVMAddressEqualsNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, byte, byte, LLVMI8LoadNode, LLVMI8StoreNode)] */ && arg1Value instanceof Byte) {
                        byte arg1Value_ = (byte) arg1Value;
                        if (arg2Value instanceof Byte) {
                            byte arg2Value_ = (byte) arg2Value;
                            Op5Data s5_ = this.op5_cache;
                            if (s5_ != null) {
                                return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_, s5_.read_, s5_.write_);
                            }
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, short, short, LLVMI16LoadNode, LLVMI16StoreNode)] */ && arg1Value instanceof Short) {
                        short arg1Value_ = (short) arg1Value;
                        if (arg2Value instanceof Short) {
                            short arg2Value_ = (short) arg2Value;
                            Op6Data s6_ = this.op6_cache;
                            if (s6_ != null) {
                                return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_, s6_.read_, s6_.write_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, int, int, LLVMI32LoadNode, LLVMI32StoreNode)] */ && arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        if (arg2Value instanceof Integer) {
                            int arg2Value_ = (int) arg2Value;
                            Op7Data s7_ = this.op7_cache;
                            if (s7_ != null) {
                                return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_, s7_.read_, s7_.write_);
                            }
                        }
                    }
                    if ((state_0 & 0b101000000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLong(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode)] || SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLongGeneric(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode, LLVMAddressEqualsNode)] */ && arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        if (arg2Value instanceof Long) {
                            long arg2Value_ = (long) arg2Value;
                            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLong(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode)] */) {
                                LongData s8_ = this.long_cache;
                                if (s8_ != null) {
                                    try {
                                        return doLong(frameValue, arg0Value_, arg1Value_, arg2Value_, s8_.read_, s8_.write_);
                                    } catch (RewriteException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLong(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode)] */;
                                        state_0 = state_0 | 0b10000000000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        this.long_cache = null;
                                        return executeAndSpecialize(frameValue, arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLongGeneric(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode, LLVMAddressEqualsNode)] */) {
                                LongGenericData s9_ = this.longGeneric_cache;
                                if (s9_ != null) {
                                    return doLongGeneric(frameValue, arg0Value_, arg1Value_, arg2Value_, s9_.read_, s9_.write_, s9_.cmp_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)] */ && LLVMTypes.isPointer(arg1Value)) {
                        LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                        if (LLVMTypes.isPointer(arg2Value)) {
                            LLVMPointer arg2Value_ = LLVMTypes.asPointer(arg2Value);
                            Op8Data s10_ = this.op8_cache;
                            if (s10_ != null) {
                                return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_, s10_.read_, s10_.write_, s10_.cmp_);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if (arg1Value instanceof Byte) {
                    byte arg1Value_ = (byte) arg1Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (byte) arg2Value;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, byte, byte)] */;
                        this.state_0_ = state_0;
                        return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                    }
                }
                if (arg1Value instanceof Short) {
                    short arg1Value_ = (short) arg1Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (short) arg2Value;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, short, short)] */;
                        this.state_0_ = state_0;
                        return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                    }
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (int) arg2Value;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, int, int)] */;
                        this.state_0_ = state_0;
                        return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                    }
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (long) arg2Value;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, long, long)] */;
                        this.state_0_ = state_0;
                        return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                    }
                }
                if (LLVMTypes.isNativePointer(arg1Value)) {
                    LLVMNativePointer arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                    if (LLVMTypes.isNativePointer(arg2Value)) {
                        LLVMNativePointer arg2Value_ = LLVMTypes.asNativePointer(arg2Value);
                        state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMNativePointer)] */;
                        this.state_0_ = state_0;
                        return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_);
                    }
                }
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Byte) {
                    byte arg1Value_ = (byte) arg1Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (byte) arg2Value;
                        Op5Data s5_ = this.insert(new Op5Data());
                        s5_.read_ = s5_.insert((LLVMI8LoadNode.create()));
                        s5_.write_ = s5_.insert((LLVMI8StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.op5_cache = s5_;
                        state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, byte, byte, LLVMI8LoadNode, LLVMI8StoreNode)] */;
                        this.state_0_ = state_0;
                        return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_, s5_.read_, s5_.write_);
                    }
                }
                if (arg1Value instanceof Short) {
                    short arg1Value_ = (short) arg1Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (short) arg2Value;
                        Op6Data s6_ = this.insert(new Op6Data());
                        s6_.read_ = s6_.insert((LLVMI16LoadNode.create()));
                        s6_.write_ = s6_.insert((LLVMI16StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.op6_cache = s6_;
                        state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, short, short, LLVMI16LoadNode, LLVMI16StoreNode)] */;
                        this.state_0_ = state_0;
                        return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_, s6_.read_, s6_.write_);
                    }
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (int) arg2Value;
                        Op7Data s7_ = this.insert(new Op7Data());
                        s7_.read_ = s7_.insert((LLVMI32LoadNode.create()));
                        s7_.write_ = s7_.insert((LLVMI32StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.op7_cache = s7_;
                        state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, int, int, LLVMI32LoadNode, LLVMI32StoreNode)] */;
                        this.state_0_ = state_0;
                        return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_, s7_.read_, s7_.write_);
                    }
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (long) arg2Value;
                        if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLongGeneric(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode, LLVMAddressEqualsNode)] */ && ((state_0 & 0b10000000000)) == 0 /* is-not SpecializationExcluded  */) {
                            LongData s8_ = this.insert(new LongData());
                            s8_.read_ = s8_.insert((LLVMI64LoadNode.create()));
                            s8_.write_ = s8_.insert((LLVMI64StoreNode.create()));
                            VarHandle.storeStoreFence();
                            this.long_cache = s8_;
                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLong(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode)] */;
                            this.state_0_ = state_0;
                            try {
                                return doLong(frameValue, arg0Value_, arg1Value_, arg2Value_, s8_.read_, s8_.write_);
                            } catch (RewriteException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLong(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode)] */;
                                state_0 = state_0 | 0b10000000000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.long_cache = null;
                                return executeAndSpecialize(frameValue, arg0Value_, arg1Value_, arg2Value_);
                            }
                        }
                        LongGenericData s9_ = this.insert(new LongGenericData());
                        s9_.read_ = s9_.insert((LLVMI64LoadNode.create()));
                        s9_.write_ = s9_.insert((LLVMI64StoreNode.create()));
                        s9_.cmp_ = s9_.insert((LLVMAddressEqualsNode.create()));
                        VarHandle.storeStoreFence();
                        this.longGeneric_cache = s9_;
                        this.long_cache = null;
                        state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLong(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode)] */;
                        state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLongGeneric(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode, LLVMAddressEqualsNode)] */;
                        this.state_0_ = state_0;
                        return doLongGeneric(frameValue, arg0Value_, arg1Value_, arg2Value_, s9_.read_, s9_.write_, s9_.cmp_);
                    }
                }
                if (LLVMTypes.isPointer(arg1Value)) {
                    LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                    if (LLVMTypes.isPointer(arg2Value)) {
                        LLVMPointer arg2Value_ = LLVMTypes.asPointer(arg2Value);
                        Op8Data s10_ = this.insert(new Op8Data());
                        s10_.read_ = s10_.insert((LLVMPointerLoadNode.create()));
                        s10_.write_ = s10_.insert((LLVMPointerStoreNode.create()));
                        s10_.cmp_ = s10_.insert((LLVMAddressEqualsNode.create()));
                        VarHandle.storeStoreFence();
                        this.op8_cache = s10_;
                        state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)] */;
                        this.state_0_ = state_0;
                        return doOp(frameValue, arg0Value_, arg1Value_, arg2Value_, s10_.read_, s10_.write_, s10_.cmp_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, byte, byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, short, short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, int, int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, long, long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMNativePointer)] */;
            }
            {
                Op5Data s5_ = this.insert(new Op5Data());
                s5_.read_ = s5_.insert((LLVMI8LoadNode.create()));
                s5_.write_ = s5_.insert((LLVMI8StoreNode.create()));
                VarHandle.storeStoreFence();
                this.op5_cache = s5_;
                assert NodeUtil.assertRecursion(s5_.read_, 1);
                ((GenerateAOT.Provider) s5_.read_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s5_.write_, 1);
                ((GenerateAOT.Provider) s5_.write_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, byte, byte, LLVMI8LoadNode, LLVMI8StoreNode)] */;
            }
            {
                Op6Data s6_ = this.insert(new Op6Data());
                s6_.read_ = s6_.insert((LLVMI16LoadNode.create()));
                s6_.write_ = s6_.insert((LLVMI16StoreNode.create()));
                VarHandle.storeStoreFence();
                this.op6_cache = s6_;
                assert NodeUtil.assertRecursion(s6_.read_, 1);
                ((GenerateAOT.Provider) s6_.read_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s6_.write_, 1);
                ((GenerateAOT.Provider) s6_.write_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, short, short, LLVMI16LoadNode, LLVMI16StoreNode)] */;
            }
            {
                Op7Data s7_ = this.insert(new Op7Data());
                s7_.read_ = s7_.insert((LLVMI32LoadNode.create()));
                s7_.write_ = s7_.insert((LLVMI32StoreNode.create()));
                VarHandle.storeStoreFence();
                this.op7_cache = s7_;
                assert NodeUtil.assertRecursion(s7_.read_, 1);
                ((GenerateAOT.Provider) s7_.read_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s7_.write_, 1);
                ((GenerateAOT.Provider) s7_.write_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, int, int, LLVMI32LoadNode, LLVMI32StoreNode)] */;
            }
            {
                LongGenericData s9_ = this.insert(new LongGenericData());
                s9_.read_ = s9_.insert((LLVMI64LoadNode.create()));
                s9_.write_ = s9_.insert((LLVMI64StoreNode.create()));
                s9_.cmp_ = s9_.insert((LLVMAddressEqualsNode.create()));
                VarHandle.storeStoreFence();
                this.longGeneric_cache = s9_;
                this.long_cache = null;
                this.state_0_ = state_0_ & 0xfffffdff /* remove SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLong(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode)] */;
                assert NodeUtil.assertRecursion(s9_.read_, 1);
                ((GenerateAOT.Provider) s9_.read_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s9_.write_, 1);
                ((GenerateAOT.Provider) s9_.write_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s9_.cmp_, 1);
                ((GenerateAOT.Provider) s9_.cmp_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doLongGeneric(VirtualFrame, LLVMManagedPointer, long, long, LLVMI64LoadNode, LLVMI64StoreNode, LLVMAddressEqualsNode)] */;
            }
            {
                Op8Data s10_ = this.insert(new Op8Data());
                s10_.read_ = s10_.insert((LLVMPointerLoadNode.create()));
                s10_.write_ = s10_.insert((LLVMPointerStoreNode.create()));
                s10_.cmp_ = s10_.insert((LLVMAddressEqualsNode.create()));
                VarHandle.storeStoreFence();
                this.op8_cache = s10_;
                assert NodeUtil.assertRecursion(s10_.read_, 1);
                ((GenerateAOT.Provider) s10_.read_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s10_.write_, 1);
                ((GenerateAOT.Provider) s10_.write_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s10_.cmp_, 1);
                ((GenerateAOT.Provider) s10_.cmp_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.op5_cache = null;
            this.op6_cache = null;
            this.op7_cache = null;
            this.longGeneric_cache = null;
            this.op8_cache = null;
        }

        @NeverDefault
        public static LLVMCMPXCHInternalNode create(AllocResultNode allocResult) {
            return new LLVMCMPXCHInternalNodeGen(allocResult);
        }

        @GeneratedBy(LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class Op5Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, byte, byte, LLVMI8LoadNode, LLVMI8StoreNode)}
             *   Parameter: {@link LLVMI8LoadNode} read</pre>
             */
            @Child LLVMI8LoadNode read_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, byte, byte, LLVMI8LoadNode, LLVMI8StoreNode)}
             *   Parameter: {@link LLVMI8StoreNode} write</pre>
             */
            @Child LLVMI8StoreNode write_;

            Op5Data() {
            }

        }
        @GeneratedBy(LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class Op6Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, short, short, LLVMI16LoadNode, LLVMI16StoreNode)}
             *   Parameter: {@link LLVMI16LoadNode} read</pre>
             */
            @Child LLVMI16LoadNode read_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, short, short, LLVMI16LoadNode, LLVMI16StoreNode)}
             *   Parameter: {@link LLVMI16StoreNode} write</pre>
             */
            @Child LLVMI16StoreNode write_;

            Op6Data() {
            }

        }
        @GeneratedBy(LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class Op7Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, int, int, LLVMI32LoadNode, LLVMI32StoreNode)}
             *   Parameter: {@link LLVMI32LoadNode} read</pre>
             */
            @Child LLVMI32LoadNode read_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, int, int, LLVMI32LoadNode, LLVMI32StoreNode)}
             *   Parameter: {@link LLVMI32StoreNode} write</pre>
             */
            @Child LLVMI32StoreNode write_;

            Op7Data() {
            }

        }
        @GeneratedBy(LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class LongData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doLong}
             *   Parameter: {@link LLVMI64LoadNode} read</pre>
             */
            @Child LLVMI64LoadNode read_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doLong}
             *   Parameter: {@link LLVMI64StoreNode} write</pre>
             */
            @Child LLVMI64StoreNode write_;

            LongData() {
            }

        }
        @GeneratedBy(LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class LongGenericData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doLongGeneric}
             *   Parameter: {@link LLVMI64LoadNode} read</pre>
             */
            @Child LLVMI64LoadNode read_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doLongGeneric}
             *   Parameter: {@link LLVMI64StoreNode} write</pre>
             */
            @Child LLVMI64StoreNode write_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doLongGeneric}
             *   Parameter: {@link LLVMAddressEqualsNode} cmp</pre>
             */
            @Child LLVMAddressEqualsNode cmp_;

            LongGenericData() {
            }

        }
        @GeneratedBy(LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class Op8Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)}
             *   Parameter: {@link LLVMPointerLoadNode} read</pre>
             */
            @Child LLVMPointerLoadNode read_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)}
             *   Parameter: {@link LLVMPointerStoreNode} write</pre>
             */
            @Child LLVMPointerStoreNode write_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMCMPXCHInternalNode#doOp(VirtualFrame, LLVMManagedPointer, LLVMPointer, LLVMPointer, LLVMPointerLoadNode, LLVMPointerStoreNode, LLVMAddressEqualsNode)}
             *   Parameter: {@link LLVMAddressEqualsNode} cmp</pre>
             */
            @Child LLVMAddressEqualsNode cmp_;

            Op8Data() {
            }

        }
    }
}
