// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMI8ArrayLiteralNode#foreignWrite}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMI8ArrayLiteralNode.class)
@SuppressWarnings("javadoc")
public final class LLVMI8ArrayLiteralNodeGen extends LLVMI8ArrayLiteralNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMI8ArrayLiteralNode#foreignWrite}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMI8ArrayLiteralNodeGen(byte[] values, LLVMExpressionNode address) {
        super(values);
        this.address_ = address;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI8ArrayLiteralNode.foreignWrite(LLVMPointer)] */ && LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return foreignWrite(addressValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    private LLVMPointer executeAndSpecialize(Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI8ArrayLiteralNode.foreignWrite(LLVMPointer)] */;
            this.state_0_ = state_0;
            return foreignWrite(addressValue_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI8ArrayLiteralNode.foreignWrite(LLVMPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMI8ArrayLiteralNode create(byte[] values, LLVMExpressionNode address) {
        return new LLVMI8ArrayLiteralNodeGen(values, address);
    }

}
