// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMStructLoadNode#doPointer}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMStructLoadNode.class)
@SuppressWarnings("javadoc")
public final class LLVMStructLoadNodeGen extends LLVMStructLoadNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMStructLoadNode#doPointer}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMStructLoadNodeGen(LLVMExpressionNode address) {
        this.address_ = address;
    }

    @Override
    public Object executeWithTargetGeneric(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStructLoadNode.doPointer(LLVMPointer)] */ && LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            return doPointer(addressValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStructLoadNode.doPointer(LLVMPointer)] */ && LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return doPointer(addressValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    private LLVMPointer executeAndSpecialize(Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMStructLoadNode.doPointer(LLVMPointer)] */;
            this.state_0_ = state_0;
            return doPointer(addressValue_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMStructLoadNode.doPointer(LLVMPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMStructLoadNode create(LLVMExpressionNode address) {
        return new LLVMStructLoadNodeGen(address);
    }

}
