// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVM128BitFloatStoreNode#doOp}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link LLVM128BitFloatStoreNode#doOpDerefHandle}
 *     Activation probability: 0.33333
 *     With/without class size: 12/8 bytes
 *   Specialization {@link LLVM128BitFloatStoreNode#doForeign}
 *     Activation probability: 0.18333
 *     With/without class size: 7/4 bytes
 * </pre>
 */
@GeneratedBy(LLVM128BitFloatStoreNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVM128BitFloatStoreNodeGen extends LLVM128BitFloatStoreNode implements GenerateAOT.Provider {

    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVM128BitFloatStoreNode#doOp}
     *   2: SpecializationActive {@link LLVM128BitFloatStoreNode#doOpDerefHandle}
     *   3: SpecializationActive {@link LLVM128BitFloatStoreNode#doForeign}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private OpDerefHandleData opDerefHandle_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVM128BitFloatStoreNode#doForeign}
     *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
     */
    @Child private LLVMManagedWriteLibrary foreign_nativeWrite_;

    private LLVM128BitFloatStoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    private LLVM128BitFloatStoreNodeGen(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value) {
        super(isRecursive);
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    public void executeWithTarget(VirtualFrame frameValue, Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] || SpecializationActive[LLVM128BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVM128BitFloat) {
            LLVM128BitFloat valueValue_ = (LLVM128BitFloat) valueValue;
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doOp(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] */) {
                    OpDerefHandleData s1_ = this.opDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue_))) {
                            LLVM128BitFloatStoreNode.doOpDerefHandle(addressValue_, valueValue_, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                {
                    LLVMManagedWriteLibrary nativeWrite__ = this.foreign_nativeWrite_;
                    if (nativeWrite__ != null) {
                        LLVM128BitFloatStoreNode.doForeign(addressValue_, valueValue_, nativeWrite__);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @Override
    public void executeWithTarget(LLVMPointer addressValue, LLVM128BitFloat valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] || SpecializationActive[LLVM128BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM128BitFloat, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doOp(addressValue_, valueValue);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] */) {
                    OpDerefHandleData s1_ = this.opDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue_))) {
                            LLVM128BitFloatStoreNode.doOpDerefHandle(addressValue_, valueValue, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                {
                    LLVMManagedWriteLibrary nativeWrite__ = this.foreign_nativeWrite_;
                    if (nativeWrite__ != null) {
                        LLVM128BitFloatStoreNode.doForeign(addressValue_, valueValue, nativeWrite__);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] || SpecializationActive[LLVM128BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVM128BitFloat) {
            LLVM128BitFloat valueValue__ = (LLVM128BitFloat) valueValue_;
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        doOp(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] */) {
                    OpDerefHandleData s1_ = this.opDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue__))) {
                            LLVM128BitFloatStoreNode.doOpDerefHandle(addressValue__, valueValue__, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                {
                    LLVMManagedWriteLibrary nativeWrite__ = this.foreign_nativeWrite_;
                    if (nativeWrite__ != null) {
                        LLVM128BitFloatStoreNode.doForeign(addressValue__, valueValue__, nativeWrite__);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue_, valueValue_);
        return;
    }

    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (valueValue instanceof LLVM128BitFloat) {
            LLVM128BitFloat valueValue_ = (LLVM128BitFloat) valueValue;
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] */;
                    this.state_0_ = state_0;
                    doOp(addressValue_, valueValue_);
                    return;
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.store_ = s1_.insert((LLVM128BitFloatStoreNode.createRecursive()));
                    VarHandle.storeStoreFence();
                    this.opDerefHandle_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] */;
                    this.state_0_ = state_0;
                    LLVM128BitFloatStoreNode.doOpDerefHandle(addressValue_, valueValue_, getReceiver__, s1_.store_);
                    return;
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.foreign_nativeWrite_ = nativeWrite__;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVM128BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM128BitFloat, LLVMManagedWriteLibrary)] */;
                this.state_0_ = state_0;
                LLVM128BitFloatStoreNode.doForeign(addressValue_, valueValue_, nativeWrite__);
                return;
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.value_}, addressValue, valueValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVM128BitFloatStoreNode.doOp(LLVMNativePointer, LLVM128BitFloat)] */;
        }
        {
            if ((!(isRecursive))) {
                OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.getReceiver_ = getReceiver__;
                s1_.store_ = s1_.insert((LLVM128BitFloatStoreNode.createRecursive()));
                VarHandle.storeStoreFence();
                this.opDerefHandle_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.store_, 1);
                ((GenerateAOT.Provider) s1_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVM128BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatStoreNode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.opDerefHandle_cache = null;
    }

    @NeverDefault
    public static LLVM128BitFloatStoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVM128BitFloatStoreNodeGen(address, value);
    }

    @NeverDefault
    public static LLVM128BitFloatStoreNode create(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVM128BitFloatStoreNodeGen(isRecursive, address, value);
    }

    @GeneratedBy(LLVM128BitFloatStoreNode.class)
    @DenyReplace
    private static final class OpDerefHandleData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM128BitFloatStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child LLVMDerefHandleGetReceiverNode getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM128BitFloatStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVM128BitFloatStoreNode} store</pre>
         */
        @Child LLVM128BitFloatStoreNode store_;

        OpDerefHandleData() {
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVM128BitFloatOffsetStoreNode#doOp}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVM128BitFloatOffsetStoreNode#doOpDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVM128BitFloatOffsetStoreNode#doOpManaged}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVM128BitFloatOffsetStoreNode#doOpManaged}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVM128BitFloatOffsetStoreNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVM128BitFloatOffsetStoreNodeGen extends LLVM128BitFloatOffsetStoreNode implements GenerateAOT.Provider {

        static final ReferenceField<OpManaged0Data> OP_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "opManaged0_cache", OpManaged0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private LLVMExpressionNode target_;
        @Child private LLVMExpressionNode offset_;
        @Child private LLVMExpressionNode value_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVM128BitFloatOffsetStoreNode#doOp}
         *   2: SpecializationActive {@link LLVM128BitFloatOffsetStoreNode#doOpDerefHandle}
         *   3: SpecializationActive {@link LLVM128BitFloatOffsetStoreNode#doOpManaged}
         *   4: SpecializationActive {@link LLVM128BitFloatOffsetStoreNode#doOpManaged}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM128BitFloatOffsetStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode opDerefHandle_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM128BitFloatOffsetStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child private LLVMManagedWriteLibrary opDerefHandle_nativeWrite_;
        @UnsafeAccessedField @Child private OpManaged0Data opManaged0_cache;

        private LLVM128BitFloatOffsetStoreNodeGen(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        @ExplodeLoop
        @Override
        public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat valueValue_ = (LLVM128BitFloat) valueValue;
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s2_ = this.opManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, s2_.nativeWrite_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary(state_0, targetValue_, offsetValue, valueValue_);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary(int state_0, LLVMManagedPointer targetValue_, long offsetValue, LLVM128BitFloat valueValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, nativeWrite__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public void executeWithTarget(LLVMPointer targetValue, long offsetValue, LLVM128BitFloat valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s2_ = this.opManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, s2_.nativeWrite_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary0(state_0, targetValue_, offsetValue, valueValue);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary0(int state_0, LLVMManagedPointer targetValue_, long offsetValue, LLVM128BitFloat valueValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, nativeWrite__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = this.state_0_;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue_);
                return;
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVM128BitFloat) {
                LLVM128BitFloat valueValue__ = (LLVM128BitFloat) valueValue_;
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue__);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue__, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s2_ = this.opManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue__, s2_.nativeWrite_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary1(state_0, targetValue_, offsetValue, valueValue__);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary1(int state_0, LLVMManagedPointer targetValue_, long offsetValue, LLVM128BitFloat valueValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue__, nativeWrite__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object targetValue, Object offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (long) offsetValue;
                if (valueValue instanceof LLVM128BitFloat) {
                    LLVM128BitFloat valueValue_ = (LLVM128BitFloat) valueValue;
                    if (LLVMTypes.isNativePointer(targetValue)) {
                        LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] */;
                            this.state_0_ = state_0;
                            doOp(targetValue_, offsetValue_, valueValue_);
                            return;
                        }
                        if ((isAutoDerefHandle(targetValue_))) {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                            Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.opDerefHandle_getReceiver_ = getReceiver__;
                            LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                            Objects.requireNonNull(nativeWrite__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.opDerefHandle_nativeWrite_ = nativeWrite__;
                            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue_, valueValue_, getReceiver__, nativeWrite__);
                            return;
                        }
                    }
                    if (LLVMTypes.isManagedPointer(targetValue)) {
                        LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */) {
                            while (true) {
                                int count2_ = 0;
                                OpManaged0Data s2_ = OP_MANAGED0_CACHE_UPDATER.getVolatile(this);
                                OpManaged0Data s2_original = s2_;
                                while (s2_ != null) {
                                    if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                        break;
                                    }
                                    count2_++;
                                    s2_ = s2_.next_;
                                }
                                if (s2_ == null) {
                                    // assert (s2_.nativeWrite_.accepts(targetValue_.getObject()));
                                    if (count2_ < (3)) {
                                        s2_ = this.insert(new OpManaged0Data(s2_original));
                                        LLVMManagedWriteLibrary nativeWrite__1 = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(targetValue_.getObject())));
                                        Objects.requireNonNull(nativeWrite__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s2_.nativeWrite_ = nativeWrite__1;
                                        if (!OP_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s2_ != null) {
                                    LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue_, valueValue_, s2_.nativeWrite_);
                                    return;
                                }
                                break;
                            }
                        }
                        {
                            LLVMManagedWriteLibrary nativeWrite__1 = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                                    this.opManaged0_cache = null;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM128BitFloat, LLVMManagedWriteLibrary)] */;
                                    this.state_0_ = state_0;
                                    LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue_, valueValue_, nativeWrite__1);
                                    return;
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.target_, this.offset_, this.value_}, targetValue, offsetValue, valueValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM128BitFloat)] */;
            }
            {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.opDerefHandle_getReceiver_ = getReceiver__;
                LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.opDerefHandle_nativeWrite_ = nativeWrite__;
                assert NodeUtil.assertRecursion(this.opDerefHandle_getReceiver_, 1);
                ((GenerateAOT.Provider) this.opDerefHandle_getReceiver_).prepareForAOT(language, root);
                if (this.opDerefHandle_nativeWrite_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.opDerefHandle_nativeWrite_, 1);
                    ((GenerateAOT.Provider) this.opDerefHandle_nativeWrite_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVM128BitFloatStoreNode.LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM128BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.opDerefHandle_getReceiver_ = null;
            this.opDerefHandle_nativeWrite_ = null;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException3LJL(Node thisNode_, Object targetValue, long offsetValue, Object valueValue) {
            return new UnsupportedSpecializationException(thisNode_, null, targetValue, offsetValue, valueValue);
        }

        @NeverDefault
        public static LLVM128BitFloatOffsetStoreNode create(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVM128BitFloatOffsetStoreNodeGen(target, offset, value);
        }

        @NeverDefault
        public static LLVM128BitFloatOffsetStoreNode getUncached() {
            return LLVM128BitFloatOffsetStoreNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVM128BitFloatOffsetStoreNode.class)
        @DenyReplace
        private static final class OpManaged0Data extends Node implements SpecializationDataNode {

            @Child OpManaged0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVM128BitFloatOffsetStoreNode#doOpManaged}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            OpManaged0Data(OpManaged0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LLVM128BitFloatOffsetStoreNode.class)
        @DenyReplace
        private static final class Uncached extends LLVM128BitFloatOffsetStoreNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
                if (valueValue instanceof LLVM128BitFloat) {
                    LLVM128BitFloat valueValue_ = (LLVM128BitFloat) valueValue;
                    if (LLVMTypes.isNativePointer(targetValue)) {
                        LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                        if ((isAutoDerefHandle(targetValue_))) {
                            LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                            return;
                        }
                    }
                    if (LLVMTypes.isManagedPointer(targetValue)) {
                        LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                        LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject())));
                        return;
                    }
                }
                throw newUnsupportedSpecializationException3LJL(this, targetValue, offsetValue, valueValue);
            }

            @TruffleBoundary
            @Override
            public void executeWithTarget(LLVMPointer targetValue, long offsetValue, LLVM128BitFloat valueValue) {
                if (LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        doOp(targetValue_, offsetValue, valueValue);
                        return;
                    }
                    if ((isAutoDerefHandle(targetValue_))) {
                        LLVM128BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    LLVM128BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject())));
                    return;
                }
                throw newUnsupportedSpecializationException3LJL(this, targetValue, offsetValue, valueValue);
            }

            @Override
            public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
                throw CompilerDirectives.shouldNotReachHere("This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
            }

        }
    }
}
