// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMOffsetStoreNode.class)
@SuppressWarnings("javadoc")
public final class LLVMOffsetStoreNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMGenericOffsetStoreNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMGenericOffsetStoreNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMGenericOffsetStoreNodeGen extends LLVMGenericOffsetStoreNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode target_;
        @Child private LLVMExpressionNode offset_;
        @Child private LLVMExpressionNode value_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMGenericOffsetStoreNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMGenericOffsetStoreNodeGen(LLVMStoreNode store, LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            super(store);
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = this.state_0_;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, targetValue, offsetValue, valueValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode.doOp(VirtualFrame, LLVMPointer, long, Object)] */) {
                doOp(frameValue, targetValue, offsetValue, valueValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, targetValue, offsetValue, valueValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object targetValue, Object offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(targetValue)) {
                LLVMPointer targetValue_ = LLVMTypes.asPointer(targetValue);
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (long) offsetValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode.doOp(VirtualFrame, LLVMPointer, long, Object)] */;
                    this.state_0_ = state_0;
                    doOp(frameValue, targetValue_, offsetValue_, valueValue);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.target_, this.offset_, this.value_}, targetValue, offsetValue, valueValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode.doOp(VirtualFrame, LLVMPointer, long, Object)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMGenericOffsetStoreNode create(LLVMStoreNode store, LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVMGenericOffsetStoreNodeGen(store, target, offset, value);
        }

    }
}
