// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMStructStoreNode#noCopy}
 *     Activation probability: 0.27381
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMStructStoreNode#doOp}
 *     Activation probability: 0.23095
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMStructStoreNode#doOpDerefHandle}
 *     Activation probability: 0.18810
 *     With/without class size: 7/4 bytes
 *   Specialization {@link LLVMStructStoreNode#doManaged}
 *     Activation probability: 0.14524
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMStructStoreNode#doConvert}
 *     Activation probability: 0.10238
 *     With/without class size: 6/4 bytes
 *   Specialization {@link LLVMStructStoreNode#doVarArgCompoundValue}
 *     Activation probability: 0.05952
 *     With/without class size: 5/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMStructStoreNode.class)
@SuppressWarnings("javadoc")
public final class LLVMStructStoreNodeGen extends LLVMStructStoreNode implements GenerateAOT.Provider {

    private final long structSize;
    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMStructStoreNode#noCopy}
     *   2: SpecializationActive {@link LLVMStructStoreNode#doOp}
     *   3: SpecializationActive {@link LLVMStructStoreNode#doConvert}
     *   4: SpecializationActive {@link LLVMStructStoreNode#doOpDerefHandle}
     *   5: SpecializationActive {@link LLVMStructStoreNode#doManaged}
     *   6: SpecializationActive {@link LLVMStructStoreNode#doVarArgCompoundValue}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMStructStoreNode#doOpDerefHandle}
     *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
     */
    @Child private LLVMDerefHandleGetReceiverNode opDerefHandle_getReceiver_;
    @Child private ConvertData convert_cache;
    @Child private VarArgCompoundValueData varArgCompoundValue_cache;

    private LLVMStructStoreNodeGen(LLVMMemMoveNode memMove, boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        super(memMove, isRecursive);
        this.structSize = structSize;
        this.address_ = address;
        this.value_ = value;
    }

    private LLVMStructStoreNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        super(memMove);
        this.structSize = structSize;
        this.address_ = address;
        this.value_ = value;
    }

    private LLVMStructStoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        this.structSize = structSize;
        this.address_ = address;
        this.value_ = value;
    }

    private LLVMStructStoreNodeGen(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        super(isRecursive);
        this.structSize = structSize;
        this.address_ = address;
        this.value_ = value;
    }

    @Idempotent
    @Override
    public long getStructSize() {
        return this.structSize;
    }

    @Override
    public void executeWithTarget(VirtualFrame frameValue, Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMStructStoreNode.noCopy(Object, Object)] || SpecializationActive[LLVMStructStoreNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMStructStoreNode.doOpDerefHandle(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)] || SpecializationActive[LLVMStructStoreNode.doManaged(VirtualFrame, LLVMManagedPointer, LLVMPointer)] || SpecializationActive[LLVMStructStoreNode.doConvert(VirtualFrame, LLVMNativePointer, LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMStructStoreNode.doVarArgCompoundValue(VirtualFrame, LLVMNativePointer, LLVMVarArgCompoundValue, LLVMStructStoreNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStructStoreNode.noCopy(Object, Object)] */) {
                assert DSLSupport.assertIdempotence((getStructSize() == 0));
                noCopy(addressValue, valueValue);
                return;
            }
            if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMStructStoreNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMStructStoreNode.doOpDerefHandle(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if (LLVMTypes.isNativePointer(valueValue)) {
                    LLVMNativePointer valueValue_ = LLVMTypes.asNativePointer(valueValue);
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMStructStoreNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer)] */) {
                        assert DSLSupport.assertIdempotence((getStructSize() > 0));
                        if ((!(isAutoDerefHandle(addressValue_))) && (!(isAutoDerefHandle(valueValue_)))) {
                            doOp(frameValue, addressValue_, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doOpDerefHandle(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                assert DSLSupport.assertIdempotence((getStructSize() > 0));
                                if ((isAutoDerefHandle(addressValue_)) && (isAutoDerefHandle(valueValue_))) {
                                    doOpDerefHandle(frameValue, addressValue_, valueValue_, getReceiver__);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doManaged(VirtualFrame, LLVMManagedPointer, LLVMPointer)] || SpecializationActive[LLVMStructStoreNode.doConvert(VirtualFrame, LLVMNativePointer, LLVMPointer, LLVMToNativeNode)] */ && LLVMTypes.isPointer(valueValue)) {
                LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doManaged(VirtualFrame, LLVMManagedPointer, LLVMPointer)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    assert DSLSupport.assertIdempotence((getStructSize() > 0));
                    doManaged(frameValue, addressValue_, valueValue_);
                    return;
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doConvert(VirtualFrame, LLVMNativePointer, LLVMPointer, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    ConvertData s4_ = this.convert_cache;
                    if (s4_ != null) {
                        assert DSLSupport.assertIdempotence((getStructSize() > 0));
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            doConvert(frameValue, addressValue_, valueValue_, s4_.toNative_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doVarArgCompoundValue(VirtualFrame, LLVMNativePointer, LLVMVarArgCompoundValue, LLVMStructStoreNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if (valueValue instanceof LLVMVarArgCompoundValue) {
                    LLVMVarArgCompoundValue valueValue_ = (LLVMVarArgCompoundValue) valueValue;
                    VarArgCompoundValueData s5_ = this.varArgCompoundValue_cache;
                    if (s5_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        doVarArgCompoundValue(frameValue, addressValue_, valueValue_, s5_.recursionNode_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(frameValue, addressValue, valueValue);
        return;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMStructStoreNode.noCopy(Object, Object)] || SpecializationActive[LLVMStructStoreNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMStructStoreNode.doOpDerefHandle(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)] || SpecializationActive[LLVMStructStoreNode.doManaged(VirtualFrame, LLVMManagedPointer, LLVMPointer)] || SpecializationActive[LLVMStructStoreNode.doConvert(VirtualFrame, LLVMNativePointer, LLVMPointer, LLVMToNativeNode)] || SpecializationActive[LLVMStructStoreNode.doVarArgCompoundValue(VirtualFrame, LLVMNativePointer, LLVMVarArgCompoundValue, LLVMStructStoreNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStructStoreNode.noCopy(Object, Object)] */) {
                assert DSLSupport.assertIdempotence((getStructSize() == 0));
                noCopy(addressValue_, valueValue_);
                return;
            }
            if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMStructStoreNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMStructStoreNode.doOpDerefHandle(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if (LLVMTypes.isNativePointer(valueValue_)) {
                    LLVMNativePointer valueValue__ = LLVMTypes.asNativePointer(valueValue_);
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMStructStoreNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer)] */) {
                        assert DSLSupport.assertIdempotence((getStructSize() > 0));
                        if ((!(isAutoDerefHandle(addressValue__))) && (!(isAutoDerefHandle(valueValue__)))) {
                            doOp(frameValue, addressValue__, valueValue__);
                            return;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doOpDerefHandle(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                assert DSLSupport.assertIdempotence((getStructSize() > 0));
                                if ((isAutoDerefHandle(addressValue__)) && (isAutoDerefHandle(valueValue__))) {
                                    doOpDerefHandle(frameValue, addressValue__, valueValue__, getReceiver__);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doManaged(VirtualFrame, LLVMManagedPointer, LLVMPointer)] || SpecializationActive[LLVMStructStoreNode.doConvert(VirtualFrame, LLVMNativePointer, LLVMPointer, LLVMToNativeNode)] */ && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doManaged(VirtualFrame, LLVMManagedPointer, LLVMPointer)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                    LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                    assert DSLSupport.assertIdempotence((getStructSize() > 0));
                    doManaged(frameValue, addressValue__, valueValue__);
                    return;
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doConvert(VirtualFrame, LLVMNativePointer, LLVMPointer, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                    LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                    ConvertData s4_ = this.convert_cache;
                    if (s4_ != null) {
                        assert DSLSupport.assertIdempotence((getStructSize() > 0));
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            doConvert(frameValue, addressValue__, valueValue__, s4_.toNative_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMStructStoreNode.doVarArgCompoundValue(VirtualFrame, LLVMNativePointer, LLVMVarArgCompoundValue, LLVMStructStoreNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if (valueValue_ instanceof LLVMVarArgCompoundValue) {
                    LLVMVarArgCompoundValue valueValue__ = (LLVMVarArgCompoundValue) valueValue_;
                    VarArgCompoundValueData s5_ = this.varArgCompoundValue_cache;
                    if (s5_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        doVarArgCompoundValue(frameValue, addressValue__, valueValue__, s5_.recursionNode_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(frameValue, addressValue_, valueValue_);
        return;
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((getStructSize() == 0)) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMStructStoreNode.noCopy(Object, Object)] */;
            this.state_0_ = state_0;
            noCopy(addressValue, valueValue);
            return;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if (LLVMTypes.isNativePointer(valueValue)) {
                LLVMNativePointer valueValue_ = LLVMTypes.asNativePointer(valueValue);
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMStructStoreNode.doConvert(VirtualFrame, LLVMNativePointer, LLVMPointer, LLVMToNativeNode)] */) {
                    if ((getStructSize() > 0) && (!(isAutoDerefHandle(addressValue_))) && (!(isAutoDerefHandle(valueValue_)))) {
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMStructStoreNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer)] */;
                        this.state_0_ = state_0;
                        doOp(frameValue, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((getStructSize() > 0) && (isAutoDerefHandle(addressValue_)) && (isAutoDerefHandle(valueValue_))) {
                    LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.opDerefHandle_getReceiver_ = getReceiver__;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMStructStoreNode.doOpDerefHandle(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)] */;
                    this.state_0_ = state_0;
                    doOpDerefHandle(frameValue, addressValue_, valueValue_, getReceiver__);
                    return;
                }
            }
        }
        if (LLVMTypes.isPointer(valueValue)) {
            LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((getStructSize() > 0)) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMStructStoreNode.doManaged(VirtualFrame, LLVMManagedPointer, LLVMPointer)] */;
                    this.state_0_ = state_0;
                    doManaged(frameValue, addressValue_, valueValue_);
                    return;
                }
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((getStructSize() > 0) && (!(isAutoDerefHandle(addressValue_)))) {
                    ConvertData s4_ = this.insert(new ConvertData());
                    s4_.toNative_ = s4_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    VarHandle.storeStoreFence();
                    this.convert_cache = s4_;
                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMStructStoreNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer)] */;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMStructStoreNode.doConvert(VirtualFrame, LLVMNativePointer, LLVMPointer, LLVMToNativeNode)] */;
                    this.state_0_ = state_0;
                    doConvert(frameValue, addressValue_, valueValue_, s4_.toNative_);
                    return;
                }
            }
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if (valueValue instanceof LLVMVarArgCompoundValue) {
                LLVMVarArgCompoundValue valueValue_ = (LLVMVarArgCompoundValue) valueValue;
                if ((!(isRecursive))) {
                    VarArgCompoundValueData s5_ = this.insert(new VarArgCompoundValueData());
                    s5_.recursionNode_ = s5_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.varArgCompoundValue_cache = s5_;
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMStructStoreNode.doVarArgCompoundValue(VirtualFrame, LLVMNativePointer, LLVMVarArgCompoundValue, LLVMStructStoreNode)] */;
                    this.state_0_ = state_0;
                    doVarArgCompoundValue(frameValue, addressValue_, valueValue_, s5_.recursionNode_);
                    return;
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.value_}, addressValue, valueValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            if ((getStructSize() == 0)) {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMStructStoreNode.noCopy(Object, Object)] */;
            }
        }
        {
            if ((getStructSize() > 0)) {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.opDerefHandle_getReceiver_ = getReceiver__;
                assert NodeUtil.assertRecursion(this.opDerefHandle_getReceiver_, 1);
                ((GenerateAOT.Provider) this.opDerefHandle_getReceiver_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMStructStoreNode.doOpDerefHandle(VirtualFrame, LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)] */;
            }
        }
        {
            if ((getStructSize() > 0)) {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMStructStoreNode.doManaged(VirtualFrame, LLVMManagedPointer, LLVMPointer)] */;
            }
        }
        {
            if ((getStructSize() > 0)) {
                ConvertData s4_ = this.insert(new ConvertData());
                s4_.toNative_ = s4_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.convert_cache = s4_;
                this.state_0_ = state_0_ & 0xfffffffb /* remove SpecializationActive[LLVMStructStoreNode.doOp(VirtualFrame, LLVMNativePointer, LLVMNativePointer)] */;
                assert NodeUtil.assertRecursion(s4_.toNative_, 1);
                ((GenerateAOT.Provider) s4_.toNative_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMStructStoreNode.doConvert(VirtualFrame, LLVMNativePointer, LLVMPointer, LLVMToNativeNode)] */;
            }
        }
        {
            if ((!(isRecursive))) {
                VarArgCompoundValueData s5_ = this.insert(new VarArgCompoundValueData());
                s5_.recursionNode_ = s5_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.varArgCompoundValue_cache = s5_;
                assert NodeUtil.assertRecursion(s5_.recursionNode_, 1);
                ((GenerateAOT.Provider) s5_.recursionNode_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMStructStoreNode.doVarArgCompoundValue(VirtualFrame, LLVMNativePointer, LLVMVarArgCompoundValue, LLVMStructStoreNode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.opDerefHandle_getReceiver_ = null;
        this.convert_cache = null;
        this.varArgCompoundValue_cache = null;
    }

    @NeverDefault
    public static LLVMStructStoreNode create(LLVMMemMoveNode memMove, boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        return new LLVMStructStoreNodeGen(memMove, isRecursive, address, value, structSize);
    }

    @NeverDefault
    public static LLVMStructStoreNode create(LLVMMemMoveNode memMove, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        return new LLVMStructStoreNodeGen(memMove, address, value, structSize);
    }

    @NeverDefault
    public static LLVMStructStoreNode create(LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        return new LLVMStructStoreNodeGen(address, value, structSize);
    }

    @NeverDefault
    public static LLVMStructStoreNode create(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        return new LLVMStructStoreNodeGen(isRecursive, address, value, structSize);
    }

    @GeneratedBy(LLVMStructStoreNode.class)
    @DenyReplace
    private static final class ConvertData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStructStoreNode#doConvert}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;

        ConvertData() {
        }

    }
    @GeneratedBy(LLVMStructStoreNode.class)
    @DenyReplace
    private static final class VarArgCompoundValueData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStructStoreNode#doVarArgCompoundValue}
         *   Parameter: {@link LLVMStructStoreNode} recursionNode</pre>
         */
        @Child LLVMStructStoreNode recursionNode_;

        VarArgCompoundValueData() {
        }

    }
}
