// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.AsPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.IsPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.AsPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.IsPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue.ManagedToComparableValue;
import com.oracle.truffle.llvm.runtime.nodes.util.LLVMSameObjectNode;
import com.oracle.truffle.llvm.runtime.nodes.util.LLVMSameObjectNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPointerCompareNode#doCompare(long, long)}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMPointerCompareNode#doCompare(LLVMNativePointer, LLVMNativePointer)}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMPointerCompareNode#doPointerPointer}
 *     Activation probability: 0.20000
 *     With/without class size: 11/16 bytes
 *   Specialization {@link LLVMPointerCompareNode#doPointerPointerException}
 *     Activation probability: 0.14000
 *     With/without class size: 9/20 bytes
 *   Specialization {@link LLVMPointerCompareNode#doOther}
 *     Activation probability: 0.08000
 *     With/without class size: 7/20 bytes
 * </pre>
 */
@GeneratedBy(LLVMPointerCompareNode.class)
@SuppressWarnings("javadoc")
public final class LLVMPointerCompareNodeGen extends LLVMPointerCompareNode implements GenerateAOT.Provider {

    static final ReferenceField<PointerPointerData> POINTER_POINTER_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "pointerPointer_cache", PointerPointerData.class);
    static final ReferenceField<PointerPointerExceptionData> POINTER_POINTER_EXCEPTION_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "pointerPointerException_cache", PointerPointerExceptionData.class);
    static final ReferenceField<OtherData> OTHER_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "other_cache", OtherData.class);

    @Child private LLVMExpressionNode child0_;
    @Child private LLVMExpressionNode child1_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPointerCompareNode#doCompare(long, long)}
     *   2: SpecializationActive {@link LLVMPointerCompareNode#doCompare(LLVMNativePointer, LLVMNativePointer)}
     *   3: SpecializationActive {@link LLVMPointerCompareNode#doPointerPointer}
     *   4: SpecializationExcluded {@link LLVMPointerCompareNode#doPointerPointer}
     *   5: SpecializationActive {@link LLVMPointerCompareNode#doPointerPointerException}
     *   6: SpecializationActive {@link LLVMPointerCompareNode#doOther}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private PointerPointerData pointerPointer_cache;
    @UnsafeAccessedField @Child private PointerPointerExceptionData pointerPointerException_cache;
    @UnsafeAccessedField @Child private OtherData other_cache;

    private LLVMPointerCompareNodeGen(NativePointerCompare op, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        super(op);
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @ExplodeLoop
    @Override
    public boolean executeWithTarget(Object child0Value, Object child1Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value, child1Value);
        }
        if ((state_0 & 0b1101110) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] || SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] || SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */ && child0Value instanceof Long) {
                long child0Value_ = (long) child0Value;
                if (child1Value instanceof Long) {
                    long child1Value_ = (long) child1Value;
                    return doCompare(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(child0Value)) {
                LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                if (LLVMTypes.isNativePointer(child1Value)) {
                    LLVMNativePointer child1Value_ = LLVMTypes.asNativePointer(child1Value);
                    return doCompare(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 0b1101000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] || SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */) {
                    PointerPointerData s2_ = this.pointerPointer_cache;
                    while (s2_ != null) {
                        if ((s2_.isPointerA_.execute(child0Value)) && (s2_.isPointerB_.execute(child1Value))) {
                            try {
                                return doPointerPointer(child0Value, child1Value, s2_.isPointerA_, s2_.asPointerA_, s2_.isPointerB_, s2_.asPointerB_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointerPointer_cache = null;
                                return executeAndSpecialize(child0Value, child1Value);
                            }
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                    PointerPointerExceptionData s3_ = this.pointerPointerException_cache;
                    while (s3_ != null) {
                        if ((s3_.isPointerA_.execute(child0Value)) && (s3_.isPointerB_.execute(child1Value))) {
                            return doPointerPointerException(child0Value, child1Value, s3_.isPointerA_, s3_.asPointerA_, s3_.isPointerB_, s3_.asPointerB_, s3_.managedCompare_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                    OtherData s4_ = this.other_cache;
                    while (s4_ != null) {
                        if ((!(s4_.isPointerA_.execute(child0Value)) || !(s4_.isPointerB_.execute(child1Value)))) {
                            return doOther(child0Value, child1Value, s4_.isPointerA_, s4_.asPointerA_, s4_.isPointerB_, s4_.asPointerB_, s4_.managedCompare_);
                        }
                        s4_ = s4_.next_;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value, child1Value);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1101100) == 0 /* only-active SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */ && ((state_0 & 0b1101110) != 0  /* is-not SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] && SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] && SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] && SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] && SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */)) {
            return executeGeneric_long_long0(state_0, frameValue);
        } else {
            return executeGeneric_generic1(state_0, frameValue);
        }
    }

    private Object executeGeneric_long_long0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object child1Value = this.child1_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), child1Value);
        }
        long child1Value_;
        try {
            child1Value_ = this.child1_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(child0Value_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_, child1Value_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */;
        return doCompare(child0Value_, child1Value_);
    }

    @ExplodeLoop
    private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        Object child1Value_ = this.child1_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_, child1Value_);
        }
        if ((state_0 & 0b1101110) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] || SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] || SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */ && child0Value_ instanceof Long) {
                long child0Value__ = (long) child0Value_;
                if (child1Value_ instanceof Long) {
                    long child1Value__ = (long) child1Value_;
                    return doCompare(child0Value__, child1Value__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                if (LLVMTypes.isNativePointer(child1Value_)) {
                    LLVMNativePointer child1Value__ = LLVMTypes.asNativePointer(child1Value_);
                    return doCompare(child0Value__, child1Value__);
                }
            }
            if ((state_0 & 0b1101000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] || SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */) {
                    PointerPointerData s2_ = this.pointerPointer_cache;
                    while (s2_ != null) {
                        if ((s2_.isPointerA_.execute(child0Value_)) && (s2_.isPointerB_.execute(child1Value_))) {
                            try {
                                return doPointerPointer(child0Value_, child1Value_, s2_.isPointerA_, s2_.asPointerA_, s2_.isPointerB_, s2_.asPointerB_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointerPointer_cache = null;
                                return executeAndSpecialize(child0Value_, child1Value_);
                            }
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                    PointerPointerExceptionData s3_ = this.pointerPointerException_cache;
                    while (s3_ != null) {
                        if ((s3_.isPointerA_.execute(child0Value_)) && (s3_.isPointerB_.execute(child1Value_))) {
                            return doPointerPointerException(child0Value_, child1Value_, s3_.isPointerA_, s3_.asPointerA_, s3_.isPointerB_, s3_.asPointerB_, s3_.managedCompare_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                    OtherData s4_ = this.other_cache;
                    while (s4_ != null) {
                        if ((!(s4_.isPointerA_.execute(child0Value_)) || !(s4_.isPointerB_.execute(child1Value_)))) {
                            return doOther(child0Value_, child1Value_, s4_.isPointerA_, s4_.asPointerA_, s4_.isPointerB_, s4_.asPointerB_, s4_.managedCompare_);
                        }
                        s4_ = s4_.next_;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_, child1Value_);
    }

    @Override
    public boolean executeGenericBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1101100) == 0 /* only-active SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */ && ((state_0 & 0b1101110) != 0  /* is-not SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] && SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] && SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] && SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] && SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */)) {
            return executeGenericBoolean_long_long2(state_0, frameValue);
        } else {
            return executeGenericBoolean_generic3(state_0, frameValue);
        }
    }

    private boolean executeGenericBoolean_long_long2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object child1Value = this.child1_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), child1Value);
        }
        long child1Value_;
        try {
            child1Value_ = this.child1_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(child0Value_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_, child1Value_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */;
        return doCompare(child0Value_, child1Value_);
    }

    @ExplodeLoop
    private boolean executeGenericBoolean_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        Object child1Value_ = this.child1_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_, child1Value_);
        }
        if ((state_0 & 0b1101110) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] || SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] || SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */ && child0Value_ instanceof Long) {
                long child0Value__ = (long) child0Value_;
                if (child1Value_ instanceof Long) {
                    long child1Value__ = (long) child1Value_;
                    return doCompare(child0Value__, child1Value__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                if (LLVMTypes.isNativePointer(child1Value_)) {
                    LLVMNativePointer child1Value__ = LLVMTypes.asNativePointer(child1Value_);
                    return doCompare(child0Value__, child1Value__);
                }
            }
            if ((state_0 & 0b1101000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] || SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */) {
                    PointerPointerData s2_ = this.pointerPointer_cache;
                    while (s2_ != null) {
                        if ((s2_.isPointerA_.execute(child0Value_)) && (s2_.isPointerB_.execute(child1Value_))) {
                            try {
                                return doPointerPointer(child0Value_, child1Value_, s2_.isPointerA_, s2_.asPointerA_, s2_.isPointerB_, s2_.asPointerB_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointerPointer_cache = null;
                                return executeAndSpecialize(child0Value_, child1Value_);
                            }
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                    PointerPointerExceptionData s3_ = this.pointerPointerException_cache;
                    while (s3_ != null) {
                        if ((s3_.isPointerA_.execute(child0Value_)) && (s3_.isPointerB_.execute(child1Value_))) {
                            return doPointerPointerException(child0Value_, child1Value_, s3_.isPointerA_, s3_.asPointerA_, s3_.isPointerB_, s3_.asPointerB_, s3_.managedCompare_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                    OtherData s4_ = this.other_cache;
                    while (s4_ != null) {
                        if ((!(s4_.isPointerA_.execute(child0Value_)) || !(s4_.isPointerB_.execute(child1Value_)))) {
                            return doOther(child0Value_, child1Value_, s4_.isPointerA_, s4_.asPointerA_, s4_.isPointerB_, s4_.asPointerB_, s4_.managedCompare_);
                        }
                        s4_ = s4_.next_;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_, child1Value_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1101100) == 0 /* only-active SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */ && ((state_0 & 0b1101110) != 0  /* is-not SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] && SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] && SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] && SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] && SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */)) {
            return executeI1_long_long4(state_0, frameValue);
        } else {
            return executeI1_generic5(state_0, frameValue);
        }
    }

    private boolean executeI1_long_long4(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object child1Value = this.child1_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), child1Value);
        }
        long child1Value_;
        try {
            child1Value_ = this.child1_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(child0Value_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_, child1Value_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */;
        return doCompare(child0Value_, child1Value_);
    }

    @ExplodeLoop
    private boolean executeI1_generic5(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        Object child1Value_ = this.child1_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_, child1Value_);
        }
        if ((state_0 & 0b1101110) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] || SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] || SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */ && child0Value_ instanceof Long) {
                long child0Value__ = (long) child0Value_;
                if (child1Value_ instanceof Long) {
                    long child1Value__ = (long) child1Value_;
                    return doCompare(child0Value__, child1Value__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                if (LLVMTypes.isNativePointer(child1Value_)) {
                    LLVMNativePointer child1Value__ = LLVMTypes.asNativePointer(child1Value_);
                    return doCompare(child0Value__, child1Value__);
                }
            }
            if ((state_0 & 0b1101000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] || SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */) {
                    PointerPointerData s2_ = this.pointerPointer_cache;
                    while (s2_ != null) {
                        if ((s2_.isPointerA_.execute(child0Value_)) && (s2_.isPointerB_.execute(child1Value_))) {
                            try {
                                return doPointerPointer(child0Value_, child1Value_, s2_.isPointerA_, s2_.asPointerA_, s2_.isPointerB_, s2_.asPointerB_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.pointerPointer_cache = null;
                                return executeAndSpecialize(child0Value_, child1Value_);
                            }
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                    PointerPointerExceptionData s3_ = this.pointerPointerException_cache;
                    while (s3_ != null) {
                        if ((s3_.isPointerA_.execute(child0Value_)) && (s3_.isPointerB_.execute(child1Value_))) {
                            return doPointerPointerException(child0Value_, child1Value_, s3_.isPointerA_, s3_.asPointerA_, s3_.isPointerB_, s3_.asPointerB_, s3_.managedCompare_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */) {
                    OtherData s4_ = this.other_cache;
                    while (s4_ != null) {
                        if ((!(s4_.isPointerA_.execute(child0Value_)) || !(s4_.isPointerB_.execute(child1Value_)))) {
                            return doOther(child0Value_, child1Value_, s4_.isPointerA_, s4_.asPointerA_, s4_.isPointerB_, s4_.asPointerB_, s4_.managedCompare_);
                        }
                        s4_ = s4_.next_;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_, child1Value_);
    }

    @SuppressWarnings("unused")
    private boolean executeAndSpecialize(Object child0Value, Object child1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (child0Value instanceof Long) {
            long child0Value_ = (long) child0Value;
            if (child1Value instanceof Long) {
                long child1Value_ = (long) child1Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */;
                this.state_0_ = state_0;
                return doCompare(child0Value_, child1Value_);
            }
        }
        if (LLVMTypes.isNativePointer(child0Value)) {
            LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
            if (LLVMTypes.isNativePointer(child1Value)) {
                LLVMNativePointer child1Value_ = LLVMTypes.asNativePointer(child1Value);
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doCompare(child0Value_, child1Value_);
            }
        }
        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */) {
            while (true) {
                int count2_ = 0;
                PointerPointerData s2_ = POINTER_POINTER_CACHE_UPDATER.getVolatile(this);
                PointerPointerData s2_original = s2_;
                while (s2_ != null) {
                    if ((s2_.isPointerA_.execute(child0Value)) && (s2_.isPointerB_.execute(child1Value))) {
                        break;
                    }
                    count2_++;
                    s2_ = s2_.next_;
                }
                if (s2_ == null) {
                    {
                        IsPointerNode isPointerA__ = this.insert((IsPointerNodeGen.create()));
                        if ((isPointerA__.execute(child0Value))) {
                            IsPointerNode isPointerB__ = this.insert((IsPointerNodeGen.create()));
                            if ((isPointerB__.execute(child1Value)) && count2_ < (3)) {
                                s2_ = this.insert(new PointerPointerData(s2_original));
                                Objects.requireNonNull(s2_.insert(isPointerA__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.isPointerA_ = isPointerA__;
                                AsPointerNode asPointerA__ = s2_.insert((AsPointerNodeGen.create()));
                                Objects.requireNonNull(asPointerA__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.asPointerA_ = asPointerA__;
                                Objects.requireNonNull(s2_.insert(isPointerB__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.isPointerB_ = isPointerB__;
                                AsPointerNode asPointerB__ = s2_.insert((AsPointerNodeGen.create()));
                                Objects.requireNonNull(asPointerB__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.asPointerB_ = asPointerB__;
                                if (!POINTER_POINTER_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                }
                if (s2_ != null) {
                    try {
                        return doPointerPointer(child0Value, child1Value, s2_.isPointerA_, s2_.asPointerA_, s2_.isPointerB_, s2_.asPointerB_);
                    } catch (UnsupportedMessageException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */;
                        state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.pointerPointer_cache = null;
                        return executeAndSpecialize(child0Value, child1Value);
                    }
                }
                break;
            }
        }
        while (true) {
            int count3_ = 0;
            PointerPointerExceptionData s3_ = POINTER_POINTER_EXCEPTION_CACHE_UPDATER.getVolatile(this);
            PointerPointerExceptionData s3_original = s3_;
            while (s3_ != null) {
                if ((s3_.isPointerA_.execute(child0Value)) && (s3_.isPointerB_.execute(child1Value))) {
                    break;
                }
                count3_++;
                s3_ = s3_.next_;
            }
            if (s3_ == null) {
                {
                    IsPointerNode isPointerA__1 = this.insert((IsPointerNodeGen.create()));
                    if ((isPointerA__1.execute(child0Value))) {
                        IsPointerNode isPointerB__1 = this.insert((IsPointerNodeGen.create()));
                        if ((isPointerB__1.execute(child1Value)) && count3_ < (3)) {
                            s3_ = this.insert(new PointerPointerExceptionData(s3_original));
                            Objects.requireNonNull(s3_.insert(isPointerA__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s3_.isPointerA_ = isPointerA__1;
                            AsPointerNode asPointerA__1 = s3_.insert((AsPointerNodeGen.create()));
                            Objects.requireNonNull(asPointerA__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s3_.asPointerA_ = asPointerA__1;
                            Objects.requireNonNull(s3_.insert(isPointerB__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s3_.isPointerB_ = isPointerB__1;
                            AsPointerNode asPointerB__1 = s3_.insert((AsPointerNodeGen.create()));
                            Objects.requireNonNull(asPointerB__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s3_.asPointerB_ = asPointerB__1;
                            LLVMManagedCompareNode managedCompare__ = s3_.insert((LLVMManagedCompareNodeGen.create()));
                            Objects.requireNonNull(managedCompare__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s3_.managedCompare_ = managedCompare__;
                            if (!POINTER_POINTER_EXCEPTION_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
            }
            if (s3_ != null) {
                return doPointerPointerException(child0Value, child1Value, s3_.isPointerA_, s3_.asPointerA_, s3_.isPointerB_, s3_.asPointerB_, s3_.managedCompare_);
            }
            break;
        }
        while (true) {
            int count4_ = 0;
            OtherData s4_ = OTHER_CACHE_UPDATER.getVolatile(this);
            OtherData s4_original = s4_;
            while (s4_ != null) {
                if ((!(s4_.isPointerA_.execute(child0Value)) || !(s4_.isPointerB_.execute(child1Value)))) {
                    break;
                }
                count4_++;
                s4_ = s4_.next_;
            }
            if (s4_ == null) {
                {
                    IsPointerNode isPointerA__2 = this.insert((IsPointerNodeGen.create()));
                    IsPointerNode isPointerB__2 = this.insert((IsPointerNodeGen.create()));
                    if ((!(isPointerA__2.execute(child0Value)) || !(isPointerB__2.execute(child1Value))) && count4_ < (3)) {
                        s4_ = this.insert(new OtherData(s4_original));
                        Objects.requireNonNull(s4_.insert(isPointerA__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s4_.isPointerA_ = isPointerA__2;
                        AsPointerNode asPointerA__2 = s4_.insert((AsPointerNodeGen.create()));
                        Objects.requireNonNull(asPointerA__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s4_.asPointerA_ = asPointerA__2;
                        Objects.requireNonNull(s4_.insert(isPointerB__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s4_.isPointerB_ = isPointerB__2;
                        AsPointerNode asPointerB__2 = s4_.insert((AsPointerNodeGen.create()));
                        Objects.requireNonNull(asPointerB__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s4_.asPointerB_ = asPointerB__2;
                        LLVMManagedCompareNode managedCompare__1 = s4_.insert((LLVMManagedCompareNodeGen.create()));
                        Objects.requireNonNull(managedCompare__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s4_.managedCompare_ = managedCompare__1;
                        if (!OTHER_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */;
                        this.state_0_ = state_0;
                    }
                }
            }
            if (s4_ != null) {
                return doOther(child0Value, child1Value, s4_.isPointerA_, s4_.asPointerA_, s4_.isPointerB_, s4_.asPointerB_, s4_.managedCompare_);
            }
            break;
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_, this.child1_}, child0Value, child1Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPointerCompareNode.doCompare(long, long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPointerCompareNode.doCompare(LLVMNativePointer, LLVMNativePointer)] */;
        }
        {
            PointerPointerData s2_ = this.insert(new PointerPointerData(this.pointerPointer_cache));
            IsPointerNode isPointerA__ = s2_.insert((IsPointerNodeGen.create()));
            Objects.requireNonNull(isPointerA__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s2_.isPointerA_ = isPointerA__;
            AsPointerNode asPointerA__ = s2_.insert((AsPointerNodeGen.create()));
            Objects.requireNonNull(asPointerA__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s2_.asPointerA_ = asPointerA__;
            IsPointerNode isPointerB__ = s2_.insert((IsPointerNodeGen.create()));
            Objects.requireNonNull(isPointerB__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s2_.isPointerB_ = isPointerB__;
            AsPointerNode asPointerB__ = s2_.insert((AsPointerNodeGen.create()));
            Objects.requireNonNull(asPointerB__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s2_.asPointerB_ = asPointerB__;
            VarHandle.storeStoreFence();
            this.pointerPointer_cache = s2_;
            assert NodeUtil.assertRecursion(s2_.isPointerA_, 1);
            ((GenerateAOT.Provider) s2_.isPointerA_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s2_.asPointerA_, 1);
            ((GenerateAOT.Provider) s2_.asPointerA_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s2_.isPointerB_, 1);
            ((GenerateAOT.Provider) s2_.isPointerB_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s2_.asPointerB_, 1);
            ((GenerateAOT.Provider) s2_.asPointerB_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMPointerCompareNode.doPointerPointer(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode)] */;
        }
        {
            PointerPointerExceptionData s3_ = this.insert(new PointerPointerExceptionData(this.pointerPointerException_cache));
            IsPointerNode isPointerA__1 = s3_.insert((IsPointerNodeGen.create()));
            Objects.requireNonNull(isPointerA__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.isPointerA_ = isPointerA__1;
            AsPointerNode asPointerA__1 = s3_.insert((AsPointerNodeGen.create()));
            Objects.requireNonNull(asPointerA__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.asPointerA_ = asPointerA__1;
            IsPointerNode isPointerB__1 = s3_.insert((IsPointerNodeGen.create()));
            Objects.requireNonNull(isPointerB__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.isPointerB_ = isPointerB__1;
            AsPointerNode asPointerB__1 = s3_.insert((AsPointerNodeGen.create()));
            Objects.requireNonNull(asPointerB__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.asPointerB_ = asPointerB__1;
            LLVMManagedCompareNode managedCompare__ = s3_.insert((LLVMManagedCompareNodeGen.create()));
            Objects.requireNonNull(managedCompare__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.managedCompare_ = managedCompare__;
            VarHandle.storeStoreFence();
            this.pointerPointerException_cache = s3_;
            assert NodeUtil.assertRecursion(s3_.isPointerA_, 1);
            ((GenerateAOT.Provider) s3_.isPointerA_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s3_.asPointerA_, 1);
            ((GenerateAOT.Provider) s3_.asPointerA_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s3_.isPointerB_, 1);
            ((GenerateAOT.Provider) s3_.isPointerB_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s3_.asPointerB_, 1);
            ((GenerateAOT.Provider) s3_.asPointerB_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s3_.managedCompare_, 1);
            ((GenerateAOT.Provider) s3_.managedCompare_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMPointerCompareNode.doPointerPointerException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */;
        }
        {
            OtherData s4_ = this.insert(new OtherData(this.other_cache));
            IsPointerNode isPointerA__2 = s4_.insert((IsPointerNodeGen.create()));
            Objects.requireNonNull(isPointerA__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s4_.isPointerA_ = isPointerA__2;
            AsPointerNode asPointerA__2 = s4_.insert((AsPointerNodeGen.create()));
            Objects.requireNonNull(asPointerA__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s4_.asPointerA_ = asPointerA__2;
            IsPointerNode isPointerB__2 = s4_.insert((IsPointerNodeGen.create()));
            Objects.requireNonNull(isPointerB__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s4_.isPointerB_ = isPointerB__2;
            AsPointerNode asPointerB__2 = s4_.insert((AsPointerNodeGen.create()));
            Objects.requireNonNull(asPointerB__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s4_.asPointerB_ = asPointerB__2;
            LLVMManagedCompareNode managedCompare__1 = s4_.insert((LLVMManagedCompareNodeGen.create()));
            Objects.requireNonNull(managedCompare__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s4_.managedCompare_ = managedCompare__1;
            VarHandle.storeStoreFence();
            this.other_cache = s4_;
            assert NodeUtil.assertRecursion(s4_.isPointerA_, 1);
            ((GenerateAOT.Provider) s4_.isPointerA_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s4_.asPointerA_, 1);
            ((GenerateAOT.Provider) s4_.asPointerA_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s4_.isPointerB_, 1);
            ((GenerateAOT.Provider) s4_.isPointerB_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s4_.asPointerB_, 1);
            ((GenerateAOT.Provider) s4_.asPointerB_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s4_.managedCompare_, 1);
            ((GenerateAOT.Provider) s4_.managedCompare_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMPointerCompareNode.doOther(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, LLVMManagedCompareNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.pointerPointer_cache = null;
        this.pointerPointerException_cache = null;
        this.other_cache = null;
    }

    @NeverDefault
    public static LLVMPointerCompareNode create(NativePointerCompare op, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        return new LLVMPointerCompareNodeGen(op, child0, child1);
    }

    @GeneratedBy(LLVMPointerCompareNode.class)
    @DenyReplace
    private static final class PointerPointerData extends Node implements SpecializationDataNode {

        @Child PointerPointerData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doPointerPointer}
         *   Parameter: {@link IsPointerNode} isPointerA</pre>
         */
        @Child IsPointerNode isPointerA_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doPointerPointer}
         *   Parameter: {@link AsPointerNode} asPointerA</pre>
         */
        @Child AsPointerNode asPointerA_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doPointerPointer}
         *   Parameter: {@link IsPointerNode} isPointerB</pre>
         */
        @Child IsPointerNode isPointerB_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doPointerPointer}
         *   Parameter: {@link AsPointerNode} asPointerB</pre>
         */
        @Child AsPointerNode asPointerB_;

        PointerPointerData(PointerPointerData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMPointerCompareNode.class)
    @DenyReplace
    private static final class PointerPointerExceptionData extends Node implements SpecializationDataNode {

        @Child PointerPointerExceptionData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doPointerPointerException}
         *   Parameter: {@link IsPointerNode} isPointerA</pre>
         */
        @Child IsPointerNode isPointerA_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doPointerPointerException}
         *   Parameter: {@link AsPointerNode} asPointerA</pre>
         */
        @Child AsPointerNode asPointerA_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doPointerPointerException}
         *   Parameter: {@link IsPointerNode} isPointerB</pre>
         */
        @Child IsPointerNode isPointerB_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doPointerPointerException}
         *   Parameter: {@link AsPointerNode} asPointerB</pre>
         */
        @Child AsPointerNode asPointerB_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doPointerPointerException}
         *   Parameter: {@link LLVMManagedCompareNode} managedCompare</pre>
         */
        @Child LLVMManagedCompareNode managedCompare_;

        PointerPointerExceptionData(PointerPointerExceptionData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMPointerCompareNode.class)
    @DenyReplace
    private static final class OtherData extends Node implements SpecializationDataNode {

        @Child OtherData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doOther}
         *   Parameter: {@link IsPointerNode} isPointerA</pre>
         */
        @Child IsPointerNode isPointerA_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doOther}
         *   Parameter: {@link AsPointerNode} asPointerA</pre>
         */
        @Child AsPointerNode asPointerA_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doOther}
         *   Parameter: {@link IsPointerNode} isPointerB</pre>
         */
        @Child IsPointerNode isPointerB_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doOther}
         *   Parameter: {@link AsPointerNode} asPointerB</pre>
         */
        @Child AsPointerNode asPointerB_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerCompareNode#doOther}
         *   Parameter: {@link LLVMManagedCompareNode} managedCompare</pre>
         */
        @Child LLVMManagedCompareNode managedCompare_;

        OtherData(OtherData next_) {
            this.next_ = next_;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMManagedCompareNode#doForeignSameObject}
     *     Activation probability: 0.32000
     *     With/without class size: 11/4 bytes
     *   Specialization {@link LLVMManagedCompareNode#doForeignDifferentObjects}
     *     Activation probability: 0.26000
     *     With/without class size: 12/12 bytes
     *   Specialization {@link LLVMManagedCompareNode#doNativeManaged}
     *     Activation probability: 0.20000
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMManagedCompareNode#doManagedNative}
     *     Activation probability: 0.14000
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMManagedCompareNode#doManagedNativeException}
     *     Activation probability: 0.08000
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMManagedCompareNode.class)
    @SuppressWarnings("javadoc")
    static final class LLVMManagedCompareNodeGen extends LLVMManagedCompareNode implements GenerateAOT.Provider {

        static final ReferenceField<ForeignSameObjectData> FOREIGN_SAME_OBJECT_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreignSameObject_cache", ForeignSameObjectData.class);
        static final ReferenceField<ForeignDifferentObjectsData> FOREIGN_DIFFERENT_OBJECTS_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreignDifferentObjects_cache", ForeignDifferentObjectsData.class);

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMManagedCompareNode#doForeignSameObject}
         *   2: SpecializationActive {@link LLVMManagedCompareNode#doForeignDifferentObjects}
         *   3: SpecializationActive {@link LLVMManagedCompareNode#doNativeManaged}
         *   4: SpecializationExcluded {@link LLVMManagedCompareNode#doNativeManaged}
         *   5: SpecializationActive {@link LLVMManagedCompareNode#doManagedNative}
         *   6: SpecializationExcluded {@link LLVMManagedCompareNode#doManagedNative}
         *   7: SpecializationActive {@link LLVMManagedCompareNode#doManagedNativeException}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private ForeignSameObjectData foreignSameObject_cache;
        @UnsafeAccessedField @Child private ForeignDifferentObjectsData foreignDifferentObjects_cache;
        @Child private NativeManagedData nativeManaged_cache;
        @Child private ManagedNativeData managedNative_cache;
        @Child private ManagedNativeExceptionData managedNativeException_cache;

        private LLVMManagedCompareNodeGen() {
        }

        @ExplodeLoop
        @Override
        boolean execute(Object arg0Value, Object arg1Value, IsPointerNode arg2Value, AsPointerNode arg3Value, IsPointerNode arg4Value, AsPointerNode arg5Value, NativePointerCompare arg6Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if ((state_0 & 0b10101110) != 0 /* is SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignSameObject(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, LLVMSameObjectNode)] || SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignDifferentObjects(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue, ManagedToComparableValue, LLVMSameObjectNode)] || SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doNativeManaged(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] || SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNative(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] || SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNativeException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignSameObject(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, LLVMSameObjectNode)] || SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignDifferentObjects(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue, ManagedToComparableValue, LLVMSameObjectNode)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if (LLVMTypes.isManagedPointer(arg1Value)) {
                        LLVMManagedPointer arg1Value_ = LLVMTypes.asManagedPointer(arg1Value);
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignSameObject(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, LLVMSameObjectNode)] */) {
                            ForeignSameObjectData s0_ = this.foreignSameObject_cache;
                            while (s0_ != null) {
                                if ((s0_.pointToSameObject_.execute(arg0Value_.getObject(), arg1Value_.getObject()))) {
                                    return doForeignSameObject(arg0Value_, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.pointToSameObject_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignDifferentObjects(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue, ManagedToComparableValue, LLVMSameObjectNode)] */) {
                            ForeignDifferentObjectsData s1_ = this.foreignDifferentObjects_cache;
                            while (s1_ != null) {
                                if ((!(s1_.pointToSameObject_.execute(arg0Value_.getObject(), arg1Value_.getObject())))) {
                                    return doForeignDifferentObjects(arg0Value_, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.convertA_, s1_.convertB_, s1_.pointToSameObject_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                    }
                }
                if ((state_0 & 0b10101000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doNativeManaged(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] || SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNative(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] || SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNativeException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */) {
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doNativeManaged(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */) {
                        NativeManagedData s2_ = this.nativeManaged_cache;
                        if (s2_ != null) {
                            if ((arg2Value.execute(arg0Value))) {
                                try {
                                    return doNativeManaged(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s2_.convert_);
                                } catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doNativeManaged(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    this.nativeManaged_cache = null;
                                    return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNative(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */) {
                        ManagedNativeData s3_ = this.managedNative_cache;
                        if (s3_ != null) {
                            if ((arg4Value.execute(arg1Value))) {
                                try {
                                    return doManagedNative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s3_.convert_);
                                } catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNative(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    this.managedNative_cache = null;
                                    return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNativeException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */) {
                        ManagedNativeExceptionData s4_ = this.managedNativeException_cache;
                        if (s4_ != null) {
                            if ((arg2Value.execute(arg0Value) || arg4Value.execute(arg1Value))) {
                                return doManagedNativeException(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s4_.convert_);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @SuppressWarnings("unused")
        private boolean executeAndSpecialize(Object arg0Value, Object arg1Value, IsPointerNode arg2Value, AsPointerNode arg3Value, IsPointerNode arg4Value, AsPointerNode arg5Value, NativePointerCompare arg6Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (LLVMTypes.isManagedPointer(arg1Value)) {
                    LLVMManagedPointer arg1Value_ = LLVMTypes.asManagedPointer(arg1Value);
                    while (true) {
                        int count0_ = 0;
                        ForeignSameObjectData s0_ = FOREIGN_SAME_OBJECT_CACHE_UPDATER.getVolatile(this);
                        ForeignSameObjectData s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.pointToSameObject_.execute(arg0Value_.getObject(), arg1Value_.getObject()))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                LLVMSameObjectNode pointToSameObject__ = this.insert((LLVMSameObjectNodeGen.create()));
                                if ((pointToSameObject__.execute(arg0Value_.getObject(), arg1Value_.getObject())) && count0_ < (3)) {
                                    s0_ = this.insert(new ForeignSameObjectData(s0_original));
                                    Objects.requireNonNull(s0_.insert(pointToSameObject__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.pointToSameObject_ = pointToSameObject__;
                                    if (!FOREIGN_SAME_OBJECT_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignSameObject(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, LLVMSameObjectNode)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return doForeignSameObject(arg0Value_, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.pointToSameObject_);
                        }
                        break;
                    }
                    while (true) {
                        int count1_ = 0;
                        ForeignDifferentObjectsData s1_ = FOREIGN_DIFFERENT_OBJECTS_CACHE_UPDATER.getVolatile(this);
                        ForeignDifferentObjectsData s1_original = s1_;
                        while (s1_ != null) {
                            if ((!(s1_.pointToSameObject_.execute(arg0Value_.getObject(), arg1Value_.getObject())))) {
                                break;
                            }
                            count1_++;
                            s1_ = s1_.next_;
                        }
                        if (s1_ == null) {
                            {
                                LLVMSameObjectNode pointToSameObject__1 = this.insert((LLVMSameObjectNodeGen.create()));
                                if ((!(pointToSameObject__1.execute(arg0Value_.getObject(), arg1Value_.getObject()))) && count1_ < (3)) {
                                    s1_ = this.insert(new ForeignDifferentObjectsData(s1_original));
                                    s1_.convertA_ = s1_.insert((ManagedToComparableValue.createIgnoreOffset()));
                                    s1_.convertB_ = s1_.insert((ManagedToComparableValue.createIgnoreOffset()));
                                    Objects.requireNonNull(s1_.insert(pointToSameObject__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s1_.pointToSameObject_ = pointToSameObject__1;
                                    if (!FOREIGN_DIFFERENT_OBJECTS_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignDifferentObjects(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue, ManagedToComparableValue, LLVMSameObjectNode)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s1_ != null) {
                            return doForeignDifferentObjects(arg0Value_, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.convertA_, s1_.convertB_, s1_.pointToSameObject_);
                        }
                        break;
                    }
                }
            }
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */) {
                if ((arg2Value.execute(arg0Value))) {
                    NativeManagedData s2_ = this.insert(new NativeManagedData());
                    s2_.convert_ = s2_.insert((ManagedToComparableValue.createIgnoreOffset()));
                    VarHandle.storeStoreFence();
                    this.nativeManaged_cache = s2_;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doNativeManaged(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
                    this.state_0_ = state_0;
                    try {
                        return doNativeManaged(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s2_.convert_);
                    } catch (UnsupportedMessageException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doNativeManaged(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
                        state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.nativeManaged_cache = null;
                        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
            }
            if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationExcluded  */) {
                if ((arg4Value.execute(arg1Value))) {
                    ManagedNativeData s3_ = this.insert(new ManagedNativeData());
                    s3_.convert_ = s3_.insert((ManagedToComparableValue.createIgnoreOffset()));
                    VarHandle.storeStoreFence();
                    this.managedNative_cache = s3_;
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNative(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
                    this.state_0_ = state_0;
                    try {
                        return doManagedNative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s3_.convert_);
                    } catch (UnsupportedMessageException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNative(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
                        state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.managedNative_cache = null;
                        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
            }
            if ((arg2Value.execute(arg0Value) || arg4Value.execute(arg1Value))) {
                ManagedNativeExceptionData s4_ = this.insert(new ManagedNativeExceptionData());
                s4_.convert_ = s4_.insert((ManagedToComparableValue.createIgnoreOffset()));
                VarHandle.storeStoreFence();
                this.managedNativeException_cache = s4_;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNativeException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
                this.state_0_ = state_0;
                return doManagedNativeException(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s4_.convert_);
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                ForeignSameObjectData s0_ = this.insert(new ForeignSameObjectData(this.foreignSameObject_cache));
                LLVMSameObjectNode pointToSameObject__ = s0_.insert((LLVMSameObjectNodeGen.create()));
                Objects.requireNonNull(pointToSameObject__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.pointToSameObject_ = pointToSameObject__;
                VarHandle.storeStoreFence();
                this.foreignSameObject_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.pointToSameObject_, 1);
                ((GenerateAOT.Provider) s0_.pointToSameObject_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignSameObject(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, LLVMSameObjectNode)] */;
            }
            {
                ForeignDifferentObjectsData s1_ = this.insert(new ForeignDifferentObjectsData(this.foreignDifferentObjects_cache));
                s1_.convertA_ = s1_.insert((ManagedToComparableValue.createIgnoreOffset()));
                s1_.convertB_ = s1_.insert((ManagedToComparableValue.createIgnoreOffset()));
                LLVMSameObjectNode pointToSameObject__1 = s1_.insert((LLVMSameObjectNodeGen.create()));
                Objects.requireNonNull(pointToSameObject__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.pointToSameObject_ = pointToSameObject__1;
                VarHandle.storeStoreFence();
                this.foreignDifferentObjects_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.convertA_, 1);
                ((GenerateAOT.Provider) s1_.convertA_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.convertB_, 1);
                ((GenerateAOT.Provider) s1_.convertB_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.pointToSameObject_, 1);
                ((GenerateAOT.Provider) s1_.pointToSameObject_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doForeignDifferentObjects(LLVMManagedPointer, LLVMManagedPointer, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue, ManagedToComparableValue, LLVMSameObjectNode)] */;
            }
            {
                NativeManagedData s2_ = this.insert(new NativeManagedData());
                s2_.convert_ = s2_.insert((ManagedToComparableValue.createIgnoreOffset()));
                VarHandle.storeStoreFence();
                this.nativeManaged_cache = s2_;
                assert NodeUtil.assertRecursion(s2_.convert_, 1);
                ((GenerateAOT.Provider) s2_.convert_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doNativeManaged(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
            }
            {
                ManagedNativeData s3_ = this.insert(new ManagedNativeData());
                s3_.convert_ = s3_.insert((ManagedToComparableValue.createIgnoreOffset()));
                VarHandle.storeStoreFence();
                this.managedNative_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.convert_, 1);
                ((GenerateAOT.Provider) s3_.convert_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNative(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
            }
            {
                ManagedNativeExceptionData s4_ = this.insert(new ManagedNativeExceptionData());
                s4_.convert_ = s4_.insert((ManagedToComparableValue.createIgnoreOffset()));
                VarHandle.storeStoreFence();
                this.managedNativeException_cache = s4_;
                assert NodeUtil.assertRecursion(s4_.convert_, 1);
                ((GenerateAOT.Provider) s4_.convert_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMPointerCompareNode.LLVMManagedCompareNode.doManagedNativeException(Object, Object, IsPointerNode, AsPointerNode, IsPointerNode, AsPointerNode, NativePointerCompare, ManagedToComparableValue)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.foreignSameObject_cache = null;
            this.foreignDifferentObjects_cache = null;
            this.nativeManaged_cache = null;
            this.managedNative_cache = null;
            this.managedNativeException_cache = null;
        }

        @NeverDefault
        public static LLVMManagedCompareNode create() {
            return new LLVMManagedCompareNodeGen();
        }

        @GeneratedBy(LLVMManagedCompareNode.class)
        @DenyReplace
        private static final class ForeignSameObjectData extends Node implements SpecializationDataNode {

            @Child ForeignSameObjectData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMManagedCompareNode#doForeignSameObject}
             *   Parameter: {@link LLVMSameObjectNode} pointToSameObject</pre>
             */
            @Child LLVMSameObjectNode pointToSameObject_;

            ForeignSameObjectData(ForeignSameObjectData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LLVMManagedCompareNode.class)
        @DenyReplace
        private static final class ForeignDifferentObjectsData extends Node implements SpecializationDataNode {

            @Child ForeignDifferentObjectsData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMManagedCompareNode#doForeignDifferentObjects}
             *   Parameter: {@link ManagedToComparableValue} convertA</pre>
             */
            @Child ManagedToComparableValue convertA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMManagedCompareNode#doForeignDifferentObjects}
             *   Parameter: {@link ManagedToComparableValue} convertB</pre>
             */
            @Child ManagedToComparableValue convertB_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMManagedCompareNode#doForeignDifferentObjects}
             *   Parameter: {@link LLVMSameObjectNode} pointToSameObject</pre>
             */
            @Child LLVMSameObjectNode pointToSameObject_;

            ForeignDifferentObjectsData(ForeignDifferentObjectsData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LLVMManagedCompareNode.class)
        @DenyReplace
        private static final class NativeManagedData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMManagedCompareNode#doNativeManaged}
             *   Parameter: {@link ManagedToComparableValue} convert</pre>
             */
            @Child ManagedToComparableValue convert_;

            NativeManagedData() {
            }

        }
        @GeneratedBy(LLVMManagedCompareNode.class)
        @DenyReplace
        private static final class ManagedNativeData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMManagedCompareNode#doManagedNative}
             *   Parameter: {@link ManagedToComparableValue} convert</pre>
             */
            @Child ManagedToComparableValue convert_;

            ManagedNativeData() {
            }

        }
        @GeneratedBy(LLVMManagedCompareNode.class)
        @DenyReplace
        private static final class ManagedNativeExceptionData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMManagedCompareNode#doManagedNativeException}
             *   Parameter: {@link ManagedToComparableValue} convert</pre>
             */
            @Child ManagedToComparableValue convert_;

            ManagedNativeExceptionData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMNegateNode#doNegate}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMNegateNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMNegateNodeGen extends LLVMNegateNode implements GenerateAOT.Provider {

        private LLVMNegateNodeGen(LLVMAbstractCompareNode booleanExpression) {
            super(booleanExpression);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return doNegate(frameValue);
        }

        @Override
        public boolean executeGenericBoolean(VirtualFrame frameValue) {
            return doNegate(frameValue);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            return doNegate(frameValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static LLVMNegateNode create(LLVMAbstractCompareNode booleanExpression) {
            return new LLVMNegateNodeGen(booleanExpression);
        }

    }
}
