// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack.LLVMStackAccessHolder;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMAccessThreadLocalSymbolNode#accessSingleContext}
 *     Activation probability: 0.65000
 *     With/without class size: 14/4 bytes
 *   Specialization {@link LLVMAccessThreadLocalSymbolNode#accessMultiContext}
 *     Activation probability: 0.35000
 *     With/without class size: 11/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMAccessThreadLocalSymbolNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAccessThreadLocalSymbolNodeGen extends LLVMAccessThreadLocalSymbolNode implements GenerateAOT.Provider {

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMAccessThreadLocalSymbolNode#accessSingleContext}
     *   2: SpecializationActive {@link LLVMAccessThreadLocalSymbolNode#accessMultiContext}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMAccessThreadLocalSymbolNode#accessSingleContext}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile accessSingleContext_exception_;
    @CompilationFinal private AccessMultiContextData accessMultiContext_cache;

    private LLVMAccessThreadLocalSymbolNodeGen(LLVMSymbol symbol) {
        super(symbol);
    }

    @Override
    public LLVMPointer executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAccessThreadLocalSymbolNode.accessSingleContext(BranchProfile)] || SpecializationActive[LLVMAccessThreadLocalSymbolNode.accessMultiContext(VirtualFrame, LLVMStackAccessHolder, BranchProfile)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAccessThreadLocalSymbolNode.accessSingleContext(BranchProfile)] */) {
                {
                    BranchProfile exception__ = this.accessSingleContext_exception_;
                    if (exception__ != null) {
                        assert DSLSupport.assertIdempotence((LLVMLanguage.isSingleContext(this)));
                        return accessSingleContext(exception__);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAccessThreadLocalSymbolNode.accessMultiContext(VirtualFrame, LLVMStackAccessHolder, BranchProfile)] */) {
                AccessMultiContextData s1_ = this.accessMultiContext_cache;
                if (s1_ != null) {
                    return accessMultiContext(frameValue, s1_.stackAccessHolder_, s1_.exception_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue);
    }

    private LLVMPointer executeAndSpecialize(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((LLVMLanguage.isSingleContext(this))) {
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.accessSingleContext_exception_ = exception__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAccessThreadLocalSymbolNode.accessSingleContext(BranchProfile)] */;
            this.state_0_ = state_0;
            return accessSingleContext(exception__);
        }
        AccessMultiContextData s1_ = new AccessMultiContextData();
        s1_.stackAccessHolder_ = (createStackAccessHolder());
        BranchProfile exception__1 = (BranchProfile.create());
        Objects.requireNonNull(exception__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        s1_.exception_ = exception__1;
        VarHandle.storeStoreFence();
        this.accessMultiContext_cache = s1_;
        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAccessThreadLocalSymbolNode.accessMultiContext(VirtualFrame, LLVMStackAccessHolder, BranchProfile)] */;
        this.state_0_ = state_0;
        return accessMultiContext(frameValue, s1_.stackAccessHolder_, exception__1);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            AccessMultiContextData s1_ = new AccessMultiContextData();
            s1_.stackAccessHolder_ = (createStackAccessHolder());
            BranchProfile exception__1 = (BranchProfile.create());
            Objects.requireNonNull(exception__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.exception_ = exception__1;
            s1_.exception_.disable();
            VarHandle.storeStoreFence();
            this.accessMultiContext_cache = s1_;
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAccessThreadLocalSymbolNode.accessMultiContext(VirtualFrame, LLVMStackAccessHolder, BranchProfile)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.accessMultiContext_cache = null;
    }

    @NeverDefault
    public static LLVMAccessThreadLocalSymbolNode create(LLVMSymbol symbol) {
        return new LLVMAccessThreadLocalSymbolNodeGen(symbol);
    }

    @GeneratedBy(LLVMAccessThreadLocalSymbolNode.class)
    @DenyReplace
    private static final class AccessMultiContextData implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMAccessThreadLocalSymbolNode#accessMultiContext}
         *   Parameter: {@link LLVMStackAccessHolder} stackAccessHolder</pre>
         */
        @CompilationFinal LLVMStackAccessHolder stackAccessHolder_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMAccessThreadLocalSymbolNode#accessMultiContext}
         *   Parameter: {@link BranchProfile} exception</pre>
         */
        @CompilationFinal BranchProfile exception_;

        AccessMultiContextData() {
        }

    }
}
