// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMDynAccessSymbolNode#doAccess}
 *     Activation probability: 1.00000
 *     With/without class size: 20/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMDynAccessSymbolNode.class)
@SuppressWarnings("javadoc")
public final class LLVMDynAccessSymbolNodeGen extends LLVMDynAccessSymbolNode implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMDynAccessSymbolNode#doAccess}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMDynAccessSymbolNode#doAccess}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile exception_;

    private LLVMDynAccessSymbolNodeGen() {
    }

    @Override
    public LLVMPointer execute(LLVMSymbol arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMDynAccessSymbolNode.doAccess(LLVMSymbol, BranchProfile)] */) {
            {
                BranchProfile exception__ = this.exception_;
                if (exception__ != null) {
                    return doAccess(arg0Value, exception__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private LLVMPointer executeAndSpecialize(LLVMSymbol arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        BranchProfile exception__ = (BranchProfile.create());
        Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        VarHandle.storeStoreFence();
        this.exception_ = exception__;
        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMDynAccessSymbolNode.doAccess(LLVMSymbol, BranchProfile)] */;
        this.state_0_ = state_0;
        return doAccess(arg0Value, exception__);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.exception_ = exception__;
            this.exception_.disable();
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMDynAccessSymbolNode.doAccess(LLVMSymbol, BranchProfile)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.exception_.reset();
    }

    @NeverDefault
    public static LLVMDynAccessSymbolNode create() {
        return new LLVMDynAccessSymbolNodeGen();
    }

    @NeverDefault
    public static LLVMDynAccessSymbolNode getUncached() {
        return LLVMDynAccessSymbolNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMDynAccessSymbolNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMDynAccessSymbolNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public LLVMPointer execute(LLVMSymbol arg0Value) {
            return doAccess(arg0Value, (BranchProfile.getUncached()));
        }

    }
}
