/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromBufferNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="buffer", type=LLVMExpressionNode.class), @NodeChild(value="length", type=LLVMExpressionNode.class)})
public abstract class LLVMPolyglotFromBufferNode
extends LLVMExpressionNode {
    protected final boolean isWritable;

    protected LLVMPolyglotFromBufferNode(boolean isWritable) {
        this.isWritable = isWritable;
    }

    @Specialization
    public LLVMPointer doAsBuffer(LLVMNativePointer pointer, long length) {
        return pointer.export(new LLVMInteropType.Buffer(this.isWritable, length));
    }

    @Specialization(guards={"foreignsLib.isForeign(pointer)"}, limit="3")
    @GenerateAOT.Exclude
    public Object doManagedPointer(LLVMManagedPointer pointer, long length, @Cached LLVMAsForeignNode foreign, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception1, @Cached BranchProfile exception2, @Cached BranchProfile exception3) {
        Object buffer = foreign.execute(pointer);
        try {
            if (!interop.hasBufferElements(buffer)) {
                return this.unsupported(pointer, length);
            }
            if (this.isWritable && !interop.isBufferWritable(buffer)) {
                exception1.enter();
                throw new LLVMPolyglotException(this, "Buffer is read-only.");
            }
            if (length > interop.getBufferSize(buffer)) {
                exception2.enter();
                throw new LLVMPolyglotException((Node)this, "Buffer has length '%d', but at least '%d' bytes are required.", interop.getBufferSize(buffer), length);
            }
            return pointer;
        }
        catch (UnsupportedMessageException ex) {
            exception3.enter();
            return this.unsupported(pointer, length);
        }
    }

    @Fallback
    public Object unsupported(Object buffer, Object length) {
        throw new LLVMPolyglotException(this, "Function argument is not a buffer");
    }

    public static LLVMPolyglotFromBufferNode create(boolean isWritable, LLVMExpressionNode buffer, LLVMExpressionNode length) {
        return LLVMPolyglotFromBufferNodeGen.create(isWritable, buffer, length);
    }
}

