/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.llvm.runtime.ArithmeticOperation;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVMLongDoubleFloatingPoint;
import com.oracle.truffle.llvm.runtime.floating.LLVMLongDoubleNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNode;
import com.oracle.truffle.llvm.runtime.nodes.util.LLVMSameObjectNode;
import com.oracle.truffle.llvm.runtime.nodes.util.LLVMSameObjectNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMArithmeticNode.class)
public final class LLVMArithmeticNodeFactory {

    @GeneratedBy(value=LLVMArithmeticNode.ManagedXorNode.class)
    static final class ManagedXorNodeGen
    extends LLVMArithmeticNode.ManagedXorNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private ValueProfile type_;

        private ManagedXorNodeGen() {
        }

        @Override
        Object execute(LLVMManagedPointer arg0Value, long arg1Value) {
            ValueProfile type__;
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 2) != 0 && (type__ = this.type_) != null) {
                return this.doXor(arg0Value, arg1Value, type__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMManagedPointer executeAndSpecialize(LLVMManagedPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            ValueProfile type__ = ValueProfile.createClassProfile();
            Objects.requireNonNull(type__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.type_ = type__;
            this.state_0_ = state_0 |= 2;
            return this.doXor(arg0Value, arg1Value, type__);
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            ValueProfile type__ = ValueProfile.createClassProfile();
            Objects.requireNonNull(type__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.type_ = type__;
            this.type_.disable();
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.type_.reset();
        }

        @NeverDefault
        public static LLVMArithmeticNode.ManagedXorNode create() {
            return new ManagedXorNodeGen();
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.ManagedAndNode.class)
    static final class ManagedAndNodeGen
    extends LLVMArithmeticNode.ManagedAndNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private ManagedAndNodeGen() {
        }

        @Override
        Object execute(LLVMManagedPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && LLVMArithmeticNode.ManagedAndNode.highBitsSet(arg1Value)) {
                    return this.doAlign(arg0Value, arg1Value);
                }
                if ((state_0 & 4) != 0 && LLVMArithmeticNode.ManagedAndNode.highBitsClear(arg1Value)) {
                    return this.doMask(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        long executeLong(LLVMManagedPointer arg0Value, long arg1Value) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(arg0Value, arg1Value));
            }
            if ((state_0 & 4) != 0 && LLVMArithmeticNode.ManagedAndNode.highBitsClear(arg1Value)) {
                return this.doMask(arg0Value, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(arg0Value, arg1Value));
        }

        private Object executeAndSpecialize(LLVMManagedPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMArithmeticNode.ManagedAndNode.highBitsSet(arg1Value)) {
                this.state_0_ = state_0 |= 2;
                return this.doAlign(arg0Value, arg1Value);
            }
            if (LLVMArithmeticNode.ManagedAndNode.highBitsClear(arg1Value)) {
                this.state_0_ = state_0 |= 4;
                return this.doMask(arg0Value, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmeticNode.ManagedAndNode create() {
            return new ManagedAndNodeGen();
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.ManagedSubNode.class)
    static final class ManagedSubNodeGen
    extends LLVMArithmeticNode.ManagedSubNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private ValueProfile right_type_;

        private ManagedSubNodeGen() {
        }

        @Override
        Object execute(LLVMManagedPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 2) != 0) {
                return this.doLeft(arg0Value, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        Object execute(long arg0Value, LLVMManagedPointer arg1Value) {
            ValueProfile type__;
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 4) != 0 && (type__ = this.right_type_) != null) {
                return this.doRight(arg0Value, arg1Value, type__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMManagedPointer executeAndSpecialize(Object arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doLeft(arg0Value_, arg1Value_);
                }
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                if (LLVMTypes.isManagedPointer(arg1Value)) {
                    LLVMManagedPointer arg1Value_ = LLVMTypes.asManagedPointer(arg1Value);
                    ValueProfile type__ = ValueProfile.createClassProfile();
                    Objects.requireNonNull(type__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.right_type_ = type__;
                    this.state_0_ = state_0 |= 4;
                    return this.doRight(arg0Value_, arg1Value_, type__);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            ValueProfile type__ = ValueProfile.createClassProfile();
            Objects.requireNonNull(type__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.right_type_ = type__;
            this.right_type_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.right_type_.reset();
        }

        @NeverDefault
        public static LLVMArithmeticNode.ManagedSubNode create() {
            return new ManagedSubNodeGen();
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.ManagedMulNode.class)
    static final class ManagedMulNodeGen
    extends LLVMArithmeticNode.ManagedMulNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private ManagedMulNodeGen() {
        }

        @Override
        Object execute(LLVMManagedPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0xE) != 0) {
                if ((state_0 & 2) != 0 && arg1Value == 1L) {
                    return this.doIdentity(arg0Value, arg1Value);
                }
                if ((state_0 & 4) != 0 && arg1Value == 0L) {
                    return this.doZero(arg0Value, arg1Value);
                }
                if ((state_0 & 8) != 0 && LLVMArithmeticNode.ManagedMulNode.isMinusOne(arg1Value)) {
                    return this.doNegate(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        long executeLong(LLVMManagedPointer arg0Value, long arg1Value) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(arg0Value, arg1Value));
            }
            if ((state_0 & 4) != 0 && arg1Value == 0L) {
                return this.doZero(arg0Value, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(arg0Value, arg1Value));
        }

        private Object executeAndSpecialize(LLVMManagedPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg1Value == 1L) {
                this.state_0_ = state_0 |= 2;
                return this.doIdentity(arg0Value, arg1Value);
            }
            if (arg1Value == 0L) {
                this.state_0_ = state_0 |= 4;
                return this.doZero(arg0Value, arg1Value);
            }
            if (LLVMArithmeticNode.ManagedMulNode.isMinusOne(arg1Value)) {
                this.state_0_ = state_0 |= 8;
                return this.doNegate(arg0Value, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmeticNode.ManagedMulNode create() {
            return new ManagedMulNodeGen();
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMFP128ArithmeticNode.class)
    public static final class LLVMFP128ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMFP128ArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private Do128BitFloatData do128BitFloat_cache;

        private LLVMFP128ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0 && leftNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat leftNodeValue_ = (LLVM128BitFloat)leftNodeValue;
                if (rightNodeValue instanceof LLVM128BitFloat) {
                    LLVM128BitFloat rightNodeValue_ = (LLVM128BitFloat)rightNodeValue;
                    Do128BitFloatData s0_ = this.do128BitFloat_cache;
                    if (s0_ != null) {
                        return this.do128BitFloat(leftNodeValue_, rightNodeValue_, s0_.node_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0 && leftNodeValue_ instanceof LLVM128BitFloat) {
                LLVM128BitFloat leftNodeValue__ = (LLVM128BitFloat)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat rightNodeValue__ = (LLVM128BitFloat)rightNodeValue_;
                    Do128BitFloatData s0_ = this.do128BitFloat_cache;
                    if (s0_ != null) {
                        return this.do128BitFloat(leftNodeValue__, rightNodeValue__, s0_.node_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private LLVMLongDoubleFloatingPoint executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat leftNodeValue_ = (LLVM128BitFloat)leftNodeValue;
                if (rightNodeValue instanceof LLVM128BitFloat) {
                    LLVM128BitFloat rightNodeValue_ = (LLVM128BitFloat)rightNodeValue;
                    Do128BitFloatData s0_ = (Do128BitFloatData)this.insert(new Do128BitFloatData());
                    s0_.node_ = (LLVMLongDoubleNode)s0_.insert(this.createFP128Node());
                    VarHandle.storeStoreFence();
                    this.do128BitFloat_cache = s0_;
                    this.state_0_ = state_0 |= 2;
                    return this.do128BitFloat(leftNodeValue_, rightNodeValue_, s0_.node_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            Do128BitFloatData s0_ = (Do128BitFloatData)this.insert(new Do128BitFloatData());
            s0_.node_ = (LLVMLongDoubleNode)s0_.insert(this.createFP128Node());
            VarHandle.storeStoreFence();
            this.do128BitFloat_cache = s0_;
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.do128BitFloat_cache = null;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMFP128ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMFP128ArithmeticNodeGen(op, leftNode, rightNode);
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMFP128ArithmeticNode.class)
        @DenyReplace
        private static final class Do128BitFloatData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMLongDoubleNode node_;

            Do128BitFloatData() {
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMFP80ArithmeticNode.class)
    public static final class LLVMFP80ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMFP80ArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private Do80BitFloatData do80BitFloat_cache;

        private LLVMFP80ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0 && leftNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat leftNodeValue_ = (LLVM80BitFloat)leftNodeValue;
                if (rightNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat rightNodeValue_ = (LLVM80BitFloat)rightNodeValue;
                    Do80BitFloatData s0_ = this.do80BitFloat_cache;
                    if (s0_ != null) {
                        return this.do80BitFloat(leftNodeValue_, rightNodeValue_, s0_.node_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0 && leftNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat leftNodeValue__ = (LLVM80BitFloat)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat rightNodeValue__ = (LLVM80BitFloat)rightNodeValue_;
                    Do80BitFloatData s0_ = this.do80BitFloat_cache;
                    if (s0_ != null) {
                        return this.do80BitFloat(leftNodeValue__, rightNodeValue__, s0_.node_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private LLVMLongDoubleFloatingPoint executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat leftNodeValue_ = (LLVM80BitFloat)leftNodeValue;
                if (rightNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat rightNodeValue_ = (LLVM80BitFloat)rightNodeValue;
                    Do80BitFloatData s0_ = (Do80BitFloatData)this.insert(new Do80BitFloatData());
                    s0_.node_ = (LLVMLongDoubleNode)s0_.insert(this.createFP80Node());
                    VarHandle.storeStoreFence();
                    this.do80BitFloat_cache = s0_;
                    this.state_0_ = state_0 |= 2;
                    return this.do80BitFloat(leftNodeValue_, rightNodeValue_, s0_.node_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            Do80BitFloatData s0_ = (Do80BitFloatData)this.insert(new Do80BitFloatData());
            s0_.node_ = (LLVMLongDoubleNode)s0_.insert(this.createFP80Node());
            VarHandle.storeStoreFence();
            this.do80BitFloat_cache = s0_;
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.do80BitFloat_cache = null;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMFP80ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMFP80ArithmeticNodeGen(op, leftNode, rightNode);
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMFP80ArithmeticNode.class)
        @DenyReplace
        private static final class Do80BitFloatData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMLongDoubleNode node_;

            Do80BitFloatData() {
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMDoubleArithmeticNode.class)
    public static final class LLVMDoubleArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMDoubleArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMDoubleArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0 && leftNodeValue instanceof Double) {
                double leftNodeValue_ = (Double)leftNodeValue;
                if (rightNodeValue instanceof Double) {
                    double rightNodeValue_ = (Double)rightNodeValue;
                    return this.doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            double rightNodeValue_;
            double leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doDouble(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            double rightNodeValue_;
            double leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doDouble(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private double executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftNodeValue instanceof Double) {
                double leftNodeValue_ = (Double)leftNodeValue;
                if (rightNodeValue instanceof Double) {
                    double rightNodeValue_ = (Double)rightNodeValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMDoubleArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMDoubleArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMFloatArithmeticNode.class)
    public static final class LLVMFloatArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMFloatArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMFloatArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return Float.valueOf(this.executeAndSpecialize(leftNodeValue, rightNodeValue));
            }
            if ((state_0 & 2) != 0 && leftNodeValue instanceof Float) {
                float leftNodeValue_ = ((Float)leftNodeValue).floatValue();
                if (rightNodeValue instanceof Float) {
                    float rightNodeValue_ = ((Float)rightNodeValue).floatValue();
                    return Float.valueOf(this.doFloat(leftNodeValue_, rightNodeValue_));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(leftNodeValue, rightNodeValue));
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            float rightNodeValue_;
            float leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return Float.valueOf(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            try {
                rightNodeValue_ = this.rightNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return Float.valueOf(this.executeAndSpecialize(Float.valueOf(leftNodeValue_), ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return Float.valueOf(this.executeAndSpecialize(Float.valueOf(leftNodeValue_), Float.valueOf(rightNodeValue_)));
            }
            if ((state_0 & 2) != 0) {
                return Float.valueOf(this.doFloat(leftNodeValue_, rightNodeValue_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(Float.valueOf(leftNodeValue_), Float.valueOf(rightNodeValue_)));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            float rightNodeValue_;
            float leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(Float.valueOf(leftNodeValue_), ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(leftNodeValue_), Float.valueOf(rightNodeValue_));
            }
            if ((state_0 & 2) != 0) {
                return this.doFloat(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(leftNodeValue_), Float.valueOf(rightNodeValue_));
        }

        private float executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftNodeValue instanceof Float) {
                float leftNodeValue_ = ((Float)leftNodeValue).floatValue();
                if (rightNodeValue instanceof Float) {
                    float rightNodeValue_ = ((Float)rightNodeValue).floatValue();
                    this.state_0_ = state_0 |= 2;
                    return this.doFloat(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMFloatArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMFloatArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMIVarBitArithmeticNode.class)
    public static final class LLVMIVarBitArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMIVarBitArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMIVarBitArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x1C) >>> 2, leftNodeValue)) {
                LLVMIVarBit leftNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x1C) >>> 2, leftNodeValue);
                if (LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE0) >>> 5, rightNodeValue)) {
                    LLVMIVarBit rightNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE0) >>> 5, rightNodeValue);
                    return this.doVarBit(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x1C) >>> 2, leftNodeValue_)) {
                LLVMIVarBit leftNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x1C) >>> 2, leftNodeValue_);
                if (LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE0) >>> 5, rightNodeValue_)) {
                    LLVMIVarBit rightNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE0) >>> 5, rightNodeValue_);
                    return this.doVarBit(leftNodeValue__, rightNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int lLVMIVarBitCast0;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(leftNodeValue)) != 0) {
                LLVMIVarBit leftNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, leftNodeValue);
                int lLVMIVarBitCast1 = LLVMTypesGen.specializeImplicitLLVMIVarBit(rightNodeValue);
                if (lLVMIVarBitCast1 != 0) {
                    LLVMIVarBit rightNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast1, rightNodeValue);
                    state_0 |= lLVMIVarBitCast0 << 2;
                    state_0 |= lLVMIVarBitCast1 << 5;
                    this.state_0_ = state_0 |= 2;
                    return this.doVarBit(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            state_0 |= 1;
            this.state_0_ = state_0 |= 0xFC;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMIVarBitArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMIVarBitArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
    static final class LLVMI64SubNodeGen
    extends LLVMArithmeticNode.LLVMI64SubNode
    implements GenerateAOT.Provider {
        static final InlineSupport.ReferenceField<SameObjectLongData> SAME_OBJECT_LONG_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"sameObjectLong_cache", SameObjectLongData.class);
        static final InlineSupport.ReferenceField<NotSameObjectData> NOT_SAME_OBJECT_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"notSameObject_cache", NotSameObjectData.class);
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node leftNode_;
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ManagedLeftLongData managedLeftLong_cache;
        @Node.Child
        private ManagedLeftData managedLeft_cache;
        @Node.Child
        private ManagedRightLongData managedRightLong_cache;
        @Node.Child
        private ManagedRightData managedRight_cache;
        @Node.Child
        private LLVMNativePointerSupport.ToNativePointerNode pointerRight_toNativePointerRight_;
        @Node.Child
        private LLVMNativePointerSupport.ToNativePointerNode pointerLeft_toNativePointerLeft_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private SameObjectLongData sameObjectLong_cache;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private NotSameObjectData notSameObject_cache;

        private LLVMI64SubNodeGen(LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            this.leftNode_ = this.createCast(leftNode);
            this.rightNode_ = this.createCast(rightNode);
        }

        @Override
        @ExplodeLoop
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 0xFB6) != 0) {
                if ((state_0 & 0x16) != 0 && rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    if ((state_0 & 2) != 0 && leftNodeValue instanceof Long) {
                        long leftNodeValue_ = (Long)leftNodeValue;
                        return this.doLong(leftNodeValue_, rightNodeValue_);
                    }
                    if ((state_0 & 0x14) != 0 && LLVMTypes.isManagedPointer(leftNodeValue)) {
                        ManagedLeftData s2_;
                        ManagedLeftLongData s1_;
                        LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                        if ((state_0 & 4) != 0 && (s1_ = this.managedLeftLong_cache) != null && this.canDoManaged(rightNodeValue_)) {
                            try {
                                return this.doManagedLeftLong(leftNodeValue_, rightNodeValue_, s1_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                this.managedLeftLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x10) != 0 && (s2_ = this.managedLeft_cache) != null && this.canDoManaged(rightNodeValue_)) {
                            return this.doManagedLeft(leftNodeValue_, rightNodeValue_, s2_.node_);
                        }
                    }
                }
                if ((state_0 & 0x1A0) != 0 && leftNodeValue instanceof Long) {
                    LLVMPointer rightNodeValue_;
                    long leftNodeValue_ = (Long)leftNodeValue;
                    if ((state_0 & 0xA0) != 0 && LLVMTypes.isManagedPointer(rightNodeValue)) {
                        ManagedRightData s4_;
                        ManagedRightLongData s3_;
                        rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                        if ((state_0 & 0x20) != 0 && (s3_ = this.managedRightLong_cache) != null && this.canDoManaged(leftNodeValue_)) {
                            try {
                                return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s3_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                this.managedRightLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x80) != 0 && (s4_ = this.managedRight_cache) != null && this.canDoManaged(leftNodeValue_)) {
                            return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s4_.node_);
                        }
                    }
                    if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue)) {
                        rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                        if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue_)) {
                            return this.doPointerRight(leftNodeValue_, rightNodeValue_, toNativePointerRight__);
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue)) {
                    LLVMPointer leftNodeValue_ = LLVMTypes.asPointer(leftNodeValue);
                    if (rightNodeValue instanceof Long) {
                        long rightNodeValue_ = (Long)rightNodeValue;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue_)) {
                            return this.doPointerLeft(leftNodeValue_, rightNodeValue_, toNativePointerLeft__);
                        }
                    }
                }
                if ((state_0 & 0xC00) != 0 && LLVMTypes.isManagedPointer(leftNodeValue)) {
                    LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                    if (LLVMTypes.isManagedPointer(rightNodeValue)) {
                        LLVMManagedPointer rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                        if ((state_0 & 0x400) != 0) {
                            SameObjectLongData s7_ = this.sameObjectLong_cache;
                            while (s7_ != null) {
                                if (s7_.sameObject_.execute(leftNodeValue_.getObject(), rightNodeValue_.getObject())) {
                                    return this.doSameObjectLong(leftNodeValue_, rightNodeValue_, s7_.sameObject_);
                                }
                                s7_ = s7_.next_;
                            }
                        }
                        if ((state_0 & 0x800) != 0) {
                            NotSameObjectData s8_ = this.notSameObject_cache;
                            while (s8_ != null) {
                                if (!s8_.sameObject_.execute(leftNodeValue_.getObject(), rightNodeValue_.getObject())) {
                                    return this.doNotSameObject(leftNodeValue_, rightNodeValue_, s8_.sameObject_, s8_.toNativePointerLeft_, s8_.toNativePointerRight_);
                                }
                                s8_ = s8_.next_;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFB4) == 0 && (state_0 & 0xFB6) != 0) {
                return this.executeGeneric_long_long0(state_0, frameValue);
            }
            if ((state_0 & 0xDA2) == 0 && (state_0 & 0xFB6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue);
            }
            if ((state_0 & 0xE16) == 0 && (state_0 & 0xFB6) != 0) {
                return this.executeGeneric_long2(state_0, frameValue);
            }
            return this.executeGeneric_generic3(state_0, frameValue);
        }

        private Object executeGeneric_long_long0(int state_0__, VirtualFrame frameValue) {
            long rightNodeValue_;
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            long rightNodeValue_;
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x214) != 0) {
                LLVMPointer leftNodeValue__;
                if ((state_0 & 0x14) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    ManagedLeftData s2_;
                    ManagedLeftLongData s1_;
                    leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if ((state_0 & 4) != 0 && (s1_ = this.managedLeftLong_cache) != null && this.canDoManaged(rightNodeValue_)) {
                        try {
                            return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, s1_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.managedLeftLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if ((state_0 & 0x10) != 0 && (s2_ = this.managedLeft_cache) != null && this.canDoManaged(rightNodeValue_)) {
                        return this.doManagedLeft((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, s2_.node_);
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                    if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue_)) {
                        return this.doPointerLeft(leftNodeValue__, rightNodeValue_, toNativePointerLeft__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private Object executeGeneric_long2(int state_0__, VirtualFrame frameValue) {
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x1A0) != 0) {
                LLVMPointer rightNodeValue__;
                if ((state_0 & 0xA0) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    ManagedRightData s4_;
                    ManagedRightLongData s3_;
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if ((state_0 & 0x20) != 0 && (s3_ = this.managedRightLong_cache) != null && this.canDoManaged(leftNodeValue_)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.managedRightLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if ((state_0 & 0x80) != 0 && (s4_ = this.managedRight_cache) != null && this.canDoManaged(leftNodeValue_)) {
                        return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, s4_.node_);
                    }
                }
                if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                    if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue_)) {
                        return this.doPointerRight(leftNodeValue_, rightNodeValue__, toNativePointerRight__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @ExplodeLoop
        private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0xFB6) != 0) {
                if ((state_0 & 0x16) != 0 && rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state_0 & 2) != 0 && leftNodeValue_ instanceof Long) {
                        long leftNodeValue__ = (Long)leftNodeValue_;
                        return this.doLong(leftNodeValue__, rightNodeValue__);
                    }
                    if ((state_0 & 0x14) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                        ManagedLeftData s2_;
                        ManagedLeftLongData s1_;
                        LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                        if ((state_0 & 4) != 0 && (s1_ = this.managedLeftLong_cache) != null && this.canDoManaged(rightNodeValue__)) {
                            try {
                                return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, s1_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                this.managedLeftLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x10) != 0 && (s2_ = this.managedLeft_cache) != null && this.canDoManaged(rightNodeValue__)) {
                            return this.doManagedLeft(leftNodeValue__, rightNodeValue__, s2_.node_);
                        }
                    }
                }
                if ((state_0 & 0x1A0) != 0 && leftNodeValue_ instanceof Long) {
                    LLVMPointer rightNodeValue__;
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    if ((state_0 & 0xA0) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                        ManagedRightData s4_;
                        ManagedRightLongData s3_;
                        rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                        if ((state_0 & 0x20) != 0 && (s3_ = this.managedRightLong_cache) != null && this.canDoManaged(leftNodeValue__)) {
                            try {
                                return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                this.managedRightLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x80) != 0 && (s4_ = this.managedRight_cache) != null && this.canDoManaged(leftNodeValue__)) {
                            return this.doManagedRight(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, s4_.node_);
                        }
                    }
                    if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                        rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                        if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue__)) {
                            return this.doPointerRight(leftNodeValue__, rightNodeValue__, toNativePointerRight__);
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    if (rightNodeValue_ instanceof Long) {
                        long rightNodeValue__ = (Long)rightNodeValue_;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue__)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue__, toNativePointerLeft__);
                        }
                    }
                }
                if ((state_0 & 0xC00) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if (LLVMTypes.isManagedPointer(rightNodeValue_)) {
                        LLVMManagedPointer rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                        if ((state_0 & 0x400) != 0) {
                            SameObjectLongData s7_ = this.sameObjectLong_cache;
                            while (s7_ != null) {
                                if (s7_.sameObject_.execute(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                    return this.doSameObjectLong(leftNodeValue__, rightNodeValue__, s7_.sameObject_);
                                }
                                s7_ = s7_.next_;
                            }
                        }
                        if ((state_0 & 0x800) != 0) {
                            NotSameObjectData s8_ = this.notSameObject_cache;
                            while (s8_ != null) {
                                if (!s8_.sameObject_.execute(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                    return this.doNotSameObject(leftNodeValue__, rightNodeValue__, s8_.sameObject_, s8_.toNativePointerLeft_, s8_.toNativePointerRight_);
                                }
                                s8_ = s8_.next_;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0x90) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state_0 & 0xF24) == 0 && (state_0 & 0xF26) != 0) {
                return this.executeI64_long_long4(state_0, frameValue);
            }
            if ((state_0 & 0xD22) == 0 && (state_0 & 0xF26) != 0) {
                return this.executeI64_long5(state_0, frameValue);
            }
            if ((state_0 & 0xE06) == 0 && (state_0 & 0xF26) != 0) {
                return this.executeI64_long6(state_0, frameValue);
            }
            return this.executeI64_generic7(state_0, frameValue);
        }

        private long executeI64_long_long4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long rightNodeValue_;
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            assert ((state_0 & 2) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        private long executeI64_long5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long rightNodeValue_;
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            if ((state_0 & 0x204) != 0) {
                LLVMPointer leftNodeValue__;
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    ManagedLeftLongData s1_ = this.managedLeftLong_cache;
                    if (s1_ != null && this.canDoManaged(rightNodeValue_)) {
                        try {
                            return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, s1_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.managedLeftLong_cache = null;
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                    if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue_)) {
                        return this.doPointerLeft(leftNodeValue__, rightNodeValue_, toNativePointerLeft__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        private long executeI64_long6(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            if ((state_0 & 0x120) != 0) {
                LLVMPointer rightNodeValue__;
                if ((state_0 & 0x20) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    ManagedRightLongData s3_ = this.managedRightLong_cache;
                    if (s3_ != null && this.canDoManaged(leftNodeValue_)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.managedRightLong_cache = null;
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
                if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                    if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue_)) {
                        return this.doPointerRight(leftNodeValue_, rightNodeValue__, toNativePointerRight__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        @ExplodeLoop
        private long executeI64_generic7(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            if ((state_0 & 0xF26) != 0) {
                if ((state_0 & 6) != 0 && rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state_0 & 2) != 0 && leftNodeValue_ instanceof Long) {
                        long leftNodeValue__ = (Long)leftNodeValue_;
                        return this.doLong(leftNodeValue__, rightNodeValue__);
                    }
                    if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                        LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                        ManagedLeftLongData s1_ = this.managedLeftLong_cache;
                        if (s1_ != null && this.canDoManaged(rightNodeValue__)) {
                            try {
                                return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, s1_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                this.managedLeftLong_cache = null;
                                return LLVMTypesGen.expectLong(ex.getResult());
                            }
                        }
                    }
                }
                if ((state_0 & 0x120) != 0 && leftNodeValue_ instanceof Long) {
                    LLVMPointer rightNodeValue__;
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    if ((state_0 & 0x20) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                        rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                        ManagedRightLongData s3_ = this.managedRightLong_cache;
                        if (s3_ != null && this.canDoManaged(leftNodeValue__)) {
                            try {
                                return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                this.managedRightLong_cache = null;
                                return LLVMTypesGen.expectLong(ex.getResult());
                            }
                        }
                    }
                    if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                        rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                        if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue__)) {
                            return this.doPointerRight(leftNodeValue__, rightNodeValue__, toNativePointerRight__);
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    if (rightNodeValue_ instanceof Long) {
                        long rightNodeValue__ = (Long)rightNodeValue_;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue__)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue__, toNativePointerLeft__);
                        }
                    }
                }
                if ((state_0 & 0xC00) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if (LLVMTypes.isManagedPointer(rightNodeValue_)) {
                        LLVMManagedPointer rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                        if ((state_0 & 0x400) != 0) {
                            SameObjectLongData s7_ = this.sameObjectLong_cache;
                            while (s7_ != null) {
                                if (s7_.sameObject_.execute(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                    return this.doSameObjectLong(leftNodeValue__, rightNodeValue__, s7_.sameObject_);
                                }
                                s7_ = s7_.next_;
                            }
                        }
                        if ((state_0 & 0x800) != 0) {
                            NotSameObjectData s8_ = this.notSameObject_cache;
                            while (s8_ != null) {
                                if (!s8_.sameObject_.execute(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                    return this.doNotSameObject(leftNodeValue__, rightNodeValue__, s8_.sameObject_, s8_.toNativePointerLeft_, s8_.toNativePointerRight_);
                                }
                                s8_ = s8_.next_;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        @Override
        public long executeLongWithTarget(long leftNodeValue, long rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return (Long)this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0) {
                return this.doLong(leftNodeValue, rightNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Long)this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (rightNodeValue instanceof Long) {
                long rightNodeValue_ = (Long)rightNodeValue;
                if (leftNodeValue instanceof Long) {
                    long leftNodeValue_ = (Long)leftNodeValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doLong(leftNodeValue_, rightNodeValue_);
                }
                if (LLVMTypes.isManagedPointer(leftNodeValue)) {
                    LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                    if ((state_0 & 0x10) == 0 && (state_0 & 8) == 0 && this.canDoManaged(rightNodeValue_)) {
                        ManagedLeftLongData s1_ = (ManagedLeftLongData)this.insert(new ManagedLeftLongData());
                        s1_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s1_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedLeftLong_cache = s1_;
                        this.state_0_ = state_0 |= 4;
                        try {
                            return this.doManagedLeftLong(leftNodeValue_, rightNodeValue_, s1_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.managedLeftLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if (this.canDoManaged(rightNodeValue_)) {
                        ManagedLeftData s2_ = (ManagedLeftData)this.insert(new ManagedLeftData());
                        s2_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s2_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedLeft_cache = s2_;
                        this.managedLeftLong_cache = null;
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doManagedLeft(leftNodeValue_, rightNodeValue_, s2_.node_);
                    }
                }
            }
            if (leftNodeValue instanceof Long) {
                LLVMPointer rightNodeValue_;
                long leftNodeValue_ = (Long)leftNodeValue;
                if (LLVMTypes.isManagedPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                    if ((state_0 & 0x80) == 0 && (state_0 & 0x40) == 0 && this.canDoManaged(leftNodeValue_)) {
                        ManagedRightLongData s3_ = (ManagedRightLongData)this.insert(new ManagedRightLongData());
                        s3_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s3_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedRightLong_cache = s3_;
                        this.state_0_ = state_0 |= 0x20;
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s3_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.managedRightLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if (this.canDoManaged(leftNodeValue_)) {
                        ManagedRightData s4_ = (ManagedRightData)this.insert(new ManagedRightData());
                        s4_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s4_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedRight_cache = s4_;
                        this.managedRightLong_cache = null;
                        state_0 &= 0xFFFFFFDF;
                        this.state_0_ = state_0 |= 0x80;
                        return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s4_.node_);
                    }
                }
                if (LLVMTypes.isPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                    if (!this.canDoManaged(leftNodeValue_)) {
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                        Objects.requireNonNull(toNativePointerRight__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.pointerRight_toNativePointerRight_ = toNativePointerRight__;
                        this.state_0_ = state_0 |= 0x100;
                        return this.doPointerRight(leftNodeValue_, rightNodeValue_, toNativePointerRight__);
                    }
                }
            }
            if (LLVMTypes.isPointer(leftNodeValue)) {
                long rightNodeValue_;
                LLVMPointer leftNodeValue_ = LLVMTypes.asPointer(leftNodeValue);
                if (rightNodeValue instanceof Long && !this.canDoManaged(rightNodeValue_ = ((Long)rightNodeValue).longValue())) {
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                    Objects.requireNonNull(toNativePointerLeft__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.pointerLeft_toNativePointerLeft_ = toNativePointerLeft__;
                    this.state_0_ = state_0 |= 0x200;
                    return this.doPointerLeft(leftNodeValue_, rightNodeValue_, toNativePointerLeft__);
                }
            }
            if (LLVMTypes.isManagedPointer(leftNodeValue)) {
                LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                if (LLVMTypes.isManagedPointer(rightNodeValue)) {
                    NotSameObjectData s8_;
                    LLVMManagedPointer rightNodeValue_;
                    block27: {
                        NotSameObjectData s8_original;
                        SameObjectLongData s7_;
                        block26: {
                            SameObjectLongData s7_original;
                            rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                            do {
                                LLVMSameObjectNode sameObject__;
                                int count7_ = 0;
                                s7_original = s7_ = (SameObjectLongData)((Object)SAME_OBJECT_LONG_CACHE_UPDATER.getVolatile((Node)this));
                                while (s7_ != null && !s7_.sameObject_.execute(leftNodeValue_.getObject(), rightNodeValue_.getObject())) {
                                    ++count7_;
                                    s7_ = s7_.next_;
                                }
                                if (s7_ != null || !(sameObject__ = (LLVMSameObjectNode)this.insert(LLVMSameObjectNodeGen.create())).execute(leftNodeValue_.getObject(), rightNodeValue_.getObject()) || count7_ >= 3) break block26;
                                s7_ = (SameObjectLongData)this.insert(new SameObjectLongData(s7_original));
                                Objects.requireNonNull((LLVMSameObjectNode)s7_.insert(sameObject__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s7_.sameObject_ = sameObject__;
                            } while (!SAME_OBJECT_LONG_CACHE_UPDATER.compareAndSet((Node)this, (Object)s7_original, (Object)s7_));
                            this.state_0_ = state_0 |= 0x400;
                        }
                        if (s7_ != null) {
                            return this.doSameObjectLong(leftNodeValue_, rightNodeValue_, s7_.sameObject_);
                        }
                        do {
                            LLVMSameObjectNode sameObject__1;
                            int count8_ = 0;
                            s8_original = s8_ = (NotSameObjectData)((Object)NOT_SAME_OBJECT_CACHE_UPDATER.getVolatile((Node)this));
                            while (s8_ != null && s8_.sameObject_.execute(leftNodeValue_.getObject(), rightNodeValue_.getObject())) {
                                ++count8_;
                                s8_ = s8_.next_;
                            }
                            if (s8_ != null || (sameObject__1 = (LLVMSameObjectNode)this.insert(LLVMSameObjectNodeGen.create())).execute(leftNodeValue_.getObject(), rightNodeValue_.getObject()) || count8_ >= 3) break block27;
                            s8_ = (NotSameObjectData)this.insert(new NotSameObjectData(s8_original));
                            Objects.requireNonNull((LLVMSameObjectNode)s8_.insert(sameObject__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s8_.sameObject_ = sameObject__1;
                            LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__1 = (LLVMNativePointerSupport.ToNativePointerNode)s8_.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                            Objects.requireNonNull(toNativePointerLeft__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s8_.toNativePointerLeft_ = toNativePointerLeft__1;
                            LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__1 = (LLVMNativePointerSupport.ToNativePointerNode)s8_.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                            Objects.requireNonNull(toNativePointerRight__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s8_.toNativePointerRight_ = toNativePointerRight__1;
                        } while (!NOT_SAME_OBJECT_CACHE_UPDATER.compareAndSet((Node)this, (Object)s8_original, (Object)s8_));
                        this.state_0_ = state_0 |= 0x800;
                    }
                    if (s8_ != null) {
                        return this.doNotSameObject(leftNodeValue_, rightNodeValue_, s8_.sameObject_, s8_.toNativePointerLeft_, s8_.toNativePointerRight_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            ManagedLeftData s2_ = (ManagedLeftData)this.insert(new ManagedLeftData());
            s2_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s2_.insert(this.createManagedNode());
            VarHandle.storeStoreFence();
            this.managedLeft_cache = s2_;
            this.managedLeftLong_cache = null;
            this.state_0_ &= 0xFFFFFFFB;
            this.state_0_ |= 0x10;
            ManagedRightData s4_ = (ManagedRightData)this.insert(new ManagedRightData());
            s4_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s4_.insert(this.createManagedNode());
            VarHandle.storeStoreFence();
            this.managedRight_cache = s4_;
            this.managedRightLong_cache = null;
            this.state_0_ &= 0xFFFFFFDF;
            this.state_0_ |= 0x80;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerRight__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.pointerRight_toNativePointerRight_ = toNativePointerRight__;
            assert (NodeUtil.assertRecursion((Node)this.pointerRight_toNativePointerRight_, (int)1));
            ((GenerateAOT.Provider)this.pointerRight_toNativePointerRight_).prepareForAOT(language, root);
            this.state_0_ |= 0x100;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerLeft__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.pointerLeft_toNativePointerLeft_ = toNativePointerLeft__;
            assert (NodeUtil.assertRecursion((Node)this.pointerLeft_toNativePointerLeft_, (int)1));
            ((GenerateAOT.Provider)this.pointerLeft_toNativePointerLeft_).prepareForAOT(language, root);
            this.state_0_ |= 0x200;
            SameObjectLongData s7_ = (SameObjectLongData)this.insert(new SameObjectLongData(this.sameObjectLong_cache));
            LLVMSameObjectNode sameObject__ = (LLVMSameObjectNode)s7_.insert(LLVMSameObjectNodeGen.create());
            Objects.requireNonNull(sameObject__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s7_.sameObject_ = sameObject__;
            VarHandle.storeStoreFence();
            this.sameObjectLong_cache = s7_;
            assert (NodeUtil.assertRecursion((Node)s7_.sameObject_, (int)1));
            ((GenerateAOT.Provider)s7_.sameObject_).prepareForAOT(language, root);
            this.state_0_ |= 0x400;
            NotSameObjectData s8_ = (NotSameObjectData)this.insert(new NotSameObjectData(this.notSameObject_cache));
            LLVMSameObjectNode sameObject__1 = (LLVMSameObjectNode)s8_.insert(LLVMSameObjectNodeGen.create());
            Objects.requireNonNull(sameObject__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s8_.sameObject_ = sameObject__1;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__1 = (LLVMNativePointerSupport.ToNativePointerNode)s8_.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerLeft__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s8_.toNativePointerLeft_ = toNativePointerLeft__1;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__1 = (LLVMNativePointerSupport.ToNativePointerNode)s8_.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerRight__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s8_.toNativePointerRight_ = toNativePointerRight__1;
            VarHandle.storeStoreFence();
            this.notSameObject_cache = s8_;
            assert (NodeUtil.assertRecursion((Node)s8_.sameObject_, (int)1));
            ((GenerateAOT.Provider)s8_.sameObject_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s8_.toNativePointerLeft_, (int)1));
            ((GenerateAOT.Provider)s8_.toNativePointerLeft_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s8_.toNativePointerRight_, (int)1));
            ((GenerateAOT.Provider)s8_.toNativePointerRight_).prepareForAOT(language, root);
            this.state_0_ |= 0x800;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.managedLeft_cache = null;
            this.managedRight_cache = null;
            this.pointerRight_toNativePointerRight_ = null;
            this.pointerLeft_toNativePointerLeft_ = null;
            this.sameObjectLong_cache = null;
            this.notSameObject_cache = null;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMI64SubNode create(LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI64SubNodeGen(leftNode, rightNode);
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        @DenyReplace
        private static final class ManagedLeftLongData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedLeftLongData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        @DenyReplace
        private static final class ManagedLeftData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedLeftData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        @DenyReplace
        private static final class ManagedRightLongData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedRightLongData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        @DenyReplace
        private static final class ManagedRightData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedRightData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        @DenyReplace
        private static final class SameObjectLongData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            SameObjectLongData next_;
            @Node.Child
            LLVMSameObjectNode sameObject_;

            SameObjectLongData(SameObjectLongData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        @DenyReplace
        private static final class NotSameObjectData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            NotSameObjectData next_;
            @Node.Child
            LLVMSameObjectNode sameObject_;
            @Node.Child
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft_;
            @Node.Child
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight_;

            NotSameObjectData(NotSameObjectData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
    static final class LLVMI64ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI64ArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node leftNode_;
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ManagedLeftLongData managedLeftLong_cache;
        @Node.Child
        private ManagedLeftData managedLeft_cache;
        @Node.Child
        private ManagedRightLongData managedRightLong_cache;
        @Node.Child
        private ManagedRightData managedRight_cache;
        @Node.Child
        private LLVMNativePointerSupport.ToNativePointerNode pointerRight_toNativePointerRight_;
        @Node.Child
        private LLVMNativePointerSupport.ToNativePointerNode pointerLeft_toNativePointerLeft_;
        @Node.Child
        private PointerData pointer_cache;

        private LLVMI64ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = this.createCast(leftNode);
            this.rightNode_ = this.createCast(rightNode);
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 0x7B6) != 0) {
                if ((state_0 & 0x16) != 0 && rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    if ((state_0 & 2) != 0 && leftNodeValue instanceof Long) {
                        long leftNodeValue_ = (Long)leftNodeValue;
                        return this.doLong(leftNodeValue_, rightNodeValue_);
                    }
                    if ((state_0 & 0x14) != 0 && LLVMTypes.isManagedPointer(leftNodeValue)) {
                        ManagedLeftData s2_;
                        ManagedLeftLongData s1_;
                        LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                        if ((state_0 & 4) != 0 && (s1_ = this.managedLeftLong_cache) != null && this.canDoManaged(rightNodeValue_)) {
                            try {
                                return this.doManagedLeftLong(leftNodeValue_, rightNodeValue_, s1_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                this.managedLeftLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x10) != 0 && (s2_ = this.managedLeft_cache) != null && this.canDoManaged(rightNodeValue_)) {
                            return this.doManagedLeft(leftNodeValue_, rightNodeValue_, s2_.node_);
                        }
                    }
                }
                if ((state_0 & 0x1A0) != 0 && leftNodeValue instanceof Long) {
                    LLVMPointer rightNodeValue_;
                    long leftNodeValue_ = (Long)leftNodeValue;
                    if ((state_0 & 0xA0) != 0 && LLVMTypes.isManagedPointer(rightNodeValue)) {
                        ManagedRightData s4_;
                        ManagedRightLongData s3_;
                        rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                        if ((state_0 & 0x20) != 0 && (s3_ = this.managedRightLong_cache) != null && this.canDoManaged(leftNodeValue_)) {
                            try {
                                return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s3_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                this.managedRightLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x80) != 0 && (s4_ = this.managedRight_cache) != null && this.canDoManaged(leftNodeValue_)) {
                            return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s4_.node_);
                        }
                    }
                    if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue)) {
                        rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                        if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue_)) {
                            return this.doPointerRight(leftNodeValue_, rightNodeValue_, toNativePointerRight__);
                        }
                    }
                }
                if ((state_0 & 0x600) != 0 && LLVMTypes.isPointer(leftNodeValue)) {
                    LLVMPointer leftNodeValue_ = LLVMTypes.asPointer(leftNodeValue);
                    if ((state_0 & 0x200) != 0 && rightNodeValue instanceof Long) {
                        long rightNodeValue_ = (Long)rightNodeValue;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue_)) {
                            return this.doPointerLeft(leftNodeValue_, rightNodeValue_, toNativePointerLeft__);
                        }
                    }
                    if ((state_0 & 0x400) != 0 && LLVMTypes.isPointer(rightNodeValue)) {
                        LLVMPointer rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                        PointerData s7_ = this.pointer_cache;
                        if (s7_ != null) {
                            return this.doPointer(leftNodeValue_, rightNodeValue_, s7_.toNativePointerLeft_, s7_.toNativePointerRight_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7B4) == 0 && (state_0 & 0x7B6) != 0) {
                return this.executeGeneric_long_long0(state_0, frameValue);
            }
            if ((state_0 & 0x5A2) == 0 && (state_0 & 0x7B6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue);
            }
            if ((state_0 & 0x616) == 0 && (state_0 & 0x7B6) != 0) {
                return this.executeGeneric_long2(state_0, frameValue);
            }
            return this.executeGeneric_generic3(state_0, frameValue);
        }

        private Object executeGeneric_long_long0(int state_0__, VirtualFrame frameValue) {
            long rightNodeValue_;
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            long rightNodeValue_;
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x214) != 0) {
                LLVMPointer leftNodeValue__;
                if ((state_0 & 0x14) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    ManagedLeftData s2_;
                    ManagedLeftLongData s1_;
                    leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if ((state_0 & 4) != 0 && (s1_ = this.managedLeftLong_cache) != null && this.canDoManaged(rightNodeValue_)) {
                        try {
                            return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, s1_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.managedLeftLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if ((state_0 & 0x10) != 0 && (s2_ = this.managedLeft_cache) != null && this.canDoManaged(rightNodeValue_)) {
                        return this.doManagedLeft((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, s2_.node_);
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                    if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue_)) {
                        return this.doPointerLeft(leftNodeValue__, rightNodeValue_, toNativePointerLeft__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private Object executeGeneric_long2(int state_0__, VirtualFrame frameValue) {
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x1A0) != 0) {
                LLVMPointer rightNodeValue__;
                if ((state_0 & 0xA0) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    ManagedRightData s4_;
                    ManagedRightLongData s3_;
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if ((state_0 & 0x20) != 0 && (s3_ = this.managedRightLong_cache) != null && this.canDoManaged(leftNodeValue_)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.managedRightLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if ((state_0 & 0x80) != 0 && (s4_ = this.managedRight_cache) != null && this.canDoManaged(leftNodeValue_)) {
                        return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, s4_.node_);
                    }
                }
                if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                    if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue_)) {
                        return this.doPointerRight(leftNodeValue_, rightNodeValue__, toNativePointerRight__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x7B6) != 0) {
                if ((state_0 & 0x16) != 0 && rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state_0 & 2) != 0 && leftNodeValue_ instanceof Long) {
                        long leftNodeValue__ = (Long)leftNodeValue_;
                        return this.doLong(leftNodeValue__, rightNodeValue__);
                    }
                    if ((state_0 & 0x14) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                        ManagedLeftData s2_;
                        ManagedLeftLongData s1_;
                        LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                        if ((state_0 & 4) != 0 && (s1_ = this.managedLeftLong_cache) != null && this.canDoManaged(rightNodeValue__)) {
                            try {
                                return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, s1_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                this.managedLeftLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x10) != 0 && (s2_ = this.managedLeft_cache) != null && this.canDoManaged(rightNodeValue__)) {
                            return this.doManagedLeft(leftNodeValue__, rightNodeValue__, s2_.node_);
                        }
                    }
                }
                if ((state_0 & 0x1A0) != 0 && leftNodeValue_ instanceof Long) {
                    LLVMPointer rightNodeValue__;
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    if ((state_0 & 0xA0) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                        ManagedRightData s4_;
                        ManagedRightLongData s3_;
                        rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                        if ((state_0 & 0x20) != 0 && (s3_ = this.managedRightLong_cache) != null && this.canDoManaged(leftNodeValue__)) {
                            try {
                                return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                this.managedRightLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x80) != 0 && (s4_ = this.managedRight_cache) != null && this.canDoManaged(leftNodeValue__)) {
                            return this.doManagedRight(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, s4_.node_);
                        }
                    }
                    if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                        rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                        if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue__)) {
                            return this.doPointerRight(leftNodeValue__, rightNodeValue__, toNativePointerRight__);
                        }
                    }
                }
                if ((state_0 & 0x600) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    if ((state_0 & 0x200) != 0 && rightNodeValue_ instanceof Long) {
                        long rightNodeValue__ = (Long)rightNodeValue_;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue__)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue__, toNativePointerLeft__);
                        }
                    }
                    if ((state_0 & 0x400) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                        LLVMPointer rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                        PointerData s7_ = this.pointer_cache;
                        if (s7_ != null) {
                            return this.doPointer(leftNodeValue__, rightNodeValue__, s7_.toNativePointerLeft_, s7_.toNativePointerRight_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0x90) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state_0 & 0x724) == 0 && (state_0 & 0x726) != 0) {
                return this.executeI64_long_long4(state_0, frameValue);
            }
            if ((state_0 & 0x522) == 0 && (state_0 & 0x726) != 0) {
                return this.executeI64_long5(state_0, frameValue);
            }
            if ((state_0 & 0x606) == 0 && (state_0 & 0x726) != 0) {
                return this.executeI64_long6(state_0, frameValue);
            }
            return this.executeI64_generic7(state_0, frameValue);
        }

        private long executeI64_long_long4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long rightNodeValue_;
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            assert ((state_0 & 2) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        private long executeI64_long5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long rightNodeValue_;
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            if ((state_0 & 0x204) != 0) {
                LLVMPointer leftNodeValue__;
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    ManagedLeftLongData s1_ = this.managedLeftLong_cache;
                    if (s1_ != null && this.canDoManaged(rightNodeValue_)) {
                        try {
                            return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, s1_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.managedLeftLong_cache = null;
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                    if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue_)) {
                        return this.doPointerLeft(leftNodeValue__, rightNodeValue_, toNativePointerLeft__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        private long executeI64_long6(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            if ((state_0 & 0x120) != 0) {
                LLVMPointer rightNodeValue__;
                if ((state_0 & 0x20) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    ManagedRightLongData s3_ = this.managedRightLong_cache;
                    if (s3_ != null && this.canDoManaged(leftNodeValue_)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.managedRightLong_cache = null;
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
                if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                    if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue_)) {
                        return this.doPointerRight(leftNodeValue_, rightNodeValue__, toNativePointerRight__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        private long executeI64_generic7(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            if ((state_0 & 0x726) != 0) {
                if ((state_0 & 6) != 0 && rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state_0 & 2) != 0 && leftNodeValue_ instanceof Long) {
                        long leftNodeValue__ = (Long)leftNodeValue_;
                        return this.doLong(leftNodeValue__, rightNodeValue__);
                    }
                    if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                        LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                        ManagedLeftLongData s1_ = this.managedLeftLong_cache;
                        if (s1_ != null && this.canDoManaged(rightNodeValue__)) {
                            try {
                                return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, s1_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                this.managedLeftLong_cache = null;
                                return LLVMTypesGen.expectLong(ex.getResult());
                            }
                        }
                    }
                }
                if ((state_0 & 0x120) != 0 && leftNodeValue_ instanceof Long) {
                    LLVMPointer rightNodeValue__;
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    if ((state_0 & 0x20) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                        rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                        ManagedRightLongData s3_ = this.managedRightLong_cache;
                        if (s3_ != null && this.canDoManaged(leftNodeValue__)) {
                            try {
                                return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                this.managedRightLong_cache = null;
                                return LLVMTypesGen.expectLong(ex.getResult());
                            }
                        }
                    }
                    if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                        rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                        if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue__)) {
                            return this.doPointerRight(leftNodeValue__, rightNodeValue__, toNativePointerRight__);
                        }
                    }
                }
                if ((state_0 & 0x600) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    if ((state_0 & 0x200) != 0 && rightNodeValue_ instanceof Long) {
                        long rightNodeValue__ = (Long)rightNodeValue_;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue__)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue__, toNativePointerLeft__);
                        }
                    }
                    if ((state_0 & 0x400) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                        LLVMPointer rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                        PointerData s7_ = this.pointer_cache;
                        if (s7_ != null) {
                            return this.doPointer(leftNodeValue__, rightNodeValue__, s7_.toNativePointerLeft_, s7_.toNativePointerRight_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        @Override
        public long executeLongWithTarget(long leftNodeValue, long rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return (Long)this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0) {
                return this.doLong(leftNodeValue, rightNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Long)this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (rightNodeValue instanceof Long) {
                long rightNodeValue_ = (Long)rightNodeValue;
                if (leftNodeValue instanceof Long) {
                    long leftNodeValue_ = (Long)leftNodeValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doLong(leftNodeValue_, rightNodeValue_);
                }
                if (LLVMTypes.isManagedPointer(leftNodeValue)) {
                    LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                    if ((state_0 & 0x10) == 0 && (state_0 & 8) == 0 && this.canDoManaged(rightNodeValue_)) {
                        ManagedLeftLongData s1_ = (ManagedLeftLongData)this.insert(new ManagedLeftLongData());
                        s1_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s1_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedLeftLong_cache = s1_;
                        this.state_0_ = state_0 |= 4;
                        try {
                            return this.doManagedLeftLong(leftNodeValue_, rightNodeValue_, s1_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.managedLeftLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if (this.canDoManaged(rightNodeValue_)) {
                        ManagedLeftData s2_ = (ManagedLeftData)this.insert(new ManagedLeftData());
                        s2_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s2_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedLeft_cache = s2_;
                        this.managedLeftLong_cache = null;
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doManagedLeft(leftNodeValue_, rightNodeValue_, s2_.node_);
                    }
                }
            }
            if (leftNodeValue instanceof Long) {
                LLVMPointer rightNodeValue_;
                long leftNodeValue_ = (Long)leftNodeValue;
                if (LLVMTypes.isManagedPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                    if ((state_0 & 0x80) == 0 && (state_0 & 0x40) == 0 && this.canDoManaged(leftNodeValue_)) {
                        ManagedRightLongData s3_ = (ManagedRightLongData)this.insert(new ManagedRightLongData());
                        s3_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s3_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedRightLong_cache = s3_;
                        this.state_0_ = state_0 |= 0x20;
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s3_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.managedRightLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if (this.canDoManaged(leftNodeValue_)) {
                        ManagedRightData s4_ = (ManagedRightData)this.insert(new ManagedRightData());
                        s4_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s4_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedRight_cache = s4_;
                        this.managedRightLong_cache = null;
                        state_0 &= 0xFFFFFFDF;
                        this.state_0_ = state_0 |= 0x80;
                        return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s4_.node_);
                    }
                }
                if (LLVMTypes.isPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                    if (!this.canDoManaged(leftNodeValue_)) {
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                        Objects.requireNonNull(toNativePointerRight__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.pointerRight_toNativePointerRight_ = toNativePointerRight__;
                        this.state_0_ = state_0 |= 0x100;
                        return this.doPointerRight(leftNodeValue_, rightNodeValue_, toNativePointerRight__);
                    }
                }
            }
            if (LLVMTypes.isPointer(leftNodeValue)) {
                long rightNodeValue_;
                LLVMPointer leftNodeValue_ = LLVMTypes.asPointer(leftNodeValue);
                if (rightNodeValue instanceof Long && !this.canDoManaged(rightNodeValue_ = ((Long)rightNodeValue).longValue())) {
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                    Objects.requireNonNull(toNativePointerLeft__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.pointerLeft_toNativePointerLeft_ = toNativePointerLeft__;
                    this.state_0_ = state_0 |= 0x200;
                    return this.doPointerLeft(leftNodeValue_, rightNodeValue_, toNativePointerLeft__);
                }
                if (LLVMTypes.isPointer(rightNodeValue)) {
                    LLVMPointer rightNodeValue_2 = LLVMTypes.asPointer(rightNodeValue);
                    PointerData s7_ = (PointerData)this.insert(new PointerData());
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__1 = (LLVMNativePointerSupport.ToNativePointerNode)s7_.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                    Objects.requireNonNull(toNativePointerLeft__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s7_.toNativePointerLeft_ = toNativePointerLeft__1;
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__1 = (LLVMNativePointerSupport.ToNativePointerNode)s7_.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                    Objects.requireNonNull(toNativePointerRight__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s7_.toNativePointerRight_ = toNativePointerRight__1;
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s7_;
                    this.state_0_ = state_0 |= 0x400;
                    return this.doPointer(leftNodeValue_, rightNodeValue_2, toNativePointerLeft__1, toNativePointerRight__1);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            ManagedLeftData s2_ = (ManagedLeftData)this.insert(new ManagedLeftData());
            s2_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s2_.insert(this.createManagedNode());
            VarHandle.storeStoreFence();
            this.managedLeft_cache = s2_;
            this.managedLeftLong_cache = null;
            this.state_0_ &= 0xFFFFFFFB;
            this.state_0_ |= 0x10;
            ManagedRightData s4_ = (ManagedRightData)this.insert(new ManagedRightData());
            s4_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s4_.insert(this.createManagedNode());
            VarHandle.storeStoreFence();
            this.managedRight_cache = s4_;
            this.managedRightLong_cache = null;
            this.state_0_ &= 0xFFFFFFDF;
            this.state_0_ |= 0x80;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerRight__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.pointerRight_toNativePointerRight_ = toNativePointerRight__;
            assert (NodeUtil.assertRecursion((Node)this.pointerRight_toNativePointerRight_, (int)1));
            ((GenerateAOT.Provider)this.pointerRight_toNativePointerRight_).prepareForAOT(language, root);
            this.state_0_ |= 0x100;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerLeft__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.pointerLeft_toNativePointerLeft_ = toNativePointerLeft__;
            assert (NodeUtil.assertRecursion((Node)this.pointerLeft_toNativePointerLeft_, (int)1));
            ((GenerateAOT.Provider)this.pointerLeft_toNativePointerLeft_).prepareForAOT(language, root);
            this.state_0_ |= 0x200;
            PointerData s7_ = (PointerData)this.insert(new PointerData());
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__1 = (LLVMNativePointerSupport.ToNativePointerNode)s7_.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerLeft__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s7_.toNativePointerLeft_ = toNativePointerLeft__1;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__1 = (LLVMNativePointerSupport.ToNativePointerNode)s7_.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerRight__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s7_.toNativePointerRight_ = toNativePointerRight__1;
            VarHandle.storeStoreFence();
            this.pointer_cache = s7_;
            assert (NodeUtil.assertRecursion((Node)s7_.toNativePointerLeft_, (int)1));
            ((GenerateAOT.Provider)s7_.toNativePointerLeft_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s7_.toNativePointerRight_, (int)1));
            ((GenerateAOT.Provider)s7_.toNativePointerRight_).prepareForAOT(language, root);
            this.state_0_ |= 0x400;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.managedLeft_cache = null;
            this.managedRight_cache = null;
            this.pointerRight_toNativePointerRight_ = null;
            this.pointerLeft_toNativePointerLeft_ = null;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMI64ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI64ArithmeticNodeGen(op, leftNode, rightNode);
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
        @DenyReplace
        private static final class ManagedLeftLongData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedLeftLongData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
        @DenyReplace
        private static final class ManagedLeftData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedLeftData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
        @DenyReplace
        private static final class ManagedRightLongData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedRightLongData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
        @DenyReplace
        private static final class ManagedRightData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedRightData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
        @DenyReplace
        private static final class PointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft_;
            @Node.Child
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight_;

            PointerData() {
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.class)
    public static final class LLVMAbstractI64ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node leftNode_;
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ManagedLeftLongData managedLeftLong_cache;
        @Node.Child
        private ManagedLeftData managedLeft_cache;
        @Node.Child
        private ManagedRightLongData managedRightLong_cache;
        @Node.Child
        private ManagedRightData managedRight_cache;
        @Node.Child
        private LLVMNativePointerSupport.ToNativePointerNode pointerRight_toNativePointerRight_;
        @Node.Child
        private LLVMNativePointerSupport.ToNativePointerNode pointerLeft_toNativePointerLeft_;

        private LLVMAbstractI64ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = this.createCast(leftNode);
            this.rightNode_ = this.createCast(rightNode);
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 0x3B6) != 0) {
                if ((state_0 & 0x16) != 0 && rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    if ((state_0 & 2) != 0 && leftNodeValue instanceof Long) {
                        long leftNodeValue_ = (Long)leftNodeValue;
                        return this.doLong(leftNodeValue_, rightNodeValue_);
                    }
                    if ((state_0 & 0x14) != 0 && LLVMTypes.isManagedPointer(leftNodeValue)) {
                        ManagedLeftData s2_;
                        ManagedLeftLongData s1_;
                        LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                        if ((state_0 & 4) != 0 && (s1_ = this.managedLeftLong_cache) != null && this.canDoManaged(rightNodeValue_)) {
                            try {
                                return this.doManagedLeftLong(leftNodeValue_, rightNodeValue_, s1_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                this.managedLeftLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x10) != 0 && (s2_ = this.managedLeft_cache) != null && this.canDoManaged(rightNodeValue_)) {
                            return this.doManagedLeft(leftNodeValue_, rightNodeValue_, s2_.node_);
                        }
                    }
                }
                if ((state_0 & 0x1A0) != 0 && leftNodeValue instanceof Long) {
                    LLVMPointer rightNodeValue_;
                    long leftNodeValue_ = (Long)leftNodeValue;
                    if ((state_0 & 0xA0) != 0 && LLVMTypes.isManagedPointer(rightNodeValue)) {
                        ManagedRightData s4_;
                        ManagedRightLongData s3_;
                        rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                        if ((state_0 & 0x20) != 0 && (s3_ = this.managedRightLong_cache) != null && this.canDoManaged(leftNodeValue_)) {
                            try {
                                return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s3_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                this.managedRightLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x80) != 0 && (s4_ = this.managedRight_cache) != null && this.canDoManaged(leftNodeValue_)) {
                            return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s4_.node_);
                        }
                    }
                    if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue)) {
                        rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                        if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue_)) {
                            return this.doPointerRight(leftNodeValue_, rightNodeValue_, toNativePointerRight__);
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue)) {
                    LLVMPointer leftNodeValue_ = LLVMTypes.asPointer(leftNodeValue);
                    if (rightNodeValue instanceof Long) {
                        long rightNodeValue_ = (Long)rightNodeValue;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue_)) {
                            return this.doPointerLeft(leftNodeValue_, rightNodeValue_, toNativePointerLeft__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3B4) == 0 && (state_0 & 0x3B6) != 0) {
                return this.executeGeneric_long_long0(state_0, frameValue);
            }
            if ((state_0 & 0x1A2) == 0 && (state_0 & 0x3B6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue);
            }
            if ((state_0 & 0x216) == 0 && (state_0 & 0x3B6) != 0) {
                return this.executeGeneric_long2(state_0, frameValue);
            }
            return this.executeGeneric_generic3(state_0, frameValue);
        }

        private Object executeGeneric_long_long0(int state_0__, VirtualFrame frameValue) {
            long rightNodeValue_;
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            long rightNodeValue_;
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x214) != 0) {
                LLVMPointer leftNodeValue__;
                if ((state_0 & 0x14) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    ManagedLeftData s2_;
                    ManagedLeftLongData s1_;
                    leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if ((state_0 & 4) != 0 && (s1_ = this.managedLeftLong_cache) != null && this.canDoManaged(rightNodeValue_)) {
                        try {
                            return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, s1_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.managedLeftLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if ((state_0 & 0x10) != 0 && (s2_ = this.managedLeft_cache) != null && this.canDoManaged(rightNodeValue_)) {
                        return this.doManagedLeft((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, s2_.node_);
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                    if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue_)) {
                        return this.doPointerLeft(leftNodeValue__, rightNodeValue_, toNativePointerLeft__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private Object executeGeneric_long2(int state_0__, VirtualFrame frameValue) {
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x1A0) != 0) {
                LLVMPointer rightNodeValue__;
                if ((state_0 & 0xA0) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    ManagedRightData s4_;
                    ManagedRightLongData s3_;
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if ((state_0 & 0x20) != 0 && (s3_ = this.managedRightLong_cache) != null && this.canDoManaged(leftNodeValue_)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.managedRightLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if ((state_0 & 0x80) != 0 && (s4_ = this.managedRight_cache) != null && this.canDoManaged(leftNodeValue_)) {
                        return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, s4_.node_);
                    }
                }
                if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                    if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue_)) {
                        return this.doPointerRight(leftNodeValue_, rightNodeValue__, toNativePointerRight__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x3B6) != 0) {
                if ((state_0 & 0x16) != 0 && rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state_0 & 2) != 0 && leftNodeValue_ instanceof Long) {
                        long leftNodeValue__ = (Long)leftNodeValue_;
                        return this.doLong(leftNodeValue__, rightNodeValue__);
                    }
                    if ((state_0 & 0x14) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                        ManagedLeftData s2_;
                        ManagedLeftLongData s1_;
                        LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                        if ((state_0 & 4) != 0 && (s1_ = this.managedLeftLong_cache) != null && this.canDoManaged(rightNodeValue__)) {
                            try {
                                return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, s1_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                this.managedLeftLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x10) != 0 && (s2_ = this.managedLeft_cache) != null && this.canDoManaged(rightNodeValue__)) {
                            return this.doManagedLeft(leftNodeValue__, rightNodeValue__, s2_.node_);
                        }
                    }
                }
                if ((state_0 & 0x1A0) != 0 && leftNodeValue_ instanceof Long) {
                    LLVMPointer rightNodeValue__;
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    if ((state_0 & 0xA0) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                        ManagedRightData s4_;
                        ManagedRightLongData s3_;
                        rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                        if ((state_0 & 0x20) != 0 && (s3_ = this.managedRightLong_cache) != null && this.canDoManaged(leftNodeValue__)) {
                            try {
                                return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                this.managedRightLong_cache = null;
                                return ex.getResult();
                            }
                        }
                        if ((state_0 & 0x80) != 0 && (s4_ = this.managedRight_cache) != null && this.canDoManaged(leftNodeValue__)) {
                            return this.doManagedRight(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, s4_.node_);
                        }
                    }
                    if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                        rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                        if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue__)) {
                            return this.doPointerRight(leftNodeValue__, rightNodeValue__, toNativePointerRight__);
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    if (rightNodeValue_ instanceof Long) {
                        long rightNodeValue__ = (Long)rightNodeValue_;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue__)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue__, toNativePointerLeft__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0x90) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state_0 & 0x324) == 0 && (state_0 & 0x326) != 0) {
                return this.executeI64_long_long4(state_0, frameValue);
            }
            if ((state_0 & 0x122) == 0 && (state_0 & 0x326) != 0) {
                return this.executeI64_long5(state_0, frameValue);
            }
            if ((state_0 & 0x206) == 0 && (state_0 & 0x326) != 0) {
                return this.executeI64_long6(state_0, frameValue);
            }
            return this.executeI64_generic7(state_0, frameValue);
        }

        private long executeI64_long_long4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long rightNodeValue_;
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            assert ((state_0 & 2) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        private long executeI64_long5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long rightNodeValue_;
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            if ((state_0 & 0x204) != 0) {
                LLVMPointer leftNodeValue__;
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    ManagedLeftLongData s1_ = this.managedLeftLong_cache;
                    if (s1_ != null && this.canDoManaged(rightNodeValue_)) {
                        try {
                            return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, s1_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.managedLeftLong_cache = null;
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                    if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue_)) {
                        return this.doPointerLeft(leftNodeValue__, rightNodeValue_, toNativePointerLeft__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        private long executeI64_long6(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long leftNodeValue_;
            int state_0 = state_0__;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            if ((state_0 & 0x120) != 0) {
                LLVMPointer rightNodeValue__;
                if ((state_0 & 0x20) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    ManagedRightLongData s3_ = this.managedRightLong_cache;
                    if (s3_ != null && this.canDoManaged(leftNodeValue_)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.managedRightLong_cache = null;
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
                if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                    if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue_)) {
                        return this.doPointerRight(leftNodeValue_, rightNodeValue__, toNativePointerRight__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        private long executeI64_generic7(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
            if ((state_0 & 0x326) != 0) {
                if ((state_0 & 6) != 0 && rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state_0 & 2) != 0 && leftNodeValue_ instanceof Long) {
                        long leftNodeValue__ = (Long)leftNodeValue_;
                        return this.doLong(leftNodeValue__, rightNodeValue__);
                    }
                    if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                        LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                        ManagedLeftLongData s1_ = this.managedLeftLong_cache;
                        if (s1_ != null && this.canDoManaged(rightNodeValue__)) {
                            try {
                                return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, s1_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                this.managedLeftLong_cache = null;
                                return LLVMTypesGen.expectLong(ex.getResult());
                            }
                        }
                    }
                }
                if ((state_0 & 0x120) != 0 && leftNodeValue_ instanceof Long) {
                    LLVMPointer rightNodeValue__;
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    if ((state_0 & 0x20) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                        rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                        ManagedRightLongData s3_ = this.managedRightLong_cache;
                        if (s3_ != null && this.canDoManaged(leftNodeValue__)) {
                            try {
                                return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, s3_.node_);
                            }
                            catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                this.managedRightLong_cache = null;
                                return LLVMTypesGen.expectLong(ex.getResult());
                            }
                        }
                    }
                    if ((state_0 & 0x100) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                        rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = this.pointerRight_toNativePointerRight_;
                        if (toNativePointerRight__ != null && !this.canDoManaged(leftNodeValue__)) {
                            return this.doPointerRight(leftNodeValue__, rightNodeValue__, toNativePointerRight__);
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                    LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                    if (rightNodeValue_ instanceof Long) {
                        long rightNodeValue__ = (Long)rightNodeValue_;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.pointerLeft_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && !this.canDoManaged(rightNodeValue__)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue__, toNativePointerLeft__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        @Override
        public long executeLongWithTarget(long leftNodeValue, long rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return (Long)this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0) {
                return this.doLong(leftNodeValue, rightNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Long)this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (rightNodeValue instanceof Long) {
                long rightNodeValue_ = (Long)rightNodeValue;
                if (leftNodeValue instanceof Long) {
                    long leftNodeValue_ = (Long)leftNodeValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doLong(leftNodeValue_, rightNodeValue_);
                }
                if (LLVMTypes.isManagedPointer(leftNodeValue)) {
                    LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                    if ((state_0 & 0x10) == 0 && (state_0 & 8) == 0 && this.canDoManaged(rightNodeValue_)) {
                        ManagedLeftLongData s1_ = (ManagedLeftLongData)this.insert(new ManagedLeftLongData());
                        s1_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s1_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedLeftLong_cache = s1_;
                        this.state_0_ = state_0 |= 4;
                        try {
                            return this.doManagedLeftLong(leftNodeValue_, rightNodeValue_, s1_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.managedLeftLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if (this.canDoManaged(rightNodeValue_)) {
                        ManagedLeftData s2_ = (ManagedLeftData)this.insert(new ManagedLeftData());
                        s2_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s2_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedLeft_cache = s2_;
                        this.managedLeftLong_cache = null;
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doManagedLeft(leftNodeValue_, rightNodeValue_, s2_.node_);
                    }
                }
            }
            if (leftNodeValue instanceof Long) {
                LLVMPointer rightNodeValue_;
                long leftNodeValue_ = (Long)leftNodeValue;
                if (LLVMTypes.isManagedPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                    if ((state_0 & 0x80) == 0 && (state_0 & 0x40) == 0 && this.canDoManaged(leftNodeValue_)) {
                        ManagedRightLongData s3_ = (ManagedRightLongData)this.insert(new ManagedRightLongData());
                        s3_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s3_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedRightLong_cache = s3_;
                        this.state_0_ = state_0 |= 0x20;
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s3_.node_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.managedRightLong_cache = null;
                            return ex.getResult();
                        }
                    }
                    if (this.canDoManaged(leftNodeValue_)) {
                        ManagedRightData s4_ = (ManagedRightData)this.insert(new ManagedRightData());
                        s4_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s4_.insert(this.createManagedNode());
                        VarHandle.storeStoreFence();
                        this.managedRight_cache = s4_;
                        this.managedRightLong_cache = null;
                        state_0 &= 0xFFFFFFDF;
                        this.state_0_ = state_0 |= 0x80;
                        return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, s4_.node_);
                    }
                }
                if (LLVMTypes.isPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                    if (!this.canDoManaged(leftNodeValue_)) {
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                        Objects.requireNonNull(toNativePointerRight__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.pointerRight_toNativePointerRight_ = toNativePointerRight__;
                        this.state_0_ = state_0 |= 0x100;
                        return this.doPointerRight(leftNodeValue_, rightNodeValue_, toNativePointerRight__);
                    }
                }
            }
            if (LLVMTypes.isPointer(leftNodeValue)) {
                long rightNodeValue_;
                LLVMPointer leftNodeValue_ = LLVMTypes.asPointer(leftNodeValue);
                if (rightNodeValue instanceof Long && !this.canDoManaged(rightNodeValue_ = ((Long)rightNodeValue).longValue())) {
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                    Objects.requireNonNull(toNativePointerLeft__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.pointerLeft_toNativePointerLeft_ = toNativePointerLeft__;
                    this.state_0_ = state_0 |= 0x200;
                    return this.doPointerLeft(leftNodeValue_, rightNodeValue_, toNativePointerLeft__);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            ManagedLeftData s2_ = (ManagedLeftData)this.insert(new ManagedLeftData());
            s2_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s2_.insert(this.createManagedNode());
            VarHandle.storeStoreFence();
            this.managedLeft_cache = s2_;
            this.managedLeftLong_cache = null;
            this.state_0_ &= 0xFFFFFFFB;
            this.state_0_ |= 0x10;
            ManagedRightData s4_ = (ManagedRightData)this.insert(new ManagedRightData());
            s4_.node_ = (LLVMArithmeticNode.ManagedArithmeticNode)s4_.insert(this.createManagedNode());
            VarHandle.storeStoreFence();
            this.managedRight_cache = s4_;
            this.managedRightLong_cache = null;
            this.state_0_ &= 0xFFFFFFDF;
            this.state_0_ |= 0x80;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerRight__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.pointerRight_toNativePointerRight_ = toNativePointerRight__;
            assert (NodeUtil.assertRecursion((Node)this.pointerRight_toNativePointerRight_, (int)1));
            ((GenerateAOT.Provider)this.pointerRight_toNativePointerRight_).prepareForAOT(language, root);
            this.state_0_ |= 0x100;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerLeft__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.pointerLeft_toNativePointerLeft_ = toNativePointerLeft__;
            assert (NodeUtil.assertRecursion((Node)this.pointerLeft_toNativePointerLeft_, (int)1));
            ((GenerateAOT.Provider)this.pointerLeft_toNativePointerLeft_).prepareForAOT(language, root);
            this.state_0_ |= 0x200;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.managedLeft_cache = null;
            this.managedRight_cache = null;
            this.pointerRight_toNativePointerRight_ = null;
            this.pointerLeft_toNativePointerLeft_ = null;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMAbstractI64ArithmeticNodeGen(op, leftNode, rightNode);
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.class)
        @DenyReplace
        private static final class ManagedLeftLongData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedLeftLongData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.class)
        @DenyReplace
        private static final class ManagedLeftData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedLeftData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.class)
        @DenyReplace
        private static final class ManagedRightLongData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedRightLongData() {
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.class)
        @DenyReplace
        private static final class ManagedRightData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMArithmeticNode.ManagedArithmeticNode node_;

            ManagedRightData() {
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.PointerToI64Node.class)
    public static final class PointerToI64NodeGen
    extends LLVMArithmeticNode.PointerToI64Node
    implements GenerateAOT.Provider {
        static final InlineSupport.ReferenceField<PointerData> POINTER_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"pointer_cache", PointerData.class);
        static final InlineSupport.ReferenceField<ManagedData> MANAGED_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"managed_cache", ManagedData.class);
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private PointerData pointer_cache;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private ManagedData managed_cache;
        @Node.Child
        private GenericData generic_cache;

        private PointerToI64NodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x2C) == 0 && (state_0 & 0x2E) != 0) {
                return this.executeGeneric_long0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
            long child0Value_;
            int state_0 = state_0__;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_);
            }
            assert ((state_0 & 2) != 0);
            return this.doLong(child0Value_);
        }

        @ExplodeLoop
        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_);
            }
            if ((state_0 & 0x2E) != 0) {
                if ((state_0 & 2) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    return this.doLong(child0Value__);
                }
                if ((state_0 & 0x2C) != 0) {
                    GenericData s3_;
                    if ((state_0 & 8) != 0) {
                        PointerData s1_ = this.pointer_cache;
                        while (s1_ != null) {
                            if (s1_.isPointer_.execute(child0Value_)) {
                                try {
                                    return this.doPointer(child0Value_, s1_.isPointer_, s1_.asPointer_);
                                }
                                catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFF7;
                                    this.state_0_ = state_0 |= 0x10;
                                    this.pointer_cache = null;
                                    return this.executeAndSpecialize(child0Value_);
                                }
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0x20) != 0) {
                        ManagedData s2_ = this.managed_cache;
                        while (s2_ != null) {
                            if (!s2_.isPointer_.execute(child0Value_)) {
                                return this.doManaged(child0Value_, s2_.isPointer_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0 && (s3_ = this.generic_cache) != null) {
                        return this.doGeneric(child0Value_, s3_.isPointer_, s3_.asPointer_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0x24) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state_0 & 8) == 0 && (state_0 & 0xA) != 0) {
                return this.executeI64_long2(state_0, frameValue);
            }
            return this.executeI64_generic3(state_0, frameValue);
        }

        private long executeI64_long2(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long child0Value_;
            int state_0 = state_0__;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
            }
            assert ((state_0 & 2) != 0);
            return this.doLong(child0Value_);
        }

        @ExplodeLoop
        private long executeI64_generic3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
            }
            if ((state_0 & 0xA) != 0) {
                if ((state_0 & 2) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    return this.doLong(child0Value__);
                }
                if ((state_0 & 8) != 0) {
                    PointerData s1_ = this.pointer_cache;
                    while (s1_ != null) {
                        if (s1_.isPointer_.execute(child0Value_)) {
                            try {
                                return this.doPointer(child0Value_, s1_.isPointer_, s1_.asPointer_);
                            }
                            catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFF7;
                                this.state_0_ = state_0 |= 0x10;
                                this.pointer_cache = null;
                                return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
                            }
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((state_0 & 4) == 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                this.state_0_ = state_0 |= 2;
                return this.doLong(child0Value_);
            }
            if ((state_0 & 4) == 0 && (state_0 & 0x10) == 0) {
                PointerData s1_;
                block12: {
                    PointerData s1_original;
                    do {
                        LLVMNativePointerSupport.IsPointerNode isPointer__;
                        int count1_ = 0;
                        s1_original = s1_ = (PointerData)((Object)POINTER_CACHE_UPDATER.getVolatile((Node)this));
                        while (s1_ != null && !s1_.isPointer_.execute(child0Value)) {
                            ++count1_;
                            s1_ = s1_.next_;
                        }
                        if (s1_ != null || !(isPointer__ = (LLVMNativePointerSupport.IsPointerNode)this.insert(LLVMNativePointerSupportFactory.IsPointerNodeGen.create())).execute(child0Value) || count1_ >= 3) break block12;
                        s1_ = (PointerData)this.insert(new PointerData(s1_original));
                        Objects.requireNonNull((LLVMNativePointerSupport.IsPointerNode)s1_.insert(isPointer__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s1_.isPointer_ = isPointer__;
                        LLVMNativePointerSupport.AsPointerNode asPointer__ = (LLVMNativePointerSupport.AsPointerNode)s1_.insert(LLVMNativePointerSupportFactory.AsPointerNodeGen.create());
                        Objects.requireNonNull(asPointer__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s1_.asPointer_ = asPointer__;
                    } while (!POINTER_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                    this.state_0_ = state_0 |= 8;
                }
                if (s1_ != null) {
                    try {
                        return this.doPointer(child0Value, s1_.isPointer_, s1_.asPointer_);
                    }
                    catch (UnsupportedMessageException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFF7;
                        this.state_0_ = state_0 |= 0x10;
                        this.pointer_cache = null;
                        return this.executeAndSpecialize(child0Value);
                    }
                }
            }
            if ((state_0 & 4) == 0) {
                ManagedData s2_;
                block13: {
                    ManagedData s2_original;
                    do {
                        LLVMNativePointerSupport.IsPointerNode isPointer__1;
                        int count2_ = 0;
                        s2_original = s2_ = (ManagedData)((Object)MANAGED_CACHE_UPDATER.getVolatile((Node)this));
                        while (s2_ != null && s2_.isPointer_.execute(child0Value)) {
                            ++count2_;
                            s2_ = s2_.next_;
                        }
                        if (s2_ != null || (isPointer__1 = (LLVMNativePointerSupport.IsPointerNode)this.insert(LLVMNativePointerSupportFactory.IsPointerNodeGen.create())).execute(child0Value) || count2_ >= 3) break block13;
                        s2_ = (ManagedData)this.insert(new ManagedData(s2_original));
                        Objects.requireNonNull((LLVMNativePointerSupport.IsPointerNode)s2_.insert(isPointer__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.isPointer_ = isPointer__1;
                    } while (!MANAGED_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                    this.state_0_ = state_0 |= 0x20;
                }
                if (s2_ != null) {
                    return this.doManaged(child0Value, s2_.isPointer_);
                }
            }
            GenericData s3_ = (GenericData)this.insert(new GenericData());
            LLVMNativePointerSupport.IsPointerNode isPointer__2 = (LLVMNativePointerSupport.IsPointerNode)s3_.insert(LLVMNativePointerSupportFactory.IsPointerNodeGen.create());
            Objects.requireNonNull(isPointer__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.isPointer_ = isPointer__2;
            LLVMNativePointerSupport.AsPointerNode asPointer__1 = (LLVMNativePointerSupport.AsPointerNode)s3_.insert(LLVMNativePointerSupportFactory.AsPointerNodeGen.create());
            Objects.requireNonNull(asPointer__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.asPointer_ = asPointer__1;
            VarHandle.storeStoreFence();
            this.generic_cache = s3_;
            this.pointer_cache = null;
            this.managed_cache = null;
            state_0 &= 0xFFFFFFD5;
            this.state_0_ = state_0 |= 4;
            return this.doGeneric(child0Value, isPointer__2, asPointer__1);
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            GenericData s3_ = (GenericData)this.insert(new GenericData());
            LLVMNativePointerSupport.IsPointerNode isPointer__2 = (LLVMNativePointerSupport.IsPointerNode)s3_.insert(LLVMNativePointerSupportFactory.IsPointerNodeGen.create());
            Objects.requireNonNull(isPointer__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.isPointer_ = isPointer__2;
            LLVMNativePointerSupport.AsPointerNode asPointer__1 = (LLVMNativePointerSupport.AsPointerNode)s3_.insert(LLVMNativePointerSupportFactory.AsPointerNodeGen.create());
            Objects.requireNonNull(asPointer__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.asPointer_ = asPointer__1;
            VarHandle.storeStoreFence();
            this.generic_cache = s3_;
            this.pointer_cache = null;
            this.managed_cache = null;
            this.state_0_ &= 0xFFFFFFD5;
            assert (NodeUtil.assertRecursion((Node)s3_.isPointer_, (int)1));
            ((GenerateAOT.Provider)s3_.isPointer_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s3_.asPointer_, (int)1));
            ((GenerateAOT.Provider)s3_.asPointer_).prepareForAOT(language, root);
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.generic_cache = null;
        }

        @NeverDefault
        public static LLVMArithmeticNode.PointerToI64Node create(LLVMExpressionNode child0) {
            return new PointerToI64NodeGen(child0);
        }

        @GeneratedBy(value=LLVMArithmeticNode.PointerToI64Node.class)
        @DenyReplace
        private static final class PointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            PointerData next_;
            @Node.Child
            LLVMNativePointerSupport.IsPointerNode isPointer_;
            @Node.Child
            LLVMNativePointerSupport.AsPointerNode asPointer_;

            PointerData(PointerData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.PointerToI64Node.class)
        @DenyReplace
        private static final class ManagedData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            ManagedData next_;
            @Node.Child
            LLVMNativePointerSupport.IsPointerNode isPointer_;

            ManagedData(ManagedData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.PointerToI64Node.class)
        @DenyReplace
        private static final class GenericData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMNativePointerSupport.IsPointerNode isPointer_;
            @Node.Child
            LLVMNativePointerSupport.AsPointerNode asPointer_;

            GenericData() {
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI32ArithmeticNode.class)
    public static final class LLVMI32ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI32ArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI32ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0 && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (Integer)rightNodeValue;
                    return this.doInt(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int rightNodeValue_;
            int leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doInt(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int rightNodeValue_;
            int leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doInt(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private int executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (Integer)rightNodeValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doInt(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMI32ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI32ArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI16ArithmeticNode.class)
    public static final class LLVMI16ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI16ArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI16ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0 && leftNodeValue instanceof Short) {
                short leftNodeValue_ = (Short)leftNodeValue;
                if (rightNodeValue instanceof Short) {
                    short rightNodeValue_ = (Short)rightNodeValue;
                    return this.doShort(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short rightNodeValue_;
            short leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doShort(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            short rightNodeValue_;
            short leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doShort(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private short executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftNodeValue instanceof Short) {
                short leftNodeValue_ = (Short)leftNodeValue;
                if (rightNodeValue instanceof Short) {
                    short rightNodeValue_ = (Short)rightNodeValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doShort(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMI16ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI16ArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI8ArithmeticNode.class)
    public static final class LLVMI8ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI8ArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI8ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0 && leftNodeValue instanceof Byte) {
                byte leftNodeValue_ = (Byte)leftNodeValue;
                if (rightNodeValue instanceof Byte) {
                    byte rightNodeValue_ = (Byte)rightNodeValue;
                    return this.doByte(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightNodeValue_;
            byte leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doByte(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            byte rightNodeValue_;
            byte leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doByte(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private byte executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftNodeValue instanceof Byte) {
                byte leftNodeValue_ = (Byte)leftNodeValue;
                if (rightNodeValue instanceof Byte) {
                    byte rightNodeValue_ = (Byte)rightNodeValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doByte(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMI8ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI8ArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI1ArithmeticNode.class)
    public static final class LLVMI1ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI1ArithmeticNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI1ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 2) != 0 && leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_ = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_ = (Boolean)rightNodeValue;
                    return this.doBoolean(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            boolean rightNodeValue_;
            boolean leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doBoolean(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            boolean rightNodeValue_;
            boolean leftNodeValue_;
            int state_0 = this.state_0_;
            try {
                leftNodeValue_ = this.leftNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doBoolean(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_ = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_ = (Boolean)rightNodeValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doBoolean(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmeticNode.LLVMI1ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI1ArithmeticNodeGen(op, leftNode, rightNode);
        }
    }
}

