/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@CompilerDirectives.ValueType
public final class LLVMDoubleVector
extends LLVMVector {
    private final double[] vector;

    public static LLVMDoubleVector create(double[] vector) {
        return new LLVMDoubleVector(vector);
    }

    private LLVMDoubleVector(double[] vector) {
        this.vector = vector;
    }

    public double getValue(int index) {
        return this.vector[index];
    }

    @Override
    public int getLength() {
        return this.vector.length;
    }

    @Override
    public Type getElementType() {
        return PrimitiveType.DOUBLE;
    }

    @Override
    public Object getElement(int index) {
        return index >= 0 && index < this.vector.length ? Double.valueOf(this.vector[index]) : null;
    }
}

