// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack.LLVMStackAccessHolder;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMGetStackFromFrameNode#getStack}
 *     Activation probability: 1.00000
 *     With/without class size: 20/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMGetStackFromFrameNode.class)
@SuppressWarnings("javadoc")
public final class LLVMGetStackFromFrameNodeGen extends LLVMGetStackFromFrameNode implements GenerateAOT.Provider {

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMGetStackFromFrameNode#getStack}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @CompilationFinal private GetStackData getStack_cache;

    private LLVMGetStackFromFrameNodeGen() {
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMGetStackFromFrameNode.getStack(VirtualFrame, LLVMStackAccessHolder)] */) {
            GetStackData s0_ = this.getStack_cache;
            if (s0_ != null) {
                return getStack(frameValue, s0_.stackAccessHolder_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        GetStackData s0_ = new GetStackData();
        s0_.stackAccessHolder_ = (createStackAccessHolder());
        VarHandle.storeStoreFence();
        this.getStack_cache = s0_;
        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMGetStackFromFrameNode.getStack(VirtualFrame, LLVMStackAccessHolder)] */;
        this.state_0_ = state_0;
        return getStack(frameValue, s0_.stackAccessHolder_);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            GetStackData s0_ = new GetStackData();
            s0_.stackAccessHolder_ = (createStackAccessHolder());
            VarHandle.storeStoreFence();
            this.getStack_cache = s0_;
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMGetStackFromFrameNode.getStack(VirtualFrame, LLVMStackAccessHolder)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.getStack_cache = null;
    }

    @NeverDefault
    public static LLVMGetStackFromFrameNode create() {
        return new LLVMGetStackFromFrameNodeGen();
    }

    @GeneratedBy(LLVMGetStackFromFrameNode.class)
    @DenyReplace
    private static final class GetStackData implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMGetStackFromFrameNode#getStack}
         *   Parameter: {@link LLVMStackAccessHolder} stackAccessHolder</pre>
         */
        @CompilationFinal LLVMStackAccessHolder stackAccessHolder_;

        GetStackData() {
        }

    }
}
