// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link DebugExprBitFlipNode#flip(boolean)}
 *     Activation probability: 0.23929
 *     With/without class size: 6/0 bytes
 *   Specialization {@link DebugExprBitFlipNode#flip(byte)}
 *     Activation probability: 0.20714
 *     With/without class size: 6/0 bytes
 *   Specialization {@link DebugExprBitFlipNode#flip(short)}
 *     Activation probability: 0.17500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link DebugExprBitFlipNode#flip(char)}
 *     Activation probability: 0.14286
 *     With/without class size: 5/0 bytes
 *   Specialization {@link DebugExprBitFlipNode#flip(int)}
 *     Activation probability: 0.11071
 *     With/without class size: 5/0 bytes
 *   Specialization {@link DebugExprBitFlipNode#flip(long)}
 *     Activation probability: 0.07857
 *     With/without class size: 4/0 bytes
 *   Specialization {@link DebugExprBitFlipNode#typeError}
 *     Activation probability: 0.04643
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(DebugExprBitFlipNode.class)
@SuppressWarnings("javadoc")
public final class DebugExprBitFlipNodeGen extends DebugExprBitFlipNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link DebugExprBitFlipNode#flip(boolean)}
     *   2: SpecializationActive {@link DebugExprBitFlipNode#flip(byte)}
     *   3: SpecializationActive {@link DebugExprBitFlipNode#flip(short)}
     *   4: SpecializationActive {@link DebugExprBitFlipNode#flip(char)}
     *   5: SpecializationActive {@link DebugExprBitFlipNode#flip(int)}
     *   6: SpecializationActive {@link DebugExprBitFlipNode#flip(long)}
     *   7: SpecializationActive {@link DebugExprBitFlipNode#typeError}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private DebugExprBitFlipNodeGen(LLVMExpressionNode child) {
        this.child_ = child;
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object childValue) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(boolean)] */) && childValue instanceof Boolean) {
            return false;
        }
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(byte)] */) && childValue instanceof Byte) {
            return false;
        }
        if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(short)] */) && childValue instanceof Short) {
            return false;
        }
        if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(char)] */) && childValue instanceof Character) {
            return false;
        }
        if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(int)] */) && childValue instanceof Integer) {
            return false;
        }
        if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(long)] */) && childValue instanceof Long) {
            return false;
        }
        return true;
    }

    @Override
    public Object executeWithTarget(Object childValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(childValue);
        }
        if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(boolean)] || SpecializationActive[DebugExprBitFlipNode.flip(byte)] || SpecializationActive[DebugExprBitFlipNode.flip(short)] || SpecializationActive[DebugExprBitFlipNode.flip(char)] || SpecializationActive[DebugExprBitFlipNode.flip(int)] || SpecializationActive[DebugExprBitFlipNode.flip(long)] || SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(boolean)] */ && childValue instanceof Boolean) {
                boolean childValue_ = (boolean) childValue;
                return flip(childValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(byte)] */ && childValue instanceof Byte) {
                byte childValue_ = (byte) childValue;
                return flip(childValue_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(short)] */ && childValue instanceof Short) {
                short childValue_ = (short) childValue;
                return flip(childValue_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(char)] */ && childValue instanceof Character) {
                char childValue_ = (char) childValue;
                return flip(childValue_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(int)] */ && childValue instanceof Integer) {
                int childValue_ = (int) childValue;
                return flip(childValue_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(long)] */ && childValue instanceof Long) {
                long childValue_ = (long) childValue;
                return flip(childValue_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */) {
                if (fallbackGuard_(state_0, childValue)) {
                    return typeError(childValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(childValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111100) == 0 /* only-active SpecializationActive[DebugExprBitFlipNode.flip(boolean)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[DebugExprBitFlipNode.flip(boolean)] && SpecializationActive[DebugExprBitFlipNode.flip(byte)] && SpecializationActive[DebugExprBitFlipNode.flip(short)] && SpecializationActive[DebugExprBitFlipNode.flip(char)] && SpecializationActive[DebugExprBitFlipNode.flip(int)] && SpecializationActive[DebugExprBitFlipNode.flip(long)] && SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */)) {
            return executeGeneric_boolean0(state_0, frameValue);
        } else if ((state_0 & 0b11111010) == 0 /* only-active SpecializationActive[DebugExprBitFlipNode.flip(byte)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[DebugExprBitFlipNode.flip(boolean)] && SpecializationActive[DebugExprBitFlipNode.flip(byte)] && SpecializationActive[DebugExprBitFlipNode.flip(short)] && SpecializationActive[DebugExprBitFlipNode.flip(char)] && SpecializationActive[DebugExprBitFlipNode.flip(int)] && SpecializationActive[DebugExprBitFlipNode.flip(long)] && SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */)) {
            return executeGeneric_byte1(state_0, frameValue);
        } else if ((state_0 & 0b11110110) == 0 /* only-active SpecializationActive[DebugExprBitFlipNode.flip(short)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[DebugExprBitFlipNode.flip(boolean)] && SpecializationActive[DebugExprBitFlipNode.flip(byte)] && SpecializationActive[DebugExprBitFlipNode.flip(short)] && SpecializationActive[DebugExprBitFlipNode.flip(char)] && SpecializationActive[DebugExprBitFlipNode.flip(int)] && SpecializationActive[DebugExprBitFlipNode.flip(long)] && SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */)) {
            return executeGeneric_short2(state_0, frameValue);
        } else if ((state_0 & 0b11011110) == 0 /* only-active SpecializationActive[DebugExprBitFlipNode.flip(int)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[DebugExprBitFlipNode.flip(boolean)] && SpecializationActive[DebugExprBitFlipNode.flip(byte)] && SpecializationActive[DebugExprBitFlipNode.flip(short)] && SpecializationActive[DebugExprBitFlipNode.flip(char)] && SpecializationActive[DebugExprBitFlipNode.flip(int)] && SpecializationActive[DebugExprBitFlipNode.flip(long)] && SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */)) {
            return executeGeneric_int3(state_0, frameValue);
        } else if ((state_0 & 0b10111110) == 0 /* only-active SpecializationActive[DebugExprBitFlipNode.flip(long)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[DebugExprBitFlipNode.flip(boolean)] && SpecializationActive[DebugExprBitFlipNode.flip(byte)] && SpecializationActive[DebugExprBitFlipNode.flip(short)] && SpecializationActive[DebugExprBitFlipNode.flip(char)] && SpecializationActive[DebugExprBitFlipNode.flip(int)] && SpecializationActive[DebugExprBitFlipNode.flip(long)] && SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */)) {
            return executeGeneric_long4(state_0, frameValue);
        } else {
            return executeGeneric_generic5(state_0, frameValue);
        }
    }

    private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        boolean childValue_;
        try {
            childValue_ = this.child_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(childValue_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(boolean)] */;
        return flip(childValue_);
    }

    private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        byte childValue_;
        try {
            childValue_ = this.child_.executeI8(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(childValue_);
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(byte)] */;
        return flip(childValue_);
    }

    private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        short childValue_;
        try {
            childValue_ = this.child_.executeI16(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(childValue_);
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(short)] */;
        return flip(childValue_);
    }

    private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int childValue_;
        try {
            childValue_ = this.child_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(childValue_);
        }
        assert (state_0 & 0b100000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(int)] */;
        return flip(childValue_);
    }

    private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long childValue_;
        try {
            childValue_ = this.child_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(childValue_);
        }
        assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(long)] */;
        return flip(childValue_);
    }

    private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object childValue_ = this.child_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(childValue_);
        }
        if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(boolean)] || SpecializationActive[DebugExprBitFlipNode.flip(byte)] || SpecializationActive[DebugExprBitFlipNode.flip(short)] || SpecializationActive[DebugExprBitFlipNode.flip(char)] || SpecializationActive[DebugExprBitFlipNode.flip(int)] || SpecializationActive[DebugExprBitFlipNode.flip(long)] || SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(boolean)] */ && childValue_ instanceof Boolean) {
                boolean childValue__ = (boolean) childValue_;
                return flip(childValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(byte)] */ && childValue_ instanceof Byte) {
                byte childValue__ = (byte) childValue_;
                return flip(childValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(short)] */ && childValue_ instanceof Short) {
                short childValue__ = (short) childValue_;
                return flip(childValue__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(char)] */ && childValue_ instanceof Character) {
                char childValue__ = (char) childValue_;
                return flip(childValue__);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(int)] */ && childValue_ instanceof Integer) {
                int childValue__ = (int) childValue_;
                return flip(childValue__);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(long)] */ && childValue_ instanceof Long) {
                long childValue__ = (long) childValue_;
                return flip(childValue__);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */) {
                if (fallbackGuard_(state_0, childValue_)) {
                    return typeError(childValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(childValue_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */) {
            return LLVMTypesGen.expectBoolean(executeGeneric(frameValue));
        }
        boolean childValue_;
        try {
            childValue_ = this.child_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectBoolean(executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectBoolean(executeAndSpecialize(childValue_));
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(boolean)] */) {
            return flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectBoolean(executeAndSpecialize(childValue_));
    }

    @Override
    public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */) {
            return LLVMTypesGen.expectByte(executeGeneric(frameValue));
        }
        byte childValue_;
        try {
            childValue_ = this.child_.executeI8(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectByte(executeAndSpecialize(childValue_));
        }
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(byte)] */) {
            return flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectByte(executeAndSpecialize(childValue_));
    }

    @Override
    public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */) {
            return LLVMTypesGen.expectInteger(executeGeneric(frameValue));
        }
        int childValue_;
        try {
            childValue_ = this.child_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectInteger(executeAndSpecialize(childValue_));
        }
        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(int)] */) {
            return flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectInteger(executeAndSpecialize(childValue_));
    }

    @Override
    public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */) {
            return LLVMTypesGen.expectLong(executeGeneric(frameValue));
        }
        long childValue_;
        try {
            childValue_ = this.child_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectLong(executeAndSpecialize(childValue_));
        }
        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(long)] */) {
            return flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(executeAndSpecialize(childValue_));
    }

    @Override
    public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */) {
            return LLVMTypesGen.expectShort(executeGeneric(frameValue));
        }
        short childValue_;
        try {
            childValue_ = this.child_.executeI16(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectShort(executeAndSpecialize(childValue_));
        }
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[DebugExprBitFlipNode.flip(short)] */) {
            return flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectShort(executeAndSpecialize(childValue_));
    }

    private Object executeAndSpecialize(Object childValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (childValue instanceof Boolean) {
            boolean childValue_ = (boolean) childValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[DebugExprBitFlipNode.flip(boolean)] */;
            this.state_0_ = state_0;
            return flip(childValue_);
        }
        if (childValue instanceof Byte) {
            byte childValue_ = (byte) childValue;
            state_0 = state_0 | 0b100 /* add SpecializationActive[DebugExprBitFlipNode.flip(byte)] */;
            this.state_0_ = state_0;
            return flip(childValue_);
        }
        if (childValue instanceof Short) {
            short childValue_ = (short) childValue;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[DebugExprBitFlipNode.flip(short)] */;
            this.state_0_ = state_0;
            return flip(childValue_);
        }
        if (childValue instanceof Character) {
            char childValue_ = (char) childValue;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[DebugExprBitFlipNode.flip(char)] */;
            this.state_0_ = state_0;
            return flip(childValue_);
        }
        if (childValue instanceof Integer) {
            int childValue_ = (int) childValue;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[DebugExprBitFlipNode.flip(int)] */;
            this.state_0_ = state_0;
            return flip(childValue_);
        }
        if (childValue instanceof Long) {
            long childValue_ = (long) childValue;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[DebugExprBitFlipNode.flip(long)] */;
            this.state_0_ = state_0;
            return flip(childValue_);
        }
        state_0 = state_0 | 0b10000000 /* add SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */;
        this.state_0_ = state_0;
        return typeError(childValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[DebugExprBitFlipNode.flip(boolean)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[DebugExprBitFlipNode.flip(byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[DebugExprBitFlipNode.flip(short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[DebugExprBitFlipNode.flip(char)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[DebugExprBitFlipNode.flip(int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[DebugExprBitFlipNode.flip(long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[DebugExprBitFlipNode.typeError(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static DebugExprBitFlipNode create(LLVMExpressionNode child) {
        return new DebugExprBitFlipNodeGen(child);
    }

}
