// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Clazz;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Method;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMInteropMethodInvokeNode#doVirtualCallCached}
 *     Activation probability: 0.48333
 *     With/without class size: 21/16 bytes
 *   Specialization {@link LLVMInteropMethodInvokeNode#doVirtualCall}
 *     Activation probability: 0.33333
 *     With/without class size: 12/8 bytes
 *   Specialization {@link LLVMInteropMethodInvokeNode#doNonvirtualCall}
 *     Activation probability: 0.18333
 *     With/without class size: 7/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMInteropMethodInvokeNode.class)
@SuppressWarnings("javadoc")
public final class LLVMInteropMethodInvokeNodeGen extends LLVMInteropMethodInvokeNode implements GenerateAOT.Provider {

    static final ReferenceField<VirtualCallCachedData> VIRTUAL_CALL_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "virtualCallCached_cache", VirtualCallCachedData.class);
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMInteropMethodInvokeNode#doVirtualCallCached}
     *   2: SpecializationActive {@link LLVMInteropMethodInvokeNode#doVirtualCall}
     *   3: SpecializationActive {@link LLVMInteropMethodInvokeNode#doNonvirtualCall}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private VirtualCallCachedData virtualCallCached_cache;
    @Child private VirtualCallData virtualCall_cache;
    @Child private NonvirtualCallData nonvirtualCall_cache;

    private LLVMInteropMethodInvokeNodeGen() {
    }

    @ExplodeLoop
    @Override
    Object execute(LLVMPointer arg0Value, String arg1Value, Clazz arg2Value, Method arg3Value, long arg4Value, Object[] arg5Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMInteropMethodInvokeNode.doVirtualCallCached(LLVMPointer, String, Clazz, Method, long, Object[], InteropLibrary, Clazz, String[], LLVMInteropVtableAccessNode)] || SpecializationActive[LLVMInteropMethodInvokeNode.doVirtualCall(LLVMPointer, String, Clazz, Method, long, Object[], InteropLibrary, LLVMInteropVtableAccessNode)] || SpecializationActive[LLVMInteropMethodInvokeNode.doNonvirtualCall(LLVMPointer, String, Clazz, Method, long, Object[], LLVMInteropNonvirtualCallNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropMethodInvokeNode.doVirtualCallCached(LLVMPointer, String, Clazz, Method, long, Object[], InteropLibrary, Clazz, String[], LLVMInteropVtableAccessNode)] */ && (LLVMInteropMethodInvokeNode.isVirtual(arg4Value))) {
                VirtualCallCachedData s0_ = this.virtualCallCached_cache;
                while (s0_ != null) {
                    if ((arg2Value == s0_.typeHash_)) {
                        return doVirtualCallCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.interop_, s0_.typeHash_, s0_.vtableHelpNames_, s0_.vtableAccessNode_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropMethodInvokeNode.doVirtualCall(LLVMPointer, String, Clazz, Method, long, Object[], InteropLibrary, LLVMInteropVtableAccessNode)] */) {
                VirtualCallData s1_ = this.virtualCall_cache;
                if (s1_ != null) {
                    if ((LLVMInteropMethodInvokeNode.isVirtual(arg4Value))) {
                        return doVirtualCall(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s1_.interop_, s1_.vtableAccessNode_);
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropMethodInvokeNode.doNonvirtualCall(LLVMPointer, String, Clazz, Method, long, Object[], LLVMInteropNonvirtualCallNode)] */) {
                NonvirtualCallData s2_ = this.nonvirtualCall_cache;
                if (s2_ != null) {
                    if ((!(LLVMInteropMethodInvokeNode.isVirtual(arg4Value)))) {
                        return doNonvirtualCall(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s2_.call_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
    }

    private Object executeAndSpecialize(LLVMPointer arg0Value, String arg1Value, Clazz arg2Value, Method arg3Value, long arg4Value, Object[] arg5Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMInteropMethodInvokeNode.doVirtualCall(LLVMPointer, String, Clazz, Method, long, Object[], InteropLibrary, LLVMInteropVtableAccessNode)] */ && (LLVMInteropMethodInvokeNode.isVirtual(arg4Value))) {
            while (true) {
                int count0_ = 0;
                VirtualCallCachedData s0_ = VIRTUAL_CALL_CACHED_CACHE_UPDATER.getVolatile(this);
                VirtualCallCachedData s0_original = s0_;
                while (s0_ != null) {
                    if ((arg2Value == s0_.typeHash_)) {
                        break;
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    // assert (arg2Value == s0_.typeHash_);
                    if (count0_ < (3)) {
                        s0_ = this.insert(new VirtualCallCachedData(s0_original));
                        InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.createDispatched(5)));
                        Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.interop_ = interop__;
                        s0_.typeHash_ = (arg2Value);
                        s0_.vtableHelpNames_ = (arg2Value.getVtableAccessNames());
                        s0_.vtableAccessNode_ = s0_.insert((LLVMInteropVtableAccessNode.create()));
                        if (!VIRTUAL_CALL_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropMethodInvokeNode.doVirtualCallCached(LLVMPointer, String, Clazz, Method, long, Object[], InteropLibrary, Clazz, String[], LLVMInteropVtableAccessNode)] */;
                        this.state_0_ = state_0;
                    }
                }
                if (s0_ != null) {
                    return doVirtualCallCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.interop_, s0_.typeHash_, s0_.vtableHelpNames_, s0_.vtableAccessNode_);
                }
                break;
            }
        }
        if ((LLVMInteropMethodInvokeNode.isVirtual(arg4Value))) {
            VirtualCallData s1_ = this.insert(new VirtualCallData());
            InteropLibrary interop__1 = s1_.insert((INTEROP_LIBRARY_.createDispatched(5)));
            Objects.requireNonNull(interop__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.interop_ = interop__1;
            s1_.vtableAccessNode_ = s1_.insert((LLVMInteropVtableAccessNode.create()));
            VarHandle.storeStoreFence();
            this.virtualCall_cache = s1_;
            this.virtualCallCached_cache = null;
            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMInteropMethodInvokeNode.doVirtualCallCached(LLVMPointer, String, Clazz, Method, long, Object[], InteropLibrary, Clazz, String[], LLVMInteropVtableAccessNode)] */;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropMethodInvokeNode.doVirtualCall(LLVMPointer, String, Clazz, Method, long, Object[], InteropLibrary, LLVMInteropVtableAccessNode)] */;
            this.state_0_ = state_0;
            return doVirtualCall(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, interop__1, s1_.vtableAccessNode_);
        }
        if ((!(LLVMInteropMethodInvokeNode.isVirtual(arg4Value)))) {
            NonvirtualCallData s2_ = this.insert(new NonvirtualCallData());
            s2_.call_ = s2_.insert((LLVMInteropNonvirtualCallNode.create()));
            VarHandle.storeStoreFence();
            this.nonvirtualCall_cache = s2_;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMInteropMethodInvokeNode.doNonvirtualCall(LLVMPointer, String, Clazz, Method, long, Object[], LLVMInteropNonvirtualCallNode)] */;
            this.state_0_ = state_0;
            return doNonvirtualCall(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s2_.call_);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            NonvirtualCallData s2_ = this.insert(new NonvirtualCallData());
            s2_.call_ = s2_.insert((LLVMInteropNonvirtualCallNode.create()));
            VarHandle.storeStoreFence();
            this.nonvirtualCall_cache = s2_;
            assert NodeUtil.assertRecursion(s2_.call_, 1);
            ((GenerateAOT.Provider) s2_.call_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMInteropMethodInvokeNode.doNonvirtualCall(LLVMPointer, String, Clazz, Method, long, Object[], LLVMInteropNonvirtualCallNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.nonvirtualCall_cache = null;
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException6LLLLJL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value, long arg4Value, Object arg5Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
    }

    @NeverDefault
    public static LLVMInteropMethodInvokeNode create() {
        return new LLVMInteropMethodInvokeNodeGen();
    }

    @NeverDefault
    public static LLVMInteropMethodInvokeNode getUncached() {
        return LLVMInteropMethodInvokeNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMInteropMethodInvokeNode.class)
    @DenyReplace
    private static final class VirtualCallCachedData extends Node implements SpecializationDataNode {

        @Child VirtualCallCachedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropMethodInvokeNode#doVirtualCallCached}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropMethodInvokeNode#doVirtualCallCached}
         *   Parameter: {@link Clazz} typeHash</pre>
         */
        @CompilationFinal Clazz typeHash_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropMethodInvokeNode#doVirtualCallCached}
         *   Parameter: {@link String} vtableHelpNames</pre>
         */
        @CompilationFinal(dimensions = 1) String[] vtableHelpNames_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropMethodInvokeNode#doVirtualCallCached}
         *   Parameter: {@link LLVMInteropVtableAccessNode} vtableAccessNode</pre>
         */
        @Child LLVMInteropVtableAccessNode vtableAccessNode_;

        VirtualCallCachedData(VirtualCallCachedData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMInteropMethodInvokeNode.class)
    @DenyReplace
    private static final class VirtualCallData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropMethodInvokeNode#doVirtualCall}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropMethodInvokeNode#doVirtualCall}
         *   Parameter: {@link LLVMInteropVtableAccessNode} vtableAccessNode</pre>
         */
        @Child LLVMInteropVtableAccessNode vtableAccessNode_;

        VirtualCallData() {
        }

    }
    @GeneratedBy(LLVMInteropMethodInvokeNode.class)
    @DenyReplace
    private static final class NonvirtualCallData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropMethodInvokeNode#doNonvirtualCall}
         *   Parameter: {@link LLVMInteropNonvirtualCallNode} call</pre>
         */
        @Child LLVMInteropNonvirtualCallNode call_;

        NonvirtualCallData() {
        }

    }
    @GeneratedBy(LLVMInteropMethodInvokeNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMInteropMethodInvokeNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        Object execute(LLVMPointer arg0Value, String arg1Value, Clazz arg2Value, Method arg3Value, long arg4Value, Object[] arg5Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
            if ((LLVMInteropMethodInvokeNode.isVirtual(arg4Value))) {
                return doVirtualCall(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (INTEROP_LIBRARY_.getUncached()), (LLVMInteropVtableAccessNodeGen.getUncached()));
            }
            if ((!(LLVMInteropMethodInvokeNode.isVirtual(arg4Value)))) {
                return doNonvirtualCall(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (LLVMInteropNonvirtualCallNodeGen.getUncached()));
            }
            throw newUnsupportedSpecializationException6LLLLJL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

    }
}
