// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToVoidLLVM#fromInt}
 *     Activation probability: 0.19111
 *     With/without class size: 6/0 bytes
 *   Specialization {@link ToVoidLLVM#fromChar}
 *     Activation probability: 0.17111
 *     With/without class size: 6/0 bytes
 *   Specialization {@link ToVoidLLVM#fromLong}
 *     Activation probability: 0.15111
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToVoidLLVM#fromByte}
 *     Activation probability: 0.13111
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToVoidLLVM#fromShort}
 *     Activation probability: 0.11111
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToVoidLLVM#fromFloat}
 *     Activation probability: 0.09111
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToVoidLLVM#fromDouble}
 *     Activation probability: 0.07111
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToVoidLLVM#fromBoolean}
 *     Activation probability: 0.05111
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToVoidLLVM#fromString}
 *     Activation probability: 0.03111
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(ToVoidLLVM.class)
@SuppressWarnings("javadoc")
public final class ToVoidLLVMNodeGen extends ToVoidLLVM implements GenerateAOT.Provider {

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link ToVoidLLVM#fromInt}
     *   2: SpecializationActive {@link ToVoidLLVM#fromChar}
     *   3: SpecializationActive {@link ToVoidLLVM#fromLong}
     *   4: SpecializationActive {@link ToVoidLLVM#fromByte}
     *   5: SpecializationActive {@link ToVoidLLVM#fromShort}
     *   6: SpecializationActive {@link ToVoidLLVM#fromFloat}
     *   7: SpecializationActive {@link ToVoidLLVM#fromDouble}
     *   8: SpecializationActive {@link ToVoidLLVM#fromBoolean}
     *   9: SpecializationActive {@link ToVoidLLVM#fromString}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private ToVoidLLVMNodeGen() {
    }

    @Override
    public Object executeWithForeignToLLVMType(Object arg0Value, Structured type, ForeignToLLVMType ftlType) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b1111111110) != 0 /* is SpecializationActive[ToVoidLLVM.fromInt(int)] || SpecializationActive[ToVoidLLVM.fromChar(char)] || SpecializationActive[ToVoidLLVM.fromLong(long)] || SpecializationActive[ToVoidLLVM.fromByte(byte)] || SpecializationActive[ToVoidLLVM.fromShort(short)] || SpecializationActive[ToVoidLLVM.fromFloat(float)] || SpecializationActive[ToVoidLLVM.fromDouble(double)] || SpecializationActive[ToVoidLLVM.fromBoolean(boolean)] || SpecializationActive[ToVoidLLVM.fromString(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToVoidLLVM.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToVoidLLVM.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToVoidLLVM.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToVoidLLVM.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToVoidLLVM.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromString(Object)] */) {
                return fromString(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @Override
    public Object executeWithType(Object arg0Value, Structured type) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b1111111110) != 0 /* is SpecializationActive[ToVoidLLVM.fromInt(int)] || SpecializationActive[ToVoidLLVM.fromChar(char)] || SpecializationActive[ToVoidLLVM.fromLong(long)] || SpecializationActive[ToVoidLLVM.fromByte(byte)] || SpecializationActive[ToVoidLLVM.fromShort(short)] || SpecializationActive[ToVoidLLVM.fromFloat(float)] || SpecializationActive[ToVoidLLVM.fromDouble(double)] || SpecializationActive[ToVoidLLVM.fromBoolean(boolean)] || SpecializationActive[ToVoidLLVM.fromString(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToVoidLLVM.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToVoidLLVM.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToVoidLLVM.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToVoidLLVM.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToVoidLLVM.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromString(Object)] */) {
                return fromString(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b1111111110) != 0 /* is SpecializationActive[ToVoidLLVM.fromInt(int)] || SpecializationActive[ToVoidLLVM.fromChar(char)] || SpecializationActive[ToVoidLLVM.fromLong(long)] || SpecializationActive[ToVoidLLVM.fromByte(byte)] || SpecializationActive[ToVoidLLVM.fromShort(short)] || SpecializationActive[ToVoidLLVM.fromFloat(float)] || SpecializationActive[ToVoidLLVM.fromDouble(double)] || SpecializationActive[ToVoidLLVM.fromBoolean(boolean)] || SpecializationActive[ToVoidLLVM.fromString(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToVoidLLVM.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToVoidLLVM.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToVoidLLVM.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToVoidLLVM.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToVoidLLVM.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToVoidLLVM.fromString(Object)] */) {
                return fromString(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[ToVoidLLVM.fromInt(int)] */;
            this.state_0_ = state_0;
            return fromInt(arg0Value_);
        }
        if (arg0Value instanceof Character) {
            char arg0Value_ = (char) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[ToVoidLLVM.fromChar(char)] */;
            this.state_0_ = state_0;
            return fromChar(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[ToVoidLLVM.fromLong(long)] */;
            this.state_0_ = state_0;
            return fromLong(arg0Value_);
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (byte) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[ToVoidLLVM.fromByte(byte)] */;
            this.state_0_ = state_0;
            return fromByte(arg0Value_);
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (short) arg0Value;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[ToVoidLLVM.fromShort(short)] */;
            this.state_0_ = state_0;
            return fromShort(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = (float) arg0Value;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToVoidLLVM.fromFloat(float)] */;
            this.state_0_ = state_0;
            return fromFloat(arg0Value_);
        }
        if (arg0Value instanceof Double) {
            double arg0Value_ = (double) arg0Value;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToVoidLLVM.fromDouble(double)] */;
            this.state_0_ = state_0;
            return fromDouble(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToVoidLLVM.fromBoolean(boolean)] */;
            this.state_0_ = state_0;
            return fromBoolean(arg0Value_);
        }
        state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ToVoidLLVM.fromString(Object)] */;
        this.state_0_ = state_0;
        return fromString(arg0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToVoidLLVM.fromInt(int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[ToVoidLLVM.fromChar(char)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToVoidLLVM.fromLong(long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[ToVoidLLVM.fromByte(byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[ToVoidLLVM.fromShort(short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[ToVoidLLVM.fromFloat(float)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[ToVoidLLVM.fromDouble(double)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[ToVoidLLVM.fromBoolean(boolean)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[ToVoidLLVM.fromString(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static ToVoidLLVM create() {
        return new ToVoidLLVMNodeGen();
    }

}
