// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults.DefaultLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.VarHandle;

@GeneratedBy(DefaultLibrary.class)
@SuppressWarnings("javadoc")
final class DefaultLibraryGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(DefaultLibrary.class, new LLVMNativeLibraryExports());
    }

    private DefaultLibraryGen() {
    }

    @GeneratedBy(DefaultLibrary.class)
    private static final class LLVMNativeLibraryExports extends LibraryExport<LLVMNativeLibrary> {

        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, Object.class, true, false, 0);
        }

        @Override
        protected LLVMNativeLibrary createUncached(Object receiver) {
            LLVMNativeLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected LLVMNativeLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(DefaultLibrary.class)
        private static final class Cached extends LLVMNativeLibrary {

            @Child private InteropLibrary receiverInteropLibrary_;
            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsPointer#doPointer}
             *   1: SpecializationActive {@link IsPointer#doOther}
             *   2: SpecializationActive {@link AsPointer#doPointer}
             *   3: SpecializationActive {@link AsPointer#doNullCheck}
             *   4: SpecializationActive {@link ToNativePointer#doNull}
             *   5: SpecializationActive {@link ToNativePointer#doAlreadyNative}
             *   6: SpecializationExcluded {@link ToNativePointer#doAlreadyNative}
             *   7: SpecializationActive {@link ToNativePointer#doNotNull}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AsPointer#doPointer}
             *   Parameter: {@link BranchProfile} exceptionProfile</pre>
             */
            @CompilationFinal private BranchProfile exception;

            protected Cached(Object receiver) {
                this.receiverInteropLibrary_ = INTEROP_LIBRARY_.create((receiver));
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                if (!(dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_)) {
                    return false;
                } else if (!this.receiverInteropLibrary_.accepts((receiver))) {
                    return false;
                } else {
                    return true;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsPointer#doPointer}
             *     Activation probability: 0.21667
             *     With/without class size: 6/0 bytes
             *   Specialization {@link IsPointer#doOther}
             *     Activation probability: 0.11667
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public boolean isPointer(Object arg0Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[DefaultLibrary.IsPointer.doPointer(Object, InteropLibrary)] || SpecializationActive[DefaultLibrary.IsPointer.doOther(Object, InteropLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[DefaultLibrary.IsPointer.doPointer(Object, InteropLibrary)] */) {
                        {
                            InteropLibrary interop__ = this.receiverInteropLibrary_;
                            if ((interop__.isPointer(arg0Value))) {
                                return IsPointer.doPointer(arg0Value, interop__);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[DefaultLibrary.IsPointer.doOther(Object, InteropLibrary)] */) {
                        {
                            InteropLibrary interop__1 = this.receiverInteropLibrary_;
                            if ((!(interop__1.isPointer(arg0Value)))) {
                                return IsPointer.doOther(arg0Value, interop__1);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isPointerAndSpecialize(arg0Value);
            }

            private boolean isPointerAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    InteropLibrary interop__ = null;
                    {
                        interop__ = this.receiverInteropLibrary_;
                        if ((interop__.isPointer(arg0Value))) {
                            state_0 = state_0 | 0b1 /* add SpecializationActive[DefaultLibrary.IsPointer.doPointer(Object, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return IsPointer.doPointer(arg0Value, interop__);
                        }
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        interop__1 = this.receiverInteropLibrary_;
                        if ((!(interop__1.isPointer(arg0Value)))) {
                            state_0 = state_0 | 0b10 /* add SpecializationActive[DefaultLibrary.IsPointer.doOther(Object, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return IsPointer.doOther(arg0Value, interop__1);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link AsPointer#doPointer}
             *     Activation probability: 0.21667
             *     With/without class size: 6/0 bytes
             *   Specialization {@link AsPointer#doNullCheck}
             *     Activation probability: 0.11667
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public long asPointer(Object arg0Value) throws UnsupportedMessageException {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1100) != 0 /* is SpecializationActive[DefaultLibrary.AsPointer.doPointer(Object, InteropLibrary, BranchProfile)] || SpecializationActive[DefaultLibrary.AsPointer.doNullCheck(Object, InteropLibrary, BranchProfile)] */) {
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[DefaultLibrary.AsPointer.doPointer(Object, InteropLibrary, BranchProfile)] */) {
                        {
                            BranchProfile exception_ = this.exception;
                            if (exception_ != null) {
                                InteropLibrary interop__ = this.receiverInteropLibrary_;
                                if ((interop__.isPointer(arg0Value))) {
                                    return AsPointer.doPointer(arg0Value, interop__, exception_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[DefaultLibrary.AsPointer.doNullCheck(Object, InteropLibrary, BranchProfile)] */) {
                        {
                            BranchProfile exception_1 = this.exception;
                            if (exception_1 != null) {
                                InteropLibrary interop__1 = this.receiverInteropLibrary_;
                                if ((!(interop__1.isPointer(arg0Value)))) {
                                    return AsPointer.doNullCheck(arg0Value, interop__1, exception_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asPointerAndSpecialize(arg0Value);
            }

            private long asPointerAndSpecialize(Object arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary interop__ = null;
                    {
                        interop__ = this.receiverInteropLibrary_;
                        if ((interop__.isPointer(arg0Value))) {
                            BranchProfile exception_;
                            BranchProfile exception__shared = this.exception;
                            if (exception__shared != null) {
                                exception_ = exception__shared;
                            } else {
                                exception_ = (BranchProfile.create());
                                if (exception_ == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.exception == null) {
                                VarHandle.storeStoreFence();
                                this.exception = exception_;
                            }
                            state_0 = state_0 | 0b100 /* add SpecializationActive[DefaultLibrary.AsPointer.doPointer(Object, InteropLibrary, BranchProfile)] */;
                            this.state_0_ = state_0;
                            return AsPointer.doPointer(arg0Value, interop__, exception_);
                        }
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        interop__1 = this.receiverInteropLibrary_;
                        if ((!(interop__1.isPointer(arg0Value)))) {
                            BranchProfile exception_1;
                            BranchProfile exception_1_shared = this.exception;
                            if (exception_1_shared != null) {
                                exception_1 = exception_1_shared;
                            } else {
                                exception_1 = (BranchProfile.create());
                                if (exception_1 == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.exception == null) {
                                VarHandle.storeStoreFence();
                                this.exception = exception_1;
                            }
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[DefaultLibrary.AsPointer.doNullCheck(Object, InteropLibrary, BranchProfile)] */;
                            this.state_0_ = state_0;
                            return AsPointer.doNullCheck(arg0Value, interop__1, exception_1);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ToNativePointer#doNull}
             *     Activation probability: 0.16111
             *     With/without class size: 5/0 bytes
             *   Specialization {@link ToNativePointer#doAlreadyNative}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             *   Specialization {@link ToNativePointer#doNotNull}
             *     Activation probability: 0.06111
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10110000) != 0 /* is SpecializationActive[DefaultLibrary.ToNativePointer.doNull(Object, InteropLibrary)] || SpecializationActive[DefaultLibrary.ToNativePointer.doAlreadyNative(Object, InteropLibrary)] || SpecializationActive[DefaultLibrary.ToNativePointer.doNotNull(Object, InteropLibrary, BranchProfile)] */) {
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[DefaultLibrary.ToNativePointer.doNull(Object, InteropLibrary)] */) {
                        {
                            InteropLibrary interop__ = this.receiverInteropLibrary_;
                            if ((interop__.isNull(arg0Value))) {
                                return ToNativePointer.doNull(arg0Value, interop__);
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[DefaultLibrary.ToNativePointer.doAlreadyNative(Object, InteropLibrary)] */) {
                        {
                            InteropLibrary interop__1 = this.receiverInteropLibrary_;
                            if ((!(interop__1.isNull(arg0Value))) && (interop__1.isPointer(arg0Value))) {
                                try {
                                    return ToNativePointer.doAlreadyNative(arg0Value, interop__1);
                                } catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[DefaultLibrary.ToNativePointer.doAlreadyNative(Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return toNativePointerAndSpecialize(arg0Value);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[DefaultLibrary.ToNativePointer.doNotNull(Object, InteropLibrary, BranchProfile)] */) {
                        {
                            BranchProfile exception_ = this.exception;
                            if (exception_ != null) {
                                InteropLibrary interop__2 = this.receiverInteropLibrary_;
                                if ((!(interop__2.isNull(arg0Value)))) {
                                    return ToNativePointer.doNotNull(arg0Value, interop__2, exception_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return toNativePointerAndSpecialize(arg0Value);
            }

            private LLVMNativePointer toNativePointerAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    InteropLibrary interop__ = null;
                    {
                        interop__ = this.receiverInteropLibrary_;
                        if ((interop__.isNull(arg0Value))) {
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[DefaultLibrary.ToNativePointer.doNull(Object, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return ToNativePointer.doNull(arg0Value, interop__);
                        }
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[DefaultLibrary.ToNativePointer.doNotNull(Object, InteropLibrary, BranchProfile)] */ && ((state_0 & 0b1000000)) == 0 /* is-not SpecializationExcluded  */) {
                        {
                            interop__1 = this.receiverInteropLibrary_;
                            if ((!(interop__1.isNull(arg0Value))) && (interop__1.isPointer(arg0Value))) {
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[DefaultLibrary.ToNativePointer.doAlreadyNative(Object, InteropLibrary)] */;
                                this.state_0_ = state_0;
                                try {
                                    return ToNativePointer.doAlreadyNative(arg0Value, interop__1);
                                } catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[DefaultLibrary.ToNativePointer.doAlreadyNative(Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return toNativePointerAndSpecialize(arg0Value);
                                }
                            }
                        }
                    }
                }
                {
                    InteropLibrary interop__2 = null;
                    {
                        interop__2 = this.receiverInteropLibrary_;
                        if ((!(interop__2.isNull(arg0Value)))) {
                            BranchProfile exception_;
                            BranchProfile exception__shared = this.exception;
                            if (exception__shared != null) {
                                exception_ = exception__shared;
                            } else {
                                exception_ = (BranchProfile.create());
                                if (exception_ == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.exception == null) {
                                VarHandle.storeStoreFence();
                                this.exception = exception_;
                            }
                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[DefaultLibrary.ToNativePointer.doAlreadyNative(Object, InteropLibrary)] */;
                            state_0 = state_0 | 0b10000000 /* add SpecializationActive[DefaultLibrary.ToNativePointer.doNotNull(Object, InteropLibrary, BranchProfile)] */;
                            this.state_0_ = state_0;
                            return ToNativePointer.doNotNull(arg0Value, interop__2, exception_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
        @GeneratedBy(DefaultLibrary.class)
        @DenyReplace
        private static final class Uncached extends LLVMNativeLibrary implements UnadoptableNode {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object arg0Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                if ((INTEROP_LIBRARY_.getUncached((arg0Value)).isPointer(arg0Value))) {
                    return IsPointer.doPointer(arg0Value, INTEROP_LIBRARY_.getUncached((arg0Value)));
                }
                if ((!(INTEROP_LIBRARY_.getUncached((arg0Value)).isPointer(arg0Value)))) {
                    return IsPointer.doOther(arg0Value, INTEROP_LIBRARY_.getUncached((arg0Value)));
                }
                throw newUnsupportedSpecializationException1(this, arg0Value);
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                if ((INTEROP_LIBRARY_.getUncached((arg0Value)).isPointer(arg0Value))) {
                    return AsPointer.doPointer(arg0Value, INTEROP_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
                }
                if ((!(INTEROP_LIBRARY_.getUncached((arg0Value)).isPointer(arg0Value)))) {
                    return AsPointer.doNullCheck(arg0Value, INTEROP_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
                }
                throw newUnsupportedSpecializationException1(this, arg0Value);
            }

            @TruffleBoundary
            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                if ((INTEROP_LIBRARY_.getUncached((arg0Value)).isNull(arg0Value))) {
                    return ToNativePointer.doNull(arg0Value, INTEROP_LIBRARY_.getUncached((arg0Value)));
                }
                if ((!(INTEROP_LIBRARY_.getUncached((arg0Value)).isNull(arg0Value)))) {
                    return ToNativePointer.doNotNull(arg0Value, INTEROP_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
                }
                throw newUnsupportedSpecializationException1(this, arg0Value);
            }

            @TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value);
            }

        }
    }
}
