// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults.ArrayLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults.DefaultLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults.LongLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMNativeLibrary.class)
final class LLVMNativeLibraryGen extends LibraryFactory<LLVMNativeLibrary> {

    private static final Class<LLVMNativeLibrary> LIBRARY_CLASS = LLVMNativeLibraryGen.lazyLibraryClass();
    private static final Message IS_POINTER = new MessageImpl("isPointer", 0, false, boolean.class, Object.class);
    private static final Message AS_POINTER = new MessageImpl("asPointer", 1, false, long.class, Object.class);
    private static final Message TO_NATIVE_POINTER = new MessageImpl("toNativePointer", 2, false, LLVMNativePointer.class, Object.class);
    private static final LLVMNativeLibraryGen INSTANCE = new LLVMNativeLibraryGen();

    static  {
        LibraryFactory.register(LLVMNativeLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private LLVMNativeLibraryGen() {
        super(LLVMNativeLibraryGen.LIBRARY_CLASS, List.of(LLVMNativeLibraryGen.IS_POINTER, LLVMNativeLibraryGen.AS_POINTER, LLVMNativeLibraryGen.TO_NATIVE_POINTER));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof Long) {
            return LongLibrary.class;
        } else if (receiver instanceof byte[]) {
            return ArrayLibrary.class;
        } else {
            return DefaultLibrary.class;
        }
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected LLVMNativeLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected LLVMNativeLibrary createDelegate(LLVMNativeLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMNativeLibrary lib = (LLVMNativeLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.isPointer(receiver);
            case 1 :
                return lib.asPointer(receiver);
            case 2 :
                return lib.toNativePointer(receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected LLVMNativeLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected LLVMNativeLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<LLVMNativeLibrary> lazyLibraryClass() {
        try {
            return (Class<LLVMNativeLibrary>) Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary", false, LLVMNativeLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(LLVMNativeLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(LLVMNativeLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(LLVMNativeLibrary.class)
    private static final class Proxy extends LLVMNativeLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, LLVMNativeLibraryGen.IS_POINTER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            try {
                return (long) lib.send(receiver_, LLVMNativeLibraryGen.AS_POINTER);
            } catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public LLVMNativePointer toNativePointer(Object receiver_) {
            try {
                return (LLVMNativePointer) lib.send(receiver_, LLVMNativeLibraryGen.TO_NATIVE_POINTER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(LLVMNativeLibrary.class)
    private static final class Delegate extends LLVMNativeLibrary {

        @Child private LLVMNativeLibrary delegateLibrary;

        Delegate(LLVMNativeLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isPointer(delegate);
            } else {
                return this.delegateLibrary.isPointer(receiver_);
            }
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).asPointer(delegate);
            } else {
                return this.delegateLibrary.asPointer(receiver_);
            }
        }

        @Override
        public LLVMNativePointer toNativePointer(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).toNativePointer(delegate);
            } else {
                return this.delegateLibrary.toNativePointer(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(LLVMNativeLibrary.class)
    private static final class CachedToUncachedDispatch extends LLVMNativeLibrary {

        @TruffleBoundary
        @Override
        public boolean isPointer(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isPointer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).asPointer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public LLVMNativePointer toNativePointer(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).toNativePointer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(LLVMNativeLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends LLVMNativeLibrary implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public boolean isPointer(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isPointer(receiver_);
        }

        @TruffleBoundary
        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            return INSTANCE.getUncached(receiver_).asPointer(receiver_);
        }

        @TruffleBoundary
        @Override
        public LLVMNativePointer toNativePointer(Object receiver_) {
            return INSTANCE.getUncached(receiver_).toNativePointer(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(LLVMNativeLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(LLVMNativeLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

    }
    @GeneratedBy(LLVMNativeLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch implements GenerateAOT.Provider {

        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMNativeLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport<LLVMNativeLibrary> export : INSTANCE.getAOTExports()) {
                LLVMNativeLibrary exportLibrary = INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = insert(exportLibrary);
                } else {
                    this.next = insert(new CachedDispatchNext(exportLibrary, this.next));
                }
            }
            this.aot_ = true;
        }

    }
    @GeneratedBy(LLVMNativeLibrary.class)
    private abstract static class CachedDispatch extends LLVMNativeLibrary {

        @Child LLVMNativeLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(LLVMNativeLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean value);

        @ExplodeLoop
        @Override
        public boolean isPointer(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMNativeLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isPointer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMNativeLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.asPointer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public LLVMNativePointer toNativePointer(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMNativeLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.toNativePointer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                if (isAOT()) {
                    this.library = null;
                    this.next = null;
                    setAOT(false);
                }
                CachedDispatch current = this;
                LLVMNativeLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        LLVMNativeLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
