// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults.LongLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GeneratedBy(LongLibrary.class)
final class LongLibraryGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LongLibrary.class, new LLVMNativeLibraryExports());
    }

    private LongLibraryGen() {
    }

    @GeneratedBy(LongLibrary.class)
    private static final class LLVMNativeLibraryExports extends LibraryExport<LLVMNativeLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, Long.class, true, false, 0);
        }

        @Override
        protected LLVMNativeLibrary createUncached(Object receiver) {
            assert receiver instanceof Long;
            LLVMNativeLibrary uncached = LLVMNativeLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected LLVMNativeLibrary createCached(Object receiver) {
            assert receiver instanceof Long;
            return LLVMNativeLibraryExports.CACHE;
        }

        @GeneratedBy(LongLibrary.class)
        private static final class Cached extends LLVMNativeLibrary implements UnadoptableNode {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof Long) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Long;
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LongLibrary.isPointer((((Long) receiver)));
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LongLibrary.asPointer((((Long) receiver)));
            }

            @Override
            public LLVMNativePointer toNativePointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LongLibrary.toNativePointer((((Long) receiver)));
            }

        }
        @GeneratedBy(LongLibrary.class)
        @DenyReplace
        private static final class Uncached extends LLVMNativeLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof Long) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Long;
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LongLibrary.isPointer(((Long) receiver) );
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LongLibrary.asPointer(((Long) receiver) );
            }

            @TruffleBoundary
            @Override
            public LLVMNativePointer toNativePointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LongLibrary.toNativePointer(((Long) receiver) );
            }

        }
    }
}
