// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode.LLVMPointerDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNodeFactory.LLVMPointerDataEscapeNodeGen;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(LLVMInstrumentableNode.class)
@SuppressWarnings("javadoc")
public final class LLVMInstrumentableNodeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LLVMInstrumentableNode.class, new NodeLibraryExports());
    }

    private LLVMInstrumentableNodeGen() {
    }

    @GeneratedBy(LLVMInstrumentableNode.class)
    public static class NodeLibraryExports extends LibraryExport<NodeLibrary> {

        private NodeLibraryExports() {
            super(NodeLibrary.class, LLVMInstrumentableNode.class, false, false, 0);
        }

        @Override
        protected NodeLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMInstrumentableNode;
            NodeLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NodeLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMInstrumentableNode;
            return new Cached(receiver);
        }

        @GeneratedBy(LLVMInstrumentableNode.class)
        public static class Cached extends NodeLibrary {

            private final Class<? extends LLVMInstrumentableNode> receiverClass_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LLVMInstrumentableNode#getRootInstance(LLVMInstrumentableNode, Frame, NodeLibrary, LLVMPointerDataEscapeNode, BranchProfile)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMInstrumentableNode#getRootInstance(LLVMInstrumentableNode, Frame, NodeLibrary, LLVMPointerDataEscapeNode, BranchProfile)}
             *   Parameter: {@link LLVMPointerDataEscapeNode} dataEscapeNode</pre>
             */
            @Child private LLVMPointerDataEscapeNode getRootInstanceNode__getRootInstance_dataEscapeNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMInstrumentableNode#getRootInstance(LLVMInstrumentableNode, Frame, NodeLibrary, LLVMPointerDataEscapeNode, BranchProfile)}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal private BranchProfile getRootInstanceNode__getRootInstance_exception_;

            protected Cached(Object receiver) {
                LLVMInstrumentableNode castReceiver = ((LLVMInstrumentableNode) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean hasScope(Object receiver, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasScope(frame);
            }

            @Override
            public boolean hasRootInstance(Object receiver, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasRootInstance(frame);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LLVMInstrumentableNode#getScope(LLVMInstrumentableNode, Frame, boolean, NodeLibrary)}
             *     Activation probability: 0.50000
             *     With/without class size: 10/0 bytes
             * </pre>
             */
            @Override
            public Object getScope(Object arg0Value_, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMInstrumentableNode arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                {
                    NodeLibrary self__ = (this);
                    return arg0Value.getScope(arg1Value, arg2Value, self__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LLVMInstrumentableNode#getRootInstance(LLVMInstrumentableNode, Frame, NodeLibrary, LLVMPointerDataEscapeNode, BranchProfile)}
             *     Activation probability: 0.50000
             *     With/without class size: 16/8 bytes
             * </pre>
             */
            @Override
            public Object getRootInstance(Object arg0Value_, Frame arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMInstrumentableNode arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[LLVMInstrumentableNode.getRootInstance(LLVMInstrumentableNode, Frame, NodeLibrary, LLVMPointerDataEscapeNode, BranchProfile)] */) {
                    {
                        LLVMPointerDataEscapeNode dataEscapeNode__ = this.getRootInstanceNode__getRootInstance_dataEscapeNode_;
                        if (dataEscapeNode__ != null) {
                            BranchProfile exception__ = this.getRootInstanceNode__getRootInstance_exception_;
                            if (exception__ != null) {
                                NodeLibrary self__ = (this);
                                return arg0Value.getRootInstance(arg1Value, self__, dataEscapeNode__, exception__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getRootInstanceNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object getRootInstanceNode_AndSpecialize(LLVMInstrumentableNode arg0Value, Frame arg1Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    NodeLibrary self__ = null;
                    self__ = (this);
                    LLVMPointerDataEscapeNode dataEscapeNode__ = this.insert((LLVMPointerDataEscapeNodeGen.create()));
                    Objects.requireNonNull(dataEscapeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getRootInstanceNode__getRootInstance_dataEscapeNode_ = dataEscapeNode__;
                    BranchProfile exception__ = (BranchProfile.create());
                    Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getRootInstanceNode__getRootInstance_exception_ = exception__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[LLVMInstrumentableNode.getRootInstance(LLVMInstrumentableNode, Frame, NodeLibrary, LLVMPointerDataEscapeNode, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return arg0Value.getRootInstance(arg1Value, self__, dataEscapeNode__, exception__);
                }
            }

        }
        @GeneratedBy(LLVMInstrumentableNode.class)
        public static class Uncached extends NodeLibrary implements UnadoptableNode {

            private final Class<? extends LLVMInstrumentableNode> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((LLVMInstrumentableNode) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean hasScope(Object receiver, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInstrumentableNode) receiver) .hasScope(frame);
            }

            @Override
            public boolean hasRootInstance(Object receiver, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInstrumentableNode) receiver) .hasRootInstance(frame);
            }

            @Override
            public Object getScope(Object arg0Value_, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMInstrumentableNode arg0Value = ((LLVMInstrumentableNode) arg0Value_);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return arg0Value.getScope(arg1Value, arg2Value, (this));
            }

            @Override
            public Object getRootInstance(Object arg0Value_, Frame arg1Value) throws UnsupportedMessageException {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMInstrumentableNode arg0Value = ((LLVMInstrumentableNode) arg0Value_);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return arg0Value.getRootInstance(arg1Value, (this), (LLVMPointerDataEscapeNodeGen.getUncached()), (BranchProfile.getUncached()));
            }

        }
    }
}
