// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToPointerNode#doPointer}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link LLVMToPointerNode#doLong}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMToPointerNode#doGeneric}
 *     Activation probability: 0.18333
 *     With/without class size: 7/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMToPointerNode.class)
@SuppressWarnings("javadoc")
public final class LLVMToPointerNodeGen extends LLVMToPointerNode implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToPointerNode#doPointer}
     *   2: SpecializationActive {@link LLVMToPointerNode#doGeneric}
     *   3: SpecializationActive {@link LLVMToPointerNode#doLong}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMToPointerNode#doGeneric}
     *   Parameter: {@link LLVMToNativeNode} toNative</pre>
     */
    @Child private LLVMToNativeNode generic_toNative_;

    private LLVMToPointerNodeGen() {
    }

    @Override
    public LLVMPointer executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMToPointerNode.doPointer(LLVMPointer)] || SpecializationActive[LLVMToPointerNode.doLong(long)] || SpecializationActive[LLVMToPointerNode.doGeneric(Object, LLVMToNativeNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToPointerNode.doPointer(LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return doPointer(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToPointerNode.doLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return doLong(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToPointerNode.doGeneric(Object, LLVMToNativeNode)] */) {
                {
                    LLVMToNativeNode toNative__ = this.generic_toNative_;
                    if (toNative__ != null) {
                        return doGeneric(arg0Value, toNative__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private LLVMPointer executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMToPointerNode.doGeneric(Object, LLVMToNativeNode)] */ && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToPointerNode.doPointer(LLVMPointer)] */;
            this.state_0_ = state_0;
            return doPointer(arg0Value_);
        }
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMToPointerNode.doGeneric(Object, LLVMToNativeNode)] */ && arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToPointerNode.doLong(long)] */;
            this.state_0_ = state_0;
            return doLong(arg0Value_);
        }
        LLVMToNativeNode toNative__ = this.insert((LLVMToNativeNodeGen.create()));
        Objects.requireNonNull(toNative__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        VarHandle.storeStoreFence();
        this.generic_toNative_ = toNative__;
        state_0 = state_0 & 0xfffffff5 /* remove SpecializationActive[LLVMToPointerNode.doPointer(LLVMPointer)], SpecializationActive[LLVMToPointerNode.doLong(long)] */;
        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToPointerNode.doGeneric(Object, LLVMToNativeNode)] */;
        this.state_0_ = state_0;
        return doGeneric(arg0Value, toNative__);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            LLVMToNativeNode toNative__ = this.insert((LLVMToNativeNodeGen.create()));
            Objects.requireNonNull(toNative__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.generic_toNative_ = toNative__;
            this.state_0_ = state_0_ & 0xfffffff5 /* remove SpecializationActive[LLVMToPointerNode.doPointer(LLVMPointer)], SpecializationActive[LLVMToPointerNode.doLong(long)] */;
            assert NodeUtil.assertRecursion(this.generic_toNative_, 1);
            ((GenerateAOT.Provider) this.generic_toNative_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToPointerNode.doGeneric(Object, LLVMToNativeNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.generic_toNative_ = null;
    }

    @NeverDefault
    public static LLVMToPointerNode create() {
        return new LLVMToPointerNodeGen();
    }

    @NeverDefault
    public static LLVMToPointerNode getUncached() {
        return LLVMToPointerNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMToPointerNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMToPointerNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public LLVMPointer executeWithTarget(Object arg0Value) {
            return doGeneric(arg0Value, (LLVMToNativeNodeGen.getUncached()));
        }

    }
}
