// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@GeneratedBy(LLVMTypesLongPointer.class)
public final class LLVMTypesLongPointerGen extends LLVMTypesLongPointer {

    protected LLVMTypesLongPointerGen() {
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static boolean asBoolean(Object value) {
        assert value instanceof Boolean : "LLVMTypesLongPointerGen.asBoolean: boolean expected";
        return (boolean) value;
    }

    public static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (boolean) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isByte(Object value) {
        return value instanceof Byte;
    }

    public static byte asByte(Object value) {
        assert value instanceof Byte : "LLVMTypesLongPointerGen.asByte: byte expected";
        return (byte) value;
    }

    public static byte expectByte(Object value) throws UnexpectedResultException {
        if (value instanceof Byte) {
            return (byte) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isShort(Object value) {
        return value instanceof Short;
    }

    public static short asShort(Object value) {
        assert value instanceof Short : "LLVMTypesLongPointerGen.asShort: short expected";
        return (short) value;
    }

    public static short expectShort(Object value) throws UnexpectedResultException {
        if (value instanceof Short) {
            return (short) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isInteger(Object value) {
        return value instanceof Integer;
    }

    public static int asInteger(Object value) {
        assert value instanceof Integer : "LLVMTypesLongPointerGen.asInteger: int expected";
        return (int) value;
    }

    public static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (int) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isCharacter(Object value) {
        return value instanceof Character;
    }

    public static char asCharacter(Object value) {
        assert value instanceof Character : "LLVMTypesLongPointerGen.asCharacter: char expected";
        return (char) value;
    }

    public static char expectCharacter(Object value) throws UnexpectedResultException {
        if (value instanceof Character) {
            return (char) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLong(Object value) {
        return value instanceof Long;
    }

    public static long asLong(Object value) {
        assert value instanceof Long : "LLVMTypesLongPointerGen.asLong: long expected";
        return (long) value;
    }

    public static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (long) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isDouble(Object value) {
        return value instanceof Double;
    }

    public static double asDouble(Object value) {
        assert value instanceof Double : "LLVMTypesLongPointerGen.asDouble: double expected";
        return (double) value;
    }

    public static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return (double) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isFloat(Object value) {
        return value instanceof Float;
    }

    public static float asFloat(Object value) {
        assert value instanceof Float : "LLVMTypesLongPointerGen.asFloat: float expected";
        return (float) value;
    }

    public static float expectFloat(Object value) throws UnexpectedResultException {
        if (value instanceof Float) {
            return (float) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isByteArray(Object value) {
        return value instanceof byte[];
    }

    public static byte[] asByteArray(Object value) {
        assert value instanceof byte[] : "LLVMTypesLongPointerGen.asByteArray: byte[] expected";
        return (byte[]) value;
    }

    public static byte[] expectByteArray(Object value) throws UnexpectedResultException {
        if (value instanceof byte[]) {
            return (byte[]) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI1Vector(Object value) {
        return value instanceof LLVMI1Vector;
    }

    public static LLVMI1Vector asLLVMI1Vector(Object value) {
        assert value instanceof LLVMI1Vector : "LLVMTypesLongPointerGen.asLLVMI1Vector: LLVMI1Vector expected";
        return (LLVMI1Vector) value;
    }

    public static LLVMI1Vector expectLLVMI1Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI1Vector) {
            return (LLVMI1Vector) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI8Vector(Object value) {
        return value instanceof LLVMI8Vector;
    }

    public static LLVMI8Vector asLLVMI8Vector(Object value) {
        assert value instanceof LLVMI8Vector : "LLVMTypesLongPointerGen.asLLVMI8Vector: LLVMI8Vector expected";
        return (LLVMI8Vector) value;
    }

    public static LLVMI8Vector expectLLVMI8Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI8Vector) {
            return (LLVMI8Vector) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI16Vector(Object value) {
        return value instanceof LLVMI16Vector;
    }

    public static LLVMI16Vector asLLVMI16Vector(Object value) {
        assert value instanceof LLVMI16Vector : "LLVMTypesLongPointerGen.asLLVMI16Vector: LLVMI16Vector expected";
        return (LLVMI16Vector) value;
    }

    public static LLVMI16Vector expectLLVMI16Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI16Vector) {
            return (LLVMI16Vector) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI32Vector(Object value) {
        return value instanceof LLVMI32Vector;
    }

    public static LLVMI32Vector asLLVMI32Vector(Object value) {
        assert value instanceof LLVMI32Vector : "LLVMTypesLongPointerGen.asLLVMI32Vector: LLVMI32Vector expected";
        return (LLVMI32Vector) value;
    }

    public static LLVMI32Vector expectLLVMI32Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI32Vector) {
            return (LLVMI32Vector) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI64Vector(Object value) {
        return value instanceof LLVMI64Vector;
    }

    public static LLVMI64Vector asLLVMI64Vector(Object value) {
        assert value instanceof LLVMI64Vector : "LLVMTypesLongPointerGen.asLLVMI64Vector: LLVMI64Vector expected";
        return (LLVMI64Vector) value;
    }

    public static LLVMI64Vector expectLLVMI64Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI64Vector) {
            return (LLVMI64Vector) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMPointerVector(Object value) {
        return value instanceof LLVMPointerVector;
    }

    public static LLVMPointerVector asLLVMPointerVector(Object value) {
        assert value instanceof LLVMPointerVector : "LLVMTypesLongPointerGen.asLLVMPointerVector: LLVMPointerVector expected";
        return (LLVMPointerVector) value;
    }

    public static LLVMPointerVector expectLLVMPointerVector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMPointerVector) {
            return (LLVMPointerVector) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMFloatVector(Object value) {
        return value instanceof LLVMFloatVector;
    }

    public static LLVMFloatVector asLLVMFloatVector(Object value) {
        assert value instanceof LLVMFloatVector : "LLVMTypesLongPointerGen.asLLVMFloatVector: LLVMFloatVector expected";
        return (LLVMFloatVector) value;
    }

    public static LLVMFloatVector expectLLVMFloatVector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMFloatVector) {
            return (LLVMFloatVector) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMDoubleVector(Object value) {
        return value instanceof LLVMDoubleVector;
    }

    public static LLVMDoubleVector asLLVMDoubleVector(Object value) {
        assert value instanceof LLVMDoubleVector : "LLVMTypesLongPointerGen.asLLVMDoubleVector: LLVMDoubleVector expected";
        return (LLVMDoubleVector) value;
    }

    public static LLVMDoubleVector expectLLVMDoubleVector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMDoubleVector) {
            return (LLVMDoubleVector) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static LLVMNativePointer expectLLVMNativePointer(Object value) throws UnexpectedResultException {
        if (LLVMTypesLongPointer.isNativePointer(value)) {
            return LLVMTypesLongPointer.asNativePointer(value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static LLVMManagedPointer expectLLVMManagedPointer(Object value) throws UnexpectedResultException {
        if (LLVMTypesLongPointer.isManagedPointer(value)) {
            return LLVMTypesLongPointer.asManagedPointer(value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static LLVMPointer expectLLVMPointer(Object value) throws UnexpectedResultException {
        if (LLVMTypesLongPointer.isPointer(value)) {
            return LLVMTypesLongPointer.asPointer(value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static LLVMIVarBit expectLLVMIVarBit(Object value) throws UnexpectedResultException {
        if (LLVMTypesLongPointer.isLLVMIVarBit(value)) {
            return LLVMTypesLongPointer.asLLVMIVarBit(value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVM80BitFloat(Object value) {
        return value instanceof LLVM80BitFloat;
    }

    public static LLVM80BitFloat asLLVM80BitFloat(Object value) {
        assert value instanceof LLVM80BitFloat : "LLVMTypesLongPointerGen.asLLVM80BitFloat: LLVM80BitFloat expected";
        return (LLVM80BitFloat) value;
    }

    public static LLVM80BitFloat expectLLVM80BitFloat(Object value) throws UnexpectedResultException {
        if (value instanceof LLVM80BitFloat) {
            return (LLVM80BitFloat) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isTruffleObject(Object value) {
        return value instanceof TruffleObject;
    }

    public static TruffleObject asTruffleObject(Object value) {
        assert value instanceof TruffleObject : "LLVMTypesLongPointerGen.asTruffleObject: TruffleObject expected";
        return (TruffleObject) value;
    }

    public static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
        if (value instanceof TruffleObject) {
            return (TruffleObject) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static LLVMIVarBit expectImplicitLLVMIVarBit(int state, Object value) throws UnexpectedResultException {
        if ((state & 0b1) != 0 && LLVMTypesLongPointer.isLLVMIVarBit(value)) {
            return LLVMTypesLongPointer.asLLVMIVarBit(value);
        } else if ((state & 0b10) != 0 && LLVMTypesLongPointer.isLLVMIVarBitSmall(value)) {
            return asIVarBit(LLVMTypesLongPointer.asLLVMIVarBitSmall(value));
        } else if ((state & 0b100) != 0 && LLVMTypesLongPointer.isLLVMIVarBitLarge(value)) {
            return asIVarBit(LLVMTypesLongPointer.asLLVMIVarBitLarge(value));
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }
    }

    public static boolean isImplicitLLVMIVarBit(int state, Object value) {
        return ((state & 0b1) != 0 && LLVMTypesLongPointer.isLLVMIVarBit(value))
             || ((state & 0b10) != 0 && LLVMTypesLongPointer.isLLVMIVarBitSmall(value))
             || ((state & 0b100) != 0 && LLVMTypesLongPointer.isLLVMIVarBitLarge(value));
    }

    public static boolean isImplicitLLVMIVarBit(Object value) {
        return LLVMTypesLongPointer.isLLVMIVarBit(value)
             || LLVMTypesLongPointer.isLLVMIVarBitSmall(value)
             || LLVMTypesLongPointer.isLLVMIVarBitLarge(value);
    }

    public static LLVMIVarBit asImplicitLLVMIVarBit(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return asImplicitLLVMIVarBit(value);
        }
        if ((state & 0b1) != 0 && LLVMTypesLongPointer.isLLVMIVarBit(value)) {
            return LLVMTypesLongPointer.asLLVMIVarBit(value);
        } else if ((state & 0b10) != 0 && LLVMTypesLongPointer.isLLVMIVarBitSmall(value)) {
            return asIVarBit(LLVMTypesLongPointer.asLLVMIVarBitSmall(value));
        } else if ((state & 0b100) != 0 && LLVMTypesLongPointer.isLLVMIVarBitLarge(value)) {
            return asIVarBit(LLVMTypesLongPointer.asLLVMIVarBitLarge(value));
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static LLVMIVarBit asImplicitLLVMIVarBit(Object value) {
        if (LLVMTypesLongPointer.isLLVMIVarBit(value)) {
            return LLVMTypesLongPointer.asLLVMIVarBit(value);
        } else if (LLVMTypesLongPointer.isLLVMIVarBitSmall(value)) {
            return asIVarBit(LLVMTypesLongPointer.asLLVMIVarBitSmall(value));
        } else if (LLVMTypesLongPointer.isLLVMIVarBitLarge(value)) {
            return asIVarBit(LLVMTypesLongPointer.asLLVMIVarBitLarge(value));
        } else {
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static int specializeImplicitLLVMIVarBit(Object value) {
        if (LLVMTypesLongPointer.isLLVMIVarBit(value)) {
            return 0b1;
        } else if (LLVMTypesLongPointer.isLLVMIVarBitSmall(value)) {
            return 0b10;
        } else if (LLVMTypesLongPointer.isLLVMIVarBitLarge(value)) {
            return 0b100;
        } else {
            return 0;
        }
    }

    public static LLVMNativePointer expectImplicitLLVMNativePointer(int state, Object value) throws UnexpectedResultException {
        if ((state & 0b1) != 0 && LLVMTypesLongPointer.isNativePointer(value)) {
            return LLVMTypesLongPointer.asNativePointer(value);
        } else if ((state & 0b10) != 0 && value instanceof Long) {
            return asNativePointer((long) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }
    }

    public static boolean isImplicitLLVMNativePointer(int state, Object value) {
        return ((state & 0b1) != 0 && LLVMTypesLongPointer.isNativePointer(value))
             || ((state & 0b10) != 0 && value instanceof Long);
    }

    public static boolean isImplicitLLVMNativePointer(Object value) {
        return LLVMTypesLongPointer.isNativePointer(value)
             || value instanceof Long;
    }

    public static LLVMNativePointer asImplicitLLVMNativePointer(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return asImplicitLLVMNativePointer(value);
        }
        if ((state & 0b1) != 0 && LLVMTypesLongPointer.isNativePointer(value)) {
            return LLVMTypesLongPointer.asNativePointer(value);
        } else if ((state & 0b10) != 0 && value instanceof Long) {
            return asNativePointer((long) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static LLVMNativePointer asImplicitLLVMNativePointer(Object value) {
        if (LLVMTypesLongPointer.isNativePointer(value)) {
            return LLVMTypesLongPointer.asNativePointer(value);
        } else if (value instanceof Long) {
            return asNativePointer((long) value);
        } else {
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static int specializeImplicitLLVMNativePointer(Object value) {
        if (LLVMTypesLongPointer.isNativePointer(value)) {
            return 0b1;
        } else if (value instanceof Long) {
            return 0b10;
        } else {
            return 0;
        }
    }

    public static LLVMPointer expectImplicitLLVMPointer(int state, Object value) throws UnexpectedResultException {
        if ((state & 0b1) != 0 && LLVMTypesLongPointer.isPointer(value)) {
            return LLVMTypesLongPointer.asPointer(value);
        } else if ((state & 0b10) != 0 && value instanceof Long) {
            return asPointer((long) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }
    }

    public static boolean isImplicitLLVMPointer(int state, Object value) {
        return ((state & 0b1) != 0 && LLVMTypesLongPointer.isPointer(value))
             || ((state & 0b10) != 0 && value instanceof Long);
    }

    public static boolean isImplicitLLVMPointer(Object value) {
        return LLVMTypesLongPointer.isPointer(value)
             || value instanceof Long;
    }

    public static LLVMPointer asImplicitLLVMPointer(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return asImplicitLLVMPointer(value);
        }
        if ((state & 0b1) != 0 && LLVMTypesLongPointer.isPointer(value)) {
            return LLVMTypesLongPointer.asPointer(value);
        } else if ((state & 0b10) != 0 && value instanceof Long) {
            return asPointer((long) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static LLVMPointer asImplicitLLVMPointer(Object value) {
        if (LLVMTypesLongPointer.isPointer(value)) {
            return LLVMTypesLongPointer.asPointer(value);
        } else if (value instanceof Long) {
            return asPointer((long) value);
        } else {
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static int specializeImplicitLLVMPointer(Object value) {
        if (LLVMTypesLongPointer.isPointer(value)) {
            return 0b1;
        } else if (value instanceof Long) {
            return 0b10;
        } else {
            return 0;
        }
    }

}
