// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64AddNode.LLVMAMD64AddbNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64AddNode.LLVMAMD64AddlNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64AddNode.LLVMAMD64AddqNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64AddNode.LLVMAMD64AddwNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMAMD64AddNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64AddNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64AddbNode#doI8}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64AddbNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64AddbNodeGen extends LLVMAMD64AddbNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64AddbNode#doI8}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64AddbNodeGen(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, leftValue_, rightValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddbNode.doI8(VirtualFrame, byte, byte)] */) {
                return doI8(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, leftValue_, rightValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddbNode.doI8(VirtualFrame, byte, byte)] */) {
                return doI8(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private byte executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Byte) {
                byte leftValue_ = (byte) leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (byte) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddbNode.doI8(VirtualFrame, byte, byte)] */;
                    this.state_0_ = state_0;
                    return doI8(frameValue, leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddbNode.doI8(VirtualFrame, byte, byte)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddbNode create(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64AddbNodeGen(flags, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64AddwNode#doI16}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64AddwNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64AddwNodeGen extends LLVMAMD64AddwNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64AddwNode#doI16}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64AddwNodeGen(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, leftValue_, rightValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddwNode.doI16(VirtualFrame, short, short)] */) {
                return doI16(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, leftValue_, rightValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddwNode.doI16(VirtualFrame, short, short)] */) {
                return doI16(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private short executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Short) {
                short leftValue_ = (short) leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (short) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddwNode.doI16(VirtualFrame, short, short)] */;
                    this.state_0_ = state_0;
                    return doI16(frameValue, leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddwNode.doI16(VirtualFrame, short, short)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddwNode create(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64AddwNodeGen(flags, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64AddlNode#doI32}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64AddlNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64AddlNodeGen extends LLVMAMD64AddlNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64AddlNode#doI32}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64AddlNodeGen(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, leftValue_, rightValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddlNode.doI32(VirtualFrame, int, int)] */) {
                return doI32(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, leftValue_, rightValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddlNode.doI32(VirtualFrame, int, int)] */) {
                return doI32(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private int executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Integer) {
                int leftValue_ = (int) leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (int) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddlNode.doI32(VirtualFrame, int, int)] */;
                    this.state_0_ = state_0;
                    return doI32(frameValue, leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddlNode.doI32(VirtualFrame, int, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddlNode create(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64AddlNodeGen(flags, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64AddqNode#doI64}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64AddqNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64AddqNodeGen extends LLVMAMD64AddqNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64AddqNode#doI64}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64AddqNodeGen(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, leftValue_, rightValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddqNode.doI64(VirtualFrame, long, long)] */) {
                return doI64(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, leftValue_, rightValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddqNode.doI64(VirtualFrame, long, long)] */) {
                return doI64(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private long executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Long) {
                long leftValue_ = (long) leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (long) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddqNode.doI64(VirtualFrame, long, long)] */;
                    this.state_0_ = state_0;
                    return doI64(frameValue, leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64AddNode.LLVMAMD64AddqNode.doI64(VirtualFrame, long, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddqNode create(LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64AddqNodeGen(flags, left, right);
        }

    }
}
