// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CmpNode.LLVMAMD64CmpbNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CmpNode.LLVMAMD64CmplNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CmpNode.LLVMAMD64CmpqNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CmpNode.LLVMAMD64CmpwNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMAMD64CmpNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64CmpNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64CmpbNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64CmpbNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64CmpbNodeGen extends LLVMAMD64CmpbNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64CmpbNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64CmpbNodeGen(LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmpbNode.doOp(VirtualFrame, byte, byte)] */) {
                doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, leftValue_, rightValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Byte) {
                byte leftValue_ = (byte) leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (byte) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmpbNode.doOp(VirtualFrame, byte, byte)] */;
                    this.state_0_ = state_0;
                    doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmpbNode.doOp(VirtualFrame, byte, byte)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64CmpbNode create(LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64CmpbNodeGen(flags, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64CmpwNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64CmpwNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64CmpwNodeGen extends LLVMAMD64CmpwNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64CmpwNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64CmpwNodeGen(LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmpwNode.doOp(VirtualFrame, short, short)] */) {
                doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, leftValue_, rightValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Short) {
                short leftValue_ = (short) leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (short) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmpwNode.doOp(VirtualFrame, short, short)] */;
                    this.state_0_ = state_0;
                    doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmpwNode.doOp(VirtualFrame, short, short)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64CmpwNode create(LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64CmpwNodeGen(flags, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64CmplNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64CmplNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64CmplNodeGen extends LLVMAMD64CmplNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64CmplNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64CmplNodeGen(LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmplNode.doOp(VirtualFrame, int, int)] */) {
                doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, leftValue_, rightValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Integer) {
                int leftValue_ = (int) leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (int) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmplNode.doOp(VirtualFrame, int, int)] */;
                    this.state_0_ = state_0;
                    doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmplNode.doOp(VirtualFrame, int, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64CmplNode create(LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64CmplNodeGen(flags, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64CmpqNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64CmpqNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64CmpqNodeGen extends LLVMAMD64CmpqNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64CmpqNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64CmpqNodeGen(LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmpqNode.doOp(VirtualFrame, long, long)] */) {
                doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, leftValue_, rightValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Long) {
                long leftValue_ = (long) leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (long) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmpqNode.doOp(VirtualFrame, long, long)] */;
                    this.state_0_ = state_0;
                    doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64CmpNode.LLVMAMD64CmpqNode.doOp(VirtualFrame, long, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64CmpqNode create(LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64CmpqNodeGen(flags, left, right);
        }

    }
}
