// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMAMD64ModNode#doI32}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMAMD64ModNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64ModNodeGen extends LLVMAMD64ModNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode left_;
    @Child private LLVMExpressionNode rightAX_;
    @Child private LLVMExpressionNode rightDX_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMAMD64ModNode#doI32}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMAMD64ModNodeGen(LLVMExpressionNode left, LLVMExpressionNode rightAX, LLVMExpressionNode rightDX) {
        this.left_ = left;
        this.rightAX_ = rightAX;
        this.rightDX_ = rightDX;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        int leftValue_;
        try {
            leftValue_ = this.left_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightAXValue = this.rightAX_.executeGeneric(frameValue);
            Object rightDXValue = this.rightDX_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), rightAXValue, rightDXValue);
        }
        int rightAXValue_;
        try {
            rightAXValue_ = this.rightAX_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightDXValue = this.rightDX_.executeGeneric(frameValue);
            return executeAndSpecialize(leftValue_, ex.getResult(), rightDXValue);
        }
        int rightDXValue_;
        try {
            rightDXValue_ = this.rightDX_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightAXValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(leftValue_, rightAXValue_, rightDXValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ModNode.doI32(int, int, int)] */) {
            return doI32(leftValue_, rightAXValue_, rightDXValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftValue_, rightAXValue_, rightDXValue_);
    }

    @Override
    public int executeI32(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        int leftValue_;
        try {
            leftValue_ = this.left_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightAXValue = this.rightAX_.executeGeneric(frameValue);
            Object rightDXValue = this.rightDX_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), rightAXValue, rightDXValue);
        }
        int rightAXValue_;
        try {
            rightAXValue_ = this.rightAX_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightDXValue = this.rightDX_.executeGeneric(frameValue);
            return executeAndSpecialize(leftValue_, ex.getResult(), rightDXValue);
        }
        int rightDXValue_;
        try {
            rightDXValue_ = this.rightDX_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightAXValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(leftValue_, rightAXValue_, rightDXValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ModNode.doI32(int, int, int)] */) {
            return doI32(leftValue_, rightAXValue_, rightDXValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftValue_, rightAXValue_, rightDXValue_);
    }

    private int executeAndSpecialize(Object leftValue, Object rightAXValue, Object rightDXValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (leftValue instanceof Integer) {
            int leftValue_ = (int) leftValue;
            if (rightAXValue instanceof Integer) {
                int rightAXValue_ = (int) rightAXValue;
                if (rightDXValue instanceof Integer) {
                    int rightDXValue_ = (int) rightDXValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64ModNode.doI32(int, int, int)] */;
                    this.state_0_ = state_0;
                    return doI32(leftValue_, rightAXValue_, rightDXValue_);
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.rightAX_, this.rightDX_}, leftValue, rightAXValue, rightDXValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64ModNode.doI32(int, int, int)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64ModNode create(LLVMExpressionNode left, LLVMExpressionNode rightAX, LLVMExpressionNode rightDX) {
        return new LLVMAMD64ModNodeGen(left, rightAX, rightDX);
    }

}
