// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StoreFlags.LLVMAMD64SahfNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StoreFlags.LLVMAMD64WriteFlagswNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMAMD64StoreFlags.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64StoreFlagsFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64SahfNode#doObject}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64SahfNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64SahfNodeGen extends LLVMAMD64SahfNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode flags_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64SahfNode#doObject}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64SahfNodeGen(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf, LLVMExpressionNode flags) {
            super(cf, pf, af, zf, sf);
            this.flags_ = flags;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte flagsValue_;
            try {
                flagsValue_ = this.flags_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, flagsValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StoreFlags.LLVMAMD64SahfNode.doObject(VirtualFrame, byte)] */) {
                doObject(frameValue, flagsValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, flagsValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object flagsValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (flagsValue instanceof Byte) {
                byte flagsValue_ = (byte) flagsValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64StoreFlags.LLVMAMD64SahfNode.doObject(VirtualFrame, byte)] */;
                this.state_0_ = state_0;
                doObject(frameValue, flagsValue_);
                return;
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.flags_}, flagsValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64StoreFlags.LLVMAMD64SahfNode.doObject(VirtualFrame, byte)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64SahfNode create(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf, LLVMExpressionNode flags) {
            return new LLVMAMD64SahfNodeGen(cf, pf, af, zf, sf, flags);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64WriteFlagswNode#doObject}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64WriteFlagswNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64WriteFlagswNodeGen extends LLVMAMD64WriteFlagswNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode flags_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64WriteFlagswNode#doObject}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64WriteFlagswNodeGen(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf, LLVMAMD64WriteBooleanNode of, LLVMExpressionNode flags) {
            super(cf, pf, af, zf, sf, of);
            this.flags_ = flags;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short flagsValue_;
            try {
                flagsValue_ = this.flags_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, flagsValue_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StoreFlags.LLVMAMD64WriteFlagswNode.doObject(VirtualFrame, short)] */) {
                doObject(frameValue, flagsValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, flagsValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object flagsValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (flagsValue instanceof Short) {
                short flagsValue_ = (short) flagsValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64StoreFlags.LLVMAMD64WriteFlagswNode.doObject(VirtualFrame, short)] */;
                this.state_0_ = state_0;
                doObject(frameValue, flagsValue_);
                return;
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.flags_}, flagsValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64StoreFlags.LLVMAMD64WriteFlagswNode.doObject(VirtualFrame, short)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64WriteFlagswNode create(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf, LLVMAMD64WriteBooleanNode of, LLVMExpressionNode flags) {
            return new LLVMAMD64WriteFlagswNodeGen(cf, pf, af, zf, sf, of, flags);
        }

    }
}
