// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMAMD64AddressComputationNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64AddressComputationNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64AddressDisplacementComputationNode#doLLVMPointer}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link LLVMAMD64AddressDisplacementComputationNode#doInt}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMAMD64AddressDisplacementComputationNode#doLong}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64AddressDisplacementComputationNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64AddressDisplacementComputationNodeGen extends LLVMAMD64AddressDisplacementComputationNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode base_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64AddressDisplacementComputationNode#doLLVMPointer}
         *   2: SpecializationActive {@link LLVMAMD64AddressDisplacementComputationNode#doInt}
         *   3: SpecializationActive {@link LLVMAMD64AddressDisplacementComputationNode#doLong}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64AddressDisplacementComputationNodeGen(int displacement, LLVMExpressionNode base) {
            super(displacement);
            this.base_ = base;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1010) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLLVMPointer(LLVMPointer)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */)) {
                return executeGeneric_int0(state_0, frameValue);
            } else if ((state_0 & 0b110) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLLVMPointer(LLVMPointer)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */)) {
                return executeGeneric_long1(state_0, frameValue);
            } else {
                return executeGeneric_generic2(state_0, frameValue);
            }
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int baseValue_;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] */;
            return doInt(baseValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */;
            return doLong(baseValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_);
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLLVMPointer(LLVMPointer)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLLVMPointer(LLVMPointer)] */ && LLVMTypes.isPointer(baseValue_)) {
                    LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                    return doLLVMPointer(baseValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] */ && baseValue_ instanceof Integer) {
                    int baseValue__ = (int) baseValue_;
                    return doInt(baseValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */ && baseValue_ instanceof Long) {
                    long baseValue__ = (long) baseValue_;
                    return doLong(baseValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1000) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] */ && ((state_0 & 0b1100) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */)) {
                return executeI64_int3(state_0, frameValue);
            } else if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */ && ((state_0 & 0b1100) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */)) {
                return executeI64_long4(state_0, frameValue);
            } else {
                return executeI64_generic5(state_0, frameValue);
            }
        }

        private long executeI64_int3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            int baseValue_;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_));
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] */;
            return doInt(baseValue_);
        }

        private long executeI64_long4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_));
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */;
            return doLong(baseValue_);
        }

        private long executeI64_generic5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_));
            }
            if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */) {
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] */ && baseValue_ instanceof Integer) {
                    int baseValue__ = (int) baseValue_;
                    return doInt(baseValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */ && baseValue_ instanceof Long) {
                    long baseValue__ = (long) baseValue_;
                    return doLong(baseValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_));
        }

        private Object executeAndSpecialize(Object baseValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(baseValue)) {
                LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLLVMPointer(LLVMPointer)] */;
                this.state_0_ = state_0;
                return doLLVMPointer(baseValue_);
            }
            if (baseValue instanceof Integer) {
                int baseValue_ = (int) baseValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] */;
                this.state_0_ = state_0;
                return doInt(baseValue_);
            }
            if (baseValue instanceof Long) {
                long baseValue_ = (long) baseValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */;
                this.state_0_ = state_0;
                return doLong(baseValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.base_}, baseValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLLVMPointer(LLVMPointer)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doInt(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.doLong(long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddressDisplacementComputationNode create(int displacement, LLVMExpressionNode base) {
            return new LLVMAMD64AddressDisplacementComputationNodeGen(displacement, base);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64AddressOffsetComputationNode#doI64(int, int)}
     *     Activation probability: 0.32000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LLVMAMD64AddressOffsetComputationNode#doI64(long, int)}
     *     Activation probability: 0.26000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LLVMAMD64AddressOffsetComputationNode#doI64(long, long)}
     *     Activation probability: 0.20000
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMAMD64AddressOffsetComputationNode#doLLVMPointer(LLVMPointer, int)}
     *     Activation probability: 0.14000
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMAMD64AddressOffsetComputationNode#doLLVMPointer(LLVMPointer, long)}
     *     Activation probability: 0.08000
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64AddressOffsetComputationNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64AddressOffsetComputationNodeGen extends LLVMAMD64AddressOffsetComputationNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode base_;
        @Child private LLVMExpressionNode offset_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64AddressOffsetComputationNode#doI64(int, int)}
         *   2: SpecializationActive {@link LLVMAMD64AddressOffsetComputationNode#doI64(long, int)}
         *   3: SpecializationActive {@link LLVMAMD64AddressOffsetComputationNode#doI64(long, long)}
         *   4: SpecializationActive {@link LLVMAMD64AddressOffsetComputationNode#doLLVMPointer(LLVMPointer, int)}
         *   5: SpecializationActive {@link LLVMAMD64AddressOffsetComputationNode#doLLVMPointer(LLVMPointer, long)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64AddressOffsetComputationNodeGen(int displacement, int shift, LLVMExpressionNode base, LLVMExpressionNode offset) {
            super(displacement, shift);
            this.base_ = base;
            this.offset_ = offset;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111100) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */)) {
                return executeGeneric_int_int0(state_0, frameValue);
            } else if ((state_0 & 0b111010) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */)) {
                return executeGeneric_long_int1(state_0, frameValue);
            } else if ((state_0 & 0b110110) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */)) {
                return executeGeneric_long_long2(state_0, frameValue);
            } else if ((state_0 & 0b101110) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b11110) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else {
                return executeGeneric_generic5(state_0, frameValue);
            }
        }

        private Object executeGeneric_int_int0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int baseValue_;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), offsetValue);
            }
            int offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] */;
            return doI64(baseValue_, offsetValue_);
        }

        private Object executeGeneric_long_int1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), offsetValue);
            }
            int offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */;
            return doI64(baseValue_, offsetValue_);
        }

        private Object executeGeneric_long_long2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), offsetValue);
            }
            long offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */;
            return doI64(baseValue_, offsetValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            int offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] */;
            if (LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return doLLVMPointer(baseValue__, offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_, offsetValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            long offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */;
            if (LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return doLLVMPointer(baseValue__, offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_, offsetValue_);
        }

        private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_, offsetValue_);
            }
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */ && offsetValue_ instanceof Integer) {
                    int offsetValue__ = (int) offsetValue_;
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] */ && baseValue_ instanceof Integer) {
                        int baseValue__ = (int) baseValue_;
                        return doI64(baseValue__, offsetValue__);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */ && baseValue_ instanceof Long) {
                        long baseValue__ = (long) baseValue_;
                        return doI64(baseValue__, offsetValue__);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */ && baseValue_ instanceof Long) {
                    long baseValue__ = (long) baseValue_;
                    if (offsetValue_ instanceof Long) {
                        long offsetValue__ = (long) offsetValue_;
                        return doI64(baseValue__, offsetValue__);
                    }
                }
                if ((state_0 & 0b110000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */ && LLVMTypes.isPointer(baseValue_)) {
                    LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] */ && offsetValue_ instanceof Integer) {
                        int offsetValue__ = (int) offsetValue_;
                        return doLLVMPointer(baseValue__, offsetValue__);
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */ && offsetValue_ instanceof Long) {
                        long offsetValue__ = (long) offsetValue_;
                        return doLLVMPointer(baseValue__, offsetValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_, offsetValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1100) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */)) {
                return executeI64_int_int6(state_0, frameValue);
            } else if ((state_0 & 0b1010) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */)) {
                return executeI64_long_int7(state_0, frameValue);
            } else if ((state_0 & 0b110) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */)) {
                return executeI64_long_long8(state_0, frameValue);
            } else {
                return executeI64_generic9(state_0, frameValue);
            }
        }

        private long executeI64_int_int6(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            int baseValue_;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult(), offsetValue));
            }
            int offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_, offsetValue_));
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] */;
            return doI64(baseValue_, offsetValue_);
        }

        private long executeI64_long_int7(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult(), offsetValue));
            }
            int offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_, offsetValue_));
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */;
            return doI64(baseValue_, offsetValue_);
        }

        private long executeI64_long_long8(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult(), offsetValue));
            }
            long offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_, offsetValue_));
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */;
            return doI64(baseValue_, offsetValue_);
        }

        private long executeI64_generic9(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_, offsetValue_));
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */ && offsetValue_ instanceof Integer) {
                    int offsetValue__ = (int) offsetValue_;
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] */ && baseValue_ instanceof Integer) {
                        int baseValue__ = (int) baseValue_;
                        return doI64(baseValue__, offsetValue__);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */ && baseValue_ instanceof Long) {
                        long baseValue__ = (long) baseValue_;
                        return doI64(baseValue__, offsetValue__);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */ && baseValue_ instanceof Long) {
                    long baseValue__ = (long) baseValue_;
                    if (offsetValue_ instanceof Long) {
                        long offsetValue__ = (long) offsetValue_;
                        return doI64(baseValue__, offsetValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(baseValue_, offsetValue_));
        }

        private Object executeAndSpecialize(Object baseValue, Object offsetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Integer) {
                int offsetValue_ = (int) offsetValue;
                if (baseValue instanceof Integer) {
                    int baseValue_ = (int) baseValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] */;
                    this.state_0_ = state_0;
                    return doI64(baseValue_, offsetValue_);
                }
                if (baseValue instanceof Long) {
                    long baseValue_ = (long) baseValue;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */;
                    this.state_0_ = state_0;
                    return doI64(baseValue_, offsetValue_);
                }
            }
            if (baseValue instanceof Long) {
                long baseValue_ = (long) baseValue;
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (long) offsetValue;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */;
                    this.state_0_ = state_0;
                    return doI64(baseValue_, offsetValue_);
                }
            }
            if (LLVMTypes.isPointer(baseValue)) {
                LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
                if (offsetValue instanceof Integer) {
                    int offsetValue_ = (int) offsetValue;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] */;
                    this.state_0_ = state_0;
                    return doLLVMPointer(baseValue_, offsetValue_);
                }
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (long) offsetValue;
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */;
                    this.state_0_ = state_0;
                    return doLLVMPointer(baseValue_, offsetValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.base_, this.offset_}, baseValue, offsetValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(int, int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doI64(long, long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.doLLVMPointer(LLVMPointer, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddressOffsetComputationNode create(int displacement, int shift, LLVMExpressionNode base, LLVMExpressionNode offset) {
            return new LLVMAMD64AddressOffsetComputationNodeGen(displacement, shift, base, offset);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64AddressNoBaseOffsetComputationNode#doInt}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link LLVMAMD64AddressNoBaseOffsetComputationNode#doLong}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMAMD64AddressNoBaseOffsetComputationNode#doLLVMNativePointer}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64AddressNoBaseOffsetComputationNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64AddressNoBaseOffsetComputationNodeGen extends LLVMAMD64AddressNoBaseOffsetComputationNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode offset_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64AddressNoBaseOffsetComputationNode#doInt}
         *   2: SpecializationActive {@link LLVMAMD64AddressNoBaseOffsetComputationNode#doLong}
         *   3: SpecializationActive {@link LLVMAMD64AddressNoBaseOffsetComputationNode#doLLVMNativePointer}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64AddressNoBaseOffsetComputationNodeGen(int displacement, int shift, LLVMExpressionNode offset) {
            super(displacement, shift);
            this.offset_ = offset;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1100) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doInt(int)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doInt(int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLong(long)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLLVMNativePointer(LLVMNativePointer)] */)) {
                return executeGeneric_int0(state_0, frameValue);
            } else if ((state_0 & 0b1010) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLong(long)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doInt(int)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLong(long)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLLVMNativePointer(LLVMNativePointer)] */)) {
                return executeGeneric_long1(state_0, frameValue);
            } else {
                return executeGeneric_generic2(state_0, frameValue);
            }
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(offsetValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doInt(int)] */;
            return doInt(offsetValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(offsetValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLong(long)] */;
            return doLong(offsetValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(offsetValue_);
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doInt(int)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLong(long)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLLVMNativePointer(LLVMNativePointer)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doInt(int)] */ && offsetValue_ instanceof Integer) {
                    int offsetValue__ = (int) offsetValue_;
                    return doInt(offsetValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLong(long)] */ && offsetValue_ instanceof Long) {
                    long offsetValue__ = (long) offsetValue_;
                    return doLong(offsetValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLLVMNativePointer(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(offsetValue_)) {
                    LLVMNativePointer offsetValue__ = LLVMTypes.asNativePointer(offsetValue_);
                    return doLLVMNativePointer(offsetValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(offsetValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            long offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(offsetValue_));
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLong(long)] */) {
                return doLong(offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(offsetValue_));
        }

        private Object executeAndSpecialize(Object offsetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Integer) {
                int offsetValue_ = (int) offsetValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doInt(int)] */;
                this.state_0_ = state_0;
                return doInt(offsetValue_);
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (long) offsetValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLong(long)] */;
                this.state_0_ = state_0;
                return doLong(offsetValue_);
            }
            if (LLVMTypes.isNativePointer(offsetValue)) {
                LLVMNativePointer offsetValue_ = LLVMTypes.asNativePointer(offsetValue);
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLLVMNativePointer(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doLLVMNativePointer(offsetValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.offset_}, offsetValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doInt(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLong(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.doLLVMNativePointer(LLVMNativePointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddressNoBaseOffsetComputationNode create(int displacement, int shift, LLVMExpressionNode offset) {
            return new LLVMAMD64AddressNoBaseOffsetComputationNodeGen(displacement, shift, offset);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64AddressSegmentComputationNode#doLLVMPointer}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link LLVMAMD64AddressSegmentComputationNode#doI64}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64AddressSegmentComputationNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64AddressSegmentComputationNodeGen extends LLVMAMD64AddressSegmentComputationNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode base_;
        @Child private LLVMExpressionNode offset_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64AddressSegmentComputationNode#doLLVMPointer}
         *   2: SpecializationActive {@link LLVMAMD64AddressSegmentComputationNode#doI64}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64AddressSegmentComputationNodeGen(LLVMExpressionNode base, LLVMExpressionNode offset) {
            this.base_ = base;
            this.offset_ = offset;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doI64(LLVMPointer, long)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doLLVMPointer(LLVMPointer, LLVMNativePointer)] && SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doI64(LLVMPointer, long)] */)) {
                return executeGeneric_long0(state_0, frameValue, baseValue_);
            } else {
                return executeGeneric_generic1(state_0, frameValue, baseValue_);
            }
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue, Object baseValue_) {
            int state_0 = state_0__;
            long offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doI64(LLVMPointer, long)] */;
            if (LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return doI64(baseValue__, offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_, offsetValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue, Object baseValue_) {
            int state_0 = state_0__;
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(baseValue_, offsetValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doLLVMPointer(LLVMPointer, LLVMNativePointer)] || SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doI64(LLVMPointer, long)] */ && LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doLLVMPointer(LLVMPointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(offsetValue_)) {
                    LLVMNativePointer offsetValue__ = LLVMTypes.asNativePointer(offsetValue_);
                    return doLLVMPointer(baseValue__, offsetValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doI64(LLVMPointer, long)] */ && offsetValue_ instanceof Long) {
                    long offsetValue__ = (long) offsetValue_;
                    return doI64(baseValue__, offsetValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_, offsetValue_);
        }

        private LLVMPointer executeAndSpecialize(Object baseValue, Object offsetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(baseValue)) {
                LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
                if (LLVMTypes.isNativePointer(offsetValue)) {
                    LLVMNativePointer offsetValue_ = LLVMTypes.asNativePointer(offsetValue);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doLLVMPointer(LLVMPointer, LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    return doLLVMPointer(baseValue_, offsetValue_);
                }
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (long) offsetValue;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doI64(LLVMPointer, long)] */;
                    this.state_0_ = state_0;
                    return doI64(baseValue_, offsetValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.base_, this.offset_}, baseValue, offsetValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doLLVMPointer(LLVMPointer, LLVMNativePointer)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.doI64(LLVMPointer, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddressSegmentComputationNode create(LLVMExpressionNode base, LLVMExpressionNode offset) {
            return new LLVMAMD64AddressSegmentComputationNodeGen(base, offset);
        }

    }
}
